/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.GenericMetadata;
import org.projectnessie.model.IcebergContent;
import org.projectnessie.model.IcebergTable;

@ParametersAreNonnullByDefault
@Generated(from="IcebergTable", generator="Immutables")
@Immutable
public final class ImmutableIcebergTable
extends IcebergTable {
    @Nullable
    private final String id;
    private final String metadataLocation;
    private final long snapshotId;
    private final int schemaId;
    private final int specId;
    private final int sortOrderId;
    @Nullable
    private final GenericMetadata metadata;

    private ImmutableIcebergTable(@Nullable String id, String metadataLocation, long snapshotId, int schemaId, int specId, int sortOrderId, @Nullable GenericMetadata metadata) {
        this.id = id;
        this.metadataLocation = metadataLocation;
        this.snapshotId = snapshotId;
        this.schemaId = schemaId;
        this.specId = specId;
        this.sortOrderId = sortOrderId;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="metadataLocation")
    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    @Override
    @JsonProperty(value="snapshotId")
    public long getSnapshotId() {
        return this.snapshotId;
    }

    @Override
    @JsonProperty(value="schemaId")
    public int getSchemaId() {
        return this.schemaId;
    }

    @Override
    @JsonProperty(value="specId")
    public int getSpecId() {
        return this.specId;
    }

    @Override
    @JsonProperty(value="sortOrderId")
    public int getSortOrderId() {
        return this.sortOrderId;
    }

    @Override
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public GenericMetadata getMetadata() {
        return this.metadata;
    }

    public final ImmutableIcebergTable withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableIcebergTable(value, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withMetadataLocation(String value) {
        String newValue = Objects.requireNonNull(value, "metadataLocation");
        if (this.metadataLocation.equals(newValue)) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, newValue, this.snapshotId, this.schemaId, this.specId, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withSnapshotId(long value) {
        if (this.snapshotId == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, value, this.schemaId, this.specId, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withSchemaId(int value) {
        if (this.schemaId == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, value, this.specId, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withSpecId(int value) {
        if (this.specId == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, value, this.sortOrderId, this.metadata);
    }

    public final ImmutableIcebergTable withSortOrderId(int value) {
        if (this.sortOrderId == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, value, this.metadata);
    }

    public final ImmutableIcebergTable withMetadata(@Nullable GenericMetadata value) {
        if (this.metadata == value) {
            return this;
        }
        return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, this.sortOrderId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIcebergTable && this.equalTo(0, (ImmutableIcebergTable)another);
    }

    private boolean equalTo(int synthetic, ImmutableIcebergTable another) {
        return Objects.equals(this.id, another.id) && this.metadataLocation.equals(another.metadataLocation) && this.snapshotId == another.snapshotId && this.schemaId == another.schemaId && this.specId == another.specId && this.sortOrderId == another.sortOrderId && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id);
        h2 += (h2 << 5) + this.metadataLocation.hashCode();
        h2 += (h2 << 5) + Long.hashCode(this.snapshotId);
        h2 += (h2 << 5) + this.schemaId;
        h2 += (h2 << 5) + this.specId;
        h2 += (h2 << 5) + this.sortOrderId;
        h2 += (h2 << 5) + Objects.hashCode(this.metadata);
        return h2;
    }

    public String toString() {
        return "IcebergTable{id=" + this.id + ", metadataLocation=" + this.metadataLocation + ", snapshotId=" + this.snapshotId + ", schemaId=" + this.schemaId + ", specId=" + this.specId + ", sortOrderId=" + this.sortOrderId + ", metadata=" + this.metadata + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableIcebergTable fromJson(Json json) {
        Builder builder = ImmutableIcebergTable.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.metadataLocation != null) {
            builder.metadataLocation(json.metadataLocation);
        }
        if (json.snapshotIdIsSet) {
            builder.snapshotId(json.snapshotId);
        }
        if (json.schemaIdIsSet) {
            builder.schemaId(json.schemaId);
        }
        if (json.specIdIsSet) {
            builder.specId(json.specId);
        }
        if (json.sortOrderIdIsSet) {
            builder.sortOrderId(json.sortOrderId);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        return builder.build();
    }

    public static ImmutableIcebergTable copyOf(IcebergTable instance) {
        if (instance instanceof ImmutableIcebergTable) {
            return (ImmutableIcebergTable)instance;
        }
        return ImmutableIcebergTable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IcebergTable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METADATA_LOCATION = 1L;
        private static final long INIT_BIT_SNAPSHOT_ID = 2L;
        private static final long INIT_BIT_SCHEMA_ID = 4L;
        private static final long INIT_BIT_SPEC_ID = 8L;
        private static final long INIT_BIT_SORT_ORDER_ID = 16L;
        private long initBits = 31L;
        @Nullable
        private String id;
        @Nullable
        private String metadataLocation;
        private long snapshotId;
        private int schemaId;
        private int specId;
        private int sortOrderId;
        @Nullable
        private GenericMetadata metadata;

        private Builder() {
        }

        public final Builder from(IcebergContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IcebergTable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Content instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String idValue;
            Content instance;
            long bits = 0L;
            if (object instanceof IcebergContent) {
                instance = (IcebergContent)object;
                if ((bits & 1L) == 0L) {
                    idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof IcebergTable) {
                instance = (IcebergTable)object;
                this.specId(((IcebergTable)instance).getSpecId());
                this.sortOrderId(((IcebergTable)instance).getSortOrderId());
                this.metadataLocation(((IcebergTable)instance).getMetadataLocation());
                GenericMetadata metadataValue = ((IcebergTable)instance).getMetadata();
                if (metadataValue != null) {
                    this.metadata(metadataValue);
                }
                this.snapshotId(((IcebergTable)instance).getSnapshotId());
                this.schemaId(((IcebergTable)instance).getSchemaId());
            }
            if (object instanceof Content) {
                instance = (Content)object;
                if ((bits & 1L) == 0L) {
                    idValue = instance.getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="metadataLocation")
        public final Builder metadataLocation(String metadataLocation) {
            this.metadataLocation = Objects.requireNonNull(metadataLocation, "metadataLocation");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="snapshotId")
        public final Builder snapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="schemaId")
        public final Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="specId")
        public final Builder specId(int specId) {
            this.specId = specId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="sortOrderId")
        public final Builder sortOrderId(int sortOrderId) {
            this.sortOrderId = sortOrderId;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder metadata(@Nullable GenericMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ImmutableIcebergTable build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIcebergTable(this.id, this.metadataLocation, this.snapshotId, this.schemaId, this.specId, this.sortOrderId, this.metadata);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadataLocation");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("snapshotId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("schemaId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("specId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("sortOrderId");
            }
            return "Cannot build IcebergTable, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IcebergTable", generator="Immutables")
    static final class Json
    extends IcebergTable {
        @Nullable
        String id;
        @Nullable
        String metadataLocation;
        long snapshotId;
        boolean snapshotIdIsSet;
        int schemaId;
        boolean schemaIdIsSet;
        int specId;
        boolean specIdIsSet;
        int sortOrderId;
        boolean sortOrderIdIsSet;
        @Nullable
        GenericMetadata metadata;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="metadataLocation")
        public void setMetadataLocation(String metadataLocation) {
            this.metadataLocation = metadataLocation;
        }

        @JsonProperty(value="snapshotId")
        public void setSnapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.snapshotIdIsSet = true;
        }

        @JsonProperty(value="schemaId")
        public void setSchemaId(int schemaId) {
            this.schemaId = schemaId;
            this.schemaIdIsSet = true;
        }

        @JsonProperty(value="specId")
        public void setSpecId(int specId) {
            this.specId = specId;
            this.specIdIsSet = true;
        }

        @JsonProperty(value="sortOrderId")
        public void setSortOrderId(int sortOrderId) {
            this.sortOrderId = sortOrderId;
            this.sortOrderIdIsSet = true;
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setMetadata(@Nullable GenericMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMetadataLocation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSnapshotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSchemaId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSpecId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSortOrderId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public GenericMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

