/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Detached;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;

@ParametersAreNonnullByDefault
@Generated(from="Detached", generator="Immutables")
@Immutable
public final class ImmutableDetached
implements Detached {
    @Nullable
    private final ReferenceMetadata metadata;
    private final String hash;

    private ImmutableDetached(@Nullable ReferenceMetadata metadata, String hash) {
        this.metadata = metadata;
        this.hash = hash;
    }

    @Override
    @JsonProperty(value="metadata")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public ReferenceMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    public final ImmutableDetached withMetadata(@Nullable ReferenceMetadata value) {
        if (this.metadata == value) {
            return this;
        }
        return ImmutableDetached.validate(new ImmutableDetached(value, this.hash));
    }

    public final ImmutableDetached withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return ImmutableDetached.validate(new ImmutableDetached(this.metadata, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDetached && this.equalTo(0, (ImmutableDetached)another);
    }

    private boolean equalTo(int synthetic, ImmutableDetached another) {
        return Objects.equals(this.metadata, another.metadata) && this.hash.equals(another.hash);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.metadata);
        h2 += (h2 << 5) + this.hash.hashCode();
        return h2;
    }

    public String toString() {
        return "Detached{metadata=" + this.metadata + ", hash=" + this.hash + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDetached fromJson(Json json) {
        Builder builder = ImmutableDetached.builder();
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        return builder.build();
    }

    private static ImmutableDetached validate(ImmutableDetached instance) {
        instance.checkHash();
        return instance;
    }

    public static ImmutableDetached copyOf(Detached instance) {
        if (instance instanceof ImmutableDetached) {
            return (ImmutableDetached)instance;
        }
        return ImmutableDetached.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Detached", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private long initBits = 1L;
        @Nullable
        private ReferenceMetadata metadata;
        @Nullable
        private String hash;

        private Builder() {
        }

        public final Builder from(Detached instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Reference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ReferenceMetadata metadataValue;
            Reference instance;
            long bits = 0L;
            if (object instanceof Detached) {
                instance = (Detached)object;
                if ((bits & 1L) == 0L) {
                    metadataValue = instance.getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.hash(instance.getHash());
                    bits |= 2L;
                }
            }
            if (object instanceof Reference) {
                instance = (Reference)object;
                if ((bits & 1L) == 0L) {
                    metadataValue = instance.getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.hash(instance.getHash());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder metadata(@Nullable ReferenceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="hash")
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableDetached build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableDetached.validate(new ImmutableDetached(this.metadata, this.hash));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build Detached, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Detached", generator="Immutables")
    static final class Json
    implements Detached {
        @Nullable
        ReferenceMetadata metadata;
        @Nullable
        String hash;

        Json() {
        }

        @JsonProperty(value="metadata")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setMetadata(@Nullable ReferenceMetadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public ReferenceMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }
    }
}

