/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import org.projectnessie.model.Content;
import org.projectnessie.model.types.ContentTypes;

public final class ContentTypeIdResolver
extends TypeIdResolverBase {
    private JavaType baseType;

    @Override
    public void init(JavaType bt) {
        this.baseType = bt;
    }

    @Override
    public String idFromValue(Object value) {
        return this.getId(value);
    }

    @Override
    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.getId(value);
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    private String getId(Object value) {
        if (value instanceof Content) {
            return ((Content)value).getType().name();
        }
        return null;
    }

    @Override
    public JavaType typeFromId(DatabindContext context, String id) {
        Content.Type subType = ContentTypes.forName(id);
        if (subType != null) {
            return context.constructSpecializedType(this.baseType, subType.type());
        }
        return TypeFactory.unknownType();
    }
}

