/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import java.util.List;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.tools.contentgenerator.cli.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="delete", mixinStandardHelpOptions=true, description={"Delete content objects"})
public class DeleteContent
extends AbstractCommand {
    @CommandLine.Option(names={"-r", "--branch"}, description={"Name of the branch where to make changes, defaults to 'main'"})
    private String ref = "main";
    @CommandLine.Option(names={"-k", "--key"}, description={"Content key to delete"}, required=true)
    private List<String> key;
    @CommandLine.Option(names={"-m", "--message"}, description={"Commit message (auto-generated if not set)"})
    private String message;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public void execute() throws NessieNotFoundException, NessieConflictException {
        try (NessieApiV1 api = this.createNessieApiInstance();){
            ContentKey contentKey = ContentKey.of(this.key);
            Reference refInfo = api.getReference().refName(this.ref).get();
            if (this.message == null) {
                this.message = "Delete: " + contentKey;
            }
            Branch head = ((CommitMultipleOperationsBuilder)api.commitMultipleOperations().commitMeta(CommitMeta.fromMessage(this.message)).branch((Branch)refInfo)).operation(Operation.Delete.of(contentKey)).commit();
            this.spec.commandLine().getOut().printf("Deleted %s in %s%n", contentKey, head);
        }
    }
}

