/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.keygen;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.tools.contentgenerator.keygen.KeyGenerator;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyGenerator.Params", generator="Immutables")
@Immutable
final class ImmutableParams
implements KeyGenerator.Params {
    private final long seed;
    private final String pattern;

    private ImmutableParams(Builder builder) {
        this.pattern = builder.pattern;
        this.seed = builder.seedIsSet() ? builder.seed : KeyGenerator.Params.super.seed();
    }

    private ImmutableParams(long seed, String pattern) {
        this.seed = seed;
        this.pattern = pattern;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    public final ImmutableParams withSeed(long value) {
        if (this.seed == value) {
            return this;
        }
        return new ImmutableParams(value, this.pattern);
    }

    public final ImmutableParams withPattern(String value) {
        String newValue = Objects.requireNonNull(value, "pattern");
        if (this.pattern.equals(newValue)) {
            return this;
        }
        return new ImmutableParams(this.seed, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableParams && this.equalTo(0, (ImmutableParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableParams another) {
        return this.seed == another.seed && this.pattern.equals(another.pattern);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.seed);
        h += (h << 5) + this.pattern.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Params").omitNullValues().add("seed", this.seed).add("pattern", (Object)this.pattern).toString();
    }

    public static ImmutableParams copyOf(KeyGenerator.Params instance) {
        if (instance instanceof ImmutableParams) {
            return (ImmutableParams)instance;
        }
        return ImmutableParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyGenerator.Params", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PATTERN = 1L;
        private static final long OPT_BIT_SEED = 1L;
        private long initBits = 1L;
        private long optBits;
        private long seed;
        @Nullable
        private String pattern;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyGenerator.Params instance) {
            Objects.requireNonNull(instance, "instance");
            this.seed(instance.seed());
            this.pattern(instance.pattern());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder seed(long seed) {
            this.seed = seed;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pattern(String pattern) {
            this.pattern = Objects.requireNonNull(pattern, "pattern");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableParams(this);
        }

        private boolean seedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("pattern");
            }
            return "Cannot build Params, some of required attributes are not set " + attributes;
        }
    }
}

