/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApi;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.NessieHttpClient;
import org.projectnessie.client.http.v1api.HttpApiV1;
import org.projectnessie.client.http.v2api.HttpApiV2;
import org.projectnessie.model.ser.Views;

public class HttpClientBuilder
implements NessieClientBuilder<HttpClientBuilder> {
    private final HttpClient.Builder builder = HttpClient.builder();
    private HttpAuthentication authentication;
    private boolean tracing;

    protected HttpClientBuilder() {
    }

    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    @Override
    public HttpClientBuilder fromSystemProperties() {
        return this.fromConfig(System::getProperty);
    }

    @Override
    public HttpClientBuilder fromConfig(Function<String, String> configuration) {
        String uri = configuration.apply("nessie.uri");
        if (uri != null) {
            this.withUri(URI.create(uri));
        }
        this.withAuthenticationFromConfig((Function)configuration);
        String s2 = configuration.apply("nessie.tracing");
        if (s2 != null) {
            this.withTracing(Boolean.parseBoolean(s2));
        }
        if ((s2 = configuration.apply("nessie.transport.connect-timeout")) != null) {
            this.withConnectionTimeout(Integer.parseInt(s2));
        }
        if ((s2 = configuration.apply("nessie.transport.read-timeout")) != null) {
            this.withReadTimeout(Integer.parseInt(s2));
        }
        if ((s2 = configuration.apply("nessie.transport.disable-compression")) != null) {
            this.withDisableCompression(Boolean.parseBoolean(s2));
        }
        SSLParameters sslParameters = new SSLParameters();
        boolean hasSslParameters = false;
        s2 = configuration.apply("nessie.ssl.cipher-suites");
        if (s2 != null) {
            hasSslParameters = true;
            sslParameters.setCipherSuites((String[])Arrays.stream(s2.split(",")).map(String::trim).filter(v -> !v.isEmpty()).toArray(String[]::new));
        }
        if ((s2 = configuration.apply("nessie.ssl.protocols")) != null) {
            hasSslParameters = true;
            sslParameters.setProtocols((String[])Arrays.stream(s2.split(",")).map(String::trim).filter(v -> !v.isEmpty()).toArray(String[]::new));
        }
        if ((s2 = configuration.apply("nessie.ssl.sni-hosts")) != null) {
            hasSslParameters = true;
            sslParameters.setServerNames(Arrays.stream(s2.split(",")).map(String::trim).filter(v -> !v.isEmpty()).map(SNIHostName::new).collect(Collectors.toList()));
        }
        if ((s2 = configuration.apply("nessie.ssl.sni-matcher")) != null) {
            hasSslParameters = true;
            sslParameters.setSNIMatchers(Collections.singletonList(SNIHostName.createSNIMatcher(s2)));
        }
        if (hasSslParameters) {
            this.withSSLParameters(sslParameters);
        }
        if ((s2 = configuration.apply("nessie.http2-upgrade")) != null) {
            this.withHttp2Upgrade(Boolean.parseBoolean(s2.trim()));
        }
        if ((s2 = configuration.apply("nessie.http-redirects")) != null) {
            this.withFollowRedirects(s2.trim());
        }
        if ((s2 = configuration.apply("nessie.force-url-connection-client")) != null) {
            this.withForceUrlConnectionClient(Boolean.parseBoolean(s2.trim()));
        }
        return this;
    }

    @Override
    public HttpClientBuilder withAuthenticationFromConfig(Function<String, String> configuration) {
        this.withAuthentication(NessieAuthenticationProvider.fromConfig(configuration));
        return this;
    }

    @Override
    public HttpClientBuilder withUri(URI uri) {
        this.builder.setBaseUri(uri);
        return this;
    }

    @Override
    public HttpClientBuilder withAuthentication(NessieAuthentication authentication) {
        if (authentication != null && !(authentication instanceof HttpAuthentication)) {
            throw new IllegalArgumentException("HttpClientBuilder only accepts instances of HttpAuthentication");
        }
        this.authentication = (HttpAuthentication)authentication;
        return this;
    }

    public HttpClientBuilder withTracing(boolean tracing) {
        this.tracing = tracing;
        return this;
    }

    public HttpClientBuilder withReadTimeout(int readTimeoutMillis) {
        this.builder.setReadTimeoutMillis(readTimeoutMillis);
        return this;
    }

    public HttpClientBuilder withConnectionTimeout(int connectionTimeoutMillis) {
        this.builder.setConnectionTimeoutMillis(connectionTimeoutMillis);
        return this;
    }

    public HttpClientBuilder withDisableCompression(boolean disableCompression) {
        this.builder.setDisableCompression(disableCompression);
        return this;
    }

    public HttpClientBuilder withSSLContext(SSLContext sslContext) {
        this.builder.setSslContext(sslContext);
        return this;
    }

    public HttpClientBuilder withSSLParameters(SSLParameters sslParameters) {
        this.builder.setSslParameters(sslParameters);
        return this;
    }

    public HttpClientBuilder withHttp2Upgrade(boolean http2Upgrade) {
        this.builder.setHttp2Upgrade(http2Upgrade);
        return this;
    }

    public HttpClientBuilder withFollowRedirects(String redirects) {
        this.builder.setFollowRedirects(redirects);
        return this;
    }

    public HttpClientBuilder withForceUrlConnectionClient(boolean forceUrlConnectionClient) {
        this.builder.setForceUrlConnectionClient(forceUrlConnectionClient);
        return this;
    }

    @Override
    public <API extends NessieApi> API build(Class<API> apiVersion) {
        Objects.requireNonNull(apiVersion, "API version class must be non-null");
        if (apiVersion.isAssignableFrom(HttpApiV1.class)) {
            this.builder.setJsonView(Views.V1.class);
            NessieHttpClient client = new NessieHttpClient(this.authentication, this.tracing, this.builder);
            return (API)new HttpApiV1(client);
        }
        if (apiVersion.isAssignableFrom(HttpApiV2.class)) {
            this.builder.setJsonView(Views.V2.class);
            HttpClient httpClient = NessieHttpClient.buildClient(this.authentication, this.tracing, this.builder);
            return (API)new HttpApiV2(httpClient);
        }
        throw new IllegalArgumentException(String.format("API version %s is not supported.", apiVersion.getName()));
    }
}

