/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.util.v2api;

import java.util.Map;
import java.util.Optional;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.builder.BaseDeleteNamespaceBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNamespaceNotEmptyException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;

public final class ClientSideDeleteNamespace
extends BaseDeleteNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideDeleteNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public void delete() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException, NessieNamespaceNotEmptyException {
        Map<ContentKey, Content> contentMap;
        ContentKey key = ContentKey.of(this.namespace.getElements());
        try {
            contentMap = ((GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef)).key(key).get();
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        if (!Optional.ofNullable(contentMap.get(key)).flatMap(c -> c.unwrap(Namespace.class)).isPresent()) {
            throw new NessieNamespaceNotFoundException(String.format("Namespace '%s' does not exist", key.toPathString()));
        }
        try {
            if (((GetEntriesBuilder)((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(this.refName)).hashOnRef(this.hashOnRef)).filter(String.format("entry.namespace.startsWith('%s')", key))).stream().findAny().isPresent()) {
                throw new NessieNamespaceNotEmptyException(String.format("Namespace '%s' is not empty", key.toPathString()));
            }
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        try {
            ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(this.refName)).hash(this.hashOnRef)).commitMeta(CommitMeta.fromMessage("delete namespace " + key)).operation(Operation.Delete.of(key)).commit();
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        catch (NessieConflictException e) {
            throw new IllegalStateException(e);
        }
    }
}

