/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.util.v2api;

import java.util.HashMap;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetNamespaceBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.builder.BaseUpdateNamespaceBuilder;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNamespaceNotFoundException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Operation;

public final class ClientSideUpdateNamespace
extends BaseUpdateNamespaceBuilder {
    private final NessieApiV2 api;

    public ClientSideUpdateNamespace(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public void update() throws NessieNamespaceNotFoundException, NessieReferenceNotFoundException {
        ContentKey key = ContentKey.of(this.namespace.getElements());
        Namespace oldNamespace = ((GetNamespaceBuilder)((GetNamespaceBuilder)((GetNamespaceBuilder)this.api.getNamespace().refName(this.refName)).hashOnRef(this.hashOnRef)).namespace(this.namespace)).get();
        HashMap<String, String> newProperties = new HashMap<String, String>(oldNamespace.getProperties());
        this.propertyRemovals.forEach(newProperties::remove);
        newProperties.putAll(this.propertyUpdates);
        ImmutableNamespace.Builder builder = ImmutableNamespace.builder().from(oldNamespace).properties(newProperties);
        try {
            ((CommitMultipleOperationsBuilder)((CommitMultipleOperationsBuilder)this.api.commitMultipleOperations().branchName(this.refName)).hash(this.hashOnRef)).commitMeta(CommitMeta.fromMessage("update namespace " + key)).operation(Operation.Put.of(key, builder.build(), oldNamespace)).commit();
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        catch (NessieConflictException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

