/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.keygen;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.immutables.value.Value;
import org.projectnessie.tools.contentgenerator.keygen.ImmutableParams;
import org.projectnessie.tools.contentgenerator.keygen.PatternParser;

public class KeyGenerator {
    private final Params params;
    private final Random random;
    private final List<Func> generators;

    public static KeyGenerator newKeyGenerator(@Nonnull String pattern) {
        return KeyGenerator.newKeyGenerator(ImmutableParams.builder().pattern(pattern).build());
    }

    public static KeyGenerator newKeyGenerator(long seed, @Nonnull String pattern) {
        return KeyGenerator.newKeyGenerator(ImmutableParams.builder().seed(seed).pattern(pattern).build());
    }

    public static KeyGenerator newKeyGenerator(@Nonnull Params params) {
        PatternParser parser = new PatternParser(params.pattern());
        List<Func> generators = parser.parse();
        return new KeyGenerator(params, generators);
    }

    private KeyGenerator(@Nonnull Params params, @Nonnull List<Func> generators) {
        this.params = params;
        this.random = new Random(params.seed());
        this.generators = generators;
    }

    public String generate() {
        StringBuilder sb = new StringBuilder();
        this.generate(sb);
        return sb.toString();
    }

    public void generate(StringBuilder target) {
        this.generators.forEach(f -> f.apply(this.random, target));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KeyGenerator)) {
            return false;
        }
        KeyGenerator that = (KeyGenerator)o;
        return this.params.equals(that.params);
    }

    public int hashCode() {
        return this.params.hashCode();
    }

    public String toString() {
        return "KeyGenerator{params=" + this.params + '}';
    }

    @FunctionalInterface
    static interface Func {
        public void apply(Random var1, StringBuilder var2);
    }

    @Value.Immutable
    static interface Params {
        @Value.Default
        default public long seed() {
            return new Random().nextLong();
        }

        public String pattern();
    }
}

