/*
 * Decompiled with CFR 0.152.
 */
package picocli.codegen.docgen.manpage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import picocli.CommandLine;
import picocli.codegen.util.Assert;
import picocli.codegen.util.Util;

@CommandLine.Command(name="gen-manpage", version={"${COMMAND-FULL-NAME} 4.7.0"}, helpCommand=true, showAtFileInUsageHelp=true, mixinStandardHelpOptions=true, sortOptions=false, usageHelpAutoWidth=true, usageHelpWidth=100, description={"Generates man pages for all commands in the specified directory."}, footerHeading="%nConverting to Man Page Format%n%n", footer={"Use the `asciidoctor` tool to convert the generated AsciiDoc files to man pages in roff format:", "", "`asciidoctor --backend=manpage --source-dir=SOURCE_DIR --destination-dir=DESTINATION *.adoc`", "", "Point the SOURCE_DIR to either the `--outdir` directory or the `--template-dir` directory. Use some other directory as the DESTINATION.", "See https://asciidoctor.org/docs/user-manual/#man-pages", "See http://man7.org/linux/man-pages/man7/roff.7.html"})
public class ManPageGenerator
implements Callable<Integer> {
    static final int EXIT_CODE_TEMPLATE_EXISTS = 4;
    static final CommandLine.Help.Ansi.IStyle BOLD = new CommandLine.Help.Ansi.IStyle(){

        @Override
        public String on() {
            return "*";
        }

        @Override
        public String off() {
            return "*";
        }
    };
    static final CommandLine.Help.Ansi.IStyle ITALIC = new CommandLine.Help.Ansi.IStyle(){

        @Override
        public String on() {
            return "_";
        }

        @Override
        public String off() {
            return "_";
        }
    };
    static final CommandLine.Help.Ansi.IStyle HIGHLIGHT = new CommandLine.Help.Ansi.IStyle(){

        @Override
        public String on() {
            return "#";
        }

        @Override
        public String off() {
            return "#";
        }
    };
    static final CommandLine.Help.ColorScheme COLOR_SCHEME = new CommandLine.Help.ColorScheme.Builder(CommandLine.Help.Ansi.ON).commands(BOLD).options(BOLD).optionParams(ITALIC).parameters(ITALIC).customMarkupMap(ManPageGenerator.createMarkupMap()).build();
    @CommandLine.Mixin
    Config config;
    @CommandLine.Spec
    CommandLine.Model.CommandSpec spec;

    @Override
    public Integer call() throws IOException {
        return ManPageGenerator.generateManPage(this.config, this.spec.root());
    }

    private static Map<String, CommandLine.Help.Ansi.IStyle> createMarkupMap() {
        HashMap<String, CommandLine.Help.Ansi.IStyle> result = new HashMap<String, CommandLine.Help.Ansi.IStyle>();
        result.put(CommandLine.Help.Ansi.Style.bold.name(), BOLD);
        result.put(CommandLine.Help.Ansi.Style.italic.name(), ITALIC);
        result.put(CommandLine.Help.Ansi.Style.underline.name(), ITALIC);
        result.put(CommandLine.Help.Ansi.Style.reverse.name(), HIGHLIGHT);
        return result;
    }

    public static void main(String[] args) {
        App app = new App();
        int exitCode = new CommandLine(app).execute(args);
        if (app.exit) {
            System.exit(exitCode);
        }
    }

    public static int generateManPage(File outdir, File customizablePagesDirectory, boolean[] verbosity, boolean overwriteCustomizablePages, CommandLine.Model.CommandSpec ... specs) throws IOException {
        Config config = new Config();
        config.directory = outdir;
        config.templatesDirectory = customizablePagesDirectory;
        config.verbosity = verbosity;
        config.force = overwriteCustomizablePages;
        return ManPageGenerator.generateManPage(config, specs);
    }

    static int generateManPage(Config config, CommandLine.Model.CommandSpec ... specs) throws IOException {
        Assert.notNull(config, "config");
        Assert.notNull(config.directory, "output directory");
        Assert.notNull(config.verbosity, "verbosity array");
        if (config.templatesDirectory != null && config.templatesDirectory.equals(config.directory)) {
            System.err.println("gen-manpage: Error: output directory must differ from the templates directory.");
            System.err.println("Try 'gen-manpage --help' for more information.");
            return 2;
        }
        ManPageGenerator.traceAllSpecs(specs, config);
        for (CommandLine.Model.CommandSpec spec : specs) {
            int result = ManPageGenerator.generateSingleManPage(config, spec);
            if (result != 0) {
                return result;
            }
            HashSet<CommandLine.Model.CommandSpec> done = new HashSet<CommandLine.Model.CommandSpec>();
            for (CommandLine sub : spec.subcommands().values()) {
                CommandLine.Model.CommandSpec subSpec = sub.getCommandSpec();
                if (done.contains(subSpec) || subSpec.usageMessage().hidden()) continue;
                done.add(subSpec);
                result = ManPageGenerator.generateManPage(config, subSpec);
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }

    private static void traceAllSpecs(CommandLine.Model.CommandSpec[] specs, Config config) {
        ArrayList<String> all = new ArrayList<String>();
        for (CommandLine.Model.CommandSpec spec : specs) {
            Object obj = spec.userObject();
            if (obj == null) {
                all.add(spec.name() + " (no user object)");
                continue;
            }
            if (obj instanceof Method) {
                all.add(spec.name() + " (" + ((Method)obj).toGenericString() + ")");
                continue;
            }
            all.add(obj.getClass().getName());
        }
        config.verbose("Generating man pages for %s and all subcommands%n", new Object[]{all});
    }

    private static int generateSingleManPage(Config config, CommandLine.Model.CommandSpec spec) throws IOException {
        if (!ManPageGenerator.mkdirs(config, config.directory)) {
            return 1;
        }
        File manpage = new File(config.directory, ManPageGenerator.makeFileName(spec));
        config.verbose("Generating man page %s%n", new Object[]{manpage});
        ManPageGenerator.generateSingleManPage(spec, manpage);
        return ManPageGenerator.generateCustomizableTemplate(config, spec);
    }

    private static boolean mkdirs(Config config, File directory) {
        if (directory != null && !directory.exists()) {
            config.verboseDetailed("Creating directory %s%n", new Object[]{directory});
            if (!directory.mkdirs()) {
                System.err.println("Unable to mkdirs for " + directory.getAbsolutePath());
                return false;
            }
        }
        return true;
    }

    private static String makeFileName(CommandLine.Model.CommandSpec spec) {
        return (spec.qualifiedName("-") + ".adoc").replaceAll("\\s", "_").replace("<main_class>", "main_class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateSingleManPage(CommandLine.Model.CommandSpec spec, File manpage) throws IOException {
        OutputStreamWriter writer = null;
        PrintWriter pw = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(manpage), "UTF-8");
            pw = new PrintWriter(writer);
            ManPageGenerator.writeSingleManPage(pw, spec);
        }
        catch (Throwable throwable) {
            Util.closeSilently(pw);
            Util.closeSilently(writer);
            throw throwable;
        }
        Util.closeSilently(pw);
        Util.closeSilently(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int generateCustomizableTemplate(Config config, CommandLine.Model.CommandSpec spec) throws IOException {
        if (config.templatesDirectory == null) {
            return 0;
        }
        if (!ManPageGenerator.mkdirs(config, config.templatesDirectory)) {
            return 1;
        }
        File templateFile = new File(config.templatesDirectory, ManPageGenerator.makeFileName(spec));
        if (templateFile.exists()) {
            if (!config.force) {
                System.err.printf("gen-manpage: ERROR: cannot generate man page template file %s: it already exists. Remove the --template-dir option or use --force to overwrite.%n", templateFile);
                System.err.println("Try 'gen-manpage --help' for more information.");
                return 4;
            }
            config.verbose("Overwriting existing man page template file %s...%n", new Object[]{templateFile});
        } else {
            config.verbose("Generating customizable man page template %s%n", new Object[]{templateFile});
        }
        FileWriter writer = null;
        PrintWriter pw = null;
        try {
            writer = new FileWriter(templateFile);
            pw = new PrintWriter(writer);
            ManPageGenerator.writeCustomizableManPageTemplate(pw, config.directory, spec);
        }
        catch (Throwable throwable) {
            Util.closeSilently(pw);
            Util.closeSilently(writer);
            throw throwable;
        }
        Util.closeSilently(pw);
        Util.closeSilently(writer);
        return 0;
    }

    static void writeCustomizableManPageTemplate(PrintWriter pw, File includeDir, CommandLine.Model.CommandSpec spec) {
        pw.printf(":includedir: %s%n", includeDir.getAbsolutePath().replace('\\', '/'));
        pw.printf("//include::{includedir}/%s[tag=picocli-generated-full-manpage]%n", ManPageGenerator.makeFileName(spec));
        List<String> tags = Arrays.asList("header", "name", "synopsis", "description", "options", "arguments", "commands", "exit-status", "footer");
        for (String tag : tags) {
            pw.println();
            pw.printf("include::{includedir}/%s[tag=picocli-generated-man-section-%s]%n", ManPageGenerator.makeFileName(spec), tag);
        }
    }

    public static void writeSingleManPage(PrintWriter pw, CommandLine.Model.CommandSpec spec) {
        spec.commandLine().setColorScheme(COLOR_SCHEME);
        pw.printf("// tag::picocli-generated-full-manpage[]%n", new Object[0]);
        ManPageGenerator.genHeader(pw, spec);
        ManPageGenerator.genOptions(pw, spec);
        ManPageGenerator.genPositionalArgs(pw, spec);
        ManPageGenerator.genCommands(pw, spec);
        ManPageGenerator.genExitStatus(pw, spec);
        ManPageGenerator.genFooter(pw, spec);
        pw.printf("// end::picocli-generated-full-manpage[]%n", new Object[0]);
    }

    static void genHeader(PrintWriter pw, CommandLine.Model.CommandSpec spec) {
        pw.printf("// tag::picocli-generated-man-section-header[]%n", new Object[0]);
        pw.printf(":doctype: manpage%n", new Object[0]);
        pw.printf(":revnumber: %s%n", ManPageGenerator.versionString(spec));
        pw.printf(":manmanual: %s%n", ManPageGenerator.manualTitle(spec));
        pw.printf(":mansource: %s%n", ManPageGenerator.versionString(spec));
        pw.printf(":man-linkstyle: pass:[blue R < >]%n", new Object[0]);
        pw.printf("= %s(1)%n", spec.qualifiedName("-"));
        pw.println();
        pw.printf("// end::picocli-generated-man-section-header[]%n", new Object[0]);
        pw.println();
        pw.printf("// tag::picocli-generated-man-section-name[]%n", new Object[0]);
        pw.printf("== Name%n%n", new Object[0]);
        pw.printf("%s - %s%n", spec.qualifiedName("-"), ManPageGenerator.headerDescriptionString(spec));
        pw.println();
        pw.printf("// end::picocli-generated-man-section-name[]%n", new Object[0]);
        pw.println();
        pw.printf("// tag::picocli-generated-man-section-synopsis[]%n", new Object[0]);
        pw.printf("== Synopsis%n%n", new Object[0]);
        pw.printf("%s", spec.commandLine().getHelp().synopsis(0));
        pw.println();
        pw.printf("// end::picocli-generated-man-section-synopsis[]%n", new Object[0]);
        pw.println();
        pw.printf("// tag::picocli-generated-man-section-description[]%n", new Object[0]);
        pw.printf("== Description%n%n", new Object[0]);
        pw.printf("%s%n", String.format(COLOR_SCHEME.text(ManPageGenerator.join("%n", spec.usageMessage().description())).toString(), new Object[0]));
        pw.println();
        pw.printf("// end::picocli-generated-man-section-description[]%n", new Object[0]);
        pw.println();
    }

    private static String versionString(CommandLine.Model.CommandSpec spec) {
        return spec.version().length == 0 ? "" : spec.version()[0].replaceAll(":", " ");
    }

    private static String manualTitle(CommandLine.Model.CommandSpec spec) {
        CommandLine.Model.CommandSpec parent = spec;
        while (parent.parent() != null) {
            parent = parent.parent();
        }
        String name = parent.name();
        return Character.toUpperCase(name.charAt(0)) + name.substring(1) + " Manual";
    }

    private static String headerDescriptionString(CommandLine.Model.CommandSpec spec) {
        String result = null;
        String[] headerDescription = spec.usageMessage().header();
        result = headerDescription == null || headerDescription.length == 0 || headerDescription[0] == null || headerDescription[0].length() == 0 ? ManPageGenerator.firstElement(spec.usageMessage().description()) : ManPageGenerator.join("%n", headerDescription);
        return String.format(COLOR_SCHEME.text(result).toString(), new Object[0]);
    }

    static void genOptions(PrintWriter pw, CommandLine.Model.CommandSpec spec) {
        Comparator<CommandLine.Model.OptionSpec> optionSort;
        ArrayList<CommandLine.Model.OptionSpec> options = new ArrayList<CommandLine.Model.OptionSpec>(spec.options());
        Iterator iter = options.iterator();
        while (iter.hasNext()) {
            if (!((CommandLine.Model.OptionSpec)iter.next()).hidden()) continue;
            iter.remove();
        }
        CommandLine.Help.IOptionRenderer optionRenderer = spec.commandLine().getHelp().createDefaultOptionRenderer();
        CommandLine.Help.IParamLabelRenderer paramLabelRenderer = spec.commandLine().getHelp().createDefaultParamLabelRenderer();
        CommandLine.Help.IParameterRenderer parameterRenderer = spec.commandLine().getHelp().createDefaultParameterRenderer();
        List<CommandLine.Model.ArgGroupSpec> groups = ManPageGenerator.optionListGroups(spec);
        for (CommandLine.Model.ArgGroupSpec argGroupSpec : groups) {
            options.removeAll(argGroupSpec.allOptionsNested());
        }
        if (options.isEmpty() && !spec.usageMessage().showEndOfOptionsDelimiterInUsageHelp()) {
            pw.printf("// tag::picocli-generated-man-section-options[]%n", new Object[0]);
            pw.printf("// end::picocli-generated-man-section-options[]%n", new Object[0]);
            pw.println();
            return;
        }
        pw.printf("// tag::picocli-generated-man-section-options[]%n", new Object[0]);
        pw.printf("== Options%n", new Object[0]);
        Comparator<CommandLine.Model.OptionSpec> comparator = optionSort = spec.usageMessage().sortOptions() ? new SortByShortestOptionNameAlphabetically() : ManPageGenerator.createOrderComparatorIfNecessary(spec.options());
        if (optionSort != null) {
            Collections.sort(options, optionSort);
        }
        for (CommandLine.Model.OptionSpec option : options) {
            ManPageGenerator.writeOption(pw, optionRenderer, paramLabelRenderer, option);
        }
        if (spec.usageMessage().showEndOfOptionsDelimiterInUsageHelp()) {
            CommandLine commandLine = new CommandLine(spec).setColorScheme(COLOR_SCHEME);
            CommandLine.Help help = commandLine.getHelp();
            ManPageGenerator.writeEndOfOptions(pw, optionRenderer, paramLabelRenderer, help.END_OF_OPTIONS_OPTION);
        }
        Collections.sort(groups, new SortByOrder());
        for (CommandLine.Model.ArgGroupSpec group : groups) {
            pw.println();
            String heading = ManPageGenerator.makeHeading(group.heading(), "Options Group");
            pw.printf("== %s%n", COLOR_SCHEME.text(heading));
            for (CommandLine.Model.PositionalParamSpec positional : group.allPositionalParametersNested()) {
                if (positional.hidden()) continue;
                ManPageGenerator.writePositional(pw, positional, parameterRenderer, paramLabelRenderer);
            }
            ArrayList<CommandLine.Model.OptionSpec> groupOptions = new ArrayList<CommandLine.Model.OptionSpec>(group.allOptionsNested());
            if (optionSort != null) {
                Collections.sort(groupOptions, optionSort);
            }
            for (CommandLine.Model.OptionSpec option : groupOptions) {
                ManPageGenerator.writeOption(pw, optionRenderer, paramLabelRenderer, option);
            }
        }
        pw.println();
        pw.printf("// end::picocli-generated-man-section-options[]%n", new Object[0]);
        pw.println();
    }

    private static List<CommandLine.Model.ArgGroupSpec> optionListGroups(CommandLine.Model.CommandSpec commandSpec) {
        ArrayList<CommandLine.Model.ArgGroupSpec> result = new ArrayList<CommandLine.Model.ArgGroupSpec>();
        ManPageGenerator.optionListGroups(commandSpec.argGroups(), result);
        return result;
    }

    private static void optionListGroups(List<CommandLine.Model.ArgGroupSpec> groups, List<CommandLine.Model.ArgGroupSpec> result) {
        for (CommandLine.Model.ArgGroupSpec group : groups) {
            ManPageGenerator.optionListGroups(group.subgroups(), result);
            if (group.heading() == null) continue;
            result.add(group);
        }
    }

    private static void writeOption(PrintWriter pw, CommandLine.Help.IOptionRenderer optionRenderer, CommandLine.Help.IParamLabelRenderer paramLabelRenderer, CommandLine.Model.OptionSpec option) {
        pw.println();
        CommandLine.Help.Ansi.Text[][] rows = optionRenderer.render(option, paramLabelRenderer, COLOR_SCHEME);
        pw.printf("%s::%n", ManPageGenerator.join(", ", rows[0][1], rows[0][3]));
        pw.printf("  %s%n", rows[0][4]);
        for (int i = 1; i < rows.length; ++i) {
            pw.printf("+%n%s%n", rows[i][4]);
        }
    }

    private static void writePositional(PrintWriter pw, CommandLine.Model.PositionalParamSpec positional, CommandLine.Help.IParameterRenderer parameterRenderer, CommandLine.Help.IParamLabelRenderer paramLabelRenderer) {
        pw.println();
        CommandLine.Help.Ansi.Text[][] rows = parameterRenderer.render(positional, paramLabelRenderer, COLOR_SCHEME);
        pw.printf("%s::%n", ManPageGenerator.join(", ", rows[0][1], rows[0][3]));
        pw.printf("  %s%n", rows[0][4]);
        for (int i = 1; i < rows.length; ++i) {
            pw.printf("+%n%s%n", rows[i][4]);
        }
    }

    private static void writeEndOfOptions(PrintWriter pw, CommandLine.Help.IOptionRenderer optionRenderer, CommandLine.Help.IParamLabelRenderer paramLabelRenderer, CommandLine.Model.OptionSpec option) {
        pw.println();
        CommandLine.Help.Ansi.Text[][] rows = optionRenderer.render(option, paramLabelRenderer, COLOR_SCHEME);
        pw.printf("%s::%n", ManPageGenerator.join("", rows[0][1], rows[0][3]));
        String description = String.valueOf(rows[0][4]);
        pw.printf("  %s%n", description.substring(36, description.length() - 1));
    }

    static void genPositionalArgs(PrintWriter pw, CommandLine.Model.CommandSpec spec) {
        ArrayList<CommandLine.Model.PositionalParamSpec> positionals = new ArrayList<CommandLine.Model.PositionalParamSpec>(spec.positionalParameters());
        Iterator iter = positionals.iterator();
        while (iter.hasNext()) {
            if (!((CommandLine.Model.PositionalParamSpec)iter.next()).hidden()) continue;
            iter.remove();
        }
        List<CommandLine.Model.ArgGroupSpec> groups = ManPageGenerator.optionListGroups(spec);
        for (CommandLine.Model.ArgGroupSpec group : groups) {
            positionals.removeAll(group.positionalParameters());
        }
        if (positionals.isEmpty() && !spec.usageMessage().showAtFileInUsageHelp()) {
            pw.printf("// tag::picocli-generated-man-section-arguments[]%n", new Object[0]);
            pw.printf("// end::picocli-generated-man-section-arguments[]%n", new Object[0]);
            pw.println();
            return;
        }
        pw.printf("// tag::picocli-generated-man-section-arguments[]%n", new Object[0]);
        pw.printf("== Arguments%n", new Object[0]);
        CommandLine.Help.IParameterRenderer parameterRenderer = spec.commandLine().getHelp().createDefaultParameterRenderer();
        CommandLine.Help.IParamLabelRenderer paramLabelRenderer = spec.commandLine().getHelp().createDefaultParamLabelRenderer();
        if (spec.usageMessage().showAtFileInUsageHelp()) {
            CommandLine cmd = new CommandLine(spec).setColorScheme(COLOR_SCHEME);
            CommandLine.Help help = cmd.getHelp();
            ManPageGenerator.writePositional(pw, help.AT_FILE_POSITIONAL_PARAM, parameterRenderer, paramLabelRenderer);
        }
        for (CommandLine.Model.PositionalParamSpec positional : positionals) {
            ManPageGenerator.writePositional(pw, positional, parameterRenderer, paramLabelRenderer);
        }
        pw.println();
        pw.printf("// end::picocli-generated-man-section-arguments[]%n", new Object[0]);
        pw.println();
    }

    static void genCommands(PrintWriter pw, CommandLine.Model.CommandSpec spec) {
        LinkedHashMap<String, CommandLine> subCommands = new LinkedHashMap<String, CommandLine>(spec.subcommands());
        Iterator iter = subCommands.entrySet().iterator();
        while (iter.hasNext()) {
            if (!((CommandLine)iter.next().getValue()).getCommandSpec().usageMessage().hidden()) continue;
            iter.remove();
        }
        if (spec.subcommands().isEmpty()) {
            pw.printf("// tag::picocli-generated-man-section-commands[]%n", new Object[0]);
            pw.printf("// end::picocli-generated-man-section-commands[]%n", new Object[0]);
            pw.println();
            return;
        }
        pw.printf("// tag::picocli-generated-man-section-commands[]%n", new Object[0]);
        pw.printf("== Commands%n", new Object[0]);
        for (CommandLine.Help subHelp : spec.commandLine().getHelp().subcommands().values()) {
            pw.println();
            CommandLine.Help.Ansi.Text namesText = subHelp.commandNamesText(", ");
            String names = namesText.toString();
            String xrefname = ManPageGenerator.makeFileName(subHelp.commandSpec());
            pw.printf("xref:%s[%s]::%n", xrefname, names);
            CommandLine.Model.UsageMessageSpec usage = subHelp.commandSpec().usageMessage();
            String header = !ManPageGenerator.empty(usage.header()) ? usage.header()[0] : (!ManPageGenerator.empty(usage.description()) ? usage.description()[0] : "");
            CommandLine.Help.Ansi.Text[] lines = COLOR_SCHEME.text(String.format(header, new Object[0])).splitLines();
            pw.printf("  %s%n", lines[0].toString());
            for (int i = 1; i < lines.length; ++i) {
                pw.printf("+%n%s%n", lines[i].toString());
            }
        }
        pw.println();
        pw.printf("// end::picocli-generated-man-section-commands[]%n", new Object[0]);
        pw.println();
    }

    static void genExitStatus(PrintWriter pw, CommandLine.Model.CommandSpec spec) {
        if (spec.usageMessage().exitCodeList().isEmpty()) {
            pw.printf("// tag::picocli-generated-man-section-exit-status[]%n", new Object[0]);
            pw.printf("// end::picocli-generated-man-section-exit-status[]%n", new Object[0]);
            pw.println();
            return;
        }
        String heading = ManPageGenerator.makeHeading(spec.usageMessage().exitCodeListHeading(), "Exit status");
        pw.printf("// tag::picocli-generated-man-section-exit-status[]%n", new Object[0]);
        pw.printf("== %s%n", COLOR_SCHEME.text(heading));
        for (Map.Entry<String, String> entry : spec.usageMessage().exitCodeList().entrySet()) {
            pw.println();
            pw.printf("*%s*::%n", COLOR_SCHEME.text(entry.getKey().trim()));
            pw.printf("  %s%n", COLOR_SCHEME.text(entry.getValue()));
        }
        pw.println();
        pw.printf("// end::picocli-generated-man-section-exit-status[]%n", new Object[0]);
        pw.println();
    }

    static void genFooter(PrintWriter pw, CommandLine.Model.CommandSpec spec) {
        if (spec.usageMessage().footerHeading().length() == 0 || spec.usageMessage().footer().length == 0) {
            pw.printf("// tag::picocli-generated-man-section-footer[]%n", new Object[0]);
            pw.printf("// end::picocli-generated-man-section-footer[]%n", new Object[0]);
            pw.println();
            return;
        }
        String heading = ManPageGenerator.makeHeading(spec.usageMessage().footerHeading(), "Footer");
        pw.printf("// tag::picocli-generated-man-section-footer[]%n", new Object[0]);
        pw.printf("== %s%n", COLOR_SCHEME.text(heading));
        pw.println();
        boolean hardbreaks = true;
        for (String line : spec.usageMessage().footer()) {
            String renderedLine;
            if (hardbreaks) {
                pw.println("[%hardbreaks]");
                hardbreaks = false;
            }
            if ((renderedLine = COLOR_SCHEME.text(String.format(line, new Object[0])).toString()).startsWith("# ")) {
                renderedLine = "pass:c[# ]" + renderedLine.substring(2);
            }
            pw.printf("%s%n", renderedLine);
            if (line.trim().length() != 0) continue;
            hardbreaks = true;
        }
        pw.println();
        pw.printf("// end::picocli-generated-man-section-footer[]%n", new Object[0]);
        pw.println();
    }

    private static String makeHeading(String heading, String defaultIfEmpty) {
        if (heading.endsWith("%n")) {
            heading = heading.substring(0, heading.length() - 2);
        }
        heading = heading.trim().length() == 0 ? defaultIfEmpty : heading.replaceAll("%n", " ");
        return heading;
    }

    private static Comparator<CommandLine.Model.OptionSpec> createOrderComparatorIfNecessary(List<CommandLine.Model.OptionSpec> options) {
        for (CommandLine.Model.OptionSpec option : options) {
            if (option.order() == -1) continue;
            return new SortByOrder<CommandLine.Model.OptionSpec>();
        }
        return null;
    }

    private static String join(String sep, Object ... lines) {
        StringBuilder sb = new StringBuilder();
        for (Object line : lines) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(line);
        }
        return sb.toString();
    }

    private static String firstElement(String[] elements) {
        if (elements == null || elements.length == 0) {
            return "";
        }
        return elements[0];
    }

    private static boolean empty(Object[] array) {
        return array == null || array.length == 0;
    }

    static String stripPrefix(String prefixed) {
        for (int i = 0; i < prefixed.length(); ++i) {
            if (!Character.isJavaIdentifierPart(prefixed.charAt(i))) continue;
            return prefixed.substring(i);
        }
        return prefixed;
    }

    static class SortByShortestOptionNameAlphabetically
    implements Comparator<CommandLine.Model.OptionSpec> {
        SortByShortestOptionNameAlphabetically() {
        }

        @Override
        public int compare(CommandLine.Model.OptionSpec o1, CommandLine.Model.OptionSpec o2) {
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            String[] names1 = ShortestFirst.sort(o1.names());
            String[] names2 = ShortestFirst.sort(o2.names());
            String s1 = ManPageGenerator.stripPrefix(names1[0]);
            String s2 = ManPageGenerator.stripPrefix(names2[0]);
            int result = s1.toUpperCase().compareTo(s2.toUpperCase());
            int n = result = result == 0 ? -s1.compareTo(s2) : result;
            return o1.help() == o2.help() ? result : (o2.help() ? -1 : 1);
        }
    }

    static class ShortestFirst
    implements Comparator<String> {
        ShortestFirst() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.length() - o2.length();
        }

        public static String[] sort(String[] names) {
            Arrays.sort(names, new ShortestFirst());
            return names;
        }

        public static String[] longestFirst(String[] names) {
            Arrays.sort(names, Collections.reverseOrder(new ShortestFirst()));
            return names;
        }
    }

    static class SortByOrder<T extends CommandLine.Model.IOrdered>
    implements Comparator<T> {
        SortByOrder() {
        }

        @Override
        public int compare(T o1, T o2) {
            return Integer.signum(o1.order() - o2.order());
        }
    }

    @CommandLine.Command(name="gen-manpage", version={"picocli-codegen ${COMMAND-NAME} 4.7.0"}, showAtFileInUsageHelp=true, mixinStandardHelpOptions=true, sortOptions=false, usageHelpAutoWidth=true, usageHelpWidth=100, description={"Generates one or more AsciiDoc files with doctype 'manpage' in the specified directory."}, exitCodeListHeading="%nExit Codes (if enabled with `--exit`)%n", exitCodeList={"0:Successful program execution.", "1:A runtime exception occurred while generating man pages.", "2:Usage error: user input for the command was incorrect, e.g., the wrong number of arguments, a bad flag, a bad syntax in a parameter, etc.", "4:A template file exists in the template directory. (Remove the `--template-dir` option or use `--force` to overwrite.)"}, footerHeading="%nConverting to Man Page Format%n%n", footer={"Use the `asciidoctor` tool to convert the generated AsciiDoc files to man pages in roff format:", "", "`asciidoctor --backend=manpage --source-dir=SOURCE_DIR --destination-dir=DESTINATION *.adoc`", "", "Point the SOURCE_DIR to either the `--outdir` directory or the `--template-dir` directory. Use some other directory as the DESTINATION.", "See https://asciidoctor.org/docs/user-manual/#man-pages", "See http://man7.org/linux/man-pages/man7/roff.7.html", "", "In order to generate localized man pages, set the target locale by specifying the user.language, user.country, and user.variant system properties.", "The generated usage help will then contain information retrieved from the resource bundle based on the user locale.", "", "Example", "-------", "  java -Duser.language=de -cp \"myapp.jar;picocli-4.7.0.jar;picocli-codegen-4.7.0.jar\" picocli.codegen.docgen.manpage.ManPageGenerator my.pkg.MyClass"})
    private static class App
    implements Callable<Integer> {
        @CommandLine.Parameters(arity="1..*", description={"One or more command classes to generate man pages for."})
        Class<?>[] classes = new Class[0];
        @CommandLine.Mixin
        Config config;
        @CommandLine.Option(names={"-c", "--factory"}, description={"Optionally specify the fully qualified class name of the custom factory to use to instantiate the command class. If omitted, the default picocli factory is used."})
        String factoryClass;
        @CommandLine.Option(names={"--exit"}, negatable=true, description={"Specify `--exit` if you want the application to call `System.exit` when finished. By default, `System.exit` is not called."})
        boolean exit;

        private App() {
        }

        @Override
        public Integer call() throws Exception {
            List<CommandLine.Model.CommandSpec> specs = Util.getCommandSpecs(this.factoryClass, this.classes);
            return ManPageGenerator.generateManPage(this.config, specs.toArray(new CommandLine.Model.CommandSpec[0]));
        }
    }

    static class Config {
        @CommandLine.Option(names={"-d", "--outdir"}, defaultValue=".", paramLabel="<outdir>", description={"Output directory to write the generated AsciiDoc files to. If not specified, files are written to the current directory."})
        File directory;
        @CommandLine.Option(names={"-t", "--template-dir"}, paramLabel="<template-dir>", description={"Optional directory to write customizable man page template files. If specified, an additional \"template\" file is created here for each generated manpage AsciiDoc file. ", "Each template file contains `include` directives that import content from the corresponding generated manpage AsciiDoc file in the `--outdir` directory. Text can be added after each include to customize the resulting man page. The resulting man page will be a mixture of generated and manually edited text.", "These customizable templates are intended to be generated once, and afterwards be manually updated and maintained."})
        File templatesDirectory;
        @CommandLine.Option(names={"-v", "--verbose"}, description={"Specify multiple -v options to increase verbosity.", "For example, `-v -v -v` or `-vvv`"})
        boolean[] verbosity = new boolean[0];
        @CommandLine.Option(names={"-f", "--force"}, negatable=true, description={"Overwrite existing man page templates. The default is `--no-force`, meaning processing is aborted and the process exits with status code 4 if a man page template file already exists."})
        boolean force;

        Config() {
        }

        private void verbose(String message, Object ... params) {
            if (this.verbosity.length > 0) {
                System.err.printf(message, params);
            }
        }

        private void verboseDetailed(String message, Object ... params) {
            if (this.verbosity.length > 1) {
                System.err.printf(message, params);
            }
        }
    }
}

