/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import java.util.List;
import java.util.Objects;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.FetchOption;
import org.projectnessie.model.Operation;
import org.projectnessie.tools.contentgenerator.cli.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="commits", mixinStandardHelpOptions=true, description={"Read commits"})
public class ReadCommits
extends AbstractCommand {
    @CommandLine.Option(names={"-r", "--ref"}, description={"Name of the branch/tag to read the commit log from, defaults to 'main'"})
    private String ref = "main";
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public void execute() throws NessieNotFoundException {
        try (NessieApiV1 api = this.createNessieApiInstance();){
            this.spec.commandLine().getOut().printf("Reading commits for ref '%s'\n\n", this.ref);
            FetchOption fetchOption = this.isVerbose() ? FetchOption.ALL : FetchOption.MINIMAL;
            ((GetCommitLogBuilder)api.getCommitLog().refName(this.ref)).fetch(fetchOption).stream().forEach(logEntry -> {
                CommitMeta commitMeta = logEntry.getCommitMeta();
                this.spec.commandLine().getOut().printf("%s\t%s\t%s [%s]\n", Objects.requireNonNull(commitMeta.getHash()).substring(0, 8), commitMeta.getAuthorTime(), commitMeta.getMessage(), commitMeta.getAuthor());
                List operations = logEntry.getOperations();
                if (operations != null) {
                    for (Operation op : operations) {
                        this.spec.commandLine().getOut().printf("  %s\n", op);
                        if (!this.isVerbose()) continue;
                        List key = op.getKey().getElements();
                        for (int i = 0; i < key.size(); ++i) {
                            this.spec.commandLine().getOut().printf("    key[%d]: %s\n", i, key.get(i));
                        }
                    }
                }
            });
            this.spec.commandLine().getOut().printf("\nDone reading commits for ref '%s'\n\n", this.ref);
        }
    }
}

