/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="EntriesResponse.Entry", generator="Immutables")
@Immutable
public final class ImmutableEntry
implements EntriesResponse.Entry {
    private final Content.Type type;
    private final ContentKey name;
    @Nullable
    private final String contentId;

    private ImmutableEntry(ContentKey name, Content.Type type, @Nullable String contentId) {
        this.name = Objects.requireNonNull(name, "name");
        this.type = Objects.requireNonNull(type, "type");
        this.contentId = contentId;
    }

    private ImmutableEntry(ImmutableEntry original, Content.Type type, ContentKey name, @Nullable String contentId) {
        this.type = type;
        this.name = name;
        this.contentId = contentId;
    }

    @Override
    @JsonProperty(value="type")
    public Content.Type getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="name")
    public ContentKey getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="contentId")
    @JsonView(value={Views.V2.class})
    @Nullable
    public String getContentId() {
        return this.contentId;
    }

    public final ImmutableEntry withType(Content.Type value) {
        if (this.type == value) {
            return this;
        }
        Content.Type newValue = Objects.requireNonNull(value, "type");
        return new ImmutableEntry(this, newValue, this.name, this.contentId);
    }

    public final ImmutableEntry withName(ContentKey value) {
        if (this.name == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "name");
        return new ImmutableEntry(this, this.type, newValue, this.contentId);
    }

    public final ImmutableEntry withContentId(@Nullable String value) {
        if (Objects.equals(this.contentId, value)) {
            return this;
        }
        return new ImmutableEntry(this, this.type, this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntry && this.equalTo(0, (ImmutableEntry)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntry another) {
        return this.type.equals(another.type) && this.name.equals(another.name) && Objects.equals(this.contentId, another.contentId);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.type.hashCode();
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.contentId);
        return h2;
    }

    public String toString() {
        return "Entry{type=" + this.type + ", name=" + this.name + ", contentId=" + this.contentId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntry fromJson(Json json) {
        Builder builder = ImmutableEntry.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.contentId != null) {
            builder.contentId(json.contentId);
        }
        return builder.build();
    }

    public static ImmutableEntry of(ContentKey name, Content.Type type, @Nullable String contentId) {
        return new ImmutableEntry(name, type, contentId);
    }

    public static ImmutableEntry copyOf(EntriesResponse.Entry instance) {
        if (instance instanceof ImmutableEntry) {
            return (ImmutableEntry)instance;
        }
        return ImmutableEntry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EntriesResponse.Entry", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private Content.Type type;
        @Nullable
        private ContentKey name;
        @Nullable
        private String contentId;

        private Builder() {
        }

        public final Builder from(EntriesResponse.Entry instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.getType());
            this.name(instance.getName());
            String contentIdValue = instance.getContentId();
            if (contentIdValue != null) {
                this.contentId(contentIdValue);
            }
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(Content.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(ContentKey name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="contentId")
        @JsonView(value={Views.V2.class})
        public final Builder contentId(@Nullable String contentId) {
            this.contentId = contentId;
            return this;
        }

        public ImmutableEntry build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntry(null, this.type, this.name, this.contentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Entry, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EntriesResponse.Entry", generator="Immutables")
    static final class Json
    implements EntriesResponse.Entry {
        @Nullable
        Content.Type type;
        @Nullable
        ContentKey name;
        @Nullable
        String contentId;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(Content.Type type) {
            this.type = type;
        }

        @JsonProperty(value="name")
        public void setName(ContentKey name) {
            this.name = name;
        }

        @JsonProperty(value="contentId")
        @JsonView(value={Views.V2.class})
        public void setContentId(@Nullable String contentId) {
            this.contentId = contentId;
        }

        @Override
        public Content.Type getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ContentKey getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getContentId() {
            throw new UnsupportedOperationException();
        }
    }
}

