/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class HttpHeaders {
    private final Map<String, HttpHeader> headers = new LinkedHashMap<String, HttpHeader>();

    public void put(String name, String value) {
        String key = name.toLowerCase(Locale.ROOT);
        this.headers.computeIfAbsent(key, x -> new HttpHeader(name)).addValue(value);
    }

    public boolean contains(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        return this.headers.containsKey(key);
    }

    public void remove(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        this.headers.remove(key);
    }

    public Iterable<String> getValues(String name) {
        String key = name.toLowerCase(Locale.ROOT);
        HttpHeader h2 = this.headers.get(key);
        return h2 != null ? h2.getValues() : Collections.emptyList();
    }

    public Map<String, Iterable<String>> asMap() {
        return this.headers.values().stream().collect(Collectors.toMap(HttpHeader::getName, HttpHeader::getValues));
    }

    public Collection<HttpHeader> allHeaders() {
        return this.headers.values();
    }

    public static final class HttpHeader {
        final String name;
        final Set<String> values = new LinkedHashSet<String>();

        HttpHeader(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addValue(String value) {
            this.values.add(value);
        }

        public Iterable<String> getValues() {
            return this.values;
        }
    }
}

