/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.client.api.GetNamespaceResult;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.Reference;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GetNamespaceResult", generator="Immutables")
@Immutable
public final class ImmutableGetNamespaceResult
implements GetNamespaceResult {
    private final Namespace namespace;
    @Nullable
    private final Reference effectiveReference;

    private ImmutableGetNamespaceResult(Namespace namespace, @Nullable Reference effectiveReference) {
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.effectiveReference = effectiveReference;
    }

    private ImmutableGetNamespaceResult(ImmutableGetNamespaceResult original, Namespace namespace, @Nullable Reference effectiveReference) {
        this.namespace = namespace;
        this.effectiveReference = effectiveReference;
    }

    @Override
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Override
    @Nullable
    public Reference getEffectiveReference() {
        return this.effectiveReference;
    }

    public final ImmutableGetNamespaceResult withNamespace(Namespace value) {
        if (this.namespace == value) {
            return this;
        }
        Namespace newValue = Objects.requireNonNull(value, "namespace");
        return new ImmutableGetNamespaceResult(this, newValue, this.effectiveReference);
    }

    public final ImmutableGetNamespaceResult withEffectiveReference(@Nullable Reference value) {
        if (this.effectiveReference == value) {
            return this;
        }
        return new ImmutableGetNamespaceResult(this, this.namespace, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGetNamespaceResult && this.equalTo(0, (ImmutableGetNamespaceResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableGetNamespaceResult another) {
        return this.namespace.equals(another.namespace) && Objects.equals(this.effectiveReference, another.effectiveReference);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.namespace.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.effectiveReference);
        return h2;
    }

    public String toString() {
        return "GetNamespaceResult{namespace=" + this.namespace + ", effectiveReference=" + this.effectiveReference + "}";
    }

    public static ImmutableGetNamespaceResult of(Namespace namespace, @Nullable Reference effectiveReference) {
        return new ImmutableGetNamespaceResult(namespace, effectiveReference);
    }

    public static ImmutableGetNamespaceResult copyOf(GetNamespaceResult instance) {
        if (instance instanceof ImmutableGetNamespaceResult) {
            return (ImmutableGetNamespaceResult)instance;
        }
        return ImmutableGetNamespaceResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GetNamespaceResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAMESPACE = 1L;
        private long initBits = 1L;
        @Nullable
        private Namespace namespace;
        @Nullable
        private Reference effectiveReference;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GetNamespaceResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.namespace(instance.getNamespace());
            Reference effectiveReferenceValue = instance.getEffectiveReference();
            if (effectiveReferenceValue != null) {
                this.effectiveReference(effectiveReferenceValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder namespace(Namespace namespace) {
            this.namespace = Objects.requireNonNull(namespace, "namespace");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder effectiveReference(@Nullable Reference effectiveReference) {
            this.effectiveReference = effectiveReference;
            return this;
        }

        public ImmutableGetNamespaceResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGetNamespaceResult(null, this.namespace, this.effectiveReference);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("namespace");
            }
            return "Cannot build GetNamespaceResult, some of required attributes are not set " + attributes;
        }
    }
}

