/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitResponse;
import org.projectnessie.model.ser.Views;

@ParametersAreNonnullByDefault
@Generated(from="CommitResponse", generator="Immutables")
@Immutable
public final class ImmutableCommitResponse
implements CommitResponse {
    private final Branch targetBranch;
    @Nullable
    private final List<CommitResponse.AddedContent> addedContents;

    private ImmutableCommitResponse(Branch targetBranch, @Nullable List<CommitResponse.AddedContent> addedContents) {
        this.targetBranch = targetBranch;
        this.addedContents = addedContents;
    }

    @Override
    @JsonProperty(value="targetBranch")
    public Branch getTargetBranch() {
        return this.targetBranch;
    }

    @Override
    @JsonProperty(value="addedContents")
    @JsonView(value={Views.V2.class})
    @Nullable
    public List<CommitResponse.AddedContent> getAddedContents() {
        return this.addedContents;
    }

    public final ImmutableCommitResponse withTargetBranch(Branch value) {
        if (this.targetBranch == value) {
            return this;
        }
        Branch newValue = Objects.requireNonNull(value, "targetBranch");
        return new ImmutableCommitResponse(newValue, this.addedContents);
    }

    public final ImmutableCommitResponse withAddedContents(CommitResponse.AddedContent ... elements) {
        if (elements == null) {
            return new ImmutableCommitResponse(this.targetBranch, null);
        }
        List<CommitResponse.AddedContent> newValue = Arrays.asList(elements) == null ? null : ImmutableCommitResponse.createUnmodifiableList(false, ImmutableCommitResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCommitResponse(this.targetBranch, newValue);
    }

    public final ImmutableCommitResponse withAddedContents(@Nullable Iterable<? extends CommitResponse.AddedContent> elements) {
        if (this.addedContents == elements) {
            return this;
        }
        List<CommitResponse.AddedContent> newValue = elements == null ? null : ImmutableCommitResponse.createUnmodifiableList(false, ImmutableCommitResponse.createSafeList(elements, true, false));
        return new ImmutableCommitResponse(this.targetBranch, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitResponse && this.equalTo(0, (ImmutableCommitResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitResponse another) {
        return this.targetBranch.equals(another.targetBranch) && Objects.equals(this.addedContents, another.addedContents);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.targetBranch.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.addedContents);
        return h2;
    }

    public String toString() {
        return "CommitResponse{targetBranch=" + this.targetBranch + ", addedContents=" + this.addedContents + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCommitResponse fromJson(Json json) {
        Builder builder = ImmutableCommitResponse.builder();
        if (json.targetBranch != null) {
            builder.targetBranch(json.targetBranch);
        }
        if (json.addedContents != null) {
            builder.addAllAddedContents(json.addedContents);
        }
        return builder.build();
    }

    public static ImmutableCommitResponse copyOf(CommitResponse instance) {
        if (instance instanceof ImmutableCommitResponse) {
            return (ImmutableCommitResponse)instance;
        }
        return ImmutableCommitResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CommitResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TARGET_BRANCH = 1L;
        private long initBits = 1L;
        @Nullable
        private Branch targetBranch;
        private List<CommitResponse.AddedContent> addedContents = null;

        private Builder() {
        }

        public final Builder from(CommitResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.targetBranch(instance.getTargetBranch());
            List<CommitResponse.AddedContent> addedContentsValue = instance.getAddedContents();
            if (addedContentsValue != null) {
                this.addAllAddedContents(addedContentsValue);
            }
            return this;
        }

        @JsonProperty(value="targetBranch")
        public final Builder targetBranch(Branch targetBranch) {
            this.targetBranch = Objects.requireNonNull(targetBranch, "targetBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAddedContents(CommitResponse.AddedContent element) {
            if (this.addedContents == null) {
                this.addedContents = new ArrayList<CommitResponse.AddedContent>();
            }
            this.addedContents.add(Objects.requireNonNull(element, "addedContents element"));
            return this;
        }

        public final Builder addAddedContents(CommitResponse.AddedContent ... elements) {
            if (this.addedContents == null) {
                this.addedContents = new ArrayList<CommitResponse.AddedContent>();
            }
            for (CommitResponse.AddedContent element : elements) {
                this.addedContents.add(Objects.requireNonNull(element, "addedContents element"));
            }
            return this;
        }

        @JsonProperty(value="addedContents")
        @JsonView(value={Views.V2.class})
        public final Builder addedContents(@Nullable Iterable<? extends CommitResponse.AddedContent> elements) {
            if (elements == null) {
                this.addedContents = null;
                return this;
            }
            this.addedContents = new ArrayList<CommitResponse.AddedContent>();
            return this.addAllAddedContents(elements);
        }

        public final Builder addAllAddedContents(Iterable<? extends CommitResponse.AddedContent> elements) {
            Objects.requireNonNull(elements, "addedContents element");
            if (this.addedContents == null) {
                this.addedContents = new ArrayList<CommitResponse.AddedContent>();
            }
            for (CommitResponse.AddedContent addedContent : elements) {
                this.addedContents.add(Objects.requireNonNull(addedContent, "addedContents element"));
            }
            return this;
        }

        public ImmutableCommitResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitResponse(this.targetBranch, this.addedContents == null ? null : ImmutableCommitResponse.createUnmodifiableList(true, this.addedContents));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("targetBranch");
            }
            return "Cannot build CommitResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CommitResponse", generator="Immutables")
    static final class Json
    implements CommitResponse {
        @Nullable
        Branch targetBranch;
        @Nullable
        List<CommitResponse.AddedContent> addedContents = null;

        Json() {
        }

        @JsonProperty(value="targetBranch")
        public void setTargetBranch(Branch targetBranch) {
            this.targetBranch = targetBranch;
        }

        @JsonProperty(value="addedContents")
        @JsonView(value={Views.V2.class})
        public void setAddedContents(@Nullable List<CommitResponse.AddedContent> addedContents) {
            this.addedContents = addedContents;
        }

        @Override
        public Branch getTargetBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CommitResponse.AddedContent> getAddedContents() {
            throw new UnsupportedOperationException();
        }
    }
}

