/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.tools.contentgenerator.cli.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="content-refresh", mixinStandardHelpOptions=true, description={"Get and Put content objects without changes to refresh their storage model"})
public class RefreshContent
extends AbstractCommand {
    @CommandLine.Option(names={"--input"}, description={"Input file name containing a JSON array of 'ContentInfoEntry' objects from 'content-info' CLI command. (if not set, use --key and --ref)."})
    private String input;
    @CommandLine.Option(names={"-k", "--key"}, description={"Key elements to use for loading and refreshing a content object (ignored if --input is set)."})
    private List<String> keyElements;
    @CommandLine.Option(names={"-r", "--ref"}, description={"Branch name for committing refreshed content objects (ignored if --input is set)."})
    private String ref;
    @CommandLine.Option(names={"-B", "--batch"}, defaultValue="100", description={"The number of keys to process in each batched read operation."})
    private int batchSize;
    @CommandLine.Option(names={"-m", "--message"}, description={"Commit message to use for each refresh operation (auto-generated if not set)."})
    private String message;
    @CommandLine.Option(names={"--storage-model"}, description={"If set, only those entries that have the specified storage model will be refreshed (ignored if --input is not set)."})
    private String storageModel;
    @CommandLine.Option(names={"--skip-tags"}, description={"If set, input references that are not branches will be ignored (as opposed to reported as errors)."})
    private boolean skipTags;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public void execute() throws BaseNessieClientServerException {
        block14: {
            try (NessieApiV2 api = this.createNessieApiInstance();){
                if (this.input == null) {
                    Reference reference = api.getReference().refName(this.ref).get();
                    this.refresh(api, reference, Collections.singletonList(ContentKey.of(this.keyElements)));
                    break block14;
                }
                try (FileInputStream inputStream = new FileInputStream(this.input);){
                    this.refresh(api, inputStream);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private void refresh(NessieApiV2 api, InputStream input) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonParser parser = mapper.createParser(input);
        JsonToken token = parser.nextToken();
        if (!JsonToken.START_ARRAY.equals((Object)token)) {
            throw new IllegalArgumentException("Input data should be a JSON array of 'ContentInfoEntry' objects.");
        }
        ArrayList<JsonNode> batch = new ArrayList<JsonNode>(this.batchSize);
        while (JsonToken.START_OBJECT.equals((Object)parser.nextToken())) {
            batch.add(parser.readValueAs(JsonNode.class));
            if (batch.size() < this.batchSize) continue;
            this.refresh(api, batch);
            batch.clear();
        }
        if (!batch.isEmpty()) {
            this.refresh(api, batch);
        }
    }

    private void refresh(NessieApiV2 api, List<JsonNode> batch) throws BaseNessieClientServerException {
        HashMap<String, List> perRef = new HashMap<String, List>();
        for (JsonNode jsonNode : batch) {
            ArrayList<String> keyElements = new ArrayList<String>();
            jsonNode.required("key").required("elements").elements().forEachRemaining(n -> keyElements.add(n.asText()));
            String refName = jsonNode.required("reference").asText();
            String model = jsonNode.get("storageModel").asText();
            if (this.storageModel != null && !this.storageModel.equals(model)) continue;
            perRef.computeIfAbsent(refName, key -> new ArrayList()).add(ContentKey.of(keyElements));
        }
        for (Map.Entry entry : perRef.entrySet()) {
            Reference reference = api.getReference().refName((String)entry.getKey()).get();
            this.refresh(api, reference, (List)entry.getValue());
        }
    }

    private void refresh(NessieApiV2 api, Reference ref, List<ContentKey> keys) throws BaseNessieClientServerException {
        if (!(ref instanceof Branch)) {
            if (this.skipTags) {
                this.spec.commandLine().getOut().printf("Skipped %d keys because %s is not a branch.%n", keys.size(), ref);
                return;
            }
            throw new IllegalArgumentException("Content can only be refreshed on branches: " + ref);
        }
        GetContentBuilder request = (GetContentBuilder)api.getContent().reference(ref);
        keys.forEach(request::key);
        Map<ContentKey, Content> contentMap = request.get();
        this.commitSameContent(api, (Branch)ref, contentMap);
    }

    private void commitSameContent(NessieApiV2 api, Branch branch, Map<ContentKey, Content> contentMap) throws BaseNessieClientServerException {
        if (contentMap.isEmpty()) {
            return;
        }
        String msg = this.message == null ? "Refresh " + contentMap.size() + " key(s)" : this.message;
        CommitMultipleOperationsBuilder request = ((CommitMultipleOperationsBuilder)api.commitMultipleOperations().branch(branch)).commitMeta(CommitMeta.fromMessage(msg));
        for (Map.Entry<ContentKey, Content> entry : contentMap.entrySet()) {
            Content content = entry.getValue();
            request.operation(Operation.Put.of(entry.getKey(), content, content));
        }
        Branch head = request.commit();
        this.spec.commandLine().getOut().printf("Refreshed %d keys in %s at commit %s%n", contentMap.size(), branch.getName(), head.getHash());
    }
}

