/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.validation.constraints.Min;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.IcebergView;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableIcebergView;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.projectnessie.model.Tag;
import org.projectnessie.model.types.ContentTypes;
import org.projectnessie.tools.contentgenerator.cli.AbstractCommand;
import org.projectnessie.tools.contentgenerator.keygen.KeyGenerator;
import picocli.CommandLine;

@CommandLine.Command(name="generate", mixinStandardHelpOptions=true, description={"Generate commits"})
public class GenerateContent
extends AbstractCommand {
    @CommandLine.Option(names={"-b", "--num-branches"}, defaultValue="1", description={"Number of branches to use."})
    private int branchCount;
    @CommandLine.Option(names={"-T", "--tag-probability"}, defaultValue="0", description={"Probability to create a new tag off the last commit."})
    private double newTagProbability;
    @CommandLine.Option(names={"-D", "--default-branch"}, description={"Name of the default branch, uses the server's default branch if not specified."})
    private String defaultBranchName;
    @Min(value=1L, message="Must create at least one commit.")
    @CommandLine.Option(names={"-n", "--num-commits"}, required=true, defaultValue="100", description={"Number of commits to create."})
    private @Min(value=1L, message="Must create at least one commit.") int numCommits;
    @CommandLine.Option(names={"-d", "--duration"}, description={"Runtime duration, equally distributed among the number of commits to create. See java.time.Duration for argument format details."})
    private Duration runtimeDuration;
    @Min(value=1L, message="Must use at least one table (content-key).")
    @CommandLine.Option(names={"-t", "--num-tables"}, defaultValue="1", description={"Number of table names, each commit chooses a random table (content-key)."})
    private @Min(value=1L, message="Must use at least one table (content-key).") int numTables;
    @CommandLine.Option(names={"--type"}, defaultValue="ICEBERG_TABLE", description={"Content-types to generate. Defaults to ICEBERG_TABLE. Possible values: ICEBERG_TABLE, ICEBERG_VIEW, DELTA_LAKE_TABLE"}, converter={ContentTypeConverter.class})
    private Content.Type contentType;
    @CommandLine.Option(names={"--key-pattern"})
    private String keyPattern;
    @CommandLine.Option(names={"--puts-per-commit"}, defaultValue="1")
    private int putsPerCommit;
    @CommandLine.Option(names={"--continue-on-error"}, defaultValue="false")
    private boolean continueOnError;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public void execute() throws BaseNessieClientServerException {
        if (this.runtimeDuration != null && (this.runtimeDuration.isZero() || this.runtimeDuration.isNegative())) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Duration must be absent to greater than zero.");
        }
        Duration perCommitDuration = Optional.ofNullable(this.runtimeDuration).orElse(Duration.ZERO).dividedBy(this.numCommits);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String runStartTime = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").format(LocalDateTime.now());
        List<ContentKey> tableNames = this.generateTableNames(runStartTime);
        try (NessieApiV2 api = this.createNessieApiInstance();){
            Branch defaultBranch;
            if (this.defaultBranchName == null) {
                defaultBranch = api.getDefaultBranch();
            } else {
                try {
                    defaultBranch = (Branch)api.getReference().refName(this.defaultBranchName).get();
                }
                catch (NessieReferenceNotFoundException e) {
                    defaultBranch = api.getDefaultBranch();
                    defaultBranch = (Branch)api.createReference().reference((Reference)Branch.of((String)this.defaultBranchName, (String)defaultBranch.getHash())).sourceRefName(defaultBranch.getName()).create();
                }
            }
            ArrayList<String> branches = new ArrayList<String>();
            branches.add(defaultBranch.getName());
            while (branches.size() < this.branchCount) {
                String newBranchName = "branch-" + runStartTime + "_" + (branches.size() - 1);
                Branch branch = Branch.of((String)newBranchName, (String)defaultBranch.getHash());
                this.spec.commandLine().getOut().printf("Creating branch '%s' from '%s' at %s%n", branch.getName(), defaultBranch.getName(), branch.getHash());
                api.createReference().reference((Reference)branch).sourceRefName(defaultBranch.getName()).create();
                branches.add(newBranchName);
            }
            this.spec.commandLine().getOut().printf("Starting contents generation, %d commits...%n", this.numCommits);
            for (int commitNum = 0; commitNum < this.numCommits; ++commitNum) {
                String branchName = (String)branches.get(random.nextInt(branches.size()));
                List keys = IntStream.range(0, this.putsPerCommit).mapToObj(i -> (ContentKey)tableNames.get(random.nextInt(tableNames.size()))).distinct().collect(Collectors.toList());
                GetMultipleContentsResponse contents = ((GetContentBuilder)api.getContent().refName(branchName)).keys(keys).getWithResponse();
                Map existing = contents.toContentsMap();
                Branch commitToBranch = (Branch)contents.getEffectiveReference();
                this.spec.commandLine().getOut().printf("Committing content-keys '%s' to branch '%s' at %s%n", keys.stream().map(ContentKey::toString).collect(Collectors.joining(", ")), commitToBranch.getName(), commitToBranch.getHash());
                CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)api.commitMultipleOperations().branch(commitToBranch)).commitMeta((CommitMeta)CommitMeta.builder().message(String.format("Commit #%d of %d on %s", commitNum, this.numCommits, branchName)).author(System.getProperty("user.name")).authorTime(Instant.now()).build());
                for (ContentKey key : keys) {
                    Content existingContent;
                    Content newContents = this.createContents(existingContent, random, (existingContent = (Content)existing.get(key)) != null ? existingContent.getId() : null);
                    if (existingContent instanceof IcebergTable || existingContent instanceof IcebergView || existingContent instanceof DeltaLakeTable) {
                        commit.operation((Operation)Operation.Put.of((ContentKey)key, (Content)newContents, (Content)existingContent));
                        continue;
                    }
                    commit.operation((Operation)Operation.Put.of((ContentKey)key, (Content)newContents));
                }
                try {
                    Branch newHead = commit.commit();
                    if (random.nextDouble() < this.newTagProbability) {
                        Tag tag = Tag.of((String)("new-tag-" + random.nextLong()), (String)newHead.getHash());
                        this.spec.commandLine().getOut().printf("Creating tag '%s' from '%s' at %s%n", tag.getName(), branchName, tag.getHash());
                        api.createReference().reference((Reference)tag).sourceRefName(branchName).create();
                    }
                }
                catch (NessieConflictException e) {
                    if (!this.continueOnError) {
                        throw e;
                    }
                    this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText("Conflict: " + (Object)((Object)e)));
                }
                try {
                    TimeUnit.NANOSECONDS.sleep(perCommitDuration.toNanos());
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.spec.commandLine().getOut().printf("Done creating contents.%n", new Object[0]);
    }

    private List<ContentKey> generateTableNames(String runStartTime) {
        IntFunction<ContentKey> mapper;
        if (this.keyPattern != null) {
            KeyGenerator generator = KeyGenerator.newKeyGenerator(this.keyPattern);
            mapper = i -> ContentKey.fromPathString((String)generator.generate());
        } else {
            mapper = i -> ContentKey.of((String[])new String[]{String.format("create-contents-%s", runStartTime), "contents", Integer.toString(i)});
        }
        return IntStream.range(0, this.numTables).mapToObj(mapper).collect(Collectors.toList());
    }

    private Content createContents(Content currentContents, ThreadLocalRandom random, String contentId) {
        if (this.contentType.equals(Content.Type.ICEBERG_TABLE)) {
            ImmutableIcebergTable.Builder icebergBuilder = ImmutableIcebergTable.builder().snapshotId(random.nextLong()).schemaId(random.nextInt()).specId(random.nextInt()).sortOrderId(random.nextInt()).metadataLocation("metadata " + random.nextLong());
            if (currentContents != null) {
                icebergBuilder.id(currentContents.getId());
            }
            if (contentId != null) {
                icebergBuilder.id(contentId);
            }
            return icebergBuilder.build();
        }
        if (this.contentType.equals(Content.Type.DELTA_LAKE_TABLE)) {
            ImmutableDeltaLakeTable.Builder deltaBuilder = ImmutableDeltaLakeTable.builder().lastCheckpoint("Last checkpoint foo bar " + random.nextLong()).addMetadataLocationHistory("metadata location history " + random.nextLong());
            for (int i = 0; i < random.nextInt(4); ++i) {
                deltaBuilder.lastCheckpoint("Another checkpoint " + random.nextLong()).addMetadataLocationHistory("Another metadata location " + random.nextLong());
            }
            if (currentContents != null) {
                deltaBuilder.id(currentContents.getId());
            }
            if (contentId != null) {
                deltaBuilder.id(contentId);
            }
            return deltaBuilder.build();
        }
        if (this.contentType.equals(Content.Type.ICEBERG_VIEW)) {
            ImmutableIcebergView.Builder viewBuilder = ImmutableIcebergView.builder().metadataLocation("metadata " + random.nextLong()).versionId(random.nextInt()).schemaId(random.nextInt()).dialect("Spark-" + random.nextInt()).sqlText("SELECT blah FROM meh;");
            if (currentContents != null) {
                viewBuilder.id(currentContents.getId());
            }
            if (contentId != null) {
                viewBuilder.id(contentId);
            }
            return viewBuilder.build();
        }
        throw new UnsupportedOperationException(String.format("Content type %s not supported", this.contentType.name()));
    }

    public static final class ContentTypeConverter
    implements CommandLine.ITypeConverter<Content.Type> {
        public Content.Type convert(String value) {
            return ContentTypes.forName((String)value.toUpperCase(Locale.ROOT).trim());
        }
    }
}

