/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import java.util.List;
import java.util.Map;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.GetMultipleContentsResponse;
import org.projectnessie.tools.contentgenerator.cli.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="content", mixinStandardHelpOptions=true, description={"Read content objects"})
public class ReadContent
extends AbstractCommand {
    @CommandLine.Option(names={"-r", "--ref"}, description={"Name of the branch/tag to read content from, defaults to 'main'"})
    private String ref = "main";
    @CommandLine.Option(names={"-k", "--key"}, description={"Content key to use"}, required=true)
    private List<String> key;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public void execute() throws NessieNotFoundException {
        try (NessieApiV2 api = this.createNessieApiInstance();){
            ContentKey contentKey = ContentKey.of(this.key);
            this.spec.commandLine().getOut().printf("Reading content for key '%s'\n\n", contentKey);
            GetMultipleContentsResponse contents = ((GetContentBuilder)api.getContent().refName(this.ref)).key(contentKey).getWithResponse();
            Map contentMap = contents.toContentsMap();
            this.spec.commandLine().getOut().printf("Content at '%s'\n", contents.getEffectiveReference());
            for (Map.Entry entry : contentMap.entrySet()) {
                this.spec.commandLine().getOut().printf("Key: %s\n", entry.getKey());
                if (this.isVerbose()) {
                    List key = ((ContentKey)entry.getKey()).getElements();
                    for (int i = 0; i < key.size(); ++i) {
                        this.spec.commandLine().getOut().printf("  key[%d]: %s\n", i, key.get(i));
                    }
                }
                this.spec.commandLine().getOut().printf("Value: %s\n", entry.getValue());
            }
            this.spec.commandLine().getOut().printf("\nDone reading content for key '%s'\n\n", contentKey);
        }
    }
}

