/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.keygen;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import org.projectnessie.tools.contentgenerator.keygen.KeyGenerator;

public final class Functions {
    static Map<String, FuncGenerator> FUNCTIONS = new HashMap<String, FuncGenerator>();

    private Functions() {
    }

    public static FuncGenerator resolveFunction(String function) {
        FuncGenerator generator = FUNCTIONS.get(function.toLowerCase(Locale.ROOT));
        if (generator == null) {
            throw new IllegalArgumentException("Unknown function '" + function + "'");
        }
        return generator;
    }

    static {
        FUNCTIONS.put("uuid", params -> new UuidFunc());
        FUNCTIONS.put("int", params -> {
            long bound = FuncGenerator.longParam(params);
            return new IntFunc(bound);
        });
        FUNCTIONS.put("string", params -> {
            int len = FuncGenerator.intParam(params);
            return new StringFunc(len);
        });
        FUNCTIONS.put("seq", params -> {
            int offset = FuncGenerator.intParam(params);
            return new SeqFunc(offset);
        });
        FUNCTIONS.put("prob", params -> {
            double prob = FuncGenerator.doubleParam(params);
            KeyGenerator.Func func = FuncGenerator.funcParam(params);
            return new ProbFunc(prob, func);
        });
        FUNCTIONS.put("every", params -> {
            int seq = FuncGenerator.intParam(params);
            KeyGenerator.Func func = FuncGenerator.funcParam(params);
            return new EveryFunc(seq, func);
        });
    }

    static final class ProbFunc
    implements KeyGenerator.Func {
        private final double prob;
        private final KeyGenerator.Func delegate;
        private String current;

        ProbFunc(double prob, KeyGenerator.Func delegate) {
            this.prob = prob;
            this.delegate = delegate;
        }

        @Override
        public void apply(Random random, StringBuilder target) {
            double v = random.nextDouble();
            if (v < this.prob) {
                this.current = null;
            }
            if (this.current == null) {
                StringBuilder sb = new StringBuilder();
                this.delegate.apply(random, sb);
                this.current = sb.toString();
            }
            target.append(this.current);
        }
    }

    static final class EveryFunc
    implements KeyGenerator.Func {
        private final int seq;
        private final KeyGenerator.Func delegate;
        private int num;
        private String current;

        EveryFunc(int seq, KeyGenerator.Func delegate) {
            this.seq = this.num = seq;
            this.delegate = delegate;
        }

        @Override
        public void apply(Random random, StringBuilder target) {
            if (this.num >= this.seq) {
                this.current = null;
            }
            if (this.current == null) {
                StringBuilder sb = new StringBuilder();
                this.delegate.apply(random, sb);
                this.current = sb.toString();
                this.num = 1;
            } else {
                ++this.num;
            }
            target.append(this.current);
        }
    }

    static final class SeqFunc
    implements KeyGenerator.Func {
        private int num;

        SeqFunc(int offset) {
            this.num = offset;
        }

        @Override
        public void apply(Random random, StringBuilder target) {
            target.append(this.num);
            ++this.num;
        }
    }

    static final class StringFunc
    implements KeyGenerator.Func {
        private final int len;
        private static final char[] CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789 ._-".toCharArray();

        StringFunc(int len) {
            this.len = len;
        }

        @Override
        public void apply(Random random, StringBuilder target) {
            for (int i = 0; i < this.len; ++i) {
                char c = CHARS[random.nextInt(CHARS.length)];
                target.append(c);
            }
        }
    }

    static final class IntFunc
    implements KeyGenerator.Func {
        private final long bound;

        IntFunc(long bound) {
            Preconditions.checkArgument((bound > 0L ? 1 : 0) != 0, (Object)"Bound for random must be positive");
            this.bound = bound;
        }

        @Override
        public void apply(Random random, StringBuilder target) {
            long v = (random.nextLong() & Long.MAX_VALUE) % this.bound;
            target.append(v);
        }
    }

    static final class UuidFunc
    implements KeyGenerator.Func {
        UuidFunc() {
        }

        @Override
        public void apply(Random random, StringBuilder target) {
            byte[] uuid = new byte[16];
            random.nextBytes(uuid);
            target.append(UUID.nameUUIDFromBytes(uuid));
        }
    }

    @FunctionalInterface
    static interface FuncGenerator {
        public KeyGenerator.Func generate(Queue<String> var1);

        public static double doubleParam(Queue<String> params) {
            return Double.parseDouble(params.remove());
        }

        public static int intParam(Queue<String> params) {
            return Integer.parseInt(params.remove());
        }

        public static long longParam(Queue<String> params) {
            return Long.parseLong(params.remove());
        }

        public static KeyGenerator.Func funcParam(Queue<String> params) {
            String name = params.remove();
            return Functions.resolveFunction(name).generate(params);
        }
    }
}

