/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.keygen;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.projectnessie.tools.contentgenerator.keygen.Functions;
import org.projectnessie.tools.contentgenerator.keygen.KeyGenerator;

class PatternParser {
    private final String pattern;
    private final ArrayList<KeyGenerator.Func> generators = new ArrayList();

    PatternParser(String pattern) {
        this.pattern = pattern;
    }

    IllegalArgumentException parseError(int i, String msg) {
        return new IllegalArgumentException("Failure parsing pattern '" + this.pattern + "' at col #" + i + ": " + msg);
    }

    IllegalArgumentException parseError(int i, String msg, Exception e) {
        return new IllegalArgumentException("Failure parsing pattern '" + this.pattern + "' at col #" + i + ": " + msg, e);
    }

    List<KeyGenerator.Func> parse() {
        StringBuilder currentConstant = new StringBuilder();
        StringBuilder currentFunc = new StringBuilder();
        String p = this.pattern;
        int l = p.length();
        State state = State.CONST;
        block10: for (int i = 0; i < l; ++i) {
            char c = p.charAt(i);
            switch (state) {
                case CONST: {
                    if (c == '$') {
                        this.maybeAddConstant(currentConstant);
                        state = State.DOLLAR;
                        continue block10;
                    }
                    currentConstant.append(c);
                    continue block10;
                }
                case DOLLAR: {
                    if (c == '{') {
                        state = State.FUNC;
                        continue block10;
                    }
                    if (c == '$') {
                        currentConstant.append('$');
                        state = State.CONST;
                        continue block10;
                    }
                    throw this.parseError(i, "illegal function declaration");
                }
                case FUNC: {
                    if (c == '}') {
                        try {
                            this.parseFuncPattern(currentFunc);
                            state = State.CONST;
                            continue block10;
                        }
                        catch (Exception e) {
                            throw this.parseError(i, "failure parsing function declaration: " + e.getMessage(), e);
                        }
                    }
                    currentFunc.append(c);
                    continue block10;
                }
            }
        }
        switch (state) {
            case DOLLAR: 
            case FUNC: {
                throw this.parseError(l, "unclosed function pattern at the end of the pattern");
            }
        }
        this.maybeAddConstant(currentConstant);
        this.generators.trimToSize();
        return Collections.unmodifiableList(this.generators);
    }

    private void parseFuncPattern(StringBuilder currentFunc) {
        this.parseFuncPattern(currentFunc.toString());
        currentFunc.setLength(0);
    }

    private void parseFuncPattern(String func) {
        String name;
        func = func.trim();
        int i = func.indexOf(44);
        ArrayList<String> args = new ArrayList<String>();
        if (i == -1) {
            name = func;
        } else {
            name = func.substring(0, i).trim();
            while (++i < func.length()) {
                int next = func.indexOf(44, i);
                if (next == -1) {
                    args.add(func.substring(i).trim());
                    break;
                }
                args.add(func.substring(i, next).trim());
                i = next;
            }
        }
        ArrayDeque<String> params = new ArrayDeque<String>(args);
        this.generators.add(Functions.resolveFunction(name).generate(params));
    }

    private void maybeAddConstant(StringBuilder currentConstant) {
        if (currentConstant.length() > 0) {
            String c = currentConstant.toString();
            currentConstant.setLength(0);
            this.generators.add((r, sb) -> sb.append(c));
        }
    }

    static enum State {
        CONST,
        DOLLAR,
        FUNC;

    }
}

