/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.net.URI;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.tools.contentgenerator.cli.ContentGenerator;
import picocli.CommandLine;

public class NessieContentGenerator
extends ContentGenerator<NessieApiV2> {
    @CommandLine.Option(names={"-u", "--uri"}, scope=CommandLine.ScopeType.INHERIT, description={"Nessie API endpoint URI, defaults to http://localhost:19120/api/v2."})
    private URI uri = URI.create("http://localhost:19120/api/v2");

    public static void main(String[] arguments) {
        System.exit(NessieContentGenerator.runMain(arguments));
    }

    @Override
    public NessieApiV2 createNessieApiInstance() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.builder();
        clientBuilder.fromSystemProperties();
        if (this.uri != null) {
            clientBuilder.withUri(this.uri);
        }
        return (NessieApiV2)clientBuilder.build(NessieApiV2.class);
    }

    @VisibleForTesting
    public static int runMain(String[] arguments) {
        return NessieContentGenerator.runMain(null, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static int runMain(PrintWriter out, String[] arguments) {
        CommandLine commandLine = new CommandLine((Object)new NessieContentGenerator()).setExecutionExceptionHandler((ex, cmd, parseResult) -> {
            if (ex instanceof BaseNessieClientServerException || ex instanceof HttpClientException) {
                cmd.getErr().println(cmd.getColorScheme().errorText(ex.toString()));
            } else {
                cmd.getErr().println(cmd.getColorScheme().richStackTraceString((Throwable)ex));
            }
            return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode((Throwable)ex) : cmd.getCommandSpec().exitCodeOnExecutionException();
        });
        if (null != out) {
            commandLine = commandLine.setOut(out);
        }
        try {
            int n = commandLine.execute(arguments);
            return n;
        }
        finally {
            commandLine.getOut().flush();
            commandLine.getErr().flush();
        }
    }
}

