/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.api;

import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.EntriesResponse;
import com.dremio.nessie.model.LogResponse;
import com.dremio.nessie.model.Merge;
import com.dremio.nessie.model.Operations;
import com.dremio.nessie.model.Reference;
import com.dremio.nessie.model.Tag;
import com.dremio.nessie.model.Transplant;
import java.util.List;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.parameters.RequestBody;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponses;

@Consumes(value={"application/json"})
@Path(value="trees")
public interface TreeApi {
    @GET
    @Produces(value={"application/json"})
    @Operation(summary="Get all references")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned references.")})
    public List<Reference> getAllReferences();

    @GET
    @Produces(value={"application/json"})
    @Path(value="tree")
    @Operation(summary="Get default branch for commits and reads")
    @APIResponses(value={@APIResponse(responseCode="200", description="Found and default bracnh."), @APIResponse(responseCode="404", description="Default branch not found.")})
    public Branch getDefaultBranch() throws NessieNotFoundException;

    @POST
    @Path(value="tree")
    @Operation(summary="Create a new reference")
    @APIResponses(value={@APIResponse(responseCode="204", description="Created successfully."), @APIResponse(responseCode="409", description="Reference already exists")})
    public void createReference(@NotNull @RequestBody(description="Reference to create.") Reference var1) throws NessieNotFoundException, NessieConflictException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}")
    @Operation(summary="Fetch details of a reference")
    @APIResponses(value={@APIResponse(responseCode="200", description="Found and returned reference."), @APIResponse(responseCode="404", description="Ref not found")})
    public Reference getReferenceByName(@NotNull @Parameter(description="name of ref to fetch") @PathParam(value="ref") String var1) throws NessieNotFoundException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}/entries")
    @Operation(summary="Fetch all entries for a given reference")
    @APIResponses(value={@APIResponse(description="all objects for a reference"), @APIResponse(responseCode="200", description="Returned successfully."), @APIResponse(responseCode="404", description="Ref not found")})
    public EntriesResponse getEntries(@NotNull @Parameter(description="name of ref to fetch from") @PathParam(value="ref") String var1) throws NessieNotFoundException;

    @GET
    @Produces(value={"application/json"})
    @Path(value="tree/{ref}/log")
    @Operation(summary="Get commit log for a reference")
    @APIResponses(value={@APIResponse(responseCode="200", description="Returned commits."), @APIResponse(responseCode="404", description="Ref doesn't exists")})
    public LogResponse getCommitLog(@NotNull @Parameter(description="ref to show log from") @PathParam(value="ref") String var1) throws NessieNotFoundException;

    @PUT
    @Path(value="tag/{tagName}")
    @Operation(summary="Set a tag to a specific hash")
    @APIResponses(value={@APIResponse(responseCode="204", description="Assigned successfully"), @APIResponse(responseCode="404", description="One or more references don't exist"), @APIResponse(responseCode="412", description="Update conflict")})
    public void assignTag(@NotNull @Parameter(description="Tag name to reassign") @PathParam(value="tagName") String var1, @NotNull @Parameter(description="Expected previous hash of tag") @QueryParam(value="expectedHash") String var2, @NotNull @RequestBody(description="New tag content") Tag var3) throws NessieNotFoundException, NessieConflictException;

    @DELETE
    @Path(value="tag/{tagName}")
    @Operation(summary="Delete a tag")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="412", description="update conflict")})
    public void deleteTag(@NotNull @Parameter(description="Tag to delete") @PathParam(value="tagName") String var1, @Parameter(description="Expected hash of tag") @QueryParam(value="expectedHash") String var2) throws NessieConflictException, NessieNotFoundException;

    @PUT
    @Path(value="branch/{branchName}")
    @Operation(summary="Set a branch to a specific hash")
    @APIResponses(value={@APIResponse(responseCode="204", description="Assigned successfully"), @APIResponse(responseCode="404", description="One or more references don't exist"), @APIResponse(responseCode="412", description="Update conflict")})
    public void assignBranch(@NotNull @Parameter(description="Tag name to reassign") @PathParam(value="branchName") String var1, @NotNull @Parameter(description="Expected previous hash of tag") @QueryParam(value="expectedHash") String var2, @NotNull @RequestBody(description="New branch content") Branch var3) throws NessieNotFoundException, NessieConflictException;

    @DELETE
    @Path(value="branch/{branchName}")
    @Operation(summary="Delete a branch endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Deleted successfully."), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="412", description="update conflict")})
    public void deleteBranch(@NotNull @Parameter(description="Branch to delete") @PathParam(value="branchName") String var1, @NotNull @Parameter(description="Expected hash of tag") @QueryParam(value="expectedHash") String var2) throws NessieConflictException, NessieNotFoundException;

    @POST
    @Path(value="branch/{branchName}/transplant")
    @Operation(summary="transplant commits from mergeRef to ref endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Merged successfully."), @APIResponse(responseCode="401", description="no merge ref supplied"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="412", description="update conflict")})
    public void transplantCommitsIntoBranch(@NotNull @Parameter(description="Branch to transplant into") @PathParam(value="branchName") String var1, @NotNull @Parameter(description="Expected hash of tag") @QueryParam(value="expectedHash") String var2, @Parameter(description="commit message") @QueryParam(value="message") String var3, @RequestBody(description="Hashes to transplant") Transplant var4) throws NessieNotFoundException, NessieConflictException;

    @POST
    @Path(value="branch/{branchName}/merge")
    @Operation(summary="merge commits from mergeRef to ref endpoint")
    @APIResponses(value={@APIResponse(responseCode="204", description="Merged successfully."), @APIResponse(responseCode="401", description="no merge ref supplied"), @APIResponse(responseCode="404", description="Ref doesn't exists"), @APIResponse(responseCode="412", description="update conflict")})
    public void mergeRefIntoBranch(@NotNull @Parameter(description="Branch to merge into") @PathParam(value="branchName") String var1, @NotNull @Parameter(description="Expected hash of tag") @QueryParam(value="expectedHash") String var2, @NotNull @RequestBody(description="Merge operation") Merge var3) throws NessieNotFoundException, NessieConflictException;

    @POST
    @Path(value="branch/{branchName}/commit")
    @Consumes(value={"application/json"})
    @Operation(summary="commit multiple on default branch")
    @APIResponses(value={@APIResponse(responseCode="204", description="Updated successfully."), @APIResponse(responseCode="404", description="Provided ref doesn't exists"), @APIResponse(responseCode="412", description="Update conflict")})
    public void commitMultipleOperations(@NotNull @Parameter(description="Branch to change, defaults to default branch.") @PathParam(value="branchName") String var1, @NotNull @Parameter(description="Expected hash of branch.") @QueryParam(value="expectedHash") String var2, @Parameter(description="Commit message") @QueryParam(value="message") String var3, @NotNull @RequestBody(description="Operations") Operations var4) throws NessieNotFoundException, NessieConflictException;
}

