/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client;

import com.dremio.nessie.api.ConfigApi;
import com.dremio.nessie.api.ContentsApi;
import com.dremio.nessie.api.TreeApi;
import com.dremio.nessie.client.ClientConfigApi;
import com.dremio.nessie.client.ClientContentsApi;
import com.dremio.nessie.client.ClientTreeApi;
import com.dremio.nessie.client.auth.AwsAuth;
import com.dremio.nessie.client.auth.BasicAuthFilter;
import com.dremio.nessie.client.http.HttpClient;
import com.dremio.nessie.client.http.HttpClientException;
import com.dremio.nessie.client.rest.NessieHttpResponseFilter;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import java.util.function.Function;

public class NessieClient
implements Closeable {
    private final HttpClient client;
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private final TreeApi tree;
    private final ConfigApi config;
    private final ContentsApi contents;

    public NessieClient(AuthType authType, String path, String username, String password) {
        this.client = HttpClient.builder().setBaseUri(path).setObjectMapper(this.mapper).build();
        this.authFilter(this.client, authType, username, password);
        this.client.register(new NessieHttpResponseFilter(this.mapper));
        this.contents = this.wrap(ContentsApi.class, new ClientContentsApi(this.client));
        this.tree = this.wrap(TreeApi.class, new ClientTreeApi(this.client));
        this.config = this.wrap(ConfigApi.class, new ClientConfigApi(this.client));
    }

    private void authFilter(HttpClient client, AuthType authType, String username, String password) {
        switch (authType) {
            case AWS: {
                client.register(new AwsAuth(this.mapper));
                break;
            }
            case BASIC: {
                client.register(new BasicAuthFilter(username, password));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Cannot instantiate auth filter for %s. Not a valid auth type", new Object[]{authType}));
            }
        }
    }

    private <T> T wrap(Class<T> iface, T delegate) {
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), new Class[]{iface}, (InvocationHandler)new ExceptionRewriter(delegate));
    }

    public TreeApi getTreeApi() {
        return this.tree;
    }

    public ContentsApi getContentsApi() {
        return this.contents;
    }

    public ConfigApi getConfigApi() {
        return this.config;
    }

    @Override
    public void close() {
    }

    public static NessieClient basic(String path, String username, String password) {
        return new NessieClient(AuthType.BASIC, path, username, password);
    }

    public static NessieClient aws(String path) {
        return new NessieClient(AuthType.AWS, path, null, null);
    }

    public static NessieClient none(String path) {
        return new NessieClient(AuthType.NONE, path, null, null);
    }

    public static NessieClient withConfig(Function<String, String> configuration) {
        String url = Objects.requireNonNull(configuration.apply("nessie.url"));
        String authType = configuration.apply("nessie.auth_type");
        String username = configuration.apply("nessie.username");
        String password = configuration.apply("nessie.password");
        if (authType == null) {
            authType = username != null && password != null ? AuthType.BASIC.name() : AuthType.NONE.name();
        }
        return new NessieClient(AuthType.valueOf(authType), url, username, password);
    }

    private static class ExceptionRewriter
    implements InvocationHandler {
        private final Object delegate;

        public ExceptionRewriter(Object delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (targetException instanceof HttpClientException) {
                    if (targetException.getCause() instanceof NessieNotFoundException) {
                        throw (NessieNotFoundException)targetException.getCause();
                    }
                    if (targetException.getCause() instanceof NessieConflictException) {
                        throw (NessieConflictException)targetException.getCause();
                    }
                }
                if (targetException instanceof RuntimeException) {
                    throw targetException;
                }
                throw ex;
            }
        }
    }

    public static enum AuthType {
        AWS,
        BASIC,
        NONE;

    }
}

