/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.auth;

import com.dremio.nessie.client.http.RequestContext;
import com.dremio.nessie.client.http.RequestFilter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

public class BasicAuthFilter
implements RequestFilter {
    private final String authHeaderValue;

    public BasicAuthFilter(String username, String password) {
        Objects.requireNonNull(username, "username for BasicAuthFilter must not be null");
        Objects.requireNonNull(password, "password for BasicAuthFilter must not be null");
        String userPass = username + ':' + password;
        byte[] encoded = Base64.getEncoder().encode(userPass.getBytes(StandardCharsets.UTF_8));
        String encodedString = new String(encoded, StandardCharsets.UTF_8);
        this.authHeaderValue = "Basic " + encodedString;
    }

    @Override
    public void filter(RequestContext context) {
        context.putHeader("Authorization", this.authHeaderValue);
    }
}

