/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.http;

import com.dremio.nessie.client.http.HttpClientException;
import com.dremio.nessie.client.http.HttpUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class UriBuilder {
    private final String baseUri;
    private final StringBuilder uri = new StringBuilder();
    private final StringBuilder query = new StringBuilder();
    private final Map<String, String> templateValues = new HashMap<String, String>();

    UriBuilder(String baseUri) {
        this.baseUri = HttpUtils.checkNonNullTrim(baseUri);
        HttpUtils.checkArgument(this.baseUri.length() > 0, "Base uri %s must be of length greater than 0", this.baseUri);
    }

    UriBuilder path(String path) {
        String trimmedPath;
        if (this.uri.length() > 0) {
            this.uri.append('/');
        }
        HttpUtils.checkArgument((trimmedPath = HttpUtils.checkNonNullTrim(path)).length() > 0, "Path %s must be of length greater than 0", trimmedPath);
        this.uri.append(trimmedPath);
        return this;
    }

    UriBuilder queryParam(String name, String value) {
        if (value == null) {
            return this;
        }
        if (this.query.length() > 0) {
            this.query.append('&');
        }
        this.query.append(UriBuilder.encode(HttpUtils.checkNonNullTrim(name))).append('=').append(UriBuilder.encode(HttpUtils.checkNonNullTrim(value)));
        return this;
    }

    UriBuilder resolveTemplate(String name, String value) {
        this.templateValues.put(String.format("{%s}", HttpUtils.checkNonNullTrim(name)), HttpUtils.checkNonNullTrim(value));
        return this;
    }

    private static void checkEmpty(Map<String, String> templates, StringBuilder uri) {
        if (!templates.isEmpty()) {
            String keys = String.join((CharSequence)";", templates.keySet());
            throw new HttpClientException(String.format("Cannot build uri. Not all template keys (%s) were used in uri %s", keys, uri));
        }
    }

    String build() throws HttpClientException {
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append(this.baseUri);
        if ('/' != uriBuilder.charAt(uriBuilder.length() - 1)) {
            uriBuilder.append('/');
        }
        if (this.uri.length() > 0) {
            HashMap<String, String> templates = new HashMap<String, String>(this.templateValues);
            Arrays.stream(this.uri.toString().split("/")).map(p -> UriBuilder.encode(templates.containsKey(p) ? (String)templates.remove(p) : p)).forEach(x -> {
                if ('/' != uriBuilder.charAt(uriBuilder.length() - 1)) {
                    uriBuilder.append('/');
                }
                uriBuilder.append((String)x);
            });
            UriBuilder.checkEmpty(templates, this.uri);
            if ('/' == uriBuilder.charAt(uriBuilder.length() - 1)) {
                return uriBuilder.subSequence(0, uriBuilder.length() - 1).toString();
            }
        } else {
            UriBuilder.checkEmpty(this.templateValues, this.uri);
        }
        if (this.query.length() > 0) {
            uriBuilder.append("?");
            uriBuilder.append((CharSequence)this.query);
        }
        return uriBuilder.toString();
    }

    private static String encode(String s) throws HttpClientException {
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new HttpClientException(String.format("Cannot url encode %s", s), e);
        }
    }
}

