/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.deltalake;

import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.DeltaLakeTable;
import com.dremio.nessie.model.ImmutableDeltaLakeTable;
import com.dremio.nessie.model.Reference;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.DeltaFileType;
import org.apache.spark.sql.delta.DeltaFileType$CHECKPOINT$;
import org.apache.spark.sql.delta.DeltaFileType$CHECKSUM$;
import org.apache.spark.sql.delta.DeltaFileType$DELTA$;
import org.apache.spark.sql.delta.DeltaFileType$UNKNOWN$;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t=e\u0001\u0002\u0017.\u0001YB\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\t1\u0002\u0011\t\u0011)A\u00053\")\u0011\r\u0001C\u0001E\"9q\r\u0001b\u0001\n\u0003A\u0007BB:\u0001A\u0003%\u0011\u000eC\u0004u\u0001\t\u0007I\u0011\u00015\t\rU\u0004\u0001\u0015!\u0003j\u0011\u001d1\bA1A\u0005\u0002!Daa\u001e\u0001!\u0002\u0013I\u0007b\u0002=\u0001\u0001\u0004%\t!\u001f\u0005\n\u0003#\u0001\u0001\u0019!C\u0001\u0003'Aq!a\b\u0001A\u0003&!\u0010C\u0005\u0002\"\u0001\u0011\r\u0011\"\u0003\u0002$!A\u0011q\u0006\u0001!\u0002\u0013\t)\u0003C\u0004\u00022\u0001!I!a\r\t\u0013\u0005\u0005\u0003\u00011A\u0005\n\u0005\r\u0003\"CA#\u0001\u0001\u0007I\u0011BA$\u0011!\tY\u0005\u0001Q!\n\u0005U\u0002bBA'\u0001\u0011\u0005\u0013q\n\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\t)\t\u0001C!\u0003\u000fC\u0011\"a'\u0001#\u0003%\t!!(\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"I\u0011q\u0019\u0001\u0012\u0002\u0013%\u0011\u0011\u001a\u0005\b\u0003\u001b\u0004A\u0011BAh\u0011\u001d\t9\u000f\u0001C\u0005\u0003SDq!!>\u0001\t\u0013\t9\u0010C\u0005\u0003\n\u0001\t\n\u0011\"\u0003\u0002J\"I!1\u0002\u0001\u0012\u0002\u0013%\u0011\u0011\u001a\u0005\b\u0005\u001b\u0001A\u0011\u0003B\b\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057AqA!\u0007\u0001\t\u0003\u0011)\u0003C\u0004\u0003*\u0001!\tAa\u000b\t\u000f\t]\u0002\u0001\"\u0001\u0003:!9!Q\t\u0001\u0005\u0002\t\u001d\u0003b\u0002B*\u0001\u0011\u0005!Q\u000b\u0005\b\u00053\u0002A\u0011\u0001B.\u0011\u001d\u0011\t\u0007\u0001C\u0005\u0005GBqA!\u001c\u0001\t\u0013\u0011y\u0007C\u0004\u0003z\u0001!\tEa\u001f\t\u000f\t}\u0004\u0001\"\u0011\u0003\u0002\"9!1\u0011\u0001\u0005B\t\u0015\u0005b\u0002BE\u0001\u0011\u0005#1\u0012\u0002\u000f\u001d\u0016\u001c8/[3M_\u001e\u001cFo\u001c:f\u0015\tqs&A\u0005eK2$\u0018\r\\1lK*\u0011\u0001'M\u0001\u0007]\u0016\u001c8/[3\u000b\u0005I\u001a\u0014A\u00023sK6LwNC\u00015\u0003\r\u0019w.\\\u0002\u0001'\u0011\u0001q'P'\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g!\tq4*D\u0001@\u0015\t\u0001\u0015)A\u0004ti>\u0014\u0018mZ3\u000b\u0005\t\u001b\u0015!\u00023fYR\f'B\u0001#F\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\r\u001e\u000bQa\u001d9be.T!\u0001S%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0015aA8sO&\u0011Aj\u0010\u0002\t\u0019><7\u000b^8sKB\u0011a*U\u0007\u0002\u001f*\u0011\u0001+R\u0001\tS:$XM\u001d8bY&\u0011!k\u0014\u0002\b\u0019><w-\u001b8h\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002V-6\tQ)\u0003\u0002X\u000b\nI1\u000b]1sW\u000e{gNZ\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011\u0019wN\u001c4\u000b\u0005y;\u0015A\u00025bI>|\u0007/\u0003\u0002a7\ni1i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDcA2fMB\u0011A\rA\u0007\u0002[!)1k\u0001a\u0001)\")\u0001l\u0001a\u00013\u0006\u0001B-\u001a7uC\u001aKG.\u001a)biR,'O\\\u000b\u0002SB\u0011!.]\u0007\u0002W*\u0011A.\\\u0001\u0006e\u0016<W\r\u001f\u0006\u0003]>\fA!\u001e;jY*\t\u0001/\u0001\u0003kCZ\f\u0017B\u0001:l\u0005\u001d\u0001\u0016\r\u001e;fe:\f\u0011\u0003Z3mi\u00064\u0015\u000e\\3QCR$XM\u001d8!\u0003M\u0019\u0007.Z2lgVlg)\u001b7f!\u0006$H/\u001a:o\u0003Q\u0019\u0007.Z2lgVlg)\u001b7f!\u0006$H/\u001a:oA\u0005)2\r[3dWB|\u0017N\u001c;GS2,\u0007+\u0019;uKJt\u0017AF2iK\u000e\\\u0007o\\5oi\u001aKG.\u001a)biR,'O\u001c\u0011\u0002!1\f7\u000f^*oCB\u001c\bn\u001c;Vk&$W#\u0001>\u0011\u0007aZX0\u0003\u0002}s\t1q\n\u001d;j_:\u00042A`A\u0006\u001d\ry\u0018q\u0001\t\u0004\u0003\u0003ITBAA\u0002\u0015\r\t)!N\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005%\u0011(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001b\tyA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0013I\u0014\u0001\u00067bgR\u001cf.\u00199tQ>$X+^5e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0016\u0005m\u0001c\u0001\u001d\u0002\u0018%\u0019\u0011\u0011D\u001d\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003;Y\u0011\u0011!a\u0001u\u0006\u0019\u0001\u0010J\u0019\u0002#1\f7\u000f^*oCB\u001c\bn\u001c;Vk&$\u0007%\u0001\u0004dY&,g\u000e^\u000b\u0003\u0003K\u0001B!a\n\u0002,5\u0011\u0011\u0011\u0006\u0006\u0004\u0003Cy\u0013\u0002BA\u0017\u0003S\u0011ABT3tg&,7\t\\5f]R\fqa\u00197jK:$\b%A\u0006hKR|%o\u0011:fCR,GCAA\u001b!\u0011\t9$!\u0010\u000e\u0005\u0005e\"bAA\u001e_\u0005)Qn\u001c3fY&!\u0011qHA\u001d\u0005%\u0011VMZ3sK:\u001cW-A\u0005sK\u001a,'/\u001a8dKV\u0011\u0011QG\u0001\u000ee\u00164WM]3oG\u0016|F%Z9\u0015\t\u0005U\u0011\u0011\n\u0005\n\u0003;\t\u0012\u0011!a\u0001\u0003k\t!B]3gKJ,gnY3!\u0003!a\u0017n\u001d;Ge>lG\u0003BA)\u0003_\u0002b!a\u0015\u0002^\u0005\rd\u0002BA+\u00033rA!!\u0001\u0002X%\t!(C\u0002\u0002\\e\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002`\u0005\u0005$\u0001C%uKJ\fGo\u001c:\u000b\u0007\u0005m\u0013\b\u0005\u0003\u0002f\u0005-TBAA4\u0015\r\tI'X\u0001\u0003MNLA!!\u001c\u0002h\tQa)\u001b7f'R\fG/^:\t\u000f\u0005E4\u00031\u0001\u0002t\u0005!\u0001/\u0019;i!\u0011\t)'!\u001e\n\t\u0005]\u0014q\r\u0002\u0005!\u0006$\b.\u0001\u000bqCJ\u001cX\rV1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u000b\u0005\u0003{\n\u0019\t\u0005\u00049\u0003\u007fjX0`\u0005\u0004\u0003\u0003K$A\u0002+va2,7\u0007\u0003\u0004\u0002rQ\u0001\r!`\u0001\u0006oJLG/\u001a\u000b\t\u0003+\tI)a#\u0002\u0012\"9\u0011\u0011O\u000bA\u0002\u0005M\u0004bBAG+\u0001\u0007\u0011qR\u0001\bC\u000e$\u0018n\u001c8t!\u0015\t\u0019&!\u0018~\u0011%\t\u0019*\u0006I\u0001\u0002\u0004\t)*A\u0005pm\u0016\u0014xO]5uKB\u0019\u0001(a&\n\u0007\u0005e\u0015HA\u0004C_>dW-\u00198\u0002\u001f]\u0014\u0018\u000e^3%I\u00164\u0017-\u001e7uIM*\"!a(+\t\u0005U\u0015\u0011U\u0016\u0003\u0003G\u0003B!!*\u000206\u0011\u0011q\u0015\u0006\u0005\u0003S\u000bY+A\u0005v]\u000eDWmY6fI*\u0019\u0011QV\u001d\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00022\u0006\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001R\u000f\u001d3bi\u0016$U\r\u001c;b)\u0006\u0014G.\u001a\u000b\t\u0003o\u000bi,a0\u0002DB!\u0011qGA]\u0013\u0011\tY,!\u000f\u0003\u001d\u0011+G\u000e^1MC.,G+\u00192mK\"9\u0011\u0011O\fA\u0002\u0005M\u0004BBAa/\u0001\u0007Q0A\u0005uCJ<W\r\u001e*fM\"A\u0011QY\f\u0011\u0002\u0003\u0007Q0\u0001\bmCN$8\t[3dWB|\u0017N\u001c;\u00025U\u0004H-\u0019;f\t\u0016dG/\u0019+bE2,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005-'fA?\u0002\"\u0006\tR\r\u001f;sC\u000e$8\t[3dWB|\u0017N\u001c;\u0015\r\u0005E\u00171]As!\u001dA\u00141[Al\u0003;L1!!6:\u0005\u0019!V\u000f\u001d7feA\u0019\u0001(!7\n\u0007\u0005m\u0017H\u0001\u0003M_:<\u0007#BA*\u0003?l\u0018\u0002BAq\u0003C\u00121aU3r\u0011\u0019\t)-\u0007a\u0001{\"9\u0011\u0011O\rA\u0002\u0005M\u0014aE7pm\u0016\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u001cHCBAo\u0003W\f\t\u0010C\u0004\u0002nj\u0001\r!a<\u0002\u000b\u0019LG.Z:\u0011\r\u0005M\u0013q\\A:\u0011\u001d\t\u0019P\u0007a\u0001\u0003g\nq\u0001Z3ti\u0012K'/\u0001\u0004d_6l\u0017\u000e\u001e\u000b\r\u0003+\u000bI0a?\u0002\u0000\n\r!q\u0001\u0005\b\u0003cZ\u0002\u0019AA:\u0011\u0019\tip\u0007a\u0001{\u0006\u0019!/\u001a4\t\r\t\u00051\u00041\u0001~\u0003\u0011A\u0017m\u001d5\t\u0011\t\u00151\u0004%AA\u0002u\fq!\\3tg\u0006<W\r\u0003\u0005\u0002Fn\u0001\n\u00111\u0001~\u0003A\u0019w.\\7ji\u0012\"WMZ1vYR$C'\u0001\td_6l\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u0005iqO]5uK&sG/\u001a:oC2$\"\"!\u0006\u0003\u0012\tM!Q\u0003B\f\u0011\u001d\t\tH\ba\u0001\u0003gBq!!$\u001f\u0001\u0004\ty\t\u0003\u0004\u0002~z\u0001\r! \u0005\u0007\u0005\u0003q\u0002\u0019A?\u0002\u0013A\fG\u000f\u001b+p\u0017\u0016LH\u0003\u0002B\u000f\u0005G\u0001B!a\u000e\u0003 %!!\u0011EA\u001d\u0005-\u0019uN\u001c;f]R\u001c8*Z=\t\u000f\u0005Et\u00041\u0001\u0002tQ!!Q\u0004B\u0014\u0011\u0019\t\t\b\ta\u0001{\u0006\u0011b.^7DQ\u0016\u001c7\u000e]8j]R\u0004\u0016M\u001d;t)\u0011\u0011iC!\u000e\u0011\taZ(q\u0006\t\u0004q\tE\u0012b\u0001B\u001as\t\u0019\u0011J\u001c;\t\u000f\u0005E\u0014\u00051\u0001\u0002t\u0005Yq-\u001a;GS2,G+\u001f9f)\u0011\u0011YDa\u0011\u0011\t\tu\"qH\u0007\u0002\u0003&\u0019!\u0011I!\u0003\u001b\u0011+G\u000e^1GS2,G+\u001f9f\u0011\u001d\t\tH\ta\u0001\u0003g\n1\"\u001a=ue\u0006\u001cG/T3uCR!!\u0011\nB(!\u0011\u0011iDa\u0013\n\u0007\t5\u0013IA\u0006M_\u001e4\u0015\u000e\\3NKR\f\u0007b\u0002B)G\u0001\u0007\u00111M\u0001\u000bM&dWm\u0015;biV\u001c\u0018AD3yiJ\f7\r\u001e,feNLwN\u001c\u000b\u0005\u0003/\u00149\u0006C\u0004\u0002r\u0011\u0002\r!a\u001d\u0002\u001b1L7\u000f\u001e$jY\u0016\u001chI]8n)\u0011\u0011iFa\u0018\u0011\r\u0005M\u0013Q\fB%\u0011\u001d\t\t(\na\u0001\u0003g\nq\"Z7qif\u001c\u0005.Z2la>Lg\u000e\u001e\u000b\u0007\u0005\u0013\u0012)G!\u001b\t\u000f\t\u001dd\u00051\u0001\u0002X\u00069a/\u001a:tS>t\u0007b\u0002B6M\u0001\u0007!\u0011J\u0001\fY><g)\u001b7f\u001b\u0016$\u0018-\u0001\u0005hKR$\u0016M\u00197f)\u0019\u0011\tHa\u001d\u0003vA!\u0001h_A\\\u0011\u001d\t\th\na\u0001\u0003gBaAa\u001e(\u0001\u0004i\u0018A\u00022sC:\u001c\u0007.\u0001\u0003sK\u0006$G\u0003BAo\u0005{Bq!!\u001d)\u0001\u0004\t\u0019(A\bj]Z\fG.\u001b3bi\u0016\u001c\u0015m\u00195f)\t\t)\"A\u000bjgB\u000b'\u000f^5bY^\u0013\u0018\u000e^3WSNL'\r\\3\u0015\t\u0005U%q\u0011\u0005\b\u0003cR\u0003\u0019AA:\u0003U\u0011Xm]8mm\u0016\u001c\u0005.Z2la>Lg\u000e\u001e)bi\"$B!a\u001d\u0003\u000e\"9\u0011\u0011O\u0016A\u0002\u0005M\u0004")
public class NessieLogStore
implements LogStore,
Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final Pattern deltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;
    private Option<String> lastSnapshotUuid;
    private final NessieClient client;
    private Reference reference;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public final Seq<String> read(String path) {
        return LogStore.read$(this, path);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore.write$(this, path, actions);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore.listFrom$(this, path);
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return LogStore.resolvePathOnPhysicalStorage$(this, path);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Option<String> lastSnapshotUuid() {
        return this.lastSnapshotUuid;
    }

    public void lastSnapshotUuid_$eq(Option<String> x$1) {
        this.lastSnapshotUuid = x$1;
    }

    private NessieClient client() {
        return this.client;
    }

    private Reference getOrCreate() {
        Reference reference;
        String requestedRef = this.hadoopConf.get("nessie.ref");
        try {
            reference = (Reference)Option$.MODULE$.apply((Object)requestedRef).map((Function1 & Serializable & scala.Serializable)x$1 -> this.client().getTreeApi().getReferenceByName((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.client().getTreeApi().getDefaultBranch());
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(new StringBuilder(104).append("Nessie ref ").append(requestedRef).append(" provided ").append("via ").append("nessie.ref").append(" does not exist. This ref must exist before creating a NessieCatalog.").toString(), ex);
            }
            throw new IllegalArgumentException(new StringBuilder(143).append("Nessie does not have an existing default branch. Either configure ").append("an alternative ref via ").append("nessie.ref").append(" or create the default branch on the server.").toString(), ex);
        }
        return reference;
    }

    private Reference reference() {
        return this.reference;
    }

    private void reference_$eq(Reference x$1) {
        this.reference = x$1;
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        throw new UnsupportedOperationException("listFrom from Nessie does not work.");
    }

    private Tuple3<String, String, String> parseTableIdentifier(String path) {
        if (path.contains("@") && path.contains("#")) {
            String[] tableRef = path.split("@");
            String[] refHash = tableRef[1].split("#");
            return new Tuple3((Object)tableRef[0], (Object)refHash[0], (Object)refHash[0]);
        }
        if (path.contains("@")) {
            String[] tableRef = path.split("@");
            return new Tuple3((Object)tableRef[0], (Object)tableRef[1], null);
        }
        return new Tuple3((Object)path, (Object)this.hadoopConf.get("nessie.ref"), (Object)this.hadoopConf.get("nessie.hash"));
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        if (path.getName().equals("_last_checkpoint")) {
            Path x$1 = path;
            String x$2 = this.reference().getName();
            String x$3 = this.reference().getHash();
            String x$4 = actions.mkString();
            String x$5 = this.commit$default$4();
            this.commit(x$1, x$2, x$3, x$5, x$4);
            return;
        }
        Path parent = path.getParent();
        String[] nameSplit = path.getName().split("\\.", 2);
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(nameSplit[0]);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = new StringBuilder(2).append(tableName2).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(nameSplit[1]).toString();
        Path nessiePath = new Path(parent, name);
        if (overwrite) {
            throw new IllegalStateException(new StringBuilder(32).append("Nessie won't overwrite for path ").append(path).toString());
        }
        this.writeInternal(nessiePath, actions, ref2, hash2);
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private DeltaLakeTable updateDeltaTable(Path path, String targetRef, String lastCheckpoint) {
        ImmutableDeltaLakeTable immutableDeltaLakeTable;
        Option<DeltaLakeTable> currentTable = this.getTable(path.getParent(), targetRef);
        ImmutableDeltaLakeTable table = (ImmutableDeltaLakeTable)currentTable.map((Function1 & Serializable & scala.Serializable)instance -> ImmutableDeltaLakeTable.copyOf(instance)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableDeltaLakeTable.builder().build());
        DeltaFileType deltaFileType = this.getFileType(path);
        if (((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType)) {
            String string = path.toString();
            immutableDeltaLakeTable = table.withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(table.getMetadataLocationHistory()).asScala()).toList().$colon$colon((Object)string)).asJava());
        } else {
            if (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType)) {
                throw new UnsupportedOperationException("Can't write checkpoints from LogStore");
            }
            if (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType)) {
                immutableDeltaLakeTable = table;
            } else if (((Object)DeltaFileType$UNKNOWN$.MODULE$).equals(deltaFileType)) {
                ImmutableDeltaLakeTable immutableDeltaLakeTable2;
                if (!path.getName().equals("_last_checkpoint")) {
                    immutableDeltaLakeTable2 = table;
                } else {
                    Tuple2<Object, Seq<String>> tuple2 = this.extractCheckpoint(lastCheckpoint, path.getParent());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long version = tuple2._1$mcJ$sp();
                    Seq parts = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)parts);
                    Tuple2 tuple23 = tuple22;
                    long version2 = tuple23._1$mcJ$sp();
                    Seq parts2 = (Seq)tuple23._2();
                    immutableDeltaLakeTable2 = table.withCheckpointLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(parts2).asJava()).withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.getCheckpointLocationHistory()).asScala()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$updateDeltaTable$3(this, version2, x)))).asJava()).withLastCheckpoint(lastCheckpoint);
                }
                immutableDeltaLakeTable = immutableDeltaLakeTable2;
            } else {
                immutableDeltaLakeTable = table;
            }
        }
        return immutableDeltaLakeTable;
    }

    private String updateDeltaTable$default$3() {
        return null;
    }

    private Tuple2<Object, Seq<String>> extractCheckpoint(String lastCheckpoint, Path path) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        CheckpointMetaData checkpoint = (CheckpointMetaData)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(lastCheckpoint), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(CheckpointMetaData.class));
        long version = checkpoint.version();
        Option<Object> parts = checkpoint.parts();
        Path tempPath = new Path(path, (String)this.lastSnapshotUuid().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("didn't write the correct checkpoint dir");
        }));
        Seq files = parts.isEmpty() ? (Seq)new .colon.colon((Object)FileNames$.MODULE$.checkpointFileSingular(tempPath, version), (List)Nil$.MODULE$) : FileNames$.MODULE$.checkpointFileWithParts(tempPath, version, BoxesRunTime.unboxToInt((Object)checkpoint.parts().get()));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)version), this.moveCheckpointFiles((Seq<Path>)files, path));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<String> moveCheckpointFiles(Seq<Path> files, Path destDir) {
        void var3_3;
        Seq movedFiles = (Seq)files.map((Function1 & Serializable & scala.Serializable)f -> {
            FileSystem fs = f.getFileSystem($this.hadoopConf);
            String[] parts = f.getName().split("\\.", 2);
            String destFile = new StringBuilder(2).append(parts[0]).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(parts[1]).toString();
            Path dest = new Path(destDir, destFile);
            fs.rename(f, dest);
            return dest.toString();
        }, Seq$.MODULE$.canBuildFrom());
        ((Path)files.head()).getFileSystem(this.hadoopConf).delete(((Path)files.head()).getParent(), true);
        return var3_3;
    }

    private boolean commit(Path path, String ref, String hash, String message, String lastCheckpoint) {
        String targetRef = ref == null ? this.reference().getName() : ref;
        String targetHash = hash == null ? this.reference().getHash() : hash;
        String messageWithSparkId = new StringBuilder(16).append(message).append(" ; spark.app.id=").append(this.sparkConf.get("spark.app.id")).toString();
        DeltaLakeTable table = this.updateDeltaTable(path, targetRef, lastCheckpoint);
        this.client().getContentsApi().setContents(this.pathToKey(path.getParent()), targetRef, targetHash, messageWithSparkId, table);
        this.reference_$eq(this.client().getTreeApi().getReferenceByName(this.reference().getName()));
        return true;
    }

    private String commit$default$4() {
        return "delta commit";
    }

    private String commit$default$5() {
        return null;
    }

    public void writeInternal(Path path, Iterator<String> actions, String ref, String hash) {
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        if (fs.exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        boolean streamClosed = false;
        boolean commitDone = false;
        FSDataOutputStream stream = fs.create(path);
        try {
            actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                commitDone = this.commit(path, ref, hash, this.commit$default$4(), this.commit$default$5());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!commitDone) {
                fs.delete(path, false);
            }
        }
    }

    public ContentsKey pathToKey(Path path) {
        return this.pathToKey(path.toUri().getPath());
    }

    public ContentsKey pathToKey(String path) {
        List parts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).toList();
        return new ContentsKey((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)parts).asJava());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] stringArray;
        String[] segments = path.getName().split("\\.");
        String[] stringArray2 = segments;
        Object object = stringArray2 != null && (stringArray = stringArray2).length == 6 ? new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[4])).toInt())) : None$.MODULE$;
        return object;
    }

    public DeltaFileType getFileType(Path path) {
        Path path2 = path;
        DeltaFileType deltaFileType = this.checkpointFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKPOINT$.MODULE$ : (this.deltaFilePattern().matcher(path.getName()).matches() ? DeltaFileType$DELTA$.MODULE$ : (this.checksumFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKSUM$.MODULE$ : DeltaFileType$UNKNOWN$.MODULE$));
        return deltaFileType;
    }

    public LogFileMeta extractMeta(FileStatus fileStatus) {
        return new LogFileMeta(fileStatus, this.extractVersion(fileStatus.getPath()), this.getFileType(fileStatus.getPath()), this.numCheckpointParts(fileStatus.getPath()));
    }

    public long extractVersion(Path path) {
        DeltaFileType deltaFileType = this.getFileType(path);
        long l = ((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".json").split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0].split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc").split("-")[0])).toLong() : -1L));
        return l;
    }

    public Iterator<LogFileMeta> listFilesFrom(Path path2) {
        FileSystem fs = path2.getFileSystem(this.hadoopConf);
        if (!fs.exists(path2.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path2.getParent()).toString());
        }
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(path2.toUri().getPath());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = null;
        name = hash2 != null ? hash2 : (ref2 != null ? ref2 : this.reference().getName());
        Option<DeltaLakeTable> currentTable = this.getTable(new Path(tableName2).getParent(), name);
        Set currentMetadataPath = (Set)currentTable.map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getMetadataLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> new Path(x$9), Buffer$.MODULE$.canBuildFrom())).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(15).append("No such table: ").append(path2).toString());
        });
        Set currentPath = ((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory() != null ? (Set)currentMetadataPath.$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> new Path(x$10), Buffer$.MODULE$.canBuildFrom())) : currentMetadataPath;
        long requestedVersion = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> FileNames$.MODULE$.getFileVersion(path2)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path2.getName())).stripSuffix(".checkpoint"))).toLong()));
        FileStatus[] files = fs.listStatus(path2.getParent());
        LogFileMeta[] filteredFiles = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)fileStatus -> this.extractMeta((FileStatus)fileStatus), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)currentPath.contains((Object)x.fileStatus().getPath()))))).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$9(requestedVersion, x$11))))).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.version()), (Ordering)Ordering.Long$.MODULE$);
        None$ maxExpected = currentPath.nonEmpty() ? new Some(((TraversableOnce)currentPath.map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)this.extractVersion(path)), Set$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        None$ maxFound = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).nonEmpty() ? new Some(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)maxFound.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) == BoxesRunTime.unboxToLong((Object)maxExpected.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.fileType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DeltaFileType.class))))).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$16(x$15))) == filteredFiles.length ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.emptyCheckpoint(requestedVersion, (LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).head()), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).iterator() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).iterator();
    }

    private LogFileMeta emptyCheckpoint(long version, LogFileMeta logFileMeta) {
        FileStatus fileStatus = new FileStatus(0L, false, 0, 0L, logFileMeta.fileStatus().getModificationTime(), FileNames$.MODULE$.deltaFile(logFileMeta.fileStatus().getPath().getParent(), version));
        return new LogFileMeta(fileStatus, version, DeltaFileType$DELTA$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    private Option<DeltaLakeTable> getTable(Path path, String branch) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.client().getContentsApi().getContents(this.pathToKey(path), branch)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$getTable$2(x))).map((Function1 & Serializable & scala.Serializable)x$16 -> (DeltaLakeTable)x$16).toOption();
    }

    @Override
    public Seq<String> read(Path path) {
        Seq seq;
        if (path.getName().equals("_last_checkpoint")) {
            Option<DeltaLakeTable> table = this.getTable(path.getParent(), this.reference().getName());
            String data = (String)table.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getLastCheckpoint()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new FileNotFoundException();
            });
            if (data == null) {
                throw new FileNotFoundException();
            }
            seq = (Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$);
        } else {
            FileSystem fs = path.getFileSystem(this.hadoopConf);
            try (FSDataInputStream stream = fs.open(path);){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.trim(), Buffer$.MODULE$.canBuildFrom());
            }
        }
        return seq;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    @Override
    public Path resolveCheckpointPath(Path path) {
        this.lastSnapshotUuid_$eq((Option<String>)new Some((Object)UUID.randomUUID().toString()));
        return path.getFileSystem(this.hadoopConf).makeQualified(new Path(path, (String)this.lastSnapshotUuid().get()));
    }

    public static final /* synthetic */ boolean $anonfun$updateDeltaTable$3(NessieLogStore $this, long version$1, String x) {
        return $this.extractVersion(new Path(x)) < version$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$9(long requestedVersion$1, LogFileMeta x$11) {
        return x$11.version() >= requestedVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$16(DeltaFileType x$15) {
        DeltaFileType deltaFileType = x$15;
        DeltaFileType$CHECKPOINT$ deltaFileType$CHECKPOINT$ = DeltaFileType$CHECKPOINT$.MODULE$;
        return !(deltaFileType != null ? !((Object)deltaFileType).equals(deltaFileType$CHECKPOINT$) : deltaFileType$CHECKPOINT$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTable$2(Contents x) {
        return x != null && x instanceof DeltaLakeTable;
    }

    public NessieLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        LogStore.$init$(this);
        Logging.$init$((Logging)this);
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.json")).r().pattern();
        this.checksumFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.crc")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
        this.lastSnapshotUuid = None$.MODULE$;
        this.client = NessieClient.withConfig(c -> $this.hadoopConf.get(c));
        this.reference = this.getOrCreate();
    }
}

