/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;

public class NessieError {
    private final String message;
    private final int status;
    private final String reason;
    private final String serverStackTrace;
    private final Exception clientProcessingException;

    @JsonCreator
    public NessieError(@JsonProperty(value="message") String message, @JsonProperty(value="status") int status, @JsonProperty(value="reason") String reason, @JsonProperty(value="serverStackTrace") String serverStackTrace) {
        this(message, status, reason, serverStackTrace, null);
    }

    public NessieError(String message, int status, String reason, String serverStackTrace, Exception processingException) {
        this.message = message;
        this.status = status;
        this.reason = reason;
        this.serverStackTrace = serverStackTrace;
        this.clientProcessingException = processingException;
    }

    public NessieError(int statusCode, String reason, String serverStackTrace, Exception processingException) {
        this.status = statusCode;
        this.message = reason;
        this.reason = reason;
        this.serverStackTrace = serverStackTrace;
        this.clientProcessingException = processingException;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public String getServerStackTrace() {
        return this.serverStackTrace;
    }

    @JsonIgnore
    public Exception getClientProcessingException() {
        return this.clientProcessingException;
    }

    @JsonIgnore
    public String getFullMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.reason != null) {
            sb.append(this.reason).append(" (HTTP/").append(this.status).append(')');
        }
        if (this.message != null) {
            if (sb.length() > 0) {
                sb.append(": ");
            }
            sb.append(this.message);
        }
        if (this.serverStackTrace != null) {
            sb.append("\n").append(this.serverStackTrace);
        }
        if (this.clientProcessingException != null) {
            StringWriter sw = new StringWriter();
            this.clientProcessingException.printStackTrace(new PrintWriter(sw));
            sb.append("\n").append(sw);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NessieError error = (NessieError)o;
        return this.status == error.status && Objects.equals(this.message, error.message) && Objects.equals(this.serverStackTrace, error.serverStackTrace);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.status, this.serverStackTrace);
    }
}

