/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import com.dremio.nessie.model.Hash;
import com.dremio.nessie.model.Reference;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Hash", generator="Immutables")
@Immutable
public final class ImmutableHash
extends Hash {
    private final String name;
    private final transient String hash;
    private final transient int hashCode;

    private ImmutableHash(String name) {
        this.name = name;
        this.hash = Objects.requireNonNull(super.getHash(), "hash");
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    public final ImmutableHash withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableHash.validate(new ImmutableHash(newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHash && this.equalTo((ImmutableHash)another);
    }

    private boolean equalTo(ImmutableHash another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && this.hash.equals(another.hash);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.hash.hashCode();
        return h;
    }

    public String toString() {
        return "Hash{name=" + this.name + ", hash=" + this.hash + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableHash fromJson(Json json) {
        Builder builder = ImmutableHash.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        return builder.build();
    }

    private static ImmutableHash validate(ImmutableHash instance) {
        instance.checkHash();
        return instance;
    }

    public static ImmutableHash copyOf(Hash instance) {
        if (instance instanceof ImmutableHash) {
            return (ImmutableHash)instance;
        }
        return ImmutableHash.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Hash", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Reference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Hash instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Reference) {
                Reference instance = (Reference)object;
                this.name(instance.getName());
            }
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableHash build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableHash.validate(new ImmutableHash(this.name));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Hash, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Hash", generator="Immutables")
    static final class Json
    extends Hash {
        @Nullable
        String name;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getHash() {
            throw new UnsupportedOperationException();
        }
    }
}

