/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.LogFileMeta$;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitMarker;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\red\u0001\u0002&L\u0001YC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0005S\")A\u000e\u0001C\u0001[\")\u0001\u000b\u0001C\u0005c\")a\u000f\u0001C\u0005o\")a\u0010\u0001C\u0001\u007f\"1a\u0010\u0001C\u0001\u0003_Aq!!\u0011\u0001\t\u0003\t\u0019\u0005C\u0005\u0004`\u0001\t\n\u0011\"\u0001\u0004b!91Q\r\u0001\u0005\u0002\r\u001d\u0004bBB6\u0001\u0011%1Q\u000e\u0005\b\u0007k\u0002A\u0011BAQ\u0011\u001d\u00199\b\u0001C\u0005\u0003C;q!!\u0013L\u0011\u0003\tYE\u0002\u0004K\u0017\"\u0005\u0011Q\n\u0005\u0007Y>!\t!a\u0014\t\u000f\u0005Es\u0002\"\u0003\u0002T!A\u0011QP\b\u0005\u0002-\u000by\b\u0003\u0006\u0003<=\t\n\u0011\"\u0001L\u0005{AqA!\u0011\u0010\t\u0013\u0011\u0019\u0005C\u0004\u0003^=!IAa\u0018\t\u000f\t\ru\u0002\"\u0003\u0003\u0006\u001a1\u00111R\bA\u0003\u001bC!\"a\u001f\u0018\u0005+\u0007I\u0011AAQ\u0011)\t\u0019k\u0006B\tB\u0003%\u0011Q\u0007\u0005\u000b\u0003K;\"Q3A\u0005\u0002\u0005\u0005\u0006BCAT/\tE\t\u0015!\u0003\u00026!1An\u0006C\u0001\u0003SCq!a,\u0018\t\u0003\n\t\fC\u0004\u00026^!\t%!)\t\u000f\u0005]v\u0003\"\u0011\u0002\"\"I\u0011\u0011X\f\u0002\u0002\u0013\u0005\u00111\u0018\u0005\n\u0003\u0003<\u0012\u0013!C\u0001\u0003\u0007D\u0011\"!7\u0018#\u0003%\t!a1\t\u0013\u0005mw#!A\u0005B\u0005u\u0007\"CAx/\u0005\u0005I\u0011AAy\u0011%\t\u0019pFA\u0001\n\u0003\t)\u0010C\u0005\u0003\u0002]\t\t\u0011\"\u0011\u0003\u0004!I!\u0011C\f\u0002\u0002\u0013\u0005!1\u0003\u0005\n\u0005;9\u0012\u0011!C!\u0005?A\u0011B!\t\u0018\u0003\u0003%\tEa\t\t\u0013\t\u0015r#!A\u0005B\t\u001dr!\u0003BH\u001f\u0005\u0005\t\u0012\u0001BI\r%\tYiDA\u0001\u0012\u0003\u0011\u0019\n\u0003\u0004mY\u0011\u0005!\u0011\u0015\u0005\n\u0005Ca\u0013\u0011!C#\u0005GA\u0011Ba)-\u0003\u0003%\tI!*\t\u0013\t-F&!A\u0005\u0002\n5\u0006\"\u0003B^Y\u0005\u0005I\u0011\u0002B_\r\u0019\u0011)m\u0004\u0001\u0003H\"Q!1\u001b\u001a\u0003\u0002\u0003\u0006IA!3\t\u0015\tU'G!A!\u0002\u0013\t)\u0004\u0003\u0006\u0003XJ\u0012\t\u0011)A\u0005\u0003kA!B!73\u0005\u0003\u0005\u000b\u0011\u0002Bn\u0011\u0019a'\u0007\"\u0001\u0003b\"I!Q\u001e\u001aC\u0002\u0013%!q\u001e\u0005\t\u0005{\u0014\u0004\u0015!\u0003\u0003r\"I!q \u001aC\u0002\u0013%1\u0011\u0001\u0005\t\u0007\u0013\u0011\u0004\u0015!\u0003\u0004\u0004!Y11\u0002\u001aA\u0002\u0003\u0007I\u0011BB\u0007\u0011-\u0019yA\ra\u0001\u0002\u0004%Ia!\u0005\t\u0017\rm!\u00071A\u0001B\u0003&!Q\u001a\u0005\n\u0007;\u0011\u0004\u0019!C\u0005\u0007?A\u0011b!\t3\u0001\u0004%Iaa\t\t\u0011\r\u001d\"\u0007)Q\u0005\u0005+Aqa!\u000b3\t\u0013\u0019Y\u0003C\u0004\u0004.I\"Iaa\f\t\u000f\rU\"\u0007\"\u0003\u00048!911\b\u001a\u0005\n\r-\u0002bBB\u001fe\u0011%11\u0006\u0005\b\u0007\u007f\u0011D\u0011IB\u0010\u0011\u001d\u0019\tE\rC!\u0007\u0007B\u0011b!\u0012\u0010#\u0003%\taa\u0012\u0003'\u0011+G\u000e^1ISN$xN]=NC:\fw-\u001a:\u000b\u00051k\u0015!\u00023fYR\f'B\u0001(P\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003!F\u000bQa\u001d9be.T!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sO\u000e\u00011c\u0001\u0001X;B\u0011\u0001lW\u0007\u00023*\t!,A\u0003tG\u0006d\u0017-\u0003\u0002]3\n1\u0011I\\=SK\u001a\u0004\"AX1\u000e\u0003}S!\u0001Y&\u0002\u00115,G/\u001a:j]\u001eL!AY0\u0003\u0019\u0011+G\u000e^1M_\u001e<\u0017N\\4\u0002\u0011\u0011,G\u000e^1M_\u001e\u0004\"!\u001a4\u000e\u0003-K!aZ&\u0003\u0011\u0011+G\u000e^1M_\u001e\fa\"\\1y\u0017\u0016L8\u000fU3s\u0019&\u001cH\u000f\u0005\u0002YU&\u00111.\u0017\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0002o_B\u0004\"!\u001a\u0001\t\u000b\r\u001c\u0001\u0019\u00013\t\u000f!\u001c\u0001\u0013!a\u0001SV\t!\u000f\u0005\u0002ti6\tQ*\u0003\u0002v\u001b\na1\u000b]1sWN+7o]5p]\u0006Ir-\u001a;TKJL\u0017\r\\5{C\ndW\rS1e_>\u00048i\u001c8g+\u0005A\bCA=}\u001b\u0005Q(BA>P\u0003\u0011)H/\u001b7\n\u0005uT(!G*fe&\fG.\u001b>bE2,7i\u001c8gS\u001e,(/\u0019;j_:\f!bZ3u\u0011&\u001cHo\u001c:z)\u0011\t\t!!\n\u0011\r\u0005\r\u00111CA\r\u001d\u0011\t)!a\u0004\u000f\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003V\u0003\u0019a$o\\8u}%\t!,C\u0002\u0002\u0012e\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0005]!aA*fc*\u0019\u0011\u0011C-\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\bL\u0003\u001d\t7\r^5p]NLA!a\t\u0002\u001e\tQ1i\\7nSRLeNZ8\t\u000f\u0005\u001db\u00011\u0001\u0002*\u0005AA.[7ji>\u0003H\u000f\u0005\u0003Y\u0003WI\u0017bAA\u00173\n1q\n\u001d;j_:$b!!\u0001\u00022\u0005m\u0002bBA\u001a\u000f\u0001\u0007\u0011QG\u0001\u0006gR\f'\u000f\u001e\t\u00041\u0006]\u0012bAA\u001d3\n!Aj\u001c8h\u0011\u001d\tid\u0002a\u0001\u0003\u007f\t1!\u001a8e!\u0015A\u00161FA\u001b\u0003U9W\r^!di&4XmQ8n[&$\u0018\t\u001e+j[\u0016$\u0002\"!\u0012\u0004L\r]31\f\t\u0004\u0003\u000f:bBA3\u000f\u0003M!U\r\u001c;b\u0011&\u001cHo\u001c:z\u001b\u0006t\u0017mZ3s!\t)wbE\u0002\u0010/v#\"!a\u0013\u0002\u001b\u001d,GoQ8n[&$\u0018J\u001c4p)!\tI\"!\u0016\u0002f\u0005e\u0004bBA,#\u0001\u0007\u0011\u0011L\u0001\tY><7\u000b^8sKB!\u00111LA1\u001b\t\tiFC\u0002\u0002`-\u000bqa\u001d;pe\u0006<W-\u0003\u0003\u0002d\u0005u#\u0001\u0003'pON#xN]3\t\u000f\u0005\u001d\u0014\u00031\u0001\u0002j\u0005A!-Y:f!\u0006$\b\u000e\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\u0005\u0019\u001c(bAA:#\u00061\u0001.\u00193p_BLA!a\u001e\u0002n\t!\u0001+\u0019;i\u0011\u001d\tY(\u0005a\u0001\u0003k\tqA^3sg&|g.\u0001\u0006hKR\u001cu.\\7jiN$\"\"!!\u0003,\tM\"q\u0007B\u001d!\u0015A\u00161QAD\u0013\r\t))\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0003\u0013;R\"A\b\u0003\r\r{W.\\5u'!9r+a$\u0002\u0016\u0006m\u0005\u0003BA\u000e\u0003#KA!a%\u0002\u001e\ta1i\\7nSRl\u0015M]6feB\u0019\u0001,a&\n\u0007\u0005e\u0015LA\u0004Qe>$Wo\u0019;\u0011\u0007a\u000bi*C\u0002\u0002 f\u0013AbU3sS\u0006d\u0017N_1cY\u0016,\"!!\u000e\u0002\u0011Y,'o]5p]\u0002\n\u0011\u0002^5nKN$\u0018-\u001c9\u0002\u0015QLW.Z:uC6\u0004\b\u0005\u0006\u0004\u0002\b\u0006-\u0016Q\u0016\u0005\b\u0003wb\u0002\u0019AA\u001b\u0011\u001d\t)\u000b\ba\u0001\u0003k\tQb^5uQRKW.Z:uC6\u0004H\u0003BAD\u0003gCq!!*\u001e\u0001\u0004\t)$\u0001\u0007hKR$\u0016.\\3ti\u0006l\u0007/\u0001\u0006hKR4VM]:j_:\fAaY8qsR1\u0011qQA_\u0003\u007fC\u0011\"a\u001f!!\u0003\u0005\r!!\u000e\t\u0013\u0005\u0015\u0006\u0005%AA\u0002\u0005U\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u000bTC!!\u000e\u0002H.\u0012\u0011\u0011\u001a\t\u0005\u0003\u0017\f).\u0004\u0002\u0002N*!\u0011qZAi\u0003%)hn\u00195fG.,GMC\u0002\u0002Tf\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9.!4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\t1\fgn\u001a\u0006\u0003\u0003S\fAA[1wC&!\u0011Q^Ar\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t\u0011.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0018Q \t\u00041\u0006e\u0018bAA~3\n\u0019\u0011I\\=\t\u0011\u0005}X%!AA\u0002%\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0003!\u0019\u00119A!\u0004\u0002x6\u0011!\u0011\u0002\u0006\u0004\u0005\u0017I\u0016AC2pY2,7\r^5p]&!!q\u0002B\u0005\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\tU!1\u0004\t\u00041\n]\u0011b\u0001B\r3\n9!i\\8mK\u0006t\u0007\"CA\u0000O\u0005\u0005\t\u0019AA|\u0003!A\u0017m\u001d5D_\u0012,G#A5\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a8\u0002\r\u0015\fX/\u00197t)\u0011\u0011)B!\u000b\t\u0013\u0005}(&!AA\u0002\u0005]\bbBA,%\u0001\u0007!Q\u0006\t\u0004K\n=\u0012b\u0001B\u0019\u0017\n\tBj\\4GS2,W*\u001a;b!\u0006\u00148/\u001a:\t\u000f\tU\"\u00031\u0001\u0002j\u00059An\\4QCRD\u0007bBA\u001a%\u0001\u0007\u0011Q\u0007\u0005\n\u0003{\u0011\u0002\u0013!a\u0001\u0003\u007f\tAcZ3u\u0007>lW.\u001b;tI\u0011,g-Y;mi\u0012\"TC\u0001B U\u0011\ty$a2\u000255|gn\u001c;p]&TXmQ8n[&$H+[7fgR\fW\u000e]:\u0016\t\t\u0015#Q\n\u000b\u0005\u0005\u000f\u0012I\u0006E\u0003Y\u0003\u0007\u0013I\u0005\u0005\u0003\u0003L\t5C\u0002\u0001\u0003\b\u0005\u001f\"\"\u0019\u0001B)\u0005\u0005!\u0016\u0003\u0002B*\u0003\u001f\u00032\u0001\u0017B+\u0013\r\u00119&\u0017\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\u0011Y\u0006\u0006a\u0001\u0005\u000f\nqaY8n[&$8/A\bqCJ\fG\u000e\\3m'\u0016\f'o\u001951)A\t9I!\u0019\u0003d\t\u001d$q\u000fB>\u0005{\u0012y\bC\u0003Q+\u0001\u0007!\u000f\u0003\u0004\u0003fU\u0001\r\u0001_\u0001\u0005G>tg\rC\u0004\u00036U\u0001\rA!\u001b\u0011\t\t-$1\u000f\b\u0005\u0005[\u0012y\u0007E\u0002\u0002\beK1A!\u001dZ\u0003\u0019\u0001&/\u001a3fM&!\u0011Q\u001eB;\u0015\r\u0011\t(\u0017\u0005\b\u0005s*\u0002\u0019AA\u001b\u0003\u0011!\u0018.\\3\t\u000f\u0005MR\u00031\u0001\u00026!9\u0011QH\u000bA\u0002\u0005U\u0002b\u0002BA+\u0001\u0007\u0011QG\u0001\u0005gR,\u0007/A\rmCN$8i\\7nSR\u0014UMZ8sKRKW.Z:uC6\u0004HC\u0002BD\u0005\u0013\u0013i\tE\u0003Y\u0003W\t9\tC\u0004\u0003\\Y\u0001\rAa#\u0011\r\u0005\r\u00111CAD\u0011\u001d\u0011IH\u0006a\u0001\u0003k\taaQ8n[&$\bcAAEYM)AF!&\u0002\u001cBQ!q\u0013BO\u0003k\t)$a\"\u000e\u0005\te%b\u0001BN3\u00069!/\u001e8uS6,\u0017\u0002\u0002BP\u00053\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011\t*A\u0003baBd\u0017\u0010\u0006\u0004\u0002\b\n\u001d&\u0011\u0016\u0005\b\u0003wz\u0003\u0019AA\u001b\u0011\u001d\t)k\fa\u0001\u0003k\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u00030\n]\u0006#\u0002-\u0002,\tE\u0006c\u0002-\u00034\u0006U\u0012QG\u0005\u0004\u0005kK&A\u0002+va2,'\u0007C\u0005\u0003:B\n\t\u00111\u0001\u0002\b\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u007f\u0003B!!9\u0003B&!!1YAr\u0005\u0019y%M[3di\na\")\u001e4gKJLgn\u001a'pO\u0012+G.\u001a;j_:LE/\u001a:bi>\u00148\u0003\u0002\u001aX\u0005\u0013\u0004b!a\u0001\u0003L\n5\u0017\u0002\u0002B\b\u0003/\u0001B!a\u001b\u0003P&!!\u0011[A7\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u000bk:$WM\u001d7zS:<\u0017\u0001D7bqRKW.Z:uC6\u0004\u0018AC7bqZ+'o]5p]\u0006ia/\u001a:tS>tw)\u001a;uKJ\u0004r\u0001\u0017Bo\u0003S\n)$C\u0002\u0003`f\u0013\u0011BR;oGRLwN\\\u0019\u0015\u0015\t\r(Q\u001dBt\u0005S\u0014Y\u000fE\u0002\u0002\nJBqAa58\u0001\u0004\u0011I\rC\u0004\u0003V^\u0002\r!!\u000e\t\u000f\t]w\u00071\u0001\u00026!9!\u0011\\\u001cA\u0002\tm\u0017!\u00044jY\u0016\u001cHk\u001c#fY\u0016$X-\u0006\u0002\u0003rB1!1\u001fB}\u0005\u001bl!A!>\u000b\t\t](\u0011B\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011YP!>\u0003\u000bE+X-^3\u0002\u001d\u0019LG.Z:U_\u0012+G.\u001a;fA\u0005\u0001R.Y=cK\u0012+G.\u001a;f\r&dWm]\u000b\u0003\u0007\u0007\u0001bAa=\u0004\u0006\t5\u0017\u0002BB\u0004\u0005k\u00141\"\u0011:sCf\u0014UO\u001a4fe\u0006\tR.Y=cK\u0012+G.\u001a;f\r&dWm\u001d\u0011\u0002\u00111\f7\u000f\u001e$jY\u0016,\"A!4\u0002\u00191\f7\u000f\u001e$jY\u0016|F%Z9\u0015\t\rM1\u0011\u0004\t\u00041\u000eU\u0011bAB\f3\n!QK\\5u\u0011%\ty0PA\u0001\u0002\u0004\u0011i-A\u0005mCN$h)\u001b7fA\u0005i\u0001.Y:OKb$8)\u00197mK\u0012,\"A!\u0006\u0002#!\f7OT3yi\u000e\u000bG\u000e\\3e?\u0012*\u0017\u000f\u0006\u0003\u0004\u0014\r\u0015\u0002\"CA\u0000\u0001\u0006\u0005\t\u0019\u0001B\u000b\u00039A\u0017m\u001d(fqR\u001c\u0015\r\u001c7fI\u0002\nA!\u001b8jiR\u001111C\u0001\u0011g\"|W\u000f\u001c3EK2,G/\u001a$jY\u0016$BA!\u0006\u00042!911G\"A\u0002\t5\u0017\u0001\u00024jY\u0016\f1C\\3fIN$\u0016.\\3BI*,8\u000f^7f]R$BA!\u0006\u0004:!911\u0007#A\u0002\t5\u0017a\u00034mkND')\u001e4gKJ\f!#];fk\u00164\u0015\u000e\\3t\u0013:\u0014UO\u001a4fe\u00069\u0001.Y:OKb$\u0018\u0001\u00028fqR$\"A!4\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019IEK\u0002j\u0003\u000fDq!!*\t\u0001\u0004\u0019i\u0005\u0005\u0003\u0004P\rMSBAB)\u0015\rq\u0015q]\u0005\u0005\u0007+\u001a\tFA\u0005US6,7\u000f^1na\"91\u0011\f\u0005A\u0002\tU\u0011aE2b]J+G/\u001e:o\u0019\u0006\u001cHoQ8n[&$\b\"CB/\u0011A\u0005\t\u0019\u0001B\u000b\u0003EiWo\u001d;CKJ+7M]3bi\u0006\u0014G.Z\u0001 O\u0016$\u0018i\u0019;jm\u0016\u001cu.\\7ji\u0006#H+[7fI\u0011,g-Y;mi\u0012\u001aTCAB2U\u0011\u0011)\"a2\u0002%\rDWmY6WKJ\u001c\u0018n\u001c8Fq&\u001cHo\u001d\u000b\u0005\u0007'\u0019I\u0007C\u0004\u0002|)\u0001\r!!\u000e\u0002\u001dA\f'/\u00197mK2\u001cV-\u0019:dQRA\u0011QIB8\u0007c\u001a\u0019\bC\u0004\u0003z-\u0001\r!!\u000e\t\u000f\u0005M2\u00021\u0001\u00026!9\u0011QH\u0006A\u0002\u0005U\u0012\u0001F4fi\u0016\u000b'\u000f\\5fgR$U\r\u001c;b\r&dW-A\u000fhKR,\u0015M\u001d7jKN$(+\u001a9s_\u0012,8-\u001b2mK\u000e{W.\\5u\u0001")
public class DeltaHistoryManager
implements DeltaLogging {
    private final DeltaLog deltaLog;
    private final int maxKeysPerList;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$2() {
        return DeltaHistoryManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    private SerializableConfiguration getSerializableHadoopConf() {
        return new SerializableConfiguration(this.spark().sessionState().newHadoopConf());
    }

    public Seq<CommitInfo> getHistory(Option<Object> limitOpt) {
        long listStart = BoxesRunTime.unboxToLong((Object)limitOpt.map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)limit -> scala.math.package$.MODULE$.max($this.deltaLog.update($this.deltaLog.update$default$1()).version() - (long)limit + 1L, 0L)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.getEarliestDeltaFile()));
        return this.getHistory(listStart, (Option<Object>)None$.MODULE$);
    }

    public Seq<CommitInfo> getHistory(long start, Option<Object> end) {
        public final class Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.actions.CommitInfo").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1(DeltaHistoryManager $outer) {
            }
        }
        SparkSession _spark = this.spark();
        SerializableConfiguration conf = this.getSerializableHadoopConf();
        String logPath = this.deltaLog.logPath().toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeltaHistoryManager.class.getClassLoader());
        Dataset info = this.spark().range(start, BoxesRunTime.unboxToLong((Object)end.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.deltaLog.update($this.deltaLog.update$default$1()).version())) + 1L).mapPartitions((Function1 & Serializable & scala.Serializable)versions -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), conf.value());
            Path basePath = new Path(logPath);
            FileSystem fs = basePath.getFileSystem(conf.value());
            return versions.flatMap((Function1 & Serializable & scala.Serializable)commit -> {
                Iterable iterable;
                try {
                    CommitInfo ci = DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitInfo(logStore, basePath, Predef$.MODULE$.Long2long(commit));
                    FileStatus metadata = fs.getFileStatus(FileNames$.MODULE$.deltaFile(basePath, Predef$.MODULE$.Long2long(commit)));
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ci.withTimestamp(metadata.getModificationTime())));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            });
        }, _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1(null))));
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps((CommitMarker[])info.collect()))).reverse());
    }

    public Commit getActiveCommitAtTime(Timestamp timestamp, boolean canReturnLastCommit, boolean mustBeRecreatable) {
        Commit commit;
        long time = timestamp.getTime();
        long earliest = mustBeRecreatable ? this.getEarliestReproducibleCommit() : this.getEarliestDeltaFile();
        long latestVersion = this.deltaLog.update(this.deltaLog.update$default$1()).version();
        if (latestVersion - earliest > (long)(2 * this.maxKeysPerList)) {
            commit = this.parallelSearch(time, earliest, latestVersion + 1L);
        } else {
            Commit[] commits = DeltaHistoryManager$.MODULE$.getCommits(this.deltaLog.logFileHandler(), this.deltaLog.logPath(), earliest, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(latestVersion + 1L))));
            commit = (Commit)DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<Commit>)Predef$.MODULE$.wrapRefArray((Object[])commits), time).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Commit)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).head());
        }
        Commit commit2 = commit;
        Timestamp commitTs = new Timestamp(commit2.timestamp());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        String tsString = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, DateTimeUtils$.MODULE$.fromJavaTimestamp(commitTs));
        if (commit2.timestamp() > time) {
            throw DeltaErrors$.MODULE$.timestampEarlierThanCommitRetention(timestamp, commitTs, tsString);
        }
        if (commit2.version() == latestVersion && !canReturnLastCommit && commit2.timestamp() < time) {
            throw DeltaErrors$.MODULE$.temporallyUnstableInput(timestamp, commitTs, tsString, commit2.version());
        }
        return commit2;
    }

    public boolean getActiveCommitAtTime$default$3() {
        return true;
    }

    public void checkVersionExists(long version) {
        long earliest = this.getEarliestReproducibleCommit();
        long latest = this.deltaLog.update(this.deltaLog.update$default$1()).version();
        if (version < earliest || version > latest) {
            throw DeltaErrors$.MODULE$.versionNotExistException(version, earliest, latest);
        }
    }

    private Commit parallelSearch(long time, long start, long end) {
        return DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$parallelSearch0(this.spark(), this.getSerializableHadoopConf(), this.deltaLog.logPath().toString(), time, start, end, this.maxKeysPerList);
    }

    private long getEarliestDeltaFile() {
        Option earliestVersionOpt = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])this.deltaLog.logFileHandler().listFilesFrom(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), 0L)).filter((Function1 & Serializable & scala.Serializable)logFileMeta -> BoxesRunTime.boxToBoolean((boolean)LogFileMeta$.MODULE$.isDeltaFile(logFileMeta))).take(1).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.version())).toArray(ClassTag$.MODULE$.Long()))).headOption();
        if (earliestVersionOpt.isEmpty()) {
            throw DeltaErrors$.MODULE$.noHistoryFound(this.deltaLog.logPath());
        }
        return BoxesRunTime.unboxToLong((Object)earliestVersionOpt.get());
    }

    private long getEarliestReproducibleCommit() {
        Iterator files = this.deltaLog.logFileHandler().listFilesFrom(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), 0L)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager.$anonfun$getEarliestReproducibleCommit$1(f)));
        HashMap checkpointMap = new HashMap();
        LongRef smallestDeltaVersion = LongRef.create((long)Long.MAX_VALUE);
        None$ lastCompleteCheckpoint = None$.MODULE$;
        while (files.hasNext()) {
            BoxedUnit boxedUnit;
            LogFileMeta nextFilePath = (LogFileMeta)files.next();
            if (LogFileMeta$.MODULE$.isDeltaFile(nextFilePath)) {
                long version = nextFilePath.version();
                if (version == 0L) {
                    return version;
                }
                smallestDeltaVersion.elem = scala.math.package$.MODULE$.min(version, smallestDeltaVersion.elem);
                if (lastCompleteCheckpoint.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 >= smallestDeltaVersion$1.elem)) {
                    return BoxesRunTime.unboxToLong((Object)lastCompleteCheckpoint.get());
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (LogFileMeta$.MODULE$.isCheckpointFile(nextFilePath)) {
                int preCount;
                long checkpointVersion = nextFilePath.version();
                Option<Object> parts = nextFilePath.numParts();
                if (parts.isEmpty()) {
                    lastCompleteCheckpoint = new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                int numParts = BoxesRunTime.unboxToInt((Object)parts.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
                if (numParts == (preCount = BoxesRunTime.unboxToInt((Object)checkpointMap.getOrElse((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))) + 1 && smallestDeltaVersion.elem <= checkpointVersion) {
                    lastCompleteCheckpoint = new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion));
                }
                boxedUnit = checkpointMap.put((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Object)BoxesRunTime.boxToInteger((int)(preCount + 1)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (lastCompleteCheckpoint.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 >= smallestDeltaVersion$1.elem)) {
            return BoxesRunTime.unboxToLong((Object)lastCompleteCheckpoint.get());
        }
        if (smallestDeltaVersion.elem < Long.MAX_VALUE) {
            throw DeltaErrors$.MODULE$.noReproducibleHistoryFound(this.deltaLog.logPath());
        }
        throw DeltaErrors$.MODULE$.noHistoryFound(this.deltaLog.logPath());
    }

    public static final /* synthetic */ boolean $anonfun$getEarliestReproducibleCommit$1(LogFileMeta f) {
        return LogFileMeta$.MODULE$.isDeltaFile(f) || LogFileMeta$.MODULE$.isCheckpointFile(f);
    }

    public DeltaHistoryManager(DeltaLog deltaLog, int maxKeysPerList) {
        this.deltaLog = deltaLog;
        this.maxKeysPerList = maxKeysPerList;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }

    public static class BufferingLogDeletionIterator
    implements Iterator<FileStatus> {
        private final Iterator<FileStatus> underlying;
        private final long maxTimestamp;
        private final long maxVersion;
        private final Function1<Path, Object> versionGetter;
        private final Queue<FileStatus> filesToDelete;
        private final ArrayBuffer<FileStatus> maybeDeleteFiles;
        private FileStatus lastFile;
        private boolean hasNextCalled;

        public Iterator<FileStatus> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<FileStatus> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<FileStatus> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<FileStatus, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<FileStatus, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<FileStatus> filter(Function1<FileStatus, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<FileStatus, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<FileStatus> withFilter(Function1<FileStatus, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<FileStatus> filterNot(Function1<FileStatus, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<FileStatus, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, FileStatus, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<FileStatus, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<FileStatus> takeWhile(Function1<FileStatus, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> partition(Function1<FileStatus, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> span(Function1<FileStatus, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<FileStatus> dropWhile(Function1<FileStatus, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<FileStatus, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<FileStatus, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<FileStatus, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<FileStatus, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<FileStatus, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<FileStatus> find(Function1<FileStatus, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<FileStatus> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<FileStatus> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<FileStatus> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<FileStatus> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<FileStatus> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<FileStatus, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<FileStatus, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, FileStatus, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<FileStatus, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, FileStatus, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<FileStatus> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<FileStatus> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<FileStatus> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<FileStatus> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<FileStatus> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, FileStatus, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<FileStatus, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        private Queue<FileStatus> filesToDelete() {
            return this.filesToDelete;
        }

        private ArrayBuffer<FileStatus> maybeDeleteFiles() {
            return this.maybeDeleteFiles;
        }

        private FileStatus lastFile() {
            return this.lastFile;
        }

        private void lastFile_$eq(FileStatus x$1) {
            this.lastFile = x$1;
        }

        private boolean hasNextCalled() {
            return this.hasNextCalled;
        }

        private void hasNextCalled_$eq(boolean x$1) {
            this.hasNextCalled = x$1;
        }

        private void init() {
            block0: {
                if (!this.underlying.hasNext()) break block0;
                this.lastFile_$eq((FileStatus)this.underlying.next());
                this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{this.lastFile()}));
            }
        }

        private boolean shouldDeleteFile(FileStatus file) {
            return file.getModificationTime() <= this.maxTimestamp && BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) <= this.maxVersion;
        }

        private boolean needsTimeAdjustment(FileStatus file) {
            return BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)this.lastFile().getPath())) < BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) && this.lastFile().getModificationTime() >= file.getModificationTime();
        }

        private void flushBuffer() {
            if (this.maybeDeleteFiles().lastOption().exists((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.shouldDeleteFile(file)))) {
                this.filesToDelete().enqueue(this.maybeDeleteFiles());
            }
            this.maybeDeleteFiles().clear();
        }

        private void queueFilesInBuffer() {
            boolean continueBuffering = true;
            while (continueBuffering) {
                if (!this.underlying.hasNext()) {
                    this.flushBuffer();
                    return;
                }
                FileStatus currentFile = (FileStatus)this.underlying.next();
                Predef$.MODULE$.require(currentFile != null, (Function0 & Serializable & scala.Serializable)() -> "FileStatus iterator returned null");
                if (this.needsTimeAdjustment(currentFile)) {
                    currentFile = new FileStatus(currentFile.getLen(), currentFile.isDirectory(), (int)currentFile.getReplication(), currentFile.getBlockSize(), this.lastFile().getModificationTime() + 1L, currentFile.getPath());
                    this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                } else {
                    this.flushBuffer();
                    this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                    continueBuffering = false;
                }
                this.lastFile_$eq(currentFile);
            }
        }

        public boolean hasNext() {
            block0: {
                this.hasNextCalled_$eq(true);
                if (!this.filesToDelete().isEmpty()) break block0;
                this.queueFilesInBuffer();
            }
            return this.filesToDelete().nonEmpty();
        }

        public FileStatus next() {
            if (!this.hasNextCalled()) {
                throw new NoSuchElementException();
            }
            this.hasNextCalled_$eq(false);
            return (FileStatus)this.filesToDelete().dequeue();
        }

        public BufferingLogDeletionIterator(Iterator<FileStatus> underlying, long maxTimestamp, long maxVersion, Function1<Path, Object> versionGetter) {
            this.underlying = underlying;
            this.maxTimestamp = maxTimestamp;
            this.maxVersion = maxVersion;
            this.versionGetter = versionGetter;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.filesToDelete = new Queue();
            this.maybeDeleteFiles = new ArrayBuffer();
            this.hasNextCalled = false;
            this.init();
        }
    }

    public static class Commit
    implements CommitMarker,
    Product,
    scala.Serializable {
        private final long version;
        private final long timestamp;

        public long version() {
            return this.version;
        }

        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public Commit withTimestamp(long timestamp) {
            long x$1 = timestamp;
            long x$2 = this.copy$default$1();
            return this.copy(x$2, x$1);
        }

        @Override
        public long getTimestamp() {
            return this.timestamp();
        }

        @Override
        public long getVersion() {
            return this.version();
        }

        public Commit copy(long version, long timestamp) {
            return new Commit(version, timestamp);
        }

        public long copy$default$1() {
            return this.version();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "Commit";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.version());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Commit;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Commit)) return false;
            boolean bl = true;
            if (!bl) return false;
            Commit commit = (Commit)x$1;
            if (this.version() != commit.version()) return false;
            if (this.timestamp() != commit.timestamp()) return false;
            if (!commit.canEqual(this)) return false;
            return true;
        }

        public Commit(long version, long timestamp) {
            this.version = version;
            this.timestamp = timestamp;
            Product.$init$((Product)this);
        }
    }
}

