/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.InputFileName;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.DeleteCommand$;
import org.apache.spark.sql.delta.commands.DeleteMetric;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeFileIndex;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.metric.SQLMetrics$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001\u0002\u0011\"\u0001:B\u0001B\u0014\u0001\u0003\u0016\u0004%\ta\u0014\u0005\t-\u0002\u0011\t\u0012)A\u0005!\"Aq\u000b\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005Z\u0001\tE\t\u0015!\u00030\u0011!Q\u0006A!f\u0001\n\u0003Y\u0006\u0002C3\u0001\u0005#\u0005\u000b\u0011\u0002/\t\u000b\u0019\u0004A\u0011A4\t\u000b1\u0004A\u0011I7\t\u0015\u0005U\u0001\u0001#b\u0001\n\u0013\t9\u0002\u0003\u0006\u0002*\u0001A)\u0019!C!\u0003WAq!!\u0017\u0001\t\u000b\nY\u0006C\u0004\u0002r\u0001!I!a\u001d\t\u0013\u0005M\u0005!!A\u0005\u0002\u0005U\u0005\"CAO\u0001E\u0005I\u0011AAP\u0011%\t)\fAI\u0001\n\u0003\t9\fC\u0005\u0002<\u0002\t\n\u0011\"\u0001\u0002>\"I\u0011\u0011\u0019\u0001\u0002\u0002\u0013\u0005\u00131\u0019\u0005\n\u0003'\u0004\u0011\u0011!C\u0001\u0003+D\u0011\"!8\u0001\u0003\u0003%\t!a8\t\u0013\u0005\u0015\b!!A\u0005B\u0005\u001d\b\"CAy\u0001\u0005\u0005I\u0011AAz\u0011%\ti\u0010AA\u0001\n\u0003\nypB\u0004\u0003\u0004\u0005B\tA!\u0002\u0007\r\u0001\n\u0003\u0012\u0001B\u0004\u0011\u00191\u0007\u0004\"\u0001\u0003\u0010!9!\u0011\u0003\r\u0005\u0002\tM\u0001\"\u0003B\u00101\t\u0007I\u0011AAb\u0011!\u0011\t\u0003\u0007Q\u0001\n\u0005\u0015\u0007\"\u0003B\t1\u0005\u0005I\u0011\u0011B\u0012\u0011%\u0011Y\u0003GA\u0001\n\u0003\u0013i\u0003C\u0005\u0003<a\t\t\u0011\"\u0003\u0003>\tiA)\u001a7fi\u0016\u001cu.\\7b]\u0012T!AI\u0012\u0002\u0011\r|W.\\1oINT!\u0001J\u0013\u0002\u000b\u0011,G\u000e^1\u000b\u0005\u0019:\u0013aA:rY*\u0011\u0001&K\u0001\u0006gB\f'o\u001b\u0006\u0003U-\na!\u00199bG\",'\"\u0001\u0017\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001y\u0013(Q#L!\t\u0001t'D\u00012\u0015\t\u00114'A\u0004m_\u001eL7-\u00197\u000b\u0005Q*\u0014!\u00029mC:\u001c(B\u0001\u001c&\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u001d2\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014aB2p[6\fg\u000e\u001a\u0006\u0003}\u0015\n\u0011\"\u001a=fGV$\u0018n\u001c8\n\u0005\u0001[$a\u0004*v]:\f'\r\\3D_6l\u0017M\u001c3\u0011\u0005\t\u001bU\"A\u0011\n\u0005\u0011\u000b#\u0001\u0004#fYR\f7i\\7nC:$\u0007C\u0001$J\u001b\u00059%\"\u0001%\u0002\u000bM\u001c\u0017\r\\1\n\u0005);%a\u0002)s_\u0012,8\r\u001e\t\u0003\r2K!!T$\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u001dQ\f\u0007n\\3GS2,\u0017J\u001c3fqV\t\u0001\u000b\u0005\u0002R)6\t!K\u0003\u0002TG\u0005)a-\u001b7fg&\u0011QK\u0015\u0002\u000f)\u0006Dw.\u001a$jY\u0016Le\u000eZ3y\u0003=!\u0018\r[8f\r&dW-\u00138eKb\u0004\u0013A\u0002;be\u001e,G/F\u00010\u0003\u001d!\u0018M]4fi\u0002\n\u0011bY8oI&$\u0018n\u001c8\u0016\u0003q\u00032AR/`\u0013\tqvI\u0001\u0004PaRLwN\u001c\t\u0003A\u000el\u0011!\u0019\u0006\u0003EV\n1\"\u001a=qe\u0016\u001c8/[8og&\u0011A-\u0019\u0002\u000b\u000bb\u0004(/Z:tS>t\u0017AC2p]\u0012LG/[8oA\u00051A(\u001b8jiz\"B\u0001[5kWB\u0011!\t\u0001\u0005\u0006\u001d\u001e\u0001\r\u0001\u0015\u0005\u0006/\u001e\u0001\ra\f\u0005\u00065\u001e\u0001\r\u0001X\u0001\u000eS:tWM]\"iS2$'/\u001a8\u0016\u00039\u00042a\\<{\u001d\t\u0001XO\u0004\u0002ri6\t!O\u0003\u0002t[\u00051AH]8pizJ\u0011\u0001S\u0005\u0003m\u001e\u000bq\u0001]1dW\u0006<W-\u0003\u0002ys\n\u00191+Z9\u000b\u0005Y<\u0005gA>\u0002\u0004A\u0019A0`@\u000e\u0003MJ!A`\u001a\u0003\u0013E+XM]=QY\u0006t\u0007\u0003BA\u0001\u0003\u0007a\u0001\u0001B\u0006\u0002\u0006!\t\t\u0011!A\u0003\u0002\u0005\u001d!aA0%cE!\u0011\u0011BA\b!\r1\u00151B\u0005\u0004\u0003\u001b9%a\u0002(pi\"Lgn\u001a\t\u0004\r\u0006E\u0011bAA\n\u000f\n\u0019\u0011I\\=\u0002\u0005M\u001cWCAA\r!\u0011\tY\"!\b\u000e\u0003\u001dJ1!a\b(\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=uQ\rI\u00111\u0005\t\u0004\r\u0006\u0015\u0012bAA\u0014\u000f\nIAO]1og&,g\u000e^\u0001\b[\u0016$(/[2t+\t\ti\u0003\u0005\u0005\u00020\u0005e\u0012QHA'\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012!C5n[V$\u0018M\u00197f\u0015\r\t9dR\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u001e\u0003c\u00111!T1q!\u0011\ty$a\u0012\u000f\t\u0005\u0005\u00131\t\t\u0003c\u001eK1!!\u0012H\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011JA&\u0005\u0019\u0019FO]5oO*\u0019\u0011QI$\u0011\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015>\u0003\u0019iW\r\u001e:jG&!\u0011qKA)\u0005%\u0019\u0016\u000bT'fiJL7-A\u0002sk:$B!!\u0018\u0002hA!qn^A0!\u0011\t\t'a\u0019\u000e\u0003\u0015J1!!\u001a&\u0005\r\u0011vn\u001e\u0005\b\u0003SZ\u0001\u0019AA6\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\u0011\t\t'!\u001c\n\u0007\u0005=TE\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0007qKJ4wN]7EK2,G/\u001a\u000b\t\u0003k\nY(! \u0002\nB\u0019a)a\u001e\n\u0007\u0005etI\u0001\u0003V]&$\bbBA5\u0019\u0001\u0007\u00111\u000e\u0005\b\u0003\u007fb\u0001\u0019AAA\u0003!!W\r\u001c;b\u0019><\u0007\u0003BAB\u0003\u000bk\u0011aI\u0005\u0004\u0003\u000f\u001b#\u0001\u0003#fYR\fGj\\4\t\u000f\u0005-E\u00021\u0001\u0002\u000e\u0006\u0019A\u000f\u001f8\u0011\t\u0005\r\u0015qR\u0005\u0004\u0003#\u001b#!F(qi&l\u0017n\u001d;jGR\u0013\u0018M\\:bGRLwN\\\u0001\u0005G>\u0004\u0018\u0010F\u0004i\u0003/\u000bI*a'\t\u000f9k\u0001\u0013!a\u0001!\"9q+\u0004I\u0001\u0002\u0004y\u0003b\u0002.\u000e!\u0003\u0005\r\u0001X\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tKK\u0002Q\u0003G[#!!*\u0011\t\u0005\u001d\u0016\u0011W\u0007\u0003\u0003SSA!a+\u0002.\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_;\u0015AC1o]>$\u0018\r^5p]&!\u00111WAU\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tILK\u00020\u0003G\u000babY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002@*\u001aA,a)\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\r\u0005\u0003\u0002H\u0006EWBAAe\u0015\u0011\tY-!4\u0002\t1\fgn\u001a\u0006\u0003\u0003\u001f\fAA[1wC&!\u0011\u0011JAe\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u000eE\u0002G\u00033L1!a7H\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty!!9\t\u0013\u0005\r8#!AA\u0002\u0005]\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002jB1\u00111^Aw\u0003\u001fi!!!\u000e\n\t\u0005=\u0018Q\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002v\u0006m\bc\u0001$\u0002x&\u0019\u0011\u0011`$\u0003\u000f\t{w\u000e\\3b]\"I\u00111]\u000b\u0002\u0002\u0003\u0007\u0011qB\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U(\u0011\u0001\u0005\n\u0003G4\u0012\u0011!a\u0001\u0003\u001f\tQ\u0002R3mKR,7i\\7nC:$\u0007C\u0001\"\u0019'\u0011A\"\u0011B&\u0011\u0007\u0019\u0013Y!C\u0002\u0003\u000e\u001d\u0013a!\u00118z%\u00164GC\u0001B\u0003\u0003\u0015\t\u0007\u000f\u001d7z)\rA'Q\u0003\u0005\b\u0005/Q\u0002\u0019\u0001B\r\u0003\u0019!W\r\\3uKB\u0019\u0001Ga\u0007\n\u0007\tu\u0011GA\u0006EK2$\u0018\rR3mKR,\u0017\u0001\u0005$J\u0019\u0016{f*Q'F?\u000e{E*V'O\u0003E1\u0015\nT#`\u001d\u0006kUiX\"P\u0019Vke\n\t\u000b\bQ\n\u0015\"q\u0005B\u0015\u0011\u0015qU\u00041\u0001Q\u0011\u00159V\u00041\u00010\u0011\u0015QV\u00041\u0001]\u0003\u001d)h.\u00199qYf$BAa\f\u00038A!a)\u0018B\u0019!\u00191%1\u0007)09&\u0019!QG$\u0003\rQ+\b\u000f\\34\u0011!\u0011IDHA\u0001\u0002\u0004A\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u0004\u0005\u0003\u0002H\n\u0005\u0013\u0002\u0002B\"\u0003\u0013\u0014aa\u00142kK\u000e$\b")
public class DeleteCommand
extends LogicalPlan
implements RunnableCommand,
DeltaCommand,
scala.Serializable {
    private transient SparkContext sc;
    private Map<String, SQLMetric> metrics;
    private final TahoeFileIndex tahoeFileIndex;
    private final LogicalPlan target;
    private final Option<Expression> condition;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<TahoeFileIndex, LogicalPlan, Option<Expression>>> unapply(DeleteCommand deleteCommand) {
        return DeleteCommand$.MODULE$.unapply(deleteCommand);
    }

    public static String FILE_NAME_COLUMN() {
        return DeleteCommand$.MODULE$.FILE_NAME_COLUMN();
    }

    @Override
    public Seq<Expression> parsePartitionPredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePartitionPredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public TahoeFileIndex tahoeFileIndex() {
        return this.tahoeFileIndex;
    }

    public LogicalPlan target() {
        return this.target;
    }

    public Option<Expression> condition() {
        return this.condition;
    }

    public Seq<QueryPlan<?>> innerChildren() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogicalPlan[]{this.target()}));
    }

    private SparkContext sc$lzycompute() {
        DeleteCommand deleteCommand = this;
        synchronized (deleteCommand) {
            if (!this.bitmap$trans$0) {
                this.sc = SparkContext$.MODULE$.getOrCreate();
                this.bitmap$trans$0 = true;
            }
        }
        return this.sc;
    }

    private SparkContext sc() {
        return !this.bitmap$trans$0 ? this.sc$lzycompute() : this.sc;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        DeleteCommand deleteCommand = this;
        synchronized (deleteCommand) {
            if (!this.bitmap$0) {
                this.metrics = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numRemovedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of files removed.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numAddedFiles"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of files added.")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numDeletedRows"), (Object)SQLMetrics$.MODULE$.createMetric(this.sc(), "number of rows deleted."))}));
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Row> run(SparkSession sparkSession) {
        this.recordDeltaOperation(this.tahoeFileIndex().deltaLog(), "delta.dml.delete", this.recordDeltaOperation$default$3(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            DeltaLog deltaLog = this.tahoeFileIndex().deltaLog();
            deltaLog.assertRemovable();
            deltaLog.withNewTransaction((Function1 & Serializable & scala.Serializable)txn -> {
                this.performDelete(sparkSession, deltaLog, txn);
                return BoxedUnit.UNIT;
            });
            sparkSession.sharedState().cacheManager().recacheByPlan(sparkSession, this.target());
        });
        return (Seq)Seq$.MODULE$.empty();
    }

    private void performDelete(SparkSession sparkSession, DeltaLog deltaLog, OptimisticTransaction txn) {
        Seq seq;
        LongRef numTouchedFiles = LongRef.create((long)0L);
        long numRewrittenFiles = 0L;
        long scanTimeMs = 0L;
        long rewriteTimeMs = 0L;
        long startTime = System.nanoTime();
        long numFilesTotal = deltaLog.snapshot().numOfFiles();
        Option<Expression> option = this.condition();
        if (None$.MODULE$.equals(option)) {
            Seq<AddFile> allFiles = txn.filterFiles((Seq<Expression>)Nil$.MODULE$);
            numTouchedFiles.elem = allFiles.size();
            scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
            long operationTimestamp = System.currentTimeMillis();
            ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).set((long)allFiles.size());
            seq = (Seq)allFiles.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.removeWithTimestamp(operationTimestamp, x$1.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
        } else if (option instanceof Some) {
            Seq seq2;
            Some some = (Some)option;
            Expression cond = (Expression)some.value();
            Tuple2<Seq<Expression>, Seq<Expression>> tuple2 = DeltaTableUtils$.MODULE$.splitMetadataAndDataPredicates(cond, txn.metadata().partitionColumns(), sparkSession);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq metadataPredicates = (Seq)tuple2._1();
            Seq otherPredicates = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)metadataPredicates, (Object)otherPredicates);
            Tuple2 tuple23 = tuple22;
            Seq metadataPredicates2 = (Seq)tuple23._1();
            Seq otherPredicates2 = (Seq)tuple23._2();
            if (otherPredicates2.isEmpty()) {
                long operationTimestamp = System.currentTimeMillis();
                Seq<AddFile> candidateFiles = txn.filterFiles((Seq<Expression>)metadataPredicates2);
                scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
                numTouchedFiles.elem = candidateFiles.size();
                ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).set(numTouchedFiles.elem);
                seq2 = (Seq)candidateFiles.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.removeWithTimestamp(operationTimestamp, x$3.removeWithTimestamp$default$2()), Seq$.MODULE$.canBuildFrom());
            } else {
                Seq<AddFile> candidateFiles = txn.filterFiles((Seq<Expression>)((Seq)metadataPredicates2.$plus$plus((GenTraversableOnce)otherPredicates2, Seq$.MODULE$.canBuildFrom())));
                numTouchedFiles.elem = candidateFiles.size();
                Map<String, AddFile> nameToAddFileMap = this.generateCandidateFileMap(deltaLog.dataPath(), candidateFiles);
                TahoeBatchFileIndex fileIndex = new TahoeBatchFileIndex(sparkSession, "delete", candidateFiles, deltaLog, this.tahoeFileIndex().path(), txn.snapshot());
                LogicalPlan newTarget = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), fileIndex);
                Dataset data = Dataset$.MODULE$.ofRows(sparkSession, newTarget);
                SQLMetric deletedRowCount = (SQLMetric)this.metrics().apply((Object)"numDeletedRows");
                UserDefinedFunction deletedRowUdf = functions$.MODULE$.udf((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                    deletedRowCount.$plus$eq(1L);
                    return true;
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Boolean()).asNondeterministic();
                String[] filesToRewrite = (String[])this.withStatusCode("DELTA", "Finding files to rewrite for DELETE operation", this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> numTouchedFiles$1.elem == 0L ? (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)) : (String[])data.filter(new Column(cond)).filter(deletedRowUdf.apply((Seq)Nil$.MODULE$)).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column((Expression)new InputFileName())})).distinct().as(sparkSession.implicits().newStringEncoder()).collect());
                ((SQLMetric)this.metrics().apply((Object)"numRemovedFiles")).set((long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).size());
                scanTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L;
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).isEmpty()) {
                    seq2 = Nil$.MODULE$;
                } else {
                    HadoopFsRelation baseRelation = this.buildBaseRelation(sparkSession, txn, "delete", this.tahoeFileIndex().path(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])filesToRewrite), nameToAddFileMap);
                    LogicalPlan newTarget2 = DeltaTableUtils$.MODULE$.replaceFileIndex(this.target(), baseRelation.location());
                    Dataset targetDF = Dataset$.MODULE$.ofRows(sparkSession, newTarget2);
                    Not filterCond = new Not((Expression)new EqualNullSafe(cond, (Expression)new Literal((Object)BoxesRunTime.boxToBoolean((boolean)true), (DataType)BooleanType$.MODULE$)));
                    Dataset updatedDF = targetDF.filter(new Column((Expression)filterCond));
                    Seq rewrittenFiles = (Seq)this.withStatusCode("DELTA", new StringBuilder(37).append("Rewriting ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filesToRewrite)).size()).append(" files for DELETE operation").toString(), this.withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> txn.writeFiles(updatedDF));
                    numRewrittenFiles = rewrittenFiles.size();
                    rewriteTimeMs = (System.nanoTime() - startTime) / 1000L / 1000L - scanTimeMs;
                    long operationTimestamp = System.currentTimeMillis();
                    seq2 = (Seq)this.removeFilesFromPaths(deltaLog, nameToAddFileMap, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])filesToRewrite), operationTimestamp).$plus$plus((GenTraversableOnce)rewrittenFiles, Seq$.MODULE$.canBuildFrom());
                }
            }
            seq = seq2;
        } else {
            throw new MatchError(option);
        }
        Seq deleteActions = seq;
        if (deleteActions.nonEmpty()) {
            ((SQLMetric)this.metrics().apply((Object)"numAddedFiles")).set(numRewrittenFiles);
            txn.registerSQLMetrics(sparkSession, this.metrics());
            txn.commit((Seq<Action>)deleteActions, new DeltaOperations.Delete((Seq<String>)Option$.MODULE$.option2Iterable(this.condition().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.sql())).toSeq()));
            String executionId = sparkSession.sparkContext().getLocalProperty(SQLExecution$.MODULE$.EXECUTION_ID_KEY());
            SQLMetrics$.MODULE$.postDriverMetricUpdates(sparkSession.sparkContext(), executionId, this.metrics().values().toSeq());
        }
        DeltaLog x$12 = deltaLog;
        String x$2 = "delta.dml.delete.stats";
        DeleteMetric x$32 = new DeleteMetric((String)this.condition().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.sql()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "true"), numFilesTotal, numTouchedFiles.elem, numRewrittenFiles, scanTimeMs, rewriteTimeMs);
        Map<TagDefinition, String> x$42 = this.recordDeltaEvent$default$3();
        this.recordDeltaEvent(x$12, x$2, x$42, x$32);
    }

    public DeleteCommand copy(TahoeFileIndex tahoeFileIndex, LogicalPlan target, Option<Expression> condition) {
        return new DeleteCommand(tahoeFileIndex, target, condition);
    }

    public TahoeFileIndex copy$default$1() {
        return this.tahoeFileIndex();
    }

    public LogicalPlan copy$default$2() {
        return this.target();
    }

    public Option<Expression> copy$default$3() {
        return this.condition();
    }

    public String productPrefix() {
        return "DeleteCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.tahoeFileIndex();
                break;
            }
            case 1: {
                option = this.target();
                break;
            }
            case 2: {
                option = this.condition();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return option;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DeleteCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DeleteCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        DeleteCommand deleteCommand = (DeleteCommand)x$1;
        TahoeFileIndex tahoeFileIndex = this.tahoeFileIndex();
        TahoeFileIndex tahoeFileIndex2 = deleteCommand.tahoeFileIndex();
        if (tahoeFileIndex == null) {
            if (tahoeFileIndex2 != null) {
                return false;
            }
        } else if (!tahoeFileIndex.equals(tahoeFileIndex2)) return false;
        LogicalPlan logicalPlan = this.target();
        LogicalPlan logicalPlan2 = deleteCommand.target();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        Option<Expression> option = this.condition();
        Option<Expression> option2 = deleteCommand.condition();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!deleteCommand.canEqual(this)) return false;
        return true;
    }

    public DeleteCommand(TahoeFileIndex tahoeFileIndex, LogicalPlan target, Option<Expression> condition) {
        this.tahoeFileIndex = tahoeFileIndex;
        this.target = target;
        this.condition = condition;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
    }
}

