/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.plans.logical;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExtractValue;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.DeltaUpdateTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.runtime.Nothing$;

public final class DeltaUpdateTable$
implements scala.Serializable {
    public static DeltaUpdateTable$ MODULE$;

    static {
        new DeltaUpdateTable$();
    }

    public DeltaUpdateTable resolveReferences(DeltaUpdateTable update, Function1<Expression, Expression> resolver) {
        Seq cleanedUpAttributes;
        if (update.resolved()) {
            return update;
        }
        Predef$.MODULE$.assert(update.child().resolved());
        DeltaUpdateTable deltaUpdateTable = update;
        if (deltaUpdateTable == null) {
            throw new MatchError((Object)deltaUpdateTable);
        }
        LogicalPlan child = deltaUpdateTable.child();
        Seq<NamedExpression> updateColumns = deltaUpdateTable.updateColumns();
        Seq<Expression> updateExpressions = deltaUpdateTable.updateExpressions();
        Option<Expression> condition = deltaUpdateTable.condition();
        Tuple4 tuple4 = new Tuple4((Object)child, updateColumns, updateExpressions, condition);
        Tuple4 tuple42 = tuple4;
        LogicalPlan child2 = (LogicalPlan)tuple42._1();
        Seq updateColumns2 = (Seq)tuple42._2();
        Seq updateExpressions2 = (Seq)tuple42._3();
        Option condition2 = (Option)tuple42._4();
        Seq x$1 = cleanedUpAttributes = (Seq)updateColumns2.map((Function1 & Serializable & scala.Serializable)unresolvedExpr -> {
            String errMsg = new StringBuilder(33).append("Failed to resolve ").append(((Expression)unresolvedExpr).sql()).append(" given columns ").append(new StringBuilder(3).append("[").append(((TraversableOnce)child2.output().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.qualifiedName(), Seq$.MODULE$.canBuildFrom())).mkString(", ")).append("].").toString()).toString();
            Seq<String> resolveNameParts = MODULE$.getNameParts((Expression)resolver.apply(unresolvedExpr), errMsg, (LogicalPlan)update);
            return new UnresolvedAttribute(resolveNameParts);
        }, Seq$.MODULE$.canBuildFrom());
        Seq x$2 = (Seq)updateExpressions2.map(resolver, Seq$.MODULE$.canBuildFrom());
        Option x$3 = condition2.map(resolver);
        LogicalPlan x$4 = update.copy$default$1();
        return update.copy(x$4, (Seq<NamedExpression>)x$1, (Seq<Expression>)x$2, (Option<Expression>)x$3);
    }

    public Seq<String> getNameParts(Expression resolvedTargetCol, String errMsg, LogicalPlan errNode) {
        return this.extractRecursively$1(resolvedTargetCol, errMsg, errNode);
    }

    public DeltaUpdateTable apply(LogicalPlan child, Seq<NamedExpression> updateColumns, Seq<Expression> updateExpressions, Option<Expression> condition) {
        return new DeltaUpdateTable(child, updateColumns, updateExpressions, condition);
    }

    public Option<Tuple4<LogicalPlan, Seq<NamedExpression>, Seq<Expression>, Option<Expression>>> unapply(DeltaUpdateTable x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.child(), x$0.updateColumns(), x$0.updateExpressions(), x$0.condition()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Nothing$ fail$1(String extraMsg, String errMsg$1, LogicalPlan errNode$1) {
        throw new AnalysisException(new StringBuilder(3).append(errMsg$1).append(" - ").append(extraMsg).toString(), errNode$1.origin().line(), errNode$1.origin().startPosition(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Seq extractRecursively$1(Expression expr, String errMsg$1, LogicalPlan errNode$1) {
        Expression expression;
        while (true) {
            Expression c;
            if ((expression = expr) instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)expression;
                return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{attributeReference.name()}));
            }
            if (!(expression instanceof Alias)) break;
            Alias alias = (Alias)expression;
            expr = c = alias.child();
        }
        if (expression instanceof GetStructField) {
            GetStructField getStructField = (GetStructField)expression;
            Expression c = getStructField.child();
            Option option = getStructField.name();
            if (option instanceof Some) {
                Some some = (Some)option;
                String name = (String)some.value();
                return (Seq)this.extractRecursively$1(c, errMsg$1, errNode$1).$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom());
            }
        }
        if (!(expression instanceof ExtractValue)) throw DeltaUpdateTable$.fail$1(new StringBuilder(70).append("Found unsupported expression '").append(expression).append("' while parsing target column name parts").toString(), errMsg$1, errNode$1);
        throw DeltaUpdateTable$.fail$1("Updating nested fields is only supported for StructType.", errMsg$1, errNode$1);
    }

    private DeltaUpdateTable$() {
        MODULE$ = this;
    }
}

