/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.delta.DeltaConfig;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.hooks.GenerateSymlinkManifest$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DeltaConfigs$
implements DeltaLogging {
    public static DeltaConfigs$ MODULE$;
    private final String sqlConfPrefix;
    private final HashMap<String, DeltaConfig<?>> entries;
    private final DeltaConfig<CalendarInterval> LOG_RETENTION;
    private final DeltaConfig<CalendarInterval> SAMPLE_RETENTION;
    private final DeltaConfig<CalendarInterval> CHECKPOINT_RETENTION_DURATION;
    private final DeltaConfig<Object> CHECKPOINT_INTERVAL;
    private final DeltaConfig<Object> ENABLE_EXPIRED_LOG_CLEANUP;
    private final DeltaConfig<Object> ENABLE_FULL_RETENTION_ROLLBACK;
    private final DeltaConfig<CalendarInterval> TOMBSTONE_RETENTION;
    private final DeltaConfig<Object> RANDOMIZE_FILE_PREFIXES;
    private final DeltaConfig<Object> RANDOM_PREFIX_LENGTH;
    private final DeltaConfig<Object> IS_APPEND_ONLY;
    private final DeltaConfig<Object> AUTO_OPTIMIZE;
    private final DeltaConfig<Object> DATA_SKIPPING_NUM_INDEXED_COLS;
    private final DeltaConfig<Object> SYMLINK_FORMAT_MANIFEST_ENABLED;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaConfigs$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public CalendarInterval parseCalendarInterval(String s) {
        if (s == null || s.trim().isEmpty()) {
            throw new IllegalArgumentException("Interval cannot be null or blank.");
        }
        String sInLowerCase = s.trim().toLowerCase(Locale.ROOT);
        String interval = sInLowerCase.startsWith("interval ") ? sInLowerCase : new StringBuilder(9).append("interval ").append(sInLowerCase).toString();
        CalendarInterval cal = CalendarInterval.fromString((String)interval);
        if (cal == null) {
            throw new IllegalArgumentException(new StringBuilder(18).append("Invalid interval: ").append(s).toString());
        }
        return cal;
    }

    public String sqlConfPrefix() {
        return this.sqlConfPrefix;
    }

    private HashMap<String, DeltaConfig<?>> entries() {
        return this.entries;
    }

    private <T> DeltaConfig<T> buildConfig(String key, String defaultValue, Function1<String, T> fromString, Function1<T, Object> validationFunction, String helpMessage, Option<Protocol> minimumProtocolVersion) {
        DeltaConfig<T> deltaConfig = new DeltaConfig<T>(new StringBuilder(6).append("delta.").append(key).toString(), defaultValue, fromString, validationFunction, helpMessage, minimumProtocolVersion);
        this.entries().put(key.toLowerCase(Locale.ROOT), deltaConfig);
        return deltaConfig;
    }

    private <T> Option<Protocol> buildConfig$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> validateConfigurations(Map<String, String> configurations) {
        return (Map)configurations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                String value = (String)tuple2._2();
                if (key.toLowerCase(Locale.ROOT).startsWith("delta.")) {
                    return (Tuple2)Option$.MODULE$.apply(MODULE$.entries().get(new StringOps(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT))).stripPrefix("delta."))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.apply(value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw DeltaErrors$.MODULE$.unknownConfigurationKeyException(key);
                    });
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String key = (String)tuple2._1();
            if (!MODULE$.entries().containsKey(key.toLowerCase(Locale.ROOT))) return tuple2;
            MODULE$.logConsole(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(205).append("\n              |You are trying to set a property the key of which is the same as Delta config: ").append(key).append(".\n              |If you are trying to set a Delta config, prefix it with \"delta.\", e.g. 'delta.").append(key).append("'.\n            ").toString())).stripMargin());
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
    }

    public void verifyProtocolVersionRequirements(Map<String, String> configurations, Protocol current) {
        configurations.foreach((Function1 & Serializable & scala.Serializable)config -> {
            DeltaConfigs$.$anonfun$verifyProtocolVersionRequirements$1(current, config);
            return BoxedUnit.UNIT;
        });
    }

    public Map<String, String> mergeGlobalConfigs(SQLConf sqlConfs, Map<String, String> tableConf, Protocol protocol) {
        scala.collection.mutable.Map globalConfs = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.entries()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Iterable iterable;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                DeltaConfig config = (DeltaConfig)tuple2._2();
                String sqlConfKey = new StringBuilder(0).append(MODULE$.sqlConfPrefix()).append(new StringOps(Predef$.MODULE$.augmentString(config.key())).stripPrefix("delta.")).toString();
                Option option = Option$.MODULE$.apply((Object)sqlConfs.getConfString(sqlConfKey, null));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String string = (String)some.value();
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some(config.apply(string)));
                } else {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Iterable iterable2 = iterable;
            return iterable2;
        }, Map$.MODULE$.canBuildFrom());
        Map updatedConf = globalConfs.toMap(Predef$.MODULE$.$conforms()).$plus$plus(tableConf);
        this.verifyProtocolVersionRequirements((Map<String, String>)updatedConf, protocol);
        return updatedConf;
    }

    public Seq<String> normalizeConfigKeys(Seq<String> propKeys) {
        return (Seq)propKeys.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            String string2 = string.toLowerCase(Locale.ROOT).startsWith("delta.") ? (String)Option$.MODULE$.apply(MODULE$.entries().get(new StringOps(Predef$.MODULE$.augmentString(string.toLowerCase(Locale.ROOT))).stripPrefix("delta."))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> string) : string;
            return string2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Option<String> normalizeConfigKey(Option<String> propKey) {
        return propKey.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string = x0$1;
            String string2 = string.toLowerCase(Locale.ROOT).startsWith("delta.") ? (String)Option$.MODULE$.apply(MODULE$.entries().get(new StringOps(Predef$.MODULE$.augmentString(string.toLowerCase(Locale.ROOT))).stripPrefix("delta."))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.key()).getOrElse((Function0 & Serializable & scala.Serializable)() -> string) : string;
            return string2;
        });
    }

    public long getMilliSeconds(CalendarInterval i) {
        return this.getMicroSeconds(i) / 1000L;
    }

    private long getMicroSeconds(CalendarInterval i) {
        Predef$.MODULE$.assert(i.months == 0);
        return i.microseconds;
    }

    public boolean isValidIntervalConfigValue(CalendarInterval i) {
        return i.months == 0 && this.getMicroSeconds(i) >= 0L;
    }

    public DeltaConfig<CalendarInterval> LOG_RETENTION() {
        return this.LOG_RETENTION;
    }

    public DeltaConfig<CalendarInterval> SAMPLE_RETENTION() {
        return this.SAMPLE_RETENTION;
    }

    public DeltaConfig<CalendarInterval> CHECKPOINT_RETENTION_DURATION() {
        return this.CHECKPOINT_RETENTION_DURATION;
    }

    public DeltaConfig<Object> CHECKPOINT_INTERVAL() {
        return this.CHECKPOINT_INTERVAL;
    }

    public DeltaConfig<Object> ENABLE_EXPIRED_LOG_CLEANUP() {
        return this.ENABLE_EXPIRED_LOG_CLEANUP;
    }

    public DeltaConfig<Object> ENABLE_FULL_RETENTION_ROLLBACK() {
        return this.ENABLE_FULL_RETENTION_ROLLBACK;
    }

    public DeltaConfig<CalendarInterval> TOMBSTONE_RETENTION() {
        return this.TOMBSTONE_RETENTION;
    }

    public DeltaConfig<Object> RANDOMIZE_FILE_PREFIXES() {
        return this.RANDOMIZE_FILE_PREFIXES;
    }

    public DeltaConfig<Object> RANDOM_PREFIX_LENGTH() {
        return this.RANDOM_PREFIX_LENGTH;
    }

    public DeltaConfig<Object> IS_APPEND_ONLY() {
        return this.IS_APPEND_ONLY;
    }

    public DeltaConfig<Object> AUTO_OPTIMIZE() {
        return this.AUTO_OPTIMIZE;
    }

    public DeltaConfig<Object> DATA_SKIPPING_NUM_INDEXED_COLS() {
        return this.DATA_SKIPPING_NUM_INDEXED_COLS;
    }

    public DeltaConfig<Object> SYMLINK_FORMAT_MANIFEST_ENABLED() {
        return this.SYMLINK_FORMAT_MANIFEST_ENABLED;
    }

    public static final /* synthetic */ void $anonfun$verifyProtocolVersionRequirements$1(Protocol current$1, Tuple2 config) {
        String key = new StringOps(Predef$.MODULE$.augmentString(((String)config._1()).toLowerCase(Locale.ROOT))).stripPrefix("delta.");
        if (MODULE$.entries().containsKey(key) && MODULE$.entries().get(key).minimumProtocolVersion().isDefined()) {
            Protocol required = (Protocol)MODULE$.entries().get(key).minimumProtocolVersion().get();
            if (current$1.minWriterVersion() < required.minWriterVersion() || current$1.minReaderVersion() < required.minReaderVersion()) {
                throw new AnalysisException(new StringBuilder(134).append("Setting the Delta config ").append(config._1()).append(" requires a protocol version of ").append(required).append(" ").append(new StringBuilder(59).append("or above, but the protocol version of the Delta table is ").append(current$1).append(". ").toString()).append("Please upgrade the protocol version of the table before setting this config.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
    }

    public static final /* synthetic */ int $anonfun$CHECKPOINT_INTERVAL$1(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$ENABLE_EXPIRED_LOG_CLEANUP$1(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$ENABLE_EXPIRED_LOG_CLEANUP$2(boolean x$7) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$ENABLE_FULL_RETENTION_ROLLBACK$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$ENABLE_FULL_RETENTION_ROLLBACK$2(boolean x$9) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$RANDOMIZE_FILE_PREFIXES$1(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$RANDOMIZE_FILE_PREFIXES$2(boolean x$11) {
        return true;
    }

    public static final /* synthetic */ int $anonfun$RANDOM_PREFIX_LENGTH$1(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$IS_APPEND_ONLY$1(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$IS_APPEND_ONLY$2(boolean x$14) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$AUTO_OPTIMIZE$1(String x$15) {
        return new StringOps(Predef$.MODULE$.augmentString(x$15)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$AUTO_OPTIMIZE$2(boolean x$16) {
        return true;
    }

    public static final /* synthetic */ int $anonfun$DATA_SKIPPING_NUM_INDEXED_COLS$1(String x$17) {
        return new StringOps(Predef$.MODULE$.augmentString(x$17)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$SYMLINK_FORMAT_MANIFEST_ENABLED$1(String x$18) {
        return new StringOps(Predef$.MODULE$.augmentString(x$18)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$SYMLINK_FORMAT_MANIFEST_ENABLED$2(boolean x$19) {
        return true;
    }

    private DeltaConfigs$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.sqlConfPrefix = "spark.databricks.delta.properties.defaults.";
        this.entries = new HashMap();
        this.LOG_RETENTION = this.buildConfig("logRetentionDuration", "interval 30 days", (Function1 & Serializable & scala.Serializable)s -> MODULE$.parseCalendarInterval((String)s), (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.MODULE$.isValidIntervalConfigValue(i)), "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6());
        this.SAMPLE_RETENTION = this.buildConfig("sampleRetentionDuration", "interval 7 days", (Function1 & Serializable & scala.Serializable)s -> MODULE$.parseCalendarInterval((String)s), (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.MODULE$.isValidIntervalConfigValue(i)), "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6());
        this.CHECKPOINT_RETENTION_DURATION = this.buildConfig("checkpointRetentionDuration", "interval 2 days", (Function1 & Serializable & scala.Serializable)s -> MODULE$.parseCalendarInterval((String)s), (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.MODULE$.isValidIntervalConfigValue(i)), "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6());
        this.CHECKPOINT_INTERVAL = this.buildConfig("checkpointInterval", "10", (Function1)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)DeltaConfigs$.$anonfun$CHECKPOINT_INTERVAL$1(x$4)), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 > 0, "needs to be a positive integer.", this.buildConfig$default$6());
        this.ENABLE_EXPIRED_LOG_CLEANUP = this.buildConfig("enableExpiredLogCleanup", "true", (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$ENABLE_EXPIRED_LOG_CLEANUP$1(x$6)), (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$ENABLE_EXPIRED_LOG_CLEANUP$2(BoxesRunTime.unboxToBoolean((Object)x$7))), "needs to be a boolean.", this.buildConfig$default$6());
        this.ENABLE_FULL_RETENTION_ROLLBACK = this.buildConfig("enableFullRetentionRollback", "true", (Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$ENABLE_FULL_RETENTION_ROLLBACK$1(x$8)), (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$ENABLE_FULL_RETENTION_ROLLBACK$2(BoxesRunTime.unboxToBoolean((Object)x$9))), "needs to be a boolean.", this.buildConfig$default$6());
        this.TOMBSTONE_RETENTION = this.buildConfig("deletedFileRetentionDuration", "interval 1 week", (Function1 & Serializable & scala.Serializable)s -> MODULE$.parseCalendarInterval((String)s), (Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.MODULE$.isValidIntervalConfigValue(i)), "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6());
        this.RANDOMIZE_FILE_PREFIXES = this.buildConfig("randomizeFilePrefixes", "false", (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$RANDOMIZE_FILE_PREFIXES$1(x$10)), (Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$RANDOMIZE_FILE_PREFIXES$2(BoxesRunTime.unboxToBoolean((Object)x$11))), "needs to be a boolean.", this.buildConfig$default$6());
        this.RANDOM_PREFIX_LENGTH = this.buildConfig("randomPrefixLength", "2", (Function1)(Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)DeltaConfigs$.$anonfun$RANDOM_PREFIX_LENGTH$1(x$12)), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)a -> a > 0, "needs to be greater than 0.", this.buildConfig$default$6());
        this.IS_APPEND_ONLY = this.buildConfig("appendOnly", "false", (Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$IS_APPEND_ONLY$1(x$13)), (Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$IS_APPEND_ONLY$2(BoxesRunTime.unboxToBoolean((Object)x$14))), "needs to be a boolean.", (Option<Protocol>)new Some((Object)new Protocol(0, 2)));
        this.AUTO_OPTIMIZE = this.buildConfig("autoOptimize", "false", (Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$AUTO_OPTIMIZE$1(x$15)), (Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$AUTO_OPTIMIZE$2(BoxesRunTime.unboxToBoolean((Object)x$16))), "needs to be a boolean.", this.buildConfig$default$6());
        this.DATA_SKIPPING_NUM_INDEXED_COLS = this.buildConfig("dataSkippingNumIndexedCols", "32", (Function1)(Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)DeltaConfigs$.$anonfun$DATA_SKIPPING_NUM_INDEXED_COLS$1(x$17)), (Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)a -> a >= -1, "needs to be larger than or equal to -1.", this.buildConfig$default$6());
        this.SYMLINK_FORMAT_MANIFEST_ENABLED = this.buildConfig(new StringBuilder(8).append(GenerateSymlinkManifest$.MODULE$.CONFIG_NAME_ROOT()).append(".enabled").toString(), "false", (Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$SYMLINK_FORMAT_MANIFEST_ENABLED$1(x$18)), (Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DeltaConfigs$.$anonfun$SYMLINK_FORMAT_MANIFEST_ENABLED$2(BoxesRunTime.unboxToBoolean((Object)x$19))), "needs to be a boolean.", this.buildConfig$default$6());
    }
}

