/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LogFileMeta$;
import org.apache.spark.sql.delta.LogFileMetaParser;
import org.apache.spark.sql.delta.LogFileMetaParser$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitInfo$;
import org.apache.spark.sql.delta.actions.CommitMarker;
import org.apache.spark.sql.delta.actions.JobInfo;
import org.apache.spark.sql.delta.actions.NotebookInfo;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

public final class DeltaHistoryManager$
implements DeltaLogging {
    public static DeltaHistoryManager$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaHistoryManager$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int $lessinit$greater$default$2() {
        return 1000;
    }

    public CommitInfo org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitInfo(LogStore logStore, Path basePath, long version) {
        CommitInfo commitInfo;
        Option info = logStore.read(FileNames$.MODULE$.deltaFile(basePath, version)).iterator().map((Function1 & Serializable & scala.Serializable)json -> Action$.MODULE$.fromJson((String)json)).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Action, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof CommitInfo) {
                    CommitInfo commitInfo = (CommitInfo)A1;
                    object = commitInfo;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Action x1) {
                Action action = x1;
                boolean bl = action instanceof CommitInfo;
                return bl;
            }
        });
        if (info.isEmpty()) {
            commitInfo = CommitInfo$.MODULE$.empty((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)));
        } else {
            CommitInfo qual$1 = (CommitInfo)Option$.MODULE$.option2Iterable(info).head();
            Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)version));
            Timestamp x$2 = qual$1.copy$default$2();
            Option<String> x$3 = qual$1.copy$default$3();
            Option<String> x$4 = qual$1.copy$default$4();
            String x$5 = qual$1.copy$default$5();
            Map<String, String> x$6 = qual$1.copy$default$6();
            Option<JobInfo> x$7 = qual$1.copy$default$7();
            Option<NotebookInfo> x$8 = qual$1.copy$default$8();
            Option<String> x$9 = qual$1.copy$default$9();
            Option<Object> x$10 = qual$1.copy$default$10();
            Option<String> x$11 = qual$1.copy$default$11();
            Option<Object> x$12 = qual$1.copy$default$12();
            Option<Map<String, String>> x$13 = qual$1.copy$default$13();
            commitInfo = qual$1.copy((Option<Object>)x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        }
        return commitInfo;
    }

    public DeltaHistoryManager.Commit[] getCommits(LogFileMetaParser logStore, Path logPath, long start, Option<Object> end) {
        long until = BoxesRunTime.unboxToLong((Object)end.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE));
        Iterator commits = logStore.listFilesFrom(FileNames$.MODULE$.deltaFile(logPath, start)).filter((Function1 & Serializable & scala.Serializable)logFileMeta -> BoxesRunTime.boxToBoolean((boolean)LogFileMeta$.MODULE$.isDeltaFile(logFileMeta))).map((Function1 & Serializable & scala.Serializable)fileStatus -> new DeltaHistoryManager.Commit(fileStatus.version(), fileStatus.fileStatus().getModificationTime())).takeWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager$.$anonfun$getCommits$4(until, x$4)));
        return (DeltaHistoryManager.Commit[])this.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps((CommitMarker[])commits.toArray(ClassTag$.MODULE$.apply(DeltaHistoryManager.Commit.class)));
    }

    public Option<Object> getCommits$default$4() {
        return None$.MODULE$;
    }

    public <T extends CommitMarker> T[] org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps(T[] commits) {
        IntRef i = IntRef.create((int)0);
        int length = commits.length;
        while (i.elem < length - 1) {
            long prevTimestamp = commits[i.elem].getTimestamp();
            Predef$.MODULE$.assert(commits[i.elem].getVersion() < commits[i.elem + 1].getVersion(), (Function0 & Serializable & scala.Serializable)() -> "Unordered commits provided.");
            if (prevTimestamp >= commits[i.elem + 1].getTimestamp()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Found Delta commit ").append(commits[i$1.elem].getVersion()).append(" with a timestamp ").append(prevTimestamp).append(" ").append(new StringBuilder(49).append("which is greater than the next commit timestamp ").append(commits[i$1.elem + 1].getTimestamp()).append(".").toString()).toString());
                commits[i.elem + 1] = commits[i.elem + 1].withTimestamp(prevTimestamp + 1L);
            }
            ++i.elem;
        }
        return commits;
    }

    public DeltaHistoryManager.Commit org$apache$spark$sql$delta$DeltaHistoryManager$$parallelSearch0(SparkSession spark, SerializableConfiguration conf, String logPath, long time, long start, long end, long step) {
        public final class Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.DeltaHistoryManager.Commit").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$2() {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        DeltaHistoryManager.Commit[] possibleCommits = (DeltaHistoryManager.Commit[])spark.range(start, end, step).mapPartitions((Function1 & Serializable & scala.Serializable)startVersions -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), conf.value());
            LogFileMetaParser logFileHandler = LogFileMetaParser$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), conf.value(), logStore);
            Path basePath = new Path(logPath);
            return startVersions.map((Function1 & Serializable & scala.Serializable)startVersion -> {
                DeltaHistoryManager.Commit[] commits = MODULE$.getCommits(logFileHandler, basePath, Predef$.MODULE$.Long2long(startVersion), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)scala.math.package$.MODULE$.min(Predef$.MODULE$.Long2long(startVersion) + step, end))));
                return (DeltaHistoryManager.Commit)MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<DeltaHistoryManager.Commit>)Predef$.MODULE$.wrapRefArray((Object[])commits), time).getOrElse((Function0 & Serializable & scala.Serializable)() -> (DeltaHistoryManager.Commit)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).head());
            });
        }, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$2()))).collect();
        DeltaHistoryManager.Commit[] commitList = (DeltaHistoryManager.Commit[])this.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps(possibleCommits);
        return (DeltaHistoryManager.Commit)this.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<DeltaHistoryManager.Commit>)Predef$.MODULE$.wrapRefArray((Object[])commitList), time).getOrElse((Function0 & Serializable & scala.Serializable)() -> (DeltaHistoryManager.Commit)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commitList)).head());
    }

    public Option<DeltaHistoryManager.Commit> org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp(Seq<DeltaHistoryManager.Commit> commits, long time) {
        int i = commits.lastIndexWhere((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager$.$anonfun$lastCommitBeforeTimestamp$1(time, x$5)));
        return i < 0 ? None$.MODULE$ : new Some(commits.apply(i));
    }

    public static final /* synthetic */ boolean $anonfun$getCommits$4(long until$1, DeltaHistoryManager.Commit x$4) {
        return x$4.version() < until$1;
    }

    public static final /* synthetic */ boolean $anonfun$lastCommitBeforeTimestamp$1(long time$2, DeltaHistoryManager.Commit x$5) {
        return x$5.timestamp() <= time$2;
    }

    private DeltaHistoryManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

