/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.Checkpoints;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.LogFileMeta$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001i3\u0001\u0002C\u0005\u0011\u0002\u0007\u0005AC\u0016\u0005\u0006C\u0001!\tA\t\u0005\u0006M\u0001!\ta\n\u0005\u0006W\u0001!\t\u0001\f\u0005\u0006a\u0001!\tE\t\u0005\u0007c\u0001!\t!\u0003\u0012\t\u000bI\u0002A\u0011B\u001a\t\r)\u0003A\u0011A\u0005L\u0005=iU\r^1eCR\f7\t\\3b]V\u0004(B\u0001\u0006\f\u0003\u0015!W\r\u001c;b\u0015\taQ\"A\u0002tc2T!AD\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005A\t\u0012AB1qC\u000eDWMC\u0001\u0013\u0003\ry'oZ\u0002\u0001'\r\u0001Qc\u0007\t\u0003-ei\u0011a\u0006\u0006\u00021\u0005)1oY1mC&\u0011!d\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005qyR\"A\u000f\u000b\u0005yI\u0011\u0001C7fi\u0016\u0014\u0018N\\4\n\u0005\u0001j\"\u0001\u0004#fYR\fGj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005F\u0001$!\t1B%\u0003\u0002&/\t!QK\\5u\u0003])g.\u00192mK\u0016C\b/\u001b:fI2{wm\u00117fC:,\b/F\u0001)!\t1\u0012&\u0003\u0002+/\t9!i\\8mK\u0006t\u0017\u0001\u00063fYR\f'+\u001a;f]RLwN\\'jY2L7/F\u0001.!\t1b&\u0003\u00020/\t!Aj\u001c8h\u00031!w\u000eT8h\u00072,\u0017M\\;q\u0003I\u0019G.Z1o+B,\u0005\u0010]5sK\u0012dunZ:\u0002)1L7\u000f^#ya&\u0014X\r\u001a#fYR\fGj\\4t)\t!\u0004\nE\u00026{\u0001s!AN\u001e\u000f\u0005]RT\"\u0001\u001d\u000b\u0005e\u001a\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\tat#A\u0004qC\u000e\\\u0017mZ3\n\u0005yz$\u0001C%uKJ\fGo\u001c:\u000b\u0005q:\u0002CA!G\u001b\u0005\u0011%BA\"E\u0003\t17O\u0003\u0002F\u001f\u00051\u0001.\u00193p_BL!a\u0012\"\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0003J\r\u0001\u0007Q&\u0001\bgS2,7)\u001e;PM\u001a$\u0016.\\3\u0002\u0017Q\u0014XO\\2bi\u0016$\u0015-\u001f\u000b\u0003\u0019R\u0003\"!\u0014*\u000e\u00039S!a\u0014)\u0002\tU$\u0018\u000e\u001c\u0006\u0002#\u0006!!.\u0019<b\u0013\t\u0019fJ\u0001\u0005DC2,g\u000eZ1s\u0011\u0015)v\u00011\u0001.\u0003)!\u0018.\\3NS2d\u0017n\u001d\t\u0003/bk\u0011!C\u0005\u00033&\u0011\u0001\u0002R3mi\u0006dun\u001a")
public interface MetadataCleanup
extends DeltaLogging {
    public static /* synthetic */ boolean enableExpiredLogCleanup$(MetadataCleanup $this) {
        return $this.enableExpiredLogCleanup();
    }

    default public boolean enableExpiredLogCleanup() {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_EXPIRED_LOG_CLEANUP().fromMetaData(((DeltaLog)this).metadata()));
    }

    public static /* synthetic */ long deltaRetentionMillis$(MetadataCleanup $this) {
        return $this.deltaRetentionMillis();
    }

    default public long deltaRetentionMillis() {
        CalendarInterval interval = DeltaConfigs$.MODULE$.LOG_RETENTION().fromMetaData(((DeltaLog)this).metadata());
        return DeltaConfigs$.MODULE$.getMilliSeconds(interval);
    }

    public static /* synthetic */ void doLogCleanup$(MetadataCleanup $this) {
        $this.doLogCleanup();
    }

    default public void doLogCleanup() {
        block0: {
            if (!this.enableExpiredLogCleanup()) break block0;
            this.cleanUpExpiredLogs();
        }
    }

    public static /* synthetic */ void cleanUpExpiredLogs$(MetadataCleanup $this) {
        $this.cleanUpExpiredLogs();
    }

    default public void cleanUpExpiredLogs() {
        this.recordDeltaOperation((DeltaLog)this, "delta.log.cleanup", this.recordDeltaOperation$default$3(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Date fileCutOffTime = this.truncateDay(((DeltaLog)this).clock().getTimeMillis() - this.deltaRetentionMillis()).getTime();
            String formattedDate = fileCutOffTime.toGMTString();
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Starting the deletion of log files older than ").append(formattedDate).toString());
            IntRef numDeleted = IntRef.create((int)0);
            this.listExpiredDeltaLogs(fileCutOffTime.getTime()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getPath()).foreach((Function1 & Serializable & scala.Serializable)path -> {
                MetadataCleanup.$anonfun$cleanUpExpiredLogs$4(this, numDeleted, path);
                return BoxedUnit.UNIT;
            });
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Deleted ").append(numDeleted$1.elem).append(" log files older than ").append(formattedDate).toString());
        });
    }

    private Iterator<FileStatus> listExpiredDeltaLogs(long fileCutOffTime) {
        Option<CheckpointMetaData> latestCheckpoint = ((Checkpoints)((Object)this)).lastCheckpoint();
        if (latestCheckpoint.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        long threshold = ((CheckpointMetaData)latestCheckpoint.get()).version() - 1L;
        Iterator files = ((DeltaLog)this).logFileHandler().listFilesFrom(FileNames$.MODULE$.checkpointPrefix(((DeltaLog)this).logPath(), 0L)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)MetadataCleanup.$anonfun$listExpiredDeltaLogs$1(f)));
        Tuple2[] versionTuples = (Tuple2[])files.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.fileStatus(), (Object)BoxesRunTime.boxToLong((long)f.version()))).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        Map versionMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])versionTuples)).map((Function1 & Serializable & scala.Serializable)vt -> new Tuple2((Object)((FileStatus)vt._1()).getPath(), (Object)BoxesRunTime.boxToLong((long)vt._2$mcJ$sp())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        return new DeltaHistoryManager.BufferingLogDeletionIterator((Iterator<FileStatus>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])versionTuples)).map((Function1 & Serializable & scala.Serializable)x$2 -> (FileStatus)x$2._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class))))).iterator(), fileCutOffTime, threshold, (Function1<Path, Object>)versionMap);
    }

    public static /* synthetic */ Calendar truncateDay$(MetadataCleanup $this, long timeMillis) {
        return $this.truncateDay(timeMillis);
    }

    default public Calendar truncateDay(long timeMillis) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(timeMillis);
        return DateUtils.truncate((Calendar)date, (int)5);
    }

    public static /* synthetic */ void $anonfun$cleanUpExpiredLogs$4(MetadataCleanup $this, IntRef numDeleted$1, Path path) {
        block0: {
            if (!((DeltaLog)$this).fs().delete(path, false)) break block0;
            ++numDeleted$1.elem;
        }
    }

    public static /* synthetic */ boolean $anonfun$listExpiredDeltaLogs$1(LogFileMeta f) {
        return LogFileMeta$.MODULE$.isCheckpointFile(f) || LogFileMeta$.MODULE$.isDeltaFile(f);
    }

    public static void $init$(MetadataCleanup $this) {
    }
}

