/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.TagDefinition;
import com.databricks.spark.util.TagDefinitions$TAG_ASYNC$;
import java.io.FileNotFoundException;
import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.CheckpointInstance;
import org.apache.spark.sql.delta.CheckpointInstance$;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.Checkpoints;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.InitialSnapshot;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.LogFileMeta$;
import org.apache.spark.sql.delta.LogSegment;
import org.apache.spark.sql.delta.ReadChecksum;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.SnapshotManagement$;
import org.apache.spark.sql.delta.VersionChecksum;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Metadata$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005uc!\u0003\u000e\u001c!\u0003\r\tAJA\u001f\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u001d\u0011\u0004\u00011A\u0005\u0012MBqa\u000f\u0001A\u0002\u0013EA\bC\u0004@\u0001\u0001\u0007I\u0011\u0003!\t\u000f\u0019\u0003\u0001\u0019!C\t\u000f\")\u0011\n\u0001C\t\u0015\")a\u000b\u0001C\t/\"9Q\fAI\u0001\n#q\u0006\"B5\u0001\t#\u0001\u0005\"\u00026\u0001\t\u0003\u0001\u0005\"B6\u0001\t#a\u0007\"B:\u0001\t\u0013!\b\"\u0002=\u0001\t\u0003I\bb\u0002?\u0001#\u0003%\t! \u0005\u0007\u007f\u0002!I!!\u0001\t\u0011\u0005\u001d\u0001!%A\u0005\nuDq!!\u0003\u0001\t#\tY\u0001C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u0011\u0005\u001d\u0002!%A\u0005\u0002yC\u0011\"!\u000b\u0001#\u0003%\t!a\u000b\t\u000f\u0005=\u0002\u0001\"\u0005\u00022\u001d9\u00111I\u000e\t\u0002\u0005\u0015cA\u0002\u000e\u001c\u0011\u0003\t9\u0005C\u0004\u0002J]!\t!a\u0013\t\u0015\u00055s\u0003#b\u0001\n#\tyE\u0001\nT]\u0006\u00048\u000f[8u\u001b\u0006t\u0017mZ3nK:$(B\u0001\u000f\u001e\u0003\u0015!W\r\u001c;b\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VMZ\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003=\u0002\"\u0001\u000b\u0019\n\u0005EJ#\u0001B+oSR\f1\u0003\\1tiV\u0003H-\u0019;f)&lWm\u001d;b[B,\u0012\u0001\u000e\t\u0003QUJ!AN\u0015\u0003\t1{gn\u001a\u0015\u0003\u0005a\u0002\"\u0001K\u001d\n\u0005iJ#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002/1\f7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9`I\u0015\fHCA\u0018>\u0011\u001dq4!!AA\u0002Q\n1\u0001\u001f\u00132\u0003=\u0019WO\u001d:f]R\u001cf.\u00199tQ>$X#A!\u0011\u0005\t\u001bU\"A\u000e\n\u0005\u0011[\"\u0001C*oCB\u001c\bn\u001c;)\u0005\u0011A\u0014aE2veJ,g\u000e^*oCB\u001c\bn\u001c;`I\u0015\fHCA\u0018I\u0011\u001dqT!!AA\u0002\u0005\u000b\u0011cZ3u\u0019><7+Z4nK:$hI]8n)\tYe\n\u0005\u0002C\u0019&\u0011Qj\u0007\u0002\u000b\u0019><7+Z4nK:$\b\"B(\u0007\u0001\u0004\u0001\u0016AE:uCJ$\u0018N\\4DQ\u0016\u001c7\u000e]8j]R\u00042\u0001K)T\u0013\t\u0011\u0016F\u0001\u0004PaRLwN\u001c\t\u0003\u0005RK!!V\u000e\u0003%\rCWmY6q_&tG/T3uC\u0012\u000bG/Y\u0001\u0018O\u0016$Hj\\4TK\u001elWM\u001c;G_J4VM]:j_:$2a\u0013-\\\u0011\u0015Iv\u00011\u0001[\u0003=\u0019H/\u0019:u\u0007\",7m\u001b9pS:$\bc\u0001\u0015Ri!9Al\u0002I\u0001\u0002\u0004Q\u0016!\u0004<feNLwN\u001c+p\u0019>\fG-A\u0011hKRdunZ*fO6,g\u000e\u001e$peZ+'o]5p]\u0012\"WMZ1vYR$#'F\u0001`U\tQ\u0006mK\u0001b!\t\u0011w-D\u0001d\u0015\t!W-A\u0005v]\u000eDWmY6fI*\u0011a-K\u0001\u000bC:tw\u000e^1uS>t\u0017B\u00015d\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012O\u0016$8K\\1qg\"|G/\u0011;J]&$\u0018\u0001C:oCB\u001c\bn\u001c;\u0002\u001d\r\u0014X-\u0019;f':\f\u0007o\u001d5piR!\u0011)\\8r\u0011\u0015q7\u00021\u0001L\u0003\u001d\u0019XmZ7f]RDQ\u0001]\u0006A\u0002Q\n\u0011$\\5o\r&dWMU3uK:$\u0018n\u001c8US6,7\u000f^1na\")!o\u0003a\u0001i\u0005IA/[7fgR\fW\u000e]\u0001\u0010SN\u001cf.\u00199tQ>$8\u000b^1mKV\tQ\u000f\u0005\u0002)m&\u0011q/\u000b\u0002\b\u0005>|G.Z1o\u0003\u0019)\b\u000fZ1uKR\u0011\u0011I\u001f\u0005\bw6\u0001\n\u00111\u0001v\u0003M\u0019H/\u00197f]\u0016\u001c8/Q2dKB$\u0018M\u00197f\u0003A)\b\u000fZ1uK\u0012\"WMZ1vYR$\u0013'F\u0001\u007fU\t)\b-A\u0005uef,\u0006\u000fZ1uKR\u0019\u0011)a\u0001\t\u0011\u0005\u0015q\u0002%AA\u0002U\fq![:Bgft7-A\nuef,\u0006\u000fZ1uK\u0012\"WMZ1vYR$\u0013'\u0001\bva\u0012\fG/Z%oi\u0016\u0014h.\u00197\u0015\u0007\u0005\u000bi\u0001\u0003\u0004\u0002\u0006E\u0001\r!^\u0001\u000eO\u0016$8K\\1qg\"|G/\u0011;\u0015\u000f\u0005\u000b\u0019\"a\u0006\u0002\u001c!1\u0011Q\u0003\nA\u0002Q\nqA^3sg&|g\u000e\u0003\u0005\u0002\u001aI\u0001\n\u00111\u0001[\u0003=\u0019w.\\7jiRKW.Z:uC6\u0004\b\"CA\u000f%A\u0005\t\u0019AA\u0010\u0003Ia\u0017m\u001d;DQ\u0016\u001c7\u000e]8j]RD\u0015N\u001c;\u0011\t!\n\u0016\u0011\u0005\t\u0004\u0005\u0006\r\u0012bAA\u00137\t\u00112\t[3dWB|\u0017N\u001c;J]N$\u0018M\\2f\u0003]9W\r^*oCB\u001c\bn\u001c;Bi\u0012\"WMZ1vYR$#'A\fhKR\u001cf.\u00199tQ>$\u0018\t\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0006\u0016\u0004\u0003?\u0001\u0017a\u0005<fe&4\u0017\u0010R3mi\u00064VM]:j_:\u001cHcA\u0018\u00024!9\u0011QG\u000bA\u0002\u0005]\u0012\u0001\u0003<feNLwN\\:\u0011\t!\nI\u0004N\u0005\u0004\u0003wI#!B!se\u0006L\bc\u0001\"\u0002@%\u0019\u0011\u0011I\u000e\u0003\u0011\u0011+G\u000e^1M_\u001e\f!c\u00158baNDw\u000e^'b]\u0006<W-\\3oiB\u0011!iF\n\u0003/\u001d\na\u0001P5oSRtDCAA#\u0003u!W\r\u001c;b\u0019><\u0017i]=oGV\u0003H-\u0019;f)\"\u0014X-\u00193Q_>dWCAA)!\u0011\t\u0019&!\u0017\u000e\u0005\u0005U#bAA,S\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\t\u0005m\u0013Q\u000b\u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0007")
public interface SnapshotManagement {
    public long lastUpdateTimestamp();

    public void lastUpdateTimestamp_$eq(long var1);

    public Snapshot currentSnapshot();

    public void currentSnapshot_$eq(Snapshot var1);

    public static /* synthetic */ LogSegment getLogSegmentFrom$(SnapshotManagement $this, Option startingCheckpoint) {
        return $this.getLogSegmentFrom((Option<CheckpointMetaData>)startingCheckpoint);
    }

    default public LogSegment getLogSegmentFrom(Option<CheckpointMetaData> startingCheckpoint) {
        return this.getLogSegmentForVersion((Option<Object>)startingCheckpoint.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.version())), this.getLogSegmentForVersion$default$2());
    }

    public static /* synthetic */ LogSegment getLogSegmentForVersion$(SnapshotManagement $this, Option startCheckpoint, Option versionToLoad) {
        return $this.getLogSegmentForVersion((Option<Object>)startCheckpoint, (Option<Object>)versionToLoad);
    }

    default public LogSegment getLogSegmentForVersion(Option<Object> startCheckpoint, Option<Object> versionToLoad) {
        LogSegment logSegment;
        LogFileMeta[] newFiles = (LogFileMeta[])((DeltaLog)this).logFileHandler().listFilesFrom(FileNames$.MODULE$.checkpointPrefix(((DeltaLog)this).logPath(), BoxesRunTime.unboxToLong((Object)startCheckpoint.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)))).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$2(file))).filterNot((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$3(file))).takeWhile((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)versionToLoad.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)v -> f.version() <= v))).toArray(ClassTag$.MODULE$.apply(LogFileMeta.class));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).isEmpty() && startCheckpoint.isEmpty()) {
            throw DeltaErrors$.MODULE$.emptyDirectoryException(((DeltaLog)this).logPath().toString());
        }
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newFiles)).partition((Function1 & Serializable & scala.Serializable)logFileMeta -> BoxesRunTime.boxToBoolean((boolean)LogFileMeta$.MODULE$.isCheckpointFile(logFileMeta)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LogFileMeta[] checkpoints = (LogFileMeta[])tuple2._1();
        LogFileMeta[] deltas = (LogFileMeta[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)checkpoints, (Object)deltas);
        Tuple2 tuple23 = tuple22;
        LogFileMeta[] checkpoints2 = (LogFileMeta[])tuple23._1();
        LogFileMeta[] deltas2 = (LogFileMeta[])tuple23._2();
        CheckpointInstance lastChkpoint = (CheckpointInstance)versionToLoad.map((Function1 & Serializable & scala.Serializable)x$3 -> SnapshotManagement.$anonfun$getLogSegmentForVersion$7(BoxesRunTime.unboxToLong((Object)x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> CheckpointInstance$.MODULE$.MaxValue());
        CheckpointInstance[] checkpointFiles = (CheckpointInstance[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.asCheckpointInstance(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CheckpointInstance.class)));
        Option<CheckpointInstance> newCheckpoint = ((Checkpoints)((Object)this)).getLatestCompleteCheckpointFromList(checkpointFiles, lastChkpoint);
        if (newCheckpoint.isDefined()) {
            long newCheckpointVersion = ((CheckpointInstance)newCheckpoint.get()).version();
            int newCheckpointCount = BoxesRunTime.unboxToInt((Object)((CheckpointInstance)newCheckpoint.get()).numParts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
            LogFileMeta[] deltasAfterCheckpoint = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).filter((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$11(newCheckpointVersion, file)));
            long[] deltaVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltasAfterCheckpoint)).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            if (new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).nonEmpty()) {
                this.verifyDeltaVersions(deltaVersions);
                Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).head()) == newCheckpointVersion + 1L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Did not get the first delta ").append(new StringBuilder(34).append("file version: ").append(newCheckpointVersion + 1L).append(" to compute Snapshot").toString()).toString());
                versionToLoad.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()) == version, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Did not get the last delta file version: ").append(version).append(" to compute Snapshot").toString()));
            }
            long newVersion = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).lastOption().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> ((CheckpointInstance)newCheckpoint.get()).version()));
            LogFileMeta[] newCheckpointFiles = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)SnapshotManagement.$anonfun$getLogSegmentForVersion$17(newCheckpointVersion, newCheckpointCount, f)));
            Predef$.MODULE$.assert(newCheckpointFiles.length == newCheckpointCount, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Failed in getting the file information for:\n").append(new StringBuilder(6).append(newCheckpointVersion).append(" and ").append(newCheckpointCount).append("\n").toString()).append("among\n").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])checkpoints2)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.fileStatus().getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).mkString(" -", "\n -", "")).toString());
            long lastCommitTimestamp = ((LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).last()).fileStatus().getModificationTime();
            logSegment = new LogSegment(newVersion, (Seq<FileStatus>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltasAfterCheckpoint)).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.fileStatus(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Seq<FileStatus>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newCheckpointFiles)).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.fileStatus(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Option<Object>)newCheckpoint.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.version())), lastCommitTimestamp);
        } else {
            if (startCheckpoint.isDefined()) {
                ((DeltaLogging)((Object)this)).recordDeltaEvent((DeltaLog)this, "delta.checkpoint.error.partial", ((DeltaLogging)((Object)this)).recordDeltaEvent$default$3(), ((DeltaLogging)((Object)this)).recordDeltaEvent$default$4());
                throw DeltaErrors$.MODULE$.missingPartFilesException(BoxesRunTime.unboxToLong((Object)startCheckpoint.get()), new FileNotFoundException(new StringBuilder(45).append("Checkpoint file to load version: ").append(startCheckpoint.get()).append(" is missing.").toString()));
            }
            long[] deltaVersions = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
            this.verifyDeltaVersions(deltaVersions);
            if (BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).head()) != 0L) {
                throw DeltaErrors$.MODULE$.logFileNotFoundException(FileNames$.MODULE$.deltaFile(((DeltaLog)this).logPath(), 0L), BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()), ((DeltaLog)this).metadata());
            }
            versionToLoad.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)version -> Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(deltaVersions)).last()) == version, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Did not get the last delta file version: ").append(version).append(" to compute Snapshot").toString()));
            LogFileMeta latestCommit = (LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).last();
            logSegment = new LogSegment(latestCommit.version(), (Seq<FileStatus>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deltas2)).map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.fileStatus(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), (Seq<FileStatus>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, latestCommit.fileStatus().getModificationTime());
        }
        return logSegment;
    }

    public static /* synthetic */ Option getLogSegmentForVersion$default$2$(SnapshotManagement $this) {
        return $this.getLogSegmentForVersion$default$2();
    }

    default public Option<Object> getLogSegmentForVersion$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Snapshot getSnapshotAtInit$(SnapshotManagement $this) {
        return $this.getSnapshotAtInit();
    }

    /*
     * WARNING - void declaration
     */
    default public Snapshot getSnapshotAtInit() {
        InitialSnapshot initialSnapshot;
        try {
            void var3_3;
            LogSegment segment = this.getLogSegmentFrom(((Checkpoints)((Object)this)).lastCheckpoint());
            Option startCheckpoint = segment.checkpointVersion().map((Function1 & Serializable & scala.Serializable)v -> SnapshotManagement.$anonfun$getSnapshotAtInit$1(BoxesRunTime.unboxToLong((Object)v)));
            ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Loading version ").append(segment.version()).append(startCheckpoint).toString());
            Snapshot snapshot = this.createSnapshot(segment, ((DeltaLog)this).minFileRetentionTimestamp(), segment.lastCommitTimestamp());
            this.lastUpdateTimestamp_$eq(((DeltaLog)this).clock().getTimeMillis());
            ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Returning initial snapshot ").append(snapshot).toString());
            initialSnapshot = var3_3;
        }
        catch (FileNotFoundException e) {
            ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> "Creating initial snapshot without metadata, because the directory is empty");
            initialSnapshot = new InitialSnapshot(((DeltaLog)this).logPath(), (DeltaLog)this, new Metadata(Metadata$.MODULE$.apply$default$1(), Metadata$.MODULE$.apply$default$2(), Metadata$.MODULE$.apply$default$3(), Metadata$.MODULE$.apply$default$4(), Metadata$.MODULE$.apply$default$5(), Metadata$.MODULE$.apply$default$6(), Metadata$.MODULE$.apply$default$7(), Metadata$.MODULE$.apply$default$8()));
        }
        return initialSnapshot;
    }

    public static /* synthetic */ Snapshot snapshot$(SnapshotManagement $this) {
        return $this.snapshot();
    }

    default public Snapshot snapshot() {
        return this.currentSnapshot();
    }

    public static /* synthetic */ Snapshot createSnapshot$(SnapshotManagement $this, LogSegment segment, long minFileRetentionTimestamp, long timestamp) {
        return $this.createSnapshot(segment, minFileRetentionTimestamp, timestamp);
    }

    default public Snapshot createSnapshot(LogSegment segment, long minFileRetentionTimestamp, long timestamp) {
        Option<VersionChecksum> checksumOpt = ((ReadChecksum)((Object)this)).readChecksum(segment.version());
        return new Snapshot(((DeltaLog)this).logPath(), segment.version(), segment, minFileRetentionTimestamp, (DeltaLog)this, timestamp, checksumOpt);
    }

    private boolean isSnapshotStale() {
        long stalenessLimit = BoxesRunTime.unboxToLong((Object)((DeltaLog)this).spark().sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_ASYNC_UPDATE_STALENESS_TIME_LIMIT()));
        return stalenessLimit == 0L || this.lastUpdateTimestamp() < 0L || ((DeltaLog)this).clock().getTimeMillis() - this.lastUpdateTimestamp() >= stalenessLimit;
    }

    public static /* synthetic */ Snapshot update$(SnapshotManagement $this, boolean stalenessAcceptable) {
        return $this.update(stalenessAcceptable);
    }

    default public Snapshot update(boolean stalenessAcceptable) {
        Snapshot snapshot;
        boolean doAsync;
        boolean bl = doAsync = stalenessAcceptable && !this.isSnapshotStale();
        if (!doAsync) {
            snapshot = (Snapshot)((DeltaLog)this).lockInterruptibly((Function0 & Serializable & scala.Serializable)() -> this.updateInternal(false));
        } else {
            if (((DeltaLog)this).asyncUpdateTask() == null || ((DeltaLog)this).asyncUpdateTask().isCompleted()) {
                String jobGroup = ((DeltaLog)this).spark().sparkContext().getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID());
                ((DeltaLog)this).asyncUpdateTask_$eq((Future<BoxedUnit>)Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    ((DeltaLog)this).spark().sparkContext().setLocalProperty("spark.scheduler.pool", "deltaStateUpdatePool");
                    ((DeltaLog)this).spark().sparkContext().setJobGroup(jobGroup, new StringBuilder(33).append("Updating state of Delta table at ").append(this.currentSnapshot().path()).toString(), true);
                    this.tryUpdate(true);
                }, (ExecutionContext)SnapshotManagement$.MODULE$.deltaLogAsyncUpdateThreadPool()));
            }
            snapshot = this.currentSnapshot();
        }
        return snapshot;
    }

    public static /* synthetic */ boolean update$default$1$(SnapshotManagement $this) {
        return $this.update$default$1();
    }

    default public boolean update$default$1() {
        return false;
    }

    private Snapshot tryUpdate(boolean isAsync) {
        Snapshot snapshot;
        if (((DeltaLog)this).deltaLogLock().tryLock()) {
            try {
                snapshot = this.updateInternal(isAsync);
            }
            finally {
                ((DeltaLog)this).deltaLogLock().unlock();
            }
        } else {
            snapshot = this.currentSnapshot();
        }
        return snapshot;
    }

    private boolean tryUpdate$default$1() {
        return false;
    }

    public static /* synthetic */ Snapshot updateInternal$(SnapshotManagement $this, boolean isAsync) {
        return $this.updateInternal(isAsync);
    }

    default public Snapshot updateInternal(boolean isAsync) {
        Snapshot snapshot;
        Object object = new Object();
        try {
            snapshot = (Snapshot)((DeltaLogging)((Object)this)).recordDeltaOperation((DeltaLog)this, "delta.log.update", (Map<TagDefinition, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TagDefinitions$TAG_ASYNC$.MODULE$), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)isAsync)).toString())}))), (Function0 & Serializable & scala.Serializable)() -> (Snapshot)((DeltaProgressReporter)((Object)this)).withStatusCode("DELTA", "Updating the Delta table's state", ((DeltaProgressReporter)((Object)this)).withStatusCode$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                block5: {
                    try {
                        LogSegment segment = this.getLogSegmentForVersion(this.currentSnapshot().logSegment().checkpointVersion(), this.getLogSegmentForVersion$default$2());
                        if (segment.version() == this.currentSnapshot().version()) {
                            this.lastUpdateTimestamp_$eq(((DeltaLog)this).clock().getTimeMillis());
                            throw new NonLocalReturnControl(object, (Object)this.currentSnapshot());
                        }
                        ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Loading version ").append(segment.version()).append(segment.checkpointVersion().map((Function1 & Serializable & scala.Serializable)v -> SnapshotManagement.$anonfun$updateInternal$4(BoxesRunTime.unboxToLong((Object)v)))).toString());
                        Snapshot newSnapshot = this.createSnapshot(segment, ((DeltaLog)this).minFileRetentionTimestamp(), segment.lastCommitTimestamp());
                        if (this.currentSnapshot().version() > -1L) {
                            String string = this.currentSnapshot().metadata().id();
                            String string2 = newSnapshot.metadata().id();
                            if (string == null ? string2 != null : !string.equals(string2)) {
                                String msg = new StringBuilder(57).append("Change in the table id detected while updating snapshot. ").append(new StringBuilder(38).append("\nPrevious snapshot = ").append(this.currentSnapshot()).append("\nNew snapshot = ").append(newSnapshot).append(".").toString()).toString();
                                ((Logging)this).logError((Function0 & Serializable & scala.Serializable)() -> msg);
                                DeltaLog x$1 = (DeltaLog)this;
                                String x$2 = "delta.metadataCheck.update";
                                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prevSnapshotVersion"), (Object)BoxesRunTime.boxToLong((long)this.currentSnapshot().version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"prevSnapshotMetadata"), (Object)this.currentSnapshot().metadata()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nextSnapshotVersion"), (Object)BoxesRunTime.boxToLong((long)newSnapshot.version())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"nextSnapshotMetadata"), (Object)newSnapshot.metadata())}));
                                Map<TagDefinition, String> x$4 = ((DeltaLogging)((Object)this)).recordDeltaEvent$default$3();
                                ((DeltaLogging)((Object)this)).recordDeltaEvent(x$1, x$2, x$4, x$3);
                            }
                        }
                        this.currentSnapshot().uncache();
                        this.currentSnapshot_$eq(newSnapshot);
                        ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Updated snapshot to ").append(newSnapshot).toString());
                    }
                    catch (FileNotFoundException f) {
                        String message = new StringBuilder(42).append("No delta log found for the Delta table at ").append(((DeltaLog)this).logPath()).toString();
                        ((Logging)this).logInfo((Function0 & Serializable & scala.Serializable)() -> message);
                        if (this.currentSnapshot().version() == -1L) break block5;
                        FileNotFoundException e = new FileNotFoundException(message);
                        e.setStackTrace(f.getStackTrace());
                        throw e;
                    }
                }
                this.lastUpdateTimestamp_$eq(((DeltaLog)this).clock().getTimeMillis());
                return this.currentSnapshot();
            }));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                snapshot = (Snapshot)ex.value();
            }
            throw ex;
        }
        return snapshot;
    }

    public static /* synthetic */ Snapshot getSnapshotAt$(SnapshotManagement $this, long version, Option commitTimestamp, Option lastCheckpointHint) {
        return $this.getSnapshotAt(version, (Option<Object>)commitTimestamp, (Option<CheckpointInstance>)lastCheckpointHint);
    }

    default public Snapshot getSnapshotAt(long version, Option<Object> commitTimestamp, Option<CheckpointInstance> lastCheckpointHint) {
        Snapshot current = this.snapshot();
        if (current.version() == version) {
            return current;
        }
        Option startingCheckpoint = lastCheckpointHint.collect((PartialFunction)new scala.Serializable((DeltaLog)this, version){
            public static final long serialVersionUID = 0L;
            private final long version$3;

            public final <A1 extends CheckpointInstance, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = A1.version() <= this.version$3 ? A1 : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(CheckpointInstance x1) {
                CheckpointInstance checkpointInstance = x1;
                boolean bl = checkpointInstance.version() <= this.version$3;
                return bl;
            }
            {
                this.version$3 = version$3;
            }
        }).orElse((Function0 & Serializable & scala.Serializable)() -> ((Checkpoints)((Object)this)).findLastCompleteCheckpoint(new CheckpointInstance(version, (Option<Object>)None$.MODULE$)));
        LogSegment segment = this.getLogSegmentForVersion((Option<Object>)startingCheckpoint.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.version())), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)));
        return this.createSnapshot(segment, ((DeltaLog)this).minFileRetentionTimestamp(), segment.lastCommitTimestamp());
    }

    public static /* synthetic */ Option getSnapshotAt$default$2$(SnapshotManagement $this) {
        return $this.getSnapshotAt$default$2();
    }

    default public Option<Object> getSnapshotAt$default$2() {
        return None$.MODULE$;
    }

    public static /* synthetic */ Option getSnapshotAt$default$3$(SnapshotManagement $this) {
        return $this.getSnapshotAt$default$3();
    }

    default public Option<CheckpointInstance> getSnapshotAt$default$3() {
        return None$.MODULE$;
    }

    public static /* synthetic */ void verifyDeltaVersions$(SnapshotManagement $this, long[] versions) {
        $this.verifyDeltaVersions(versions);
    }

    default public void verifyDeltaVersions(long[] versions) {
        Vector deltaVersions = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(versions)).toVector();
        if (deltaVersions.nonEmpty()) {
            NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)deltaVersions.head()))).to(deltaVersions.last());
            Vector vector = deltaVersions;
            if (inclusive == null ? vector != null : !inclusive.equals(vector)) {
                throw new IllegalStateException(new StringBuilder(30).append("versions (").append(deltaVersions).append(") are not contiguous").toString());
            }
        }
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$2(LogFileMeta file) {
        return LogFileMeta$.MODULE$.isCheckpointFile(file) || LogFileMeta$.MODULE$.isDeltaFile(file);
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$3(LogFileMeta file) {
        return LogFileMeta$.MODULE$.isCheckpointFile(file) && file.fileStatus().getLen() == 0L;
    }

    public static /* synthetic */ CheckpointInstance $anonfun$getLogSegmentForVersion$7(long x$3) {
        return new CheckpointInstance(x$3, (Option<Object>)None$.MODULE$);
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$11(long newCheckpointVersion$1, LogFileMeta file) {
        return file.version() > newCheckpointVersion$1;
    }

    public static /* synthetic */ boolean $anonfun$getLogSegmentForVersion$17(long newCheckpointVersion$1, int newCheckpointCount$1, LogFileMeta f) {
        return f.version() == newCheckpointVersion$1 && BoxesRunTime.unboxToInt((Object)f.numParts().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1)) == newCheckpointCount$1;
    }

    public static /* synthetic */ String $anonfun$getSnapshotAtInit$1(long v) {
        return new StringBuilder(26).append(" starting from checkpoint ").append(v).toString();
    }

    public static /* synthetic */ String $anonfun$updateInternal$4(long v) {
        return new StringBuilder(34).append("starting from checkpoint version ").append(v).append(".").toString();
    }

    public static void $init$(SnapshotManagement $this) {
        $this.lastUpdateTimestamp_$eq(-1L);
        $this.currentSnapshot_$eq($this.getSnapshotAtInit());
    }
}

