/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaVacuumStats;
import org.apache.spark.sql.delta.commands.VacuumCommandImpl;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.SerializableFileStatus;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.SymbolLiteral;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class VacuumCommand$
implements VacuumCommandImpl {
    public static VacuumCommand$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new VacuumCommand$();
    }

    @Override
    public String relativize(Path path, FileSystem fs, Path reservoirBase, boolean isDir) {
        return VacuumCommandImpl.relativize$(this, path, fs, reservoirBase, isDir);
    }

    @Override
    public Iterator<String> getAllSubdirs(String base, String file, FileSystem fs) {
        return VacuumCommandImpl.getAllSubdirs$(this, base, file, fs);
    }

    @Override
    public long delete(Dataset<String> diff, FileSystem fs) {
        return VacuumCommandImpl.delete$(this, diff, fs);
    }

    @Override
    public Path stringToPath(String path) {
        return VacuumCommandImpl.stringToPath$(this, path);
    }

    @Override
    public String pathToString(Path path) {
        return VacuumCommandImpl.pathToString$(this, path);
    }

    @Override
    public Seq<String> allValidFiles(String file, boolean isBloomFiltered) {
        return VacuumCommandImpl.allValidFiles$(this, file, isBloomFiltered);
    }

    @Override
    public Seq<Expression> parsePartitionPredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePartitionPredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void checkRetentionPeriodSafety(SparkSession spark, Option<Object> retentionMs, long configuredRetention) {
        Predef$.MODULE$.require(retentionMs.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> x$1 >= 0L), (Function0 & Serializable & scala.Serializable)() -> "Retention for Vacuum can't be less than 0.");
        boolean checkEnabled = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_VACUUM_RETENTION_CHECK_ENABLED()));
        boolean retentionSafe = retentionMs.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 >= configuredRetention);
        LongRef configuredRetentionHours = LongRef.create((long)TimeUnit.MILLISECONDS.toHours(configuredRetention));
        if (TimeUnit.HOURS.toMillis(configuredRetentionHours.elem) < configuredRetention) {
            ++configuredRetentionHours.elem;
        }
        Predef$.MODULE$.require(!checkEnabled || retentionSafe, (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(578).append("Are you sure you would like to vacuum files with such a low retention period? If you have\n        |writers that are currently writing to this table, there is a risk that you may corrupt the\n        |state of your Delta table.\n        |\n        |If you are certain that there are no operations being performed on this table, such as\n        |insert/upsert/delete/optimize, then you may turn off this check by setting:\n        |spark.databricks.delta.retentionDurationCheck.enabled = false\n        |\n        |If you are not sure, please use a value not less than \"").append(configuredRetentionHours$1.elem).append(" hours\".\n       ").toString())).stripMargin());
    }

    public Dataset<Row> gc(SparkSession spark, DeltaLog deltaLog, boolean dryRun, Option<Object> retentionHours, Clock clock) {
        Dataset dataset;
        Object object = new Object();
        try {
            dataset = (Dataset)this.recordDeltaOperation(deltaLog, "delta.gc", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
                Dataset dataset;
                Path path = deltaLog.dataPath();
                Configuration sessionHadoopConf = spark.sessionState().newHadoopConf();
                FileSystem fs = path.getFileSystem(sessionHadoopConf);
                Snapshot snapshot = deltaLog.update(deltaLog.update$default$1());
                Predef$.MODULE$.require(snapshot.version() >= 0L, (Function0 & Serializable & scala.Serializable)() -> "No state defined for this table. Is this really a Delta table? Refusing to garbage collect.");
                Option retentionMillis = retentionHours.map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)h -> TimeUnit.HOURS.toMillis(scala.math.package$.MODULE$.round(h)));
                MODULE$.checkRetentionPeriodSafety(spark, (Option<Object>)retentionMillis, deltaLog.tombstoneRetentionMillis());
                long deleteBeforeTimestamp = BoxesRunTime.unboxToLong((Object)retentionMillis.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)millis -> clock.getTimeMillis() - millis).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> deltaLog.minFileRetentionTimestamp()));
                MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Starting garbage collection (dryRun = ").append(dryRun).append(") of untracked files older than ").append(new StringBuilder(4).append(new Date(deleteBeforeTimestamp).toGMTString()).append(" in ").append(path).toString()).toString());
                Broadcast hadoopConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(sessionHadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
                String basePath = fs.makeQualified(path).toString();
                BooleanRef isBloomFiltered = BooleanRef.create((boolean)false);
                Dataset validFiles = snapshot.state().mapPartitions((Function1 & Serializable & scala.Serializable)actions -> {
                    Path reservoirBase = new Path(basePath);
                    FileSystem fs = reservoirBase.getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
                    return actions.flatMap((Function1 & Serializable & scala.Serializable)x$3 -> {
                        Nil$ nil$;
                        RemoveFile removeFile;
                        Action action = x$3.unwrap();
                        if (action instanceof RemoveFile && (removeFile = (RemoveFile)action).delTimestamp() < deleteBeforeTimestamp) {
                            nil$ = Nil$.MODULE$;
                        } else if (action instanceof FileAction) {
                            Path maybeRelative;
                            FileAction fileAction = (FileAction)action;
                            Path filePath = MODULE$.stringToPath(fileAction.path());
                            Option validFileOpt = filePath.isAbsolute() ? ((maybeRelative = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, reservoirBase, filePath)).isAbsolute() ? None$.MODULE$ : Option$.MODULE$.apply((Object)MODULE$.pathToString(maybeRelative))) : Option$.MODULE$.apply((Object)MODULE$.pathToString(filePath));
                            nil$ = (Seq)Option$.MODULE$.option2Iterable(validFileOpt).toSeq().flatMap((Function1 & Serializable & scala.Serializable)f -> (Seq)MODULE$.allValidFiles((String)f, isBloomFiltered$1.elem).flatMap((Function1 & Serializable & scala.Serializable)file -> {
                                Iterator<String> dirs = MODULE$.getAllSubdirs("/", (String)file, fs);
                                return dirs.$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{file})));
                            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                        } else {
                            nil$ = Nil$.MODULE$;
                        }
                        return nil$;
                    });
                }, spark.implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"}));
                String[] partitionColumns = snapshot.metadata().partitionSchema().fieldNames();
                int parallelism = spark.sessionState().conf().parallelPartitionDiscoveryParallelism();
                Dataset<SerializableFileStatus> allFilesAndDirs = DeltaFileOperations$.MODULE$.recursiveListDirs(spark, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{basePath}))), (Broadcast<SerializableConfiguration>)hadoopConf, (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableUtils$.MODULE$.isHiddenDirectory((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])partitionColumns), x$4)), (Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)parallelism)));
                try {
                    allFilesAndDirs.cache();
                    long dirCounts = allFilesAndDirs.where((Column)spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "isDir"))).count() + 1L;
                    Dataset diff = allFilesAndDirs.where(spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "modificationTime")).$less((Object)BoxesRunTime.boxToLong((long)deleteBeforeTimestamp)).$bar$bar((Object)SymbolLiteral.bootstrap("apply", "isDir"))).mapPartitions((Function1 & Serializable & scala.Serializable)fileStatusIterator -> {
                        Path reservoirBase = new Path(basePath);
                        FileSystem fs = reservoirBase.getFileSystem(((SerializableConfiguration)hadoopConf.value()).value());
                        return fileStatusIterator.flatMap((Function1 & Serializable & scala.Serializable)fileStatus -> {
                            Iterator iterator;
                            if (fileStatus.isDir()) {
                                iterator = package$.MODULE$.Iterator().single((Object)MODULE$.relativize(fileStatus.getPath(), fs, reservoirBase, true));
                            } else {
                                Iterator<String> dirs = MODULE$.getAllSubdirs(basePath, fileStatus.path(), fs);
                                Iterator dirsWithSlash = dirs.map((Function1 & Serializable & scala.Serializable)p -> MODULE$.relativize(new Path(p), fs, reservoirBase, true));
                                iterator = dirsWithSlash.$plus$plus((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.relativize(new Path(fileStatus.path()), fs, reservoirBase, false)})));
                            }
                            return iterator;
                        });
                    }, spark.implicits().newStringEncoder()).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq)Nil$.MODULE$).as((Symbol)SymbolLiteral.bootstrap("apply", "path"))})).count().join(validFiles, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"})), "leftanti").where(spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "count")).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)1))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "path"))})).as(spark.implicits().newStringEncoder()).map((Function1 & Serializable & scala.Serializable)relativePath -> {
                        Predef$.MODULE$.assert(!MODULE$.stringToPath((String)relativePath).isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> "Shouldn't have any absolute paths for deletion here.");
                        return MODULE$.pathToString(DeltaFileOperations$.MODULE$.absolutePath(basePath, (String)relativePath));
                    }, spark.implicits().newStringEncoder());
                    if (dryRun) {
                        long numFiles = diff.count();
                        DeltaVacuumStats stats = new DeltaVacuumStats(true, (Option<Object>)retentionMillis, deltaLog.tombstoneRetentionMillis(), deleteBeforeTimestamp, dirCounts, numFiles);
                        DeltaLog x$1 = deltaLog;
                        String x$2 = "delta.gc.stats";
                        DeltaVacuumStats x$3 = stats;
                        Map<TagDefinition, String> x$42 = MODULE$.recordDeltaEvent$default$3();
                        MODULE$.recordDeltaEvent(x$1, x$2, x$42, x$3);
                        MODULE$.logConsole(new StringBuilder(43).append("Found ").append(numFiles).append(" files and directories in a total of ").append(new StringBuilder(37).append(dirCounts).append(" directories that are safe to delete.").toString()).toString());
                        throw new NonLocalReturnControl(object, (Object)diff.map((Function1 & Serializable & scala.Serializable)f -> MODULE$.stringToPath((String)f).toString(), spark.implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"})));
                    }
                    MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Deleting untracked files and empty directories in ").append(path).toString());
                    long filesDeleted = MODULE$.delete((Dataset<String>)diff, fs);
                    DeltaVacuumStats stats = new DeltaVacuumStats(false, (Option<Object>)retentionMillis, deltaLog.tombstoneRetentionMillis(), deleteBeforeTimestamp, dirCounts, filesDeleted);
                    DeltaLog x$5 = deltaLog;
                    String x$6 = "delta.gc.stats";
                    DeltaVacuumStats x$7 = stats;
                    Map<TagDefinition, String> x$8 = MODULE$.recordDeltaEvent$default$3();
                    MODULE$.recordDeltaEvent(x$5, x$6, x$8, x$7);
                    MODULE$.logConsole(new StringBuilder(42).append("Deleted ").append(filesDeleted).append(" files and directories in a total ").append(new StringBuilder(16).append("of ").append(dirCounts).append(" directories.").toString()).toString());
                    dataset = spark.createDataset((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{basePath})), spark.implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"path"}));
                }
                finally {
                    allFilesAndDirs.unpersist();
                }
                return dataset;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                dataset = (Dataset)ex.value();
            }
            throw ex;
        }
        return dataset;
    }

    public boolean gc$default$3() {
        return true;
    }

    public Option<Object> gc$default$4() {
        return None$.MODULE$;
    }

    public Clock gc$default$5() {
        return new SystemClock();
    }

    private VacuumCommand$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        VacuumCommandImpl.$init$(this);
    }
}

