/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055d!\u0002\n\u0014\u0003\u0003\u0001\u0003\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011A\u0018\t\u0011Q\u0002!\u0011!Q\u0001\nAB\u0001\"\u000e\u0001\u0003\u0006\u0004%\tA\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005o!AA\b\u0001BC\u0002\u0013\u0005Q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003?\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015\t\u0007A\"\u0001c\u0011\u001da\b!%A\u0005\u0002uDq!!\u0005\u0001\t\u0003\n\u0019\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005E\u0002\u0001\"\u0005\u00024!9\u0011\u0011\n\u0001\u0005B\u0005-\u0003bBA'\u0001\u0011%\u0011q\n\u0005\b\u0003?\u0002A\u0011AA1\u00059!\u0016\r[8f\r&dW-\u00138eKbT!\u0001F\u000b\u0002\u000b\u0019LG.Z:\u000b\u0005Y9\u0012!\u00023fYR\f'B\u0001\r\u001a\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0012aA8sO\u000e\u00011c\u0001\u0001\"OA\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t1\u0011I\\=SK\u001a\u0004\"\u0001K\u0017\u000e\u0003%R!AK\u0016\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003Y]\t\u0011\"\u001a=fGV$\u0018n\u001c8\n\u00059J#!\u0003$jY\u0016Le\u000eZ3y+\u0005\u0001\u0004CA\u00193\u001b\u00059\u0012BA\u001a\u0018\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019\u0019\b/\u0019:lA\u0005AA-\u001a7uC2{w-F\u00018!\tA\u0014(D\u0001\u0016\u0013\tQTC\u0001\u0005EK2$\u0018\rT8h\u0003%!W\r\u001c;b\u0019><\u0007%\u0001\u0003qCRDW#\u0001 \u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015A\u00014t\u0015\t\u00195$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u000b\u0002\u0013A\u0001U1uQ\u0006)\u0001/\u0019;iA\u00051A(\u001b8jiz\"B!S&M\u001bB\u0011!\nA\u0007\u0002'!)!d\u0002a\u0001a!)Qg\u0002a\u0001o!)Ah\u0002a\u0001}\u0005aA/\u00192mKZ+'o]5p]V\t\u0001\u000b\u0005\u0002##&\u0011!k\t\u0002\u0005\u0019>tw-A\u0005s_>$\b+\u0019;igV\tQ\u000bE\u0002W=zr!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005i{\u0012A\u0002\u001fs_>$h(C\u0001%\u0013\ti6%A\u0004qC\u000e\\\u0017mZ3\n\u0005}\u0003'aA*fc*\u0011QlI\u0001\u000e[\u0006$8\r[5oO\u001aKG.Z:\u0015\t\rTWo\u001e\t\u0004-z#\u0007CA3i\u001b\u00051'BA4\u0016\u0003\u001d\t7\r^5p]NL!!\u001b4\u0003\u000f\u0005#GMR5mK\")1N\u0003a\u0001Y\u0006\u0001\u0002/\u0019:uSRLwN\u001c$jYR,'o\u001d\t\u0004-zk\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005I<\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005Q|'AC#yaJ,7o]5p]\")aO\u0003a\u0001Y\u0006YA-\u0019;b\r&dG/\u001a:t\u0011\u001dA(\u0002%AA\u0002e\f\u0011b[3faN#\u0018\r^:\u0011\u0005\tR\u0018BA>$\u0005\u001d\u0011un\u001c7fC:\fq#\\1uG\"Lgn\u001a$jY\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003yT#!_@,\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u001bi!!!\u0002\u000b\t\u0005\u001d\u0011\u0011B\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0003$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\t)AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011\u0002\\5ti\u001aKG.Z:\u0015\r\u0005U\u0011QDA\u0010!\u00111f,a\u0006\u0011\u0007!\nI\"C\u0002\u0002\u001c%\u0012!\u0003U1si&$\u0018n\u001c8ESJ,7\r^8ss\")1\u000e\u0004a\u0001Y\")a\u000f\u0004a\u0001Y\u0006y\u0001/\u0019:uSRLwN\\*dQ\u0016l\u0017-\u0006\u0002\u0002&A!\u0011qEA\u0017\u001b\t\tICC\u0002\u0002,]\tQ\u0001^=qKNLA!a\f\u0002*\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019\u0005\u00147o\u001c7vi\u0016\u0004\u0016\r\u001e5\u0015\u0007y\n)\u0004C\u0004\u000289\u0001\r!!\u000f\u0002\u000b\rD\u0017\u000e\u001c3\u0011\t\u0005m\u00121\t\b\u0005\u0003{\ty\u0004\u0005\u0002YG%\u0019\u0011\u0011I\u0012\u0002\rA\u0013X\rZ3g\u0013\u0011\t)%a\u0012\u0003\rM#(/\u001b8h\u0015\r\t\teI\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011H\u0001\u000eiJ,hnY1uKJKw\r\u001b;\u0015\r\u0005e\u0012\u0011KA+\u0011\u001d\t\u0019\u0006\u0005a\u0001\u0003s\tQ!\u001b8qkRDq!a\u0016\u0011\u0001\u0004\tI&A\u0002mK:\u00042AIA.\u0013\r\tif\t\u0002\u0004\u0013:$\u0018aC4fi\n\u000b7/\u001a)bi\"$B!a\u0019\u0002jA!!%!\u001a?\u0013\r\t9g\t\u0002\u0007\u001fB$\u0018n\u001c8\t\r\u0005-\u0014\u00031\u0001?\u0003!1\u0017\u000e\\3QCRD\u0007")
public abstract class TahoeFileIndex
implements FileIndex {
    private final SparkSession spark;
    private final DeltaLog deltaLog;
    private final Path path;

    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$((FileIndex)this);
    }

    public SparkSession spark() {
        return this.spark;
    }

    public DeltaLog deltaLog() {
        return this.deltaLog;
    }

    public Path path() {
        return this.path;
    }

    public long tableVersion() {
        return this.deltaLog().snapshot().version();
    }

    public Seq<Path> rootPaths() {
        Path path = this.path();
        return Nil$.MODULE$.$colon$colon((Object)path);
    }

    public abstract Seq<AddFile> matchingFiles(Seq<Expression> var1, Seq<Expression> var2, boolean var3);

    public boolean matchingFiles$default$3() {
        return false;
    }

    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        String timeZone = this.spark().sessionState().conf().sessionLocalTimeZone();
        return ((TraversableOnce)this.matchingFiles(partitionFilters, dataFilters, this.matchingFiles$default$3()).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.partitionValues()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map partitionValues = (Map)tuple2._1();
            Seq files = (Seq)tuple2._2();
            Object[] rowValues = (Object[])((TraversableOnce)this.partitionSchema().map((Function1 & Serializable & scala.Serializable)p -> {
                Cast qual$1 = new Cast((Expression)Literal$.MODULE$.apply(partitionValues.apply((Object)p.name())), p.dataType(), Option$.MODULE$.apply((Object)timeZone));
                InternalRow x$1 = qual$1.eval$default$1();
                return qual$1.eval(x$1);
            }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            FileStatus[] fileStats = (FileStatus[])((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> new FileStatus(f.size(), false, 0, 1L, f.modificationTime(), this.absolutePath(f.path())), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
            PartitionDirectory partitionDirectory = new PartitionDirectory((InternalRow)new GenericInternalRow(rowValues), (Seq)Predef$.MODULE$.wrapRefArray((Object[])fileStats));
            return partitionDirectory;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public StructType partitionSchema() {
        return this.deltaLog().snapshot().metadata().partitionSchema();
    }

    public Path absolutePath(String child) {
        Path p = new Path(new URI(child));
        return p.isAbsolute() ? p : new Path(this.path(), p);
    }

    public String toString() {
        String truncatedPath = this.truncateRight(this.path().toString(), 100);
        return new StringBuilder(17).append("Delta[version=").append(this.tableVersion()).append(", ").append(truncatedPath).append("]").toString();
    }

    private String truncateRight(String input, int len) {
        return input.length() > len ? new StringBuilder(4).append("... ").append(new StringOps(Predef$.MODULE$.augmentString(input)).takeRight(len)).toString() : input;
    }

    public Option<Path> getBasePath(Path filePath) {
        return new Some((Object)this.path());
    }

    public TahoeFileIndex(SparkSession spark, DeltaLog deltaLog, Path path) {
        this.spark = spark;
        this.deltaLog = deltaLog;
        this.path = path;
        FileIndex.$init$((FileIndex)this);
    }
}

