/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.LogFileMetaParser;
import org.apache.spark.sql.delta.LogFileMetaParser$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.SerializableFileStatus;
import org.apache.spark.sql.delta.util.SerializableFileStatus$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import scala.util.control.NonFatal$;

public final class DeltaFileOperations$
implements DeltaLogging {
    public static DeltaFileOperations$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DeltaFileOperations$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Path absolutePath(String basePath, String child) {
        Path path;
        Path p = new Path(new URI(child));
        if (p.isAbsolute()) {
            path = p;
        } else {
            Path merged = new Path(basePath, p);
            String mergedUri = merged.toUri().toString();
            path = child.endsWith("/") && !mergedUri.endsWith("/") ? new Path(new URI(new StringBuilder(1).append(mergedUri).append("/").toString())) : merged;
        }
        return path;
    }

    public Path tryRelativizePath(FileSystem fs, Path basePath, Path child) {
        Path path;
        URI childUri = child.toUri();
        if (child.isAbsolute()) {
            try {
                path = new Path(fs.makeQualified(basePath).toUri().relativize(fs.makeQualified(child).toUri()));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(422).append("Failed to relativize the path (").append(child).append("). This can happen when absolute paths make\n               |it into the transaction log, which start with the scheme s3://, wasbs:// or adls://.\n               |This is a bug that has existed before DBR 5.0. To fix this issue, please upgrade\n               |your writer jobs to DBR 5.0 and please run:\n               |%scala com.databricks.delta.Delta.fixAbsolutePathsInLog(\"").append(child).append("\")\n             ").toString())).stripMargin());
            }
        } else {
            path = child;
        }
        return path;
    }

    private boolean isThrottlingError(Throwable t) {
        return Option$.MODULE$.apply((Object)t.getMessage()).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.$anonfun$isThrottlingError$1(x$1)));
    }

    private void randomBackoff(String opName, Throwable t, int base, int jitter) {
        int sleepTime = Random$.MODULE$.nextInt(jitter) + base;
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sleeping for ").append(sleepTime).append(" ms to rate limit ").append(opName).toString(), t);
        Thread.sleep(sleepTime);
    }

    private int randomBackoff$default$3() {
        return 100;
    }

    private int randomBackoff$default$4() {
        return 1000;
    }

    private Iterator<SerializableFileStatus> listUsingLogStore(LogFileMetaParser logStore, Iterator<String> subDirs, boolean recurse, Function1<String, Object> hiddenFileNameFilter) {
        Iterator<SerializableFileStatus> filesAndDirs = subDirs.flatMap((Function1 & Serializable & scala.Serializable)dir -> this.list$1((String)dir, 10, logStore, (Function1)hiddenFileNameFilter));
        return recurse ? this.recurseDirectories(logStore, filesAndDirs, hiddenFileNameFilter) : filesAndDirs;
    }

    private Iterator<SerializableFileStatus> recurseDirectories(LogFileMetaParser logStore, Iterator<SerializableFileStatus> filesAndDirs, Function1<String, Object> hiddenFileNameFilter) {
        return filesAndDirs.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SerializableFileStatus serializableFileStatus;
            SerializableFileStatus serializableFileStatus2 = x0$1;
            Iterator iterator = serializableFileStatus2 != null && (serializableFileStatus = serializableFileStatus2).isDir() ? package$.MODULE$.Iterator().single((Object)serializableFileStatus).$plus$plus((Function0 & Serializable & scala.Serializable)() -> MODULE$.listUsingLogStore(logStore, (Iterator<String>)package$.MODULE$.Iterator().single((Object)serializableFileStatus.path()), true, hiddenFileNameFilter)) : package$.MODULE$.Iterator().single((Object)serializableFileStatus2);
            return iterator;
        });
    }

    public boolean defaultHiddenFileFilter(String fileName) {
        return fileName.startsWith("_") || fileName.startsWith(".");
    }

    public Dataset<SerializableFileStatus> recursiveListDirs(SparkSession spark, Seq<String> subDirs, Broadcast<SerializableConfiguration> hadoopConf, Function1<String, Object> hiddenFileNameFilter, Option<Object> fileListingParallelism) {
        if (subDirs.isEmpty()) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.sql.delta.util.SerializableFileStatus").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator4$1() {
                }
            }
            return spark.emptyDataset(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator4$1())));
        }
        int listParallelism = BoxesRunTime.unboxToInt((Object)fileListingParallelism.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> spark.sparkContext().defaultParallelism()));
        RDD qual$1 = spark.sparkContext().parallelize(subDirs, spark.sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(String.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)dirs -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), ((SerializableConfiguration)hadoopConf.value()).value());
            LogFileMetaParser logFileHandler = LogFileMetaParser$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), ((SerializableConfiguration)hadoopConf.value()).value(), logStore);
            return MODULE$.listUsingLogStore(logFileHandler, (Iterator<String>)dirs, false, hiddenFileNameFilter);
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD qual$2 = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        int x$3 = listParallelism;
        Ordering x$4 = qual$2.repartition$default$2(x$3);
        RDD dirsAndFiles = qual$2.repartition(x$3, x$4);
        RDD allDirsAndFiles = dirsAndFiles.mapPartitions((Function1 & Serializable & scala.Serializable)firstLevelDirsAndFiles -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), ((SerializableConfiguration)hadoopConf.value()).value());
            LogFileMetaParser logFileHandler = LogFileMetaParser$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), ((SerializableConfiguration)hadoopConf.value()).value(), logStore);
            return MODULE$.recurseDirectories(logFileHandler, (Iterator<SerializableFileStatus>)firstLevelDirsAndFiles, hiddenFileNameFilter);
        }, dirsAndFiles.mapPartitions$default$2(), ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.util.SerializableFileStatus").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator5$1() {
            }
        }
        return spark.createDataset(allDirsAndFiles, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_util_DeltaFileOperations$$typecreator5$1())));
    }

    public Function1<String, Object> recursiveListDirs$default$4() {
        return (Function1 & Serializable & scala.Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(fileName));
    }

    public Option<Object> recursiveListDirs$default$5() {
        return None$.MODULE$;
    }

    public boolean tryDeleteNonRecursive(FileSystem fs, Path path, int tries) {
        boolean bl;
        try {
            bl = fs.delete(path, false);
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileNotFoundException) {
                bl2 = true;
            } else if (throwable2 instanceof IOException) {
                bl2 = false;
            } else {
                Throwable e;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty() && this.isThrottlingError(e = (Throwable)option.get()) && tries > 0) {
                    this.randomBackoff("deletes", e, this.randomBackoff$default$3(), this.randomBackoff$default$4());
                    bl2 = this.tryDeleteNonRecursive(fs, path, tries - 1);
                } else {
                    throw throwable;
                }
            }
            bl = bl2;
        }
        return bl;
    }

    public int tryDeleteNonRecursive$default$3() {
        return 3;
    }

    public Tuple2<Iterator<String>, String> getAllSubDirectories(String base, String path) {
        String[] baseSplits = base.split("/");
        String[] pathSplits = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).drop(baseSplits.length);
        Iterator it = package$.MODULE$.Iterator().tabulate(pathSplits.length - 1, (Function1 & Serializable & scala.Serializable)i -> DeltaFileOperations$.$anonfun$getAllSubDirectories$1(baseSplits, pathSplits, BoxesRunTime.unboxToInt((Object)i)));
        return new Tuple2((Object)it, (Object)path);
    }

    public void registerTempFileDeletionTaskFailureListener(Configuration conf, Path tempPath) {
        TaskContext tc = TaskContext$.MODULE$.get();
        if (tc == null) {
            throw new IllegalStateException("Not running on a Spark task thread");
        }
        tc.addTaskFailureListener((Function2 & Serializable & scala.Serializable)(x$2, x$3) -> {
            DeltaFileOperations$.$anonfun$registerTempFileDeletionTaskFailureListener$1(tempPath, conf, x$2, x$3);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<Footer> readParquetFootersInParallel(Configuration conf, Seq<FileStatus> partFiles, boolean ignoreCorruptFiles) {
        return (Seq)((GenericTraversableTemplate)ThreadUtils$.MODULE$.parmap(partFiles, "readingParquetFooters", 8, (Function1 & Serializable & scala.Serializable)currentFile -> {
            Some some;
            try {
                some = new Some((Object)new Footer(currentFile.getPath(), ParquetFileReader.readFooter((Configuration)conf, (FileStatus)currentFile, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS)));
            }
            catch (RuntimeException e) {
                if (ignoreCorruptFiles) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(currentFile).toString(), e);
                    some = None$.MODULE$;
                }
                throw new IOException(new StringBuilder(32).append("Could not read footer for file: ").append(currentFile).toString(), e);
            }
            return some;
        }, Seq$.MODULE$.canBuildFrom(), Seq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
    }

    public static final /* synthetic */ boolean $anonfun$isThrottlingError$1(String x$1) {
        return x$1.toLowerCase(Locale.ROOT).contains("slow down");
    }

    public static final /* synthetic */ boolean $anonfun$listUsingLogStore$2(Function1 hiddenFileNameFilter$1, LogFileMeta f) {
        return BoxesRunTime.unboxToBoolean((Object)hiddenFileNameFilter$1.apply((Object)f.fileStatus().getPath().getName()));
    }

    private final Iterator list$1(String dir, int tries, LogFileMetaParser logStore$1, Function1 hiddenFileNameFilter$1) {
        Iterator iterator;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Listing ").append(dir).toString());
        try {
            iterator = logStore$1.listFilesFrom(new Path(dir, "\u0000")).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaFileOperations$.$anonfun$listUsingLogStore$2(hiddenFileNameFilter$1, f))).map((Function1 & Serializable & scala.Serializable)f -> SerializableFileStatus$.MODULE$.fromStatus(f.fileStatus()));
        }
        catch (Throwable throwable) {
            Iterator iterator2;
            Throwable e;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty() && this.isThrottlingError(e = (Throwable)option.get()) && tries > 0) {
                this.randomBackoff("listing", e, this.randomBackoff$default$3(), this.randomBackoff$default$4());
                iterator2 = this.list$1(dir, tries - 1, logStore$1, hiddenFileNameFilter$1);
            } else if (throwable2 instanceof FileNotFoundException) {
                iterator2 = package$.MODULE$.Iterator().empty();
            } else {
                throw throwable;
            }
            iterator = iterator2;
        }
        return iterator;
    }

    public static final /* synthetic */ String $anonfun$getAllSubDirectories$1(String[] baseSplits$1, String[] pathSplits$1, int i) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])baseSplits$1)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pathSplits$1)).take(i + 1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("/");
    }

    public static final /* synthetic */ void $anonfun$registerTempFileDeletionTaskFailureListener$1(Path tempPath$1, Configuration conf$1, TaskContext x$2, Throwable x$3) {
        Boolean bl;
        try {
            bl = BoxesRunTime.boxToBoolean((boolean)tempPath$1.getFileSystem(conf$1).delete(tempPath$1, false));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Failed to delete ").append(tempPath$1).toString(), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            bl = boxedUnit;
        }
    }

    private DeltaFileOperations$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }
}

