/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.deltalake;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.DeltaFileType;
import org.apache.spark.sql.delta.DeltaFileType$CHECKPOINT$;
import org.apache.spark.sql.delta.DeltaFileType$CHECKSUM$;
import org.apache.spark.sql.delta.DeltaFileType$DELTA$;
import org.apache.spark.sql.delta.DeltaFileType$UNKNOWN$;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.projectnessie.client.NessieClient;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001\u0002\u0017.\u0001QB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005+\")Q\f\u0001C\u0001=\"91\r\u0001b\u0001\n\u0003!\u0007BB8\u0001A\u0003%Q\rC\u0004q\u0001\t\u0007I\u0011\u00013\t\rE\u0004\u0001\u0015!\u0003f\u0011\u001d\u0011\bA1A\u0005\u0002\u0011Daa\u001d\u0001!\u0002\u0013)\u0007b\u0002;\u0001\u0001\u0004%\t!\u001e\u0005\n\u0003\u0013\u0001\u0001\u0019!C\u0001\u0003\u0017Aq!a\u0006\u0001A\u0003&a\u000fC\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003\u0002\u001c!A\u0011q\u0005\u0001!\u0002\u0013\ti\u0002C\u0004\u0002*\u0001!I!a\u000b\t\u0013\u0005e\u0002\u00011A\u0005\n\u0005m\u0002\"CA\u001f\u0001\u0001\u0007I\u0011BA \u0011!\t\u0019\u0005\u0001Q!\n\u00055\u0002bBA#\u0001\u0011\u0005\u0013q\t\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\ti\b\u0001C!\u0003\u007fB\u0011\"a%\u0001#\u0003%\t!!&\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\"I\u0011q\u0018\u0001\u0012\u0002\u0013%\u0011\u0011\u0019\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\ty\u000e\u0001C\u0005\u0003CDq!!<\u0001\t\u0013\ty\u000fC\u0005\u0003\u0002\u0001\t\n\u0011\"\u0003\u0002B\"I!1\u0001\u0001\u0012\u0002\u0013%\u0011\u0011\u0019\u0005\b\u0005\u000b\u0001A\u0011\u0003B\u0004\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'AqA!\u0005\u0001\t\u0003\u0011i\u0002C\u0004\u0003\"\u0001!\tAa\t\t\u000f\t=\u0002\u0001\"\u0001\u00032!9!Q\b\u0001\u0005\u0002\t}\u0002b\u0002B&\u0001\u0011\u0005!Q\n\u0005\b\u0005#\u0002A\u0011\u0001B*\u0011\u001d\u0011I\u0006\u0001C\u0005\u00057BqA!\u001a\u0001\t\u0013\u00119\u0007C\u0004\u0003r\u0001!\tEa\u001d\t\u000f\t]\u0004\u0001\"\u0011\u0003z!9!1\u0010\u0001\u0005B\tu\u0004b\u0002BA\u0001\u0011\u0005#1\u0011\u0002\u000f\u001d\u0016\u001c8/[3M_\u001e\u001cFo\u001c:f\u0015\tqs&A\u0005eK2$\u0018\r\\1lK*\u0011\u0001'M\u0001\u000eaJ|'.Z2u]\u0016\u001c8/[3\u000b\u0003I\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u001b<\u0013B\u0011a'O\u0007\u0002o)\t\u0001(A\u0003tG\u0006d\u0017-\u0003\u0002;o\t1\u0011I\\=SK\u001a\u0004\"\u0001P$\u000e\u0003uR!AP \u0002\u000fM$xN]1hK*\u0011\u0001)Q\u0001\u0006I\u0016dG/\u0019\u0006\u0003\u0005\u000e\u000b1a]9m\u0015\t!U)A\u0003ta\u0006\u00148N\u0003\u0002Gc\u00051\u0011\r]1dQ\u0016L!\u0001S\u001f\u0003\u00111{wm\u0015;pe\u0016\u0004\"AS'\u000e\u0003-S!\u0001T\"\u0002\u0011%tG/\u001a:oC2L!AT&\u0003\u000f1{wmZ5oO\u0006I1\u000f]1sW\u000e{gN\u001a\t\u0003#Jk\u0011aQ\u0005\u0003'\u000e\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0002W76\tqK\u0003\u0002Y3\u0006!1m\u001c8g\u0015\tQV)\u0001\u0004iC\u0012|w\u000e]\u0005\u00039^\u0013QbQ8oM&<WO]1uS>t\u0017A\u0002\u001fj]&$h\bF\u0002`C\n\u0004\"\u0001\u0019\u0001\u000e\u00035BQaT\u0002A\u0002ACQ\u0001V\u0002A\u0002U\u000b\u0001\u0003Z3mi\u00064\u0015\u000e\\3QCR$XM\u001d8\u0016\u0003\u0015\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u000bI,w-\u001a=\u000b\u0005)\\\u0017\u0001B;uS2T\u0011\u0001\\\u0001\u0005U\u00064\u0018-\u0003\u0002oO\n9\u0001+\u0019;uKJt\u0017!\u00053fYR\fg)\u001b7f!\u0006$H/\u001a:oA\u0005\u00192\r[3dWN,XNR5mKB\u000bG\u000f^3s]\u0006!2\r[3dWN,XNR5mKB\u000bG\u000f^3s]\u0002\nQc\u00195fG.\u0004x.\u001b8u\r&dW\rU1ui\u0016\u0014h.\u0001\fdQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3QCR$XM\u001d8!\u0003Aa\u0017m\u001d;T]\u0006\u00048\u000f[8u+VLG-F\u0001w!\r1t/_\u0005\u0003q^\u0012aa\u00149uS>t\u0007c\u0001>\u0002\u00049\u00111p \t\u0003y^j\u0011! \u0006\u0003}N\na\u0001\u0010:p_Rt\u0014bAA\u0001o\u00051\u0001K]3eK\u001aLA!!\u0002\u0002\b\t11\u000b\u001e:j]\u001eT1!!\u00018\u0003Qa\u0017m\u001d;T]\u0006\u00048\u000f[8u+VLGm\u0018\u0013fcR!\u0011QBA\n!\r1\u0014qB\u0005\u0004\u0003#9$\u0001B+oSRD\u0001\"!\u0006\f\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014!\u00057bgR\u001cf.\u00199tQ>$X+^5eA\u000511\r\\5f]R,\"!!\b\u0011\t\u0005}\u00111E\u0007\u0003\u0003CQ1!!\u00070\u0013\u0011\t)#!\t\u0003\u00199+7o]5f\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u0005Yq-\u001a;Pe\u000e\u0013X-\u0019;f)\t\ti\u0003\u0005\u0003\u00020\u0005URBAA\u0019\u0015\r\t\u0019dL\u0001\u0006[>$W\r\\\u0005\u0005\u0003o\t\tDA\u0005SK\u001a,'/\u001a8dK\u0006I!/\u001a4fe\u0016t7-Z\u000b\u0003\u0003[\tQB]3gKJ,gnY3`I\u0015\fH\u0003BA\u0007\u0003\u0003B\u0011\"!\u0006\u0012\u0003\u0003\u0005\r!!\f\u0002\u0015I,g-\u001a:f]\u000e,\u0007%\u0001\u0005mSN$hI]8n)\u0011\tI%a\u001a\u0011\r\u0005-\u0013QKA.\u001d\u0011\ti%!\u0015\u000f\u0007q\fy%C\u00019\u0013\r\t\u0019fN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9&!\u0017\u0003\u0011%#XM]1u_JT1!a\u00158!\u0011\ti&a\u0019\u000e\u0005\u0005}#bAA13\u0006\u0011am]\u0005\u0005\u0003K\nyF\u0001\u0006GS2,7\u000b^1ukNDq!!\u001b\u0014\u0001\u0004\tY'\u0001\u0003qCRD\u0007\u0003BA/\u0003[JA!a\u001c\u0002`\t!\u0001+\u0019;i\u0003Q\u0001\u0018M]:f)\u0006\u0014G.Z%eK:$\u0018NZ5feR!\u0011QOA>!\u00191\u0014qO=zs&\u0019\u0011\u0011P\u001c\u0003\rQ+\b\u000f\\34\u0011\u0019\tI\u0007\u0006a\u0001s\u0006)qO]5uKRA\u0011QBAA\u0003\u0007\u000bI\tC\u0004\u0002jU\u0001\r!a\u001b\t\u000f\u0005\u0015U\u00031\u0001\u0002\b\u00069\u0011m\u0019;j_:\u001c\b#BA&\u0003+J\b\"CAF+A\u0005\t\u0019AAG\u0003%yg/\u001a:xe&$X\rE\u00027\u0003\u001fK1!!%8\u0005\u001d\u0011un\u001c7fC:\fqb\u001e:ji\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003/SC!!$\u0002\u001a.\u0012\u00111\u0014\t\u0005\u0003;\u000b9+\u0004\u0002\u0002 *!\u0011\u0011UAR\u0003%)hn\u00195fG.,GMC\u0002\u0002&^\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI+a(\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\tva\u0012\fG/\u001a#fYR\fG+\u00192mKRA\u0011qVA[\u0003o\u000bY\f\u0005\u0003\u00020\u0005E\u0016\u0002BAZ\u0003c\u0011a\u0002R3mi\u0006d\u0015m[3UC\ndW\rC\u0004\u0002j]\u0001\r!a\u001b\t\r\u0005ev\u00031\u0001z\u0003%!\u0018M]4fiJ+g\r\u0003\u0005\u0002>^\u0001\n\u00111\u0001z\u00039a\u0017m\u001d;DQ\u0016\u001c7\u000e]8j]R\f!$\u001e9eCR,G)\u001a7uCR\u000b'\r\\3%I\u00164\u0017-\u001e7uIM*\"!a1+\u0007e\fI*A\tfqR\u0014\u0018m\u0019;DQ\u0016\u001c7\u000e]8j]R$b!!3\u0002\\\u0006u\u0007c\u0002\u001c\u0002L\u0006=\u0017Q[\u0005\u0004\u0003\u001b<$A\u0002+va2,'\u0007E\u00027\u0003#L1!a58\u0005\u0011auN\\4\u0011\u000b\u0005-\u0013q[=\n\t\u0005e\u0017\u0011\f\u0002\u0004'\u0016\f\bBBA_3\u0001\u0007\u0011\u0010C\u0004\u0002je\u0001\r!a\u001b\u0002'5|g/Z\"iK\u000e\\\u0007o\\5oi\u001aKG.Z:\u0015\r\u0005U\u00171]Au\u0011\u001d\t)O\u0007a\u0001\u0003O\fQAZ5mKN\u0004b!a\u0013\u0002X\u0006-\u0004bBAv5\u0001\u0007\u00111N\u0001\bI\u0016\u001cH\u000fR5s\u0003\u0019\u0019w.\\7jiRa\u0011QRAy\u0003g\f90a?\u0002\u0000\"9\u0011\u0011N\u000eA\u0002\u0005-\u0004BBA{7\u0001\u0007\u00110A\u0002sK\u001aDa!!?\u001c\u0001\u0004I\u0018\u0001\u00025bg\"D\u0001\"!@\u001c!\u0003\u0005\r!_\u0001\b[\u0016\u001c8/Y4f\u0011!\til\u0007I\u0001\u0002\u0004I\u0018\u0001E2p[6LG\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0003A\u0019w.\\7ji\u0012\"WMZ1vYR$S'A\u0007xe&$X-\u00138uKJt\u0017\r\u001c\u000b\u000b\u0003\u001b\u0011IAa\u0003\u0003\u000e\t=\u0001bBA5=\u0001\u0007\u00111\u000e\u0005\b\u0003\u000bs\u0002\u0019AAD\u0011\u0019\t)P\ba\u0001s\"1\u0011\u0011 \u0010A\u0002e\f\u0011\u0002]1uQR{7*Z=\u0015\t\tU!1\u0004\t\u0005\u0003_\u00119\"\u0003\u0003\u0003\u001a\u0005E\"aC\"p]R,g\u000e^:LKfDq!!\u001b \u0001\u0004\tY\u0007\u0006\u0003\u0003\u0016\t}\u0001BBA5A\u0001\u0007\u00110\u0001\nok6\u001c\u0005.Z2la>Lg\u000e\u001e)beR\u001cH\u0003\u0002B\u0013\u0005[\u0001BAN<\u0003(A\u0019aG!\u000b\n\u0007\t-rGA\u0002J]RDq!!\u001b\"\u0001\u0004\tY'A\u0006hKR4\u0015\u000e\\3UsB,G\u0003\u0002B\u001a\u0005w\u0001BA!\u000e\u000385\tq(C\u0002\u0003:}\u0012Q\u0002R3mi\u00064\u0015\u000e\\3UsB,\u0007bBA5E\u0001\u0007\u00111N\u0001\fKb$(/Y2u\u001b\u0016$\u0018\r\u0006\u0003\u0003B\t\u001d\u0003\u0003\u0002B\u001b\u0005\u0007J1A!\u0012@\u0005-aun\u001a$jY\u0016lU\r^1\t\u000f\t%3\u00051\u0001\u0002\\\u0005Qa-\u001b7f'R\fG/^:\u0002\u001d\u0015DHO]1diZ+'o]5p]R!\u0011q\u001aB(\u0011\u001d\tI\u0007\na\u0001\u0003W\nQ\u0002\\5ti\u001aKG.Z:Ge>lG\u0003\u0002B+\u0005/\u0002b!a\u0013\u0002V\t\u0005\u0003bBA5K\u0001\u0007\u00111N\u0001\u0010K6\u0004H/_\"iK\u000e\\\u0007o\\5oiR1!\u0011\tB/\u0005CBqAa\u0018'\u0001\u0004\ty-A\u0004wKJ\u001c\u0018n\u001c8\t\u000f\t\rd\u00051\u0001\u0003B\u0005YAn\\4GS2,W*\u001a;b\u0003!9W\r\u001e+bE2,GC\u0002B5\u0005W\u0012i\u0007\u0005\u00037o\u0006=\u0006bBA5O\u0001\u0007\u00111\u000e\u0005\u0007\u0005_:\u0003\u0019A=\u0002\r\t\u0014\u0018M\\2i\u0003\u0011\u0011X-\u00193\u0015\t\u0005U'Q\u000f\u0005\b\u0003SB\u0003\u0019AA6\u0003=IgN^1mS\u0012\fG/Z\"bG\",GCAA\u0007\u0003UI7\u000fU1si&\fGn\u0016:ji\u00164\u0016n]5cY\u0016$B!!$\u0003\u0000!9\u0011\u0011\u000e\u0016A\u0002\u0005-\u0014!\u0006:fg>dg/Z\"iK\u000e\\\u0007o\\5oiB\u000bG\u000f\u001b\u000b\u0005\u0003W\u0012)\tC\u0004\u0002j-\u0002\r!a\u001b")
public class NessieLogStore
implements LogStore,
Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final Pattern deltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;
    private Option<String> lastSnapshotUuid;
    private final NessieClient client;
    private Reference reference;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public final Seq<String> read(String path) {
        return LogStore.read$(this, path);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore.write$(this, path, actions);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore.listFrom$(this, path);
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return LogStore.resolvePathOnPhysicalStorage$(this, path);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Option<String> lastSnapshotUuid() {
        return this.lastSnapshotUuid;
    }

    public void lastSnapshotUuid_$eq(Option<String> x$1) {
        this.lastSnapshotUuid = x$1;
    }

    private NessieClient client() {
        return this.client;
    }

    private Reference getOrCreate() {
        Reference reference;
        String requestedRef = this.hadoopConf.get("nessie.ref");
        try {
            reference = (Reference)Option$.MODULE$.apply((Object)requestedRef).map((Function1 & Serializable & scala.Serializable)x$1 -> this.client().getTreeApi().getReferenceByName((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.client().getTreeApi().getDefaultBranch());
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(new StringBuilder(104).append("Nessie ref ").append(requestedRef).append(" provided ").append("via ").append("nessie.ref").append(" does not exist. This ref must exist before creating a NessieCatalog.").toString(), ex);
            }
            throw new IllegalArgumentException(new StringBuilder(143).append("Nessie does not have an existing default branch. Either configure ").append("an alternative ref via ").append("nessie.ref").append(" or create the default branch on the server.").toString(), ex);
        }
        return reference;
    }

    private Reference reference() {
        return this.reference;
    }

    private void reference_$eq(Reference x$1) {
        this.reference = x$1;
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        throw new UnsupportedOperationException("listFrom from Nessie does not work.");
    }

    private Tuple3<String, String, String> parseTableIdentifier(String path) {
        if (path.contains("@") && path.contains("#")) {
            String[] tableRef = path.split("@");
            String[] refHash = tableRef[1].split("#");
            return new Tuple3((Object)tableRef[0], (Object)refHash[0], (Object)refHash[0]);
        }
        if (path.contains("@")) {
            String[] tableRef = path.split("@");
            return new Tuple3((Object)tableRef[0], (Object)tableRef[1], null);
        }
        return new Tuple3((Object)path, (Object)this.hadoopConf.get("nessie.ref"), (Object)this.hadoopConf.get("nessie.hash"));
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        if (path.getName().equals("_last_checkpoint")) {
            Path x$1 = path;
            String x$2 = this.reference().getName();
            String x$3 = this.reference().getHash();
            String x$4 = actions.mkString();
            String x$5 = this.commit$default$4();
            this.commit(x$1, x$2, x$3, x$5, x$4);
            return;
        }
        Path parent = path.getParent();
        String[] nameSplit = path.getName().split("\\.", 2);
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(nameSplit[0]);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = new StringBuilder(2).append(tableName2).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(nameSplit[1]).toString();
        Path nessiePath = new Path(parent, name);
        if (overwrite) {
            throw new IllegalStateException(new StringBuilder(32).append("Nessie won't overwrite for path ").append(path).toString());
        }
        this.writeInternal(nessiePath, actions, ref2, hash2);
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private DeltaLakeTable updateDeltaTable(Path path, String targetRef, String lastCheckpoint) {
        ImmutableDeltaLakeTable immutableDeltaLakeTable;
        Option<DeltaLakeTable> currentTable = this.getTable(path.getParent(), targetRef);
        ImmutableDeltaLakeTable table = (ImmutableDeltaLakeTable)currentTable.map((Function1 & Serializable & scala.Serializable)instance -> ImmutableDeltaLakeTable.copyOf(instance)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableDeltaLakeTable.builder().build());
        DeltaFileType deltaFileType = this.getFileType(path);
        if (((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType)) {
            String string = path.toString();
            immutableDeltaLakeTable = table.withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(table.getMetadataLocationHistory()).asScala()).toList().$colon$colon((Object)string)).asJava());
        } else {
            if (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType)) {
                throw new UnsupportedOperationException("Can't write checkpoints from LogStore");
            }
            if (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType)) {
                immutableDeltaLakeTable = table;
            } else if (((Object)DeltaFileType$UNKNOWN$.MODULE$).equals(deltaFileType)) {
                ImmutableDeltaLakeTable immutableDeltaLakeTable2;
                if (!path.getName().equals("_last_checkpoint")) {
                    immutableDeltaLakeTable2 = table;
                } else {
                    Tuple2<Object, Seq<String>> tuple2 = this.extractCheckpoint(lastCheckpoint, path.getParent());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long version = tuple2._1$mcJ$sp();
                    Seq parts = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)parts);
                    Tuple2 tuple23 = tuple22;
                    long version2 = tuple23._1$mcJ$sp();
                    Seq parts2 = (Seq)tuple23._2();
                    immutableDeltaLakeTable2 = table.withCheckpointLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(parts2).asJava()).withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.getCheckpointLocationHistory()).asScala()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$updateDeltaTable$3(this, version2, x)))).asJava()).withLastCheckpoint(lastCheckpoint);
                }
                immutableDeltaLakeTable = immutableDeltaLakeTable2;
            } else {
                immutableDeltaLakeTable = table;
            }
        }
        return immutableDeltaLakeTable;
    }

    private String updateDeltaTable$default$3() {
        return null;
    }

    private Tuple2<Object, Seq<String>> extractCheckpoint(String lastCheckpoint, Path path) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        CheckpointMetaData checkpoint = (CheckpointMetaData)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(lastCheckpoint), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(CheckpointMetaData.class));
        long version = checkpoint.version();
        Option<Object> parts = checkpoint.parts();
        Path tempPath = new Path(path, (String)this.lastSnapshotUuid().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("didn't write the correct checkpoint dir");
        }));
        Seq files = parts.isEmpty() ? (Seq)new .colon.colon((Object)FileNames$.MODULE$.checkpointFileSingular(tempPath, version), (List)Nil$.MODULE$) : FileNames$.MODULE$.checkpointFileWithParts(tempPath, version, BoxesRunTime.unboxToInt((Object)checkpoint.parts().get()));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)version), this.moveCheckpointFiles((Seq<Path>)files, path));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<String> moveCheckpointFiles(Seq<Path> files, Path destDir) {
        void var3_3;
        Seq movedFiles = (Seq)files.map((Function1 & Serializable & scala.Serializable)f -> {
            FileSystem fs = f.getFileSystem($this.hadoopConf);
            String[] parts = f.getName().split("\\.", 2);
            String destFile = new StringBuilder(2).append(parts[0]).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(parts[1]).toString();
            Path dest = new Path(destDir, destFile);
            fs.rename(f, dest);
            return dest.toString();
        }, Seq$.MODULE$.canBuildFrom());
        ((Path)files.head()).getFileSystem(this.hadoopConf).delete(((Path)files.head()).getParent(), true);
        return var3_3;
    }

    private boolean commit(Path path, String ref, String hash, String message, String lastCheckpoint) {
        String targetRef = ref == null ? this.reference().getName() : ref;
        String targetHash = hash == null ? this.reference().getHash() : hash;
        DeltaLakeTable table = this.updateDeltaTable(path, targetRef, lastCheckpoint);
        Operation.Put put = Operation.Put.of(this.pathToKey(path.getParent()), table);
        ImmutableCommitMeta meta = CommitMeta.builder().message(message).putProperties("spark.app.id", this.sparkConf.get("spark.app.id")).putProperties("application.type", "delta").build();
        ImmutableOperations op = ImmutableOperations.builder().addOperations((Operation)put).commitMeta(meta).build();
        this.client().getTreeApi().commitMultipleOperations(targetRef, targetHash, op);
        this.reference_$eq(this.client().getTreeApi().getReferenceByName(this.reference().getName()));
        return true;
    }

    private String commit$default$4() {
        return "delta commit";
    }

    private String commit$default$5() {
        return null;
    }

    public void writeInternal(Path path, Iterator<String> actions, String ref, String hash) {
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        if (fs.exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        boolean streamClosed = false;
        boolean commitDone = false;
        FSDataOutputStream stream = fs.create(path);
        try {
            actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                commitDone = this.commit(path, ref, hash, this.commit$default$4(), this.commit$default$5());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!commitDone) {
                fs.delete(path, false);
            }
        }
    }

    public ContentsKey pathToKey(Path path) {
        return this.pathToKey(path.toUri().getPath());
    }

    public ContentsKey pathToKey(String path) {
        List parts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).toList();
        return ContentsKey.of((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)parts).asJava());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] stringArray;
        String[] segments = path.getName().split("\\.");
        String[] stringArray2 = segments;
        Object object = stringArray2 != null && (stringArray = stringArray2).length == 6 ? new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[4])).toInt())) : None$.MODULE$;
        return object;
    }

    public DeltaFileType getFileType(Path path) {
        Path path2 = path;
        DeltaFileType deltaFileType = this.checkpointFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKPOINT$.MODULE$ : (this.deltaFilePattern().matcher(path.getName()).matches() ? DeltaFileType$DELTA$.MODULE$ : (this.checksumFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKSUM$.MODULE$ : DeltaFileType$UNKNOWN$.MODULE$));
        return deltaFileType;
    }

    public LogFileMeta extractMeta(FileStatus fileStatus) {
        return new LogFileMeta(fileStatus, this.extractVersion(fileStatus.getPath()), this.getFileType(fileStatus.getPath()), this.numCheckpointParts(fileStatus.getPath()));
    }

    public long extractVersion(Path path) {
        DeltaFileType deltaFileType = this.getFileType(path);
        long l = ((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".json").split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0].split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc").split("-")[0])).toLong() : -1L));
        return l;
    }

    public Iterator<LogFileMeta> listFilesFrom(Path path2) {
        FileSystem fs = path2.getFileSystem(this.hadoopConf);
        if (!fs.exists(path2.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path2.getParent()).toString());
        }
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(path2.toUri().getPath());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = null;
        name = hash2 != null ? hash2 : (ref2 != null ? ref2 : this.reference().getName());
        Option<DeltaLakeTable> currentTable = this.getTable(new Path(tableName2).getParent(), name);
        Set currentMetadataPath = (Set)currentTable.map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getMetadataLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> new Path(x$9), Buffer$.MODULE$.canBuildFrom())).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(15).append("No such table: ").append(path2).toString());
        });
        Set currentPath = ((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory() != null ? (Set)currentMetadataPath.$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> new Path(x$10), Buffer$.MODULE$.canBuildFrom())) : currentMetadataPath;
        long requestedVersion = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> FileNames$.MODULE$.getFileVersion(path2)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path2.getName())).stripSuffix(".checkpoint"))).toLong()));
        FileStatus[] files = fs.listStatus(path2.getParent());
        LogFileMeta[] filteredFiles = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)fileStatus -> this.extractMeta((FileStatus)fileStatus), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)currentPath.contains((Object)x.fileStatus().getPath()))))).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$9(requestedVersion, x$11))))).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.version()), (Ordering)Ordering.Long$.MODULE$);
        None$ maxExpected = currentPath.nonEmpty() ? new Some(((TraversableOnce)currentPath.map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)this.extractVersion(path)), Set$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        None$ maxFound = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).nonEmpty() ? new Some(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)maxFound.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) == BoxesRunTime.unboxToLong((Object)maxExpected.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.fileType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DeltaFileType.class))))).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$16(x$15))) == filteredFiles.length ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.emptyCheckpoint(requestedVersion, (LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).head()), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).iterator() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).iterator();
    }

    private LogFileMeta emptyCheckpoint(long version, LogFileMeta logFileMeta) {
        FileStatus fileStatus = new FileStatus(0L, false, 0, 0L, logFileMeta.fileStatus().getModificationTime(), FileNames$.MODULE$.deltaFile(logFileMeta.fileStatus().getPath().getParent(), version));
        return new LogFileMeta(fileStatus, version, DeltaFileType$DELTA$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    private Option<DeltaLakeTable> getTable(Path path, String branch) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.client().getContentsApi().getContents(this.pathToKey(path), branch)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$getTable$2(x))).map((Function1 & Serializable & scala.Serializable)x$16 -> (DeltaLakeTable)x$16).toOption();
    }

    @Override
    public Seq<String> read(Path path) {
        Seq seq;
        if (path.getName().equals("_last_checkpoint")) {
            Option<DeltaLakeTable> table = this.getTable(path.getParent(), this.reference().getName());
            String data = (String)table.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getLastCheckpoint()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new FileNotFoundException();
            });
            if (data == null) {
                throw new FileNotFoundException();
            }
            seq = (Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$);
        } else {
            FileSystem fs = path.getFileSystem(this.hadoopConf);
            try (FSDataInputStream stream = fs.open(path);){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.trim(), Buffer$.MODULE$.canBuildFrom());
            }
        }
        return seq;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    @Override
    public Path resolveCheckpointPath(Path path) {
        this.lastSnapshotUuid_$eq((Option<String>)new Some((Object)UUID.randomUUID().toString()));
        return path.getFileSystem(this.hadoopConf).makeQualified(new Path(path, (String)this.lastSnapshotUuid().get()));
    }

    public static final /* synthetic */ boolean $anonfun$updateDeltaTable$3(NessieLogStore $this, long version$1, String x) {
        return $this.extractVersion(new Path(x)) < version$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$9(long requestedVersion$1, LogFileMeta x$11) {
        return x$11.version() >= requestedVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$16(DeltaFileType x$15) {
        DeltaFileType deltaFileType = x$15;
        DeltaFileType$CHECKPOINT$ deltaFileType$CHECKPOINT$ = DeltaFileType$CHECKPOINT$.MODULE$;
        return !(deltaFileType != null ? !((Object)deltaFileType).equals(deltaFileType$CHECKPOINT$) : deltaFileType$CHECKPOINT$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTable$2(Contents x) {
        return x != null && x instanceof DeltaLakeTable;
    }

    public NessieLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        LogStore.$init$(this);
        Logging.$init$((Logging)this);
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.json")).r().pattern();
        this.checksumFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.crc")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
        this.lastSnapshotUuid = None$.MODULE$;
        this.client = NessieClient.builder().fromConfig(c -> $this.hadoopConf.get(c)).build();
        this.reference = this.getOrCreate();
    }
}

