/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Contents;
import org.projectnessie.model.SqlView;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="SqlView", generator="Immutables")
@Immutable
public final class ImmutableSqlView
extends SqlView {
    @Nullable
    private final String id;
    private final String sqlText;
    private final SqlView.Dialect dialect;
    private final transient int hashCode;

    private ImmutableSqlView(Builder builder) {
        this.sqlText = builder.sqlText;
        this.dialect = builder.dialect;
        this.id = builder.idIsSet() ? builder.id : super.getId();
        this.hashCode = this.computeHashCode();
    }

    private ImmutableSqlView(@Nullable String id, String sqlText, SqlView.Dialect dialect) {
        this.id = id;
        this.sqlText = sqlText;
        this.dialect = dialect;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="sqlText")
    public String getSqlText() {
        return this.sqlText;
    }

    @Override
    @JsonProperty(value="dialect")
    public SqlView.Dialect getDialect() {
        return this.dialect;
    }

    public final ImmutableSqlView withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableSqlView(value, this.sqlText, this.dialect);
    }

    public final ImmutableSqlView withSqlText(String value) {
        String newValue = Objects.requireNonNull(value, "sqlText");
        if (this.sqlText.equals(newValue)) {
            return this;
        }
        return new ImmutableSqlView(this.id, newValue, this.dialect);
    }

    public final ImmutableSqlView withDialect(SqlView.Dialect value) {
        if (this.dialect == value) {
            return this;
        }
        SqlView.Dialect newValue = Objects.requireNonNull(value, "dialect");
        if (this.dialect.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableSqlView(this.id, this.sqlText, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSqlView && this.equalTo((ImmutableSqlView)another);
    }

    private boolean equalTo(ImmutableSqlView another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.id, another.id) && this.sqlText.equals(another.sqlText) && this.dialect.equals((Object)another.dialect);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + this.sqlText.hashCode();
        h += (h << 5) + this.dialect.hashCode();
        return h;
    }

    public String toString() {
        return "SqlView{id=" + this.id + ", sqlText=" + this.sqlText + ", dialect=" + (Object)((Object)this.dialect) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSqlView fromJson(Json json) {
        Builder builder = ImmutableSqlView.builder();
        if (json.idIsSet) {
            builder.id(json.id);
        }
        if (json.sqlText != null) {
            builder.sqlText(json.sqlText);
        }
        if (json.dialect != null) {
            builder.dialect(json.dialect);
        }
        return builder.build();
    }

    public static ImmutableSqlView copyOf(SqlView instance) {
        if (instance instanceof ImmutableSqlView) {
            return (ImmutableSqlView)instance;
        }
        return ImmutableSqlView.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SqlView", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SQL_TEXT = 1L;
        private static final long INIT_BIT_DIALECT = 2L;
        private static final long OPT_BIT_ID = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String id;
        @Nullable
        private String sqlText;
        @Nullable
        private SqlView.Dialect dialect;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Contents instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(SqlView instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Contents instance;
            String idValue;
            if (object instanceof Contents && (idValue = (instance = (Contents)object).getId()) != null) {
                this.id(idValue);
            }
            if (object instanceof SqlView) {
                instance = (SqlView)object;
                this.sqlText(((SqlView)instance).getSqlText());
                this.dialect(((SqlView)instance).getDialect());
            }
        }

        @JsonProperty(value="id")
        @CanIgnoreReturnValue
        public final Builder id(@Nullable String id) {
            this.id = id;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="sqlText")
        @CanIgnoreReturnValue
        public final Builder sqlText(String sqlText) {
            this.sqlText = Objects.requireNonNull(sqlText, "sqlText");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="dialect")
        @CanIgnoreReturnValue
        public final Builder dialect(SqlView.Dialect dialect) {
            this.dialect = Objects.requireNonNull(dialect, "dialect");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableSqlView build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSqlView(this);
        }

        private boolean idIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sqlText");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dialect");
            }
            return "Cannot build SqlView, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SqlView", generator="Immutables")
    static final class Json
    extends SqlView {
        @Nullable
        String id;
        boolean idIsSet;
        @Nullable
        String sqlText;
        @Nullable
        SqlView.Dialect dialect;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
            this.idIsSet = true;
        }

        @JsonProperty(value="sqlText")
        public void setSqlText(String sqlText) {
            this.sqlText = sqlText;
        }

        @JsonProperty(value="dialect")
        public void setDialect(SqlView.Dialect dialect) {
            this.dialect = dialect;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSqlText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SqlView.Dialect getDialect() {
            throw new UnsupportedOperationException();
        }
    }
}

