/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.deltalake;

import io.delta.tables.DeltaTable;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaLog;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.tests.AbstractSparkTest;
import org.projectnessie.deltalake.NessieLogFileMetaParser;
import org.projectnessie.deltalake.NessieLogStore;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.Reference;
import scala.Tuple2;

class ITDeltaLogBranches
extends AbstractSparkTest {
    private NessieClient client;
    @TempDir
    File tempPath;

    ITDeltaLogBranches() {
    }

    @BeforeAll
    protected static void createDelta() {
        conf.set("spark.delta.logStore.class", NessieLogStore.class.getCanonicalName()).set("spark.delta.logFileHandler.class", NessieLogFileMetaParser.class.getCanonicalName()).set("spark.sql.extensions", "io.delta.sql.DeltaSparkSessionExtension").set("spark.sql.catalog.spark_catalog", "org.apache.spark.sql.delta.catalog.DeltaCatalog");
    }

    @BeforeEach
    public void createClient() {
        this.client = NessieClient.builder().withUri(url).build();
    }

    @AfterEach
    public void closeClient() throws NessieNotFoundException, NessieConflictException {
        Reference ref = null;
        try {
            ref = this.client.getTreeApi().getReferenceByName("test");
        }
        catch (NessieNotFoundException nessieNotFoundException) {
            // empty catch block
        }
        if (ref != null) {
            this.client.getTreeApi().deleteBranch("test", ref.getHash());
        }
        this.client.close();
        this.client = null;
    }

    @Test
    void testBranches() throws NessieNotFoundException, NessieConflictException {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        this.client.getTreeApi().createReference((Reference)Branch.of((String)"test", (String)this.client.getTreeApi().getDefaultBranch().getHash()));
        targetTable.write().format("delta").mode("append").save(this.tempPath.getAbsolutePath());
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        int expectedSize = target.toDF().collectAsList().size();
        DeltaLog.invalidateCache((SparkSession)spark, (Path)new Path(this.tempPath.getAbsolutePath()));
        spark.sparkContext().hadoopConfiguration().set("nessie.ref", "test");
        Dataset targetBranch = spark.read().format("delta").load(this.tempPath.getAbsolutePath());
        Assertions.assertEquals((double)((double)expectedSize * 0.5), (double)targetBranch.collectAsList().size());
    }

    @Test
    void testCheckpoint() throws NessieNotFoundException {
        Dataset<Row> targetTable = this.createKVDataSet(Arrays.asList(this.tuple2(1, 10), this.tuple2(2, 20), this.tuple2(3, 30), this.tuple2(4, 40)), "key", "value");
        targetTable.write().format("delta").save(this.tempPath.getAbsolutePath());
        for (int i = 0; i < 15; ++i) {
            targetTable.write().format("delta").mode("append").save(this.tempPath.getAbsolutePath());
        }
        DeltaTable target = DeltaTable.forPath((SparkSession)spark, (String)this.tempPath.getAbsolutePath());
        int expectedSize = target.toDF().collectAsList().size();
        Assertions.assertEquals((int)64, (int)expectedSize);
        String tableName = this.tempPath.getAbsolutePath() + "/_delta_log";
        Contents contents = this.client.getContentsApi().getContents(ContentsKey.of((String[])tableName.split("/")), "main");
        Optional table = contents.unwrap(DeltaLakeTable.class);
        Assertions.assertTrue((boolean)table.isPresent());
        Assertions.assertEquals((int)1, (int)((DeltaLakeTable)table.get()).getCheckpointLocationHistory().size());
        Assertions.assertEquals((int)5, (int)((DeltaLakeTable)table.get()).getMetadataLocationHistory().size());
        Assertions.assertNotNull((Object)((DeltaLakeTable)table.get()).getLastCheckpoint());
    }

    private Dataset<Row> createKVDataSet(List<Tuple2<Integer, Integer>> data, String keyName, String valueName) {
        Encoder encoder = Encoders.tuple((Encoder)Encoders.INT(), (Encoder)Encoders.INT());
        return spark.createDataset(data, encoder).toDF(new String[]{keyName, valueName});
    }

    private <T1, T2> Tuple2<T1, T2> tuple2(T1 t1, T2 t2) {
        return new Tuple2(t1, t2);
    }
}

