/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.nio.file.FileAlreadyExistsException;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.Footer;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.AddFile$;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitInfo$;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Metadata$;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.commands.ConvertToDeltaCommandBase$ConvertProperties$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceUtils$;
import org.apache.spark.sql.delta.util.DateFormatter;
import org.apache.spark.sql.delta.util.DateFormatter$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.PartitionUtils;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.delta.util.SerializableFileStatus;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetToSparkSchemaConverter;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r-b!\u0002\u001a4\u0003\u0003\u0001\u0005\u0002C,\u0001\u0005\u0003\u0005\u000b\u0011\u0002-\t\u0011q\u0003!\u0011!Q\u0001\nuC\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006IA\u001b\u0005\u0006m\u0002!\ta\u001e\u0005\ty\u0002A)\u0019!C\u0001{\"Q\u0011q\u0002\u0001\t\u0006\u0004%\t!!\u0005\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005u\u0001\u0002CA\u0017\u0001\u0001\u0006I!a\b\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011Q\t\u0001\u0005\u0012\u0005\u001d\u0003b\u0002B\f\u0001\u0011\u0005#\u0011\u0004\u0005\b\u0005_\u0001A\u0011\tB\u0019\u0011\u001d\u0011)\u0004\u0001C\t\u0005oAqA!\u0015\u0001\t#\u0011\u0019\u0006C\u0004\u0003\\\u0001!\tB!\u0018\t\u000f\t\u001d\u0006\u0001\"\u0005\u0003*\"9!1\u0017\u0001\u0005\u0012\u0005\u0015\u0005b\u0002B[\u0001\u0011E!q\u0017\u0005\b\u0005C\u0004A\u0011\u0003Br\r\u0019\ti\u0005\u0001%\u0002P!Q\u00111\r\u000b\u0003\u0016\u0004%\t!!\u001a\t\u0015\u0005UDC!E!\u0002\u0013\t9\u0007\u0003\u0006\u0002xQ\u0011)\u001a!C\u0001\u0003sB\u0011\"a\u001f\u0015\u0005#\u0005\u000b\u0011\u00026\t\u0015\u0005uDC!f\u0001\n\u0003\ty\bC\u0005\u0002\u0002R\u0011\t\u0012)A\u0005W\"Q\u00111\u0011\u000b\u0003\u0016\u0004%\t!!\"\t\u0015\u00055EC!E!\u0002\u0013\t9\t\u0003\u0004w)\u0011\u0005\u0011q\u0012\u0005\n\u00033#\u0012\u0011!C\u0001\u00037C\u0011\"!*\u0015#\u0003%\t!a*\t\u0013\u0005uF#%A\u0005\u0002\u0005}\u0006\"CAb)E\u0005I\u0011AAc\u0011%\tI\rFI\u0001\n\u0003\tY\rC\u0005\u0002PR\t\t\u0011\"\u0011\u0002\u001e!I\u0011\u0011\u001b\u000b\u0002\u0002\u0013\u0005\u00111\u001b\u0005\n\u00037$\u0012\u0011!C\u0001\u0003;D\u0011\"!;\u0015\u0003\u0003%\t%a;\t\u0013\u0005eH#!A\u0005\u0002\u0005m\b\"\u0003B\u0003)\u0005\u0005I\u0011\tB\u0004\u0011%\u0011I\u0001FA\u0001\n\u0003\u0012Y\u0001C\u0005\u0003\u000eQ\t\t\u0011\"\u0011\u0003\u0010\u001dI!Q\u001f\u0001\u0002\u0002#E!q\u001f\u0004\n\u0003\u001b\u0002\u0011\u0011!E\t\u0005sDaA\u001e\u0017\u0005\u0002\r\u001d\u0001\"\u0003B\u0005Y\u0005\u0005IQ\tB\u0006\u0011%\u0019I\u0001LA\u0001\n\u0003\u001bY\u0001C\u0005\u0004\u00161\n\t\u0011\"!\u0004\u0018!91Q\u0005\u0001\u0005\n\r\u001d\"!G\"p]Z,'\u000f\u001e+p\t\u0016dG/Y\"p[6\fg\u000e\u001a\"bg\u0016T!\u0001N\u001b\u0002\u0011\r|W.\\1oINT!AN\u001c\u0002\u000b\u0011,G\u000e^1\u000b\u0005aJ\u0014aA:rY*\u0011!hO\u0001\u0006gB\f'o\u001b\u0006\u0003yu\na!\u00199bG\",'\"\u0001 \u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\t5j\u0015\t\u0003\u0005&k\u0011a\u0011\u0006\u0003\t\u0016\u000bq\u0001\\8hS\u000e\fGN\u0003\u0002G\u000f\u0006)\u0001\u000f\\1og*\u0011\u0001jN\u0001\tG\u0006$\u0018\r\\=ti&\u0011!j\u0011\u0002\f\u0019><\u0017nY1m!2\fg\u000e\u0005\u0002M#6\tQJ\u0003\u0002O\u001f\u000691m\\7nC:$'B\u0001)8\u0003%)\u00070Z2vi&|g.\u0003\u0002S\u001b\ny!+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002U+6\t1'\u0003\u0002Wg\taA)\u001a7uC\u000e{W.\\1oI\u0006yA/\u00192mK&#WM\u001c;jM&,'\u000f\u0005\u0002Z56\tq)\u0003\u0002\\\u000f\nyA+\u00192mK&#WM\u001c;jM&,'/A\bqCJ$\u0018\u000e^5p]N\u001b\u0007.Z7b!\rq\u0016mY\u0007\u0002?*\t\u0001-A\u0003tG\u0006d\u0017-\u0003\u0002c?\n1q\n\u001d;j_:\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ\u001c\u0002\u000bQL\b/Z:\n\u0005!,'AC*ueV\u001cG\u000fV=qK\u0006IA-\u001a7uCB\u000bG\u000f\u001b\t\u0004=\u0006\\\u0007C\u00017t\u001d\ti\u0017\u000f\u0005\u0002o?6\tqN\u0003\u0002q\u007f\u00051AH]8pizJ!A]0\u0002\rA\u0013X\rZ3g\u0013\t!XO\u0001\u0004TiJLgn\u001a\u0006\u0003e~\u000ba\u0001P5oSRtD\u0003\u0002=zun\u0004\"\u0001\u0016\u0001\t\u000b]#\u0001\u0019\u0001-\t\u000bq#\u0001\u0019A/\t\u000b%$\u0001\u0019\u00016\u0002#A\f'\u000f^5uS>t7i\u001c7OC6,7/F\u0001\u007f!\u0011y\u0018\u0011B6\u000f\t\u0005\u0005\u0011Q\u0001\b\u0004]\u0006\r\u0011\"\u00011\n\u0007\u0005\u001dq,A\u0004qC\u000e\\\u0017mZ3\n\t\u0005-\u0011Q\u0002\u0002\u0004'\u0016\f(bAA\u0004?\u0006y\u0001/\u0019:uSRLwN\u001c$jK2$7/\u0006\u0002\u0002\u0014A)q0!\u0003\u0002\u0016A\u0019A-a\u0006\n\u0007\u0005eQMA\u0006TiJ,8\r\u001e$jK2$\u0017!\u0007;j[\u0016\u001cH/Y7q!\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e;fe:,\"!a\b\u0011\t\u0005\u0005\u00121F\u0007\u0003\u0003GQA!!\n\u0002(\u0005!A.\u00198h\u0015\t\tI#\u0001\u0003kCZ\f\u0017b\u0001;\u0002$\u0005QB/[7fgR\fW\u000e\u001d)beRLG/[8o!\u0006$H/\u001a:oA\u0005\u0019!/\u001e8\u0015\t\u0005M\u0012Q\b\t\u0006\u007f\u0006%\u0011Q\u0007\t\u0005\u0003o\tI$D\u00018\u0013\r\tYd\u000e\u0002\u0004%><\bB\u0002\u001e\n\u0001\u0004\ty\u0004\u0005\u0003\u00028\u0005\u0005\u0013bAA\"o\ta1\u000b]1sWN+7o]5p]\u0006!r-\u001a;D_:4XM\u001d;Qe>\u0004XM\u001d;jKN$b!!\u0013\u0003\u0014\tU\u0001cAA&)5\t\u0001AA\tD_:4XM\u001d;Qe>\u0004XM\u001d;jKN\u001cr\u0001FA)\u0003/\ni\u0006E\u0002_\u0003'J1!!\u0016`\u0005\u0019\te.\u001f*fMB\u0019a,!\u0017\n\u0007\u0005msLA\u0004Qe>$Wo\u0019;\u0011\u0007y\u000by&C\u0002\u0002b}\u0013AbU3sS\u0006d\u0017N_1cY\u0016\fAbY1uC2|w\rV1cY\u0016,\"!a\u001a\u0011\ty\u000b\u0017\u0011\u000e\t\u0005\u0003W\n\t(\u0004\u0002\u0002n)\u0019\u0011qN$\u0002\u000f\r\fG/\u00197pO&!\u00111OA7\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u00035\u0019\u0017\r^1m_\u001e$\u0016M\u00197fA\u0005A\u0001O]8wS\u0012,'/F\u0001k\u0003%\u0001(o\u001c<jI\u0016\u0014\b%A\u0005uCJ<W\r\u001e#jeV\t1.\u0001\u0006uCJ<W\r\u001e#je\u0002\n!\u0002\u001d:pa\u0016\u0014H/[3t+\t\t9\tE\u0003m\u0003\u0013[7.C\u0002\u0002\fV\u00141!T1q\u0003-\u0001(o\u001c9feRLWm\u001d\u0011\u0015\u0015\u0005%\u0013\u0011SAJ\u0003+\u000b9\nC\u0004\u0002du\u0001\r!a\u001a\t\r\u0005]T\u00041\u0001k\u0011\u0019\ti(\ba\u0001W\"9\u00111Q\u000fA\u0002\u0005\u001d\u0015\u0001B2paf$\"\"!\u0013\u0002\u001e\u0006}\u0015\u0011UAR\u0011%\t\u0019G\bI\u0001\u0002\u0004\t9\u0007\u0003\u0005\u0002xy\u0001\n\u00111\u0001k\u0011!\tiH\bI\u0001\u0002\u0004Y\u0007\"CAB=A\u0005\t\u0019AAD\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!++\t\u0005\u001d\u00141V\u0016\u0003\u0003[\u0003B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),A\u0005v]\u000eDWmY6fI*\u0019\u0011qW0\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002<\u0006E&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAaU\rQ\u00171V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t9MK\u0002l\u0003W\u000babY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002N*\"\u0011qQAV\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u001b\t\u0004=\u0006]\u0017bAAm?\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011q\\As!\rq\u0016\u0011]\u0005\u0004\u0003G|&aA!os\"I\u0011q]\u0013\u0002\u0002\u0003\u0007\u0011Q[\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u00055\bCBAx\u0003k\fy.\u0004\u0002\u0002r*\u0019\u00111_0\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002x\u0006E(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!@\u0003\u0004A\u0019a,a@\n\u0007\t\u0005qLA\u0004C_>dW-\u00198\t\u0013\u0005\u001dx%!AA\u0002\u0005}\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0011AB3rk\u0006d7\u000f\u0006\u0003\u0002~\nE\u0001\"CAtU\u0005\u0005\t\u0019AAp\u0011\u0019Q$\u00021\u0001\u0002@!)qK\u0003a\u00011\u0006q\u0011n]\"bi\u0006dwn\u001a+bE2,GCBA\u007f\u00057\u0011Y\u0003C\u0004\u0003\u001e-\u0001\rAa\b\u0002\u0011\u0005t\u0017\r\\={KJ\u0004BA!\t\u0003(5\u0011!1\u0005\u0006\u0004\u0005K9\u0015\u0001C1oC2L8/[:\n\t\t%\"1\u0005\u0002\t\u0003:\fG.\u001f>fe\"1!QF\u0006A\u0002a\u000b!\u0002^1cY\u0016LE-\u001a8u\u0003AI7\u000fU1uQ&#WM\u001c;jM&,'\u000f\u0006\u0003\u0002~\nM\u0002B\u0002B\u0017\u0019\u0001\u0007\u0001,\u0001\u000fiC:$G.Z#ySN$\u0018N\\4Ue\u0006t7/Y2uS>tGj\\4\u0015\u0011\te\"q\bB!\u0005\u001b\u00022A\u0018B\u001e\u0013\r\u0011id\u0018\u0002\u0005+:LG\u000f\u0003\u0004;\u001b\u0001\u0007\u0011q\b\u0005\b\u0005\u0007j\u0001\u0019\u0001B#\u0003\r!\bP\u001c\t\u0005\u0005\u000f\u0012I%D\u00016\u0013\r\u0011Y%\u000e\u0002\u0016\u001fB$\u0018.\\5ti&\u001cGK]1og\u0006\u001cG/[8o\u0011\u001d\u0011y%\u0004a\u0001\u0003\u0013\n\u0011cY8om\u0016\u0014H\u000f\u0015:pa\u0016\u0014H/[3t\u00039\u0001XM\u001d4pe6\u001cuN\u001c<feR$\u0002\"a\r\u0003V\t]#\u0011\f\u0005\u0007u9\u0001\r!a\u0010\t\u000f\t\rc\u00021\u0001\u0003F!9!q\n\bA\u0002\u0005%\u0013!D2sK\u0006$X-\u00113e\r&dW\r\u0006\u0006\u0003`\t-$1\u0010BH\u0005/\u0003BA!\u0019\u0003h5\u0011!1\r\u0006\u0004\u0005K*\u0014aB1di&|gn]\u0005\u0005\u0005S\u0012\u0019GA\u0004BI\u00124\u0015\u000e\\3\t\u000f\t5t\u00021\u0001\u0003p\u0005!a-\u001b7f!\u0011\u0011\tHa\u001e\u000e\u0005\tM$b\u0001B;k\u0005!Q\u000f^5m\u0013\u0011\u0011IHa\u001d\u0003-M+'/[1mSj\f'\r\\3GS2,7\u000b^1ukNDqA! \u0010\u0001\u0004\u0011y(\u0001\u0005cCN,\u0007+\u0019;i!\u0011\u0011\tIa#\u000e\u0005\t\r%\u0002\u0002BC\u0005\u000f\u000b!AZ:\u000b\u0007\t%5(\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0005\u001b\u0013\u0019I\u0001\u0003QCRD\u0007b\u0002BC\u001f\u0001\u0007!\u0011\u0013\t\u0005\u0005\u0003\u0013\u0019*\u0003\u0003\u0003\u0016\n\r%A\u0003$jY\u0016\u001c\u0016p\u001d;f[\"9!\u0011T\bA\u0002\tm\u0015\u0001B2p]\u001a\u0004BA!(\u0003$6\u0011!q\u0014\u0006\u0004\u0005C;\u0014\u0001C5oi\u0016\u0014h.\u00197\n\t\t\u0015&q\u0014\u0002\b'Fc5i\u001c8g\u0003Q\u0019wN\\:ueV\u001cG\u000fV1cY\u0016\u001c6\r[3nCR91Ma+\u0003.\nE\u0006B\u0002\u001e\u0011\u0001\u0004\ty\u0004\u0003\u0004\u00030B\u0001\raY\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007bBA\b!\u0001\u0007\u00111C\u0001\u000bO\u0016$8i\u001c8uKb$\u0018aC:ue\u0016\fWn\u0016:ji\u0016$BB!/\u0003@\n\u0005'1\u0019Bf\u0005;\u00042A\u0018B^\u0013\r\u0011il\u0018\u0002\u0005\u0019>tw\r\u0003\u0004;%\u0001\u0007\u0011q\b\u0005\b\u0005\u0007\u0012\u0002\u0019\u0001B#\u0011\u001d\u0011)M\u0005a\u0001\u0005\u000f\f\u0001\"\u00193e\r&dWm\u001d\t\u0006\u007f\n%'qL\u0005\u0005\u0003o\fi\u0001C\u0004\u0003NJ\u0001\rAa4\u0002\u0005=\u0004\b\u0003\u0002Bi\u0005/tAAa\u0012\u0003T&\u0019!Q[\u001b\u0002\u001f\u0011+G\u000e^1Pa\u0016\u0014\u0018\r^5p]NLAA!7\u0003\\\n91i\u001c8wKJ$(b\u0001Bkk!9!q\u001c\nA\u0002\te\u0016\u0001\u00038v[\u001aKG.Z:\u0002-5,'oZ3TG\",W.Y:J]B\u000b'/\u00197mK2$R!\u0018Bs\u0005SDqAa:\u0014\u0001\u0004\ty$\u0001\u0007ta\u0006\u00148nU3tg&|g\u000eC\u0004\u0003lN\u0001\rA!<\u0002\u0019\u0019LG.Z:U_R{Wo\u00195\u0011\u000b}\fIAa<\u0011\t\t\u0005%\u0011_\u0005\u0005\u0005g\u0014\u0019I\u0001\u0006GS2,7\u000b^1ukN\f\u0011cQ8om\u0016\u0014H\u000f\u0015:pa\u0016\u0014H/[3t!\r\tY\u0005L\n\u0006Y\tm\u0018Q\f\t\r\u0005{\u001c\u0019!a\u001akW\u0006\u001d\u0015\u0011J\u0007\u0003\u0005\u007fT1a!\u0001`\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\u0002\u0003\u0000\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\t]\u0018!B1qa2LHCCA%\u0007\u001b\u0019ya!\u0005\u0004\u0014!9\u00111M\u0018A\u0002\u0005\u001d\u0004BBA<_\u0001\u0007!\u000e\u0003\u0004\u0002~=\u0002\ra\u001b\u0005\b\u0003\u0007{\u0003\u0019AAD\u0003\u001d)h.\u00199qYf$Ba!\u0007\u0004\"A!a,YB\u000e!%q6QDA4U.\f9)C\u0002\u0004 }\u0013a\u0001V;qY\u0016$\u0004\"CB\u0012a\u0005\u0005\t\u0019AA%\u0003\rAH\u0005M\u0001\u0018SND\u0015N^3TifdW\rU1scV,G\u000fV1cY\u0016$B!!@\u0004*!9\u00111M\u0019A\u0002\u0005%\u0004")
public abstract class ConvertToDeltaCommandBase
extends LogicalPlan
implements RunnableCommand,
DeltaCommand {
    private Seq<String> partitionColNames;
    private Seq<StructField> partitionFields;
    private volatile ConvertToDeltaCommandBase$ConvertProperties$ ConvertProperties$module;
    private final TableIdentifier tableIdentifier;
    private final Option<StructType> partitionSchema;
    private final Option<String> deltaPath;
    private final String timestampPartitionPattern;
    private scala.collection.immutable.Map<String, SQLMetric> metrics;
    private volatile byte bitmap$0;

    @Override
    public Seq<Expression> parsePartitionPredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePartitionPredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public scala.collection.immutable.Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, scala.collection.immutable.Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, scala.collection.immutable.Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, scala.collection.immutable.Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public ConvertToDeltaCommandBase$ConvertProperties$ ConvertProperties() {
        if (this.ConvertProperties$module == null) {
            this.ConvertProperties$lzycompute$1();
        }
        return this.ConvertProperties$module;
    }

    private scala.collection.immutable.Map<String, SQLMetric> metrics$lzycompute() {
        ConvertToDeltaCommandBase convertToDeltaCommandBase = this;
        synchronized (convertToDeltaCommandBase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.metrics;
    }

    public scala.collection.immutable.Map<String, SQLMetric> metrics() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.metrics$lzycompute() : this.metrics;
    }

    private Seq<String> partitionColNames$lzycompute() {
        ConvertToDeltaCommandBase convertToDeltaCommandBase = this;
        synchronized (convertToDeltaCommandBase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.partitionColNames = (Seq)this.partitionSchema.map((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.fieldNames())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.partitionColNames;
    }

    public Seq<String> partitionColNames() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.partitionColNames$lzycompute() : this.partitionColNames;
    }

    private Seq<StructField> partitionFields$lzycompute() {
        ConvertToDeltaCommandBase convertToDeltaCommandBase = this;
        synchronized (convertToDeltaCommandBase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.partitionFields = (Seq)this.partitionSchema.map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.fields())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.partitionFields;
    }

    public Seq<StructField> partitionFields() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.partitionFields$lzycompute() : this.partitionFields;
    }

    public String timestampPartitionPattern() {
        return this.timestampPartitionPattern;
    }

    public Seq<Row> run(SparkSession spark) {
        ConvertProperties convertProperties = this.getConvertProperties(spark, this.tableIdentifier);
        Option<String> option = convertProperties.provider();
        if (option instanceof Some) {
            Some some = (Some)option;
            String providerName = (String)some.value();
            String string = providerName.toLowerCase(Locale.ROOT);
            if (DeltaSourceUtils$.MODULE$.isDeltaDataSourceName(string)) {
                this.logConsole("The table you are trying to convert is already a delta table");
                return (Seq)Seq$.MODULE$.empty();
            }
            if (convertProperties.catalogTable().exists((Function1 & Serializable & scala.Serializable)catalogTable -> BoxesRunTime.boxToBoolean((boolean)this.isHiveStyleParquetTable(catalogTable)))) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string2 = string;
                String string3 = "parquet";
                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                    throw DeltaErrors$.MODULE$.convertNonParquetTablesException(this.tableIdentifier, string);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw DeltaErrors$.MODULE$.missingProviderForConvertException(convertProperties.targetDir());
            }
            throw new MatchError(option);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        DeltaLog deltaLog = DeltaLog$.MODULE$.forTable(spark, (String)this.deltaPath.getOrElse((Function0 & Serializable & scala.Serializable)() -> convertProperties.targetDir()));
        deltaLog.update(deltaLog.update$default$1());
        OptimisticTransaction txn = deltaLog.startTransaction();
        if (txn.readVersion() > -1L) {
            this.handleExistingTransactionLog(spark, txn, convertProperties);
            return (Seq)Seq$.MODULE$.empty();
        }
        return this.performConvert(spark, txn, convertProperties);
    }

    public ConvertProperties getConvertProperties(SparkSession spark, TableIdentifier tableIdentifier) {
        return new ConvertProperties(this, (Option<CatalogTable>)None$.MODULE$, (Option<String>)tableIdentifier.database(), tableIdentifier.table(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        boolean bl;
        try {
            bl = DeltaCommand.isCatalogTable$(this, analyzer, this.tableIdentifier);
        }
        catch (Throwable throwable) {
            AnalysisException analysisException;
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof AnalysisException) || !(analysisException = (AnalysisException)throwable2).getMessage().contains("Incompatible format detected")) {
                throw throwable;
            }
            boolean bl2 = !this.isPathIdentifier(this.tableIdentifier);
            bl = bl2;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        String provider = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        if (!DeltaSourceUtils$.MODULE$.isDeltaDataSourceName(provider)) {
            String string = provider;
            String string2 = "parquet";
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
        }
        if (!new Path(tableIdent.table()).isAbsolute()) return false;
        return true;
    }

    public void handleExistingTransactionLog(SparkSession spark, OptimisticTransaction txn, ConvertProperties convertProperties) {
        this.logConsole("The table you are trying to convert is already a delta table");
    }

    public Seq<Row> performConvert(SparkSession spark, OptimisticTransaction txn, ConvertProperties convertProperties) {
        return (Seq)this.recordDeltaOperation(txn.deltaLog(), "delta.convert", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            Path targetPath = new Path(convertProperties.targetDir());
            Configuration sessionHadoopConf = spark.sessionState().newHadoopConf();
            FileSystem fs = targetPath.getFileSystem(sessionHadoopConf);
            Path qualifiedPath = fs.makeQualified(targetPath);
            String qualifiedDir = qualifiedPath.toString();
            if (!fs.exists(qualifiedPath)) {
                throw DeltaErrors$.MODULE$.pathNotExistsException(qualifiedDir);
            }
            txn.deltaLog().ensureLogDirectoryExist();
            Broadcast conf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(spark.sessionState().newHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
            Dataset fileListResultDf = DeltaFileOperations$.MODULE$.recursiveListDirs(spark, (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{qualifiedDir}))), (Broadcast<SerializableConfiguration>)conf, DeltaFileOperations$.MODULE$.recursiveListDirs$default$4(), DeltaFileOperations$.MODULE$.recursiveListDirs$default$5()).where("!isDir");
            fileListResultDf.cache();
            try {
                if (!ConvertToDeltaCommandBase.fileListResult$1(fileListResultDf).hasNext()) {
                    throw DeltaErrors$.MODULE$.emptyDirectoryException(qualifiedDir);
                }
                int schemaBatchSize = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_IMPORT_BATCH_SIZE_SCHEMA_INFERENCE()));
                ObjectRef dataSchema = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
                LongRef numFiles = LongRef.create((long)0L);
                ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ConvertToDeltaCommandBase.fileListResult$1(fileListResultDf)).asScala()).grouped(schemaBatchSize).foreach((Function1 & Serializable & scala.Serializable)batch -> {
                    ConvertToDeltaCommandBase.$anonfun$performConvert$2(this, numFiles, txn, spark, dataSchema, batch);
                    return BoxedUnit.UNIT;
                });
                StructType schema = this.constructTableSchema(spark, (StructType)dataSchema.elem, this.partitionFields());
                String x$1 = schema.json();
                Seq<String> x$2 = this.partitionColNames();
                String x$3 = Metadata$.MODULE$.apply$default$1();
                String x$4 = Metadata$.MODULE$.apply$default$2();
                String x$5 = Metadata$.MODULE$.apply$default$3();
                Format x$6 = Metadata$.MODULE$.apply$default$4();
                scala.collection.immutable.Map<String, String> x$7 = Metadata$.MODULE$.apply$default$7();
                Option<Object> x$8 = Metadata$.MODULE$.apply$default$8();
                Metadata metadata = new Metadata(x$3, x$4, x$5, x$6, x$1, x$2, x$7, x$8);
                txn.updateMetadata(metadata);
                int statsBatchSize = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_IMPORT_BATCH_SIZE_STATS_COLLECTION()));
                Iterator addFilesIter = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(ConvertToDeltaCommandBase.fileListResult$1(fileListResultDf)).asScala()).grouped(statsBatchSize).flatMap((Function1 & Serializable & scala.Serializable)batch -> {
                    Seq adds = (Seq)batch.map((Function1 & Serializable & scala.Serializable)x$4 -> this.createAddFile((SerializableFileStatus)x$4, txn.deltaLog().dataPath(), fs, spark.sessionState().conf()), Seq$.MODULE$.canBuildFrom());
                    return adds.toIterator();
                });
                this.streamWrite(spark, txn, (Iterator<AddFile>)addFilesIter, new DeltaOperations.Convert(numFiles.elem, this.partitionColNames(), false, (Option<String>)None$.MODULE$), numFiles.elem);
            }
            finally {
                fileListResultDf.unpersist();
            }
            return (Seq)Seq$.MODULE$.empty();
        });
    }

    public AddFile createAddFile(SerializableFileStatus file, Path basePath, FileSystem fs, SQLConf conf) {
        String string;
        Option partitionOpt;
        Path path = file.getPath();
        String pathStr = file.getPath().toUri().toString();
        DateFormatter dateFormatter = DateFormatter$.MODULE$.apply();
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(this.timestampPartitionPattern(), TimeZone.getDefault());
        Function2 resolver = conf.resolver();
        Path dir = file.isDir() ? file.getPath() : file.getPath().getParent();
        Tuple2<Option<PartitionUtils.PartitionValues>, Option<Path>> tuple2 = PartitionUtils$.MODULE$.parsePartition(dir, false, (Set<Path>)Predef$.MODULE$.Set().empty(), (scala.collection.immutable.Map<String, DataType>)Predef$.MODULE$.Map().empty(), false, TimeZone.getDefault(), dateFormatter, timestampFormatter);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = partitionOpt = (Option)tuple2._1();
        Option partitionOpt2 = option;
        scala.collection.immutable.Map partition = (scala.collection.immutable.Map)partitionOpt2.map((Function1 & Serializable & scala.Serializable)partValues -> {
            if (this.partitionColNames().size() != partValues.columnNames().size()) {
                throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, partValues.columnNames(), this.partitionColNames());
            }
            Option tz = Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone());
            ((IterableLike)partValues.literals().zip(this.partitionFields(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ConvertToDeltaCommandBase.$anonfun$createAddFile$2(tz, x0$1);
                return BoxedUnit.UNIT;
            });
            Seq values = (Seq)((TraversableLike)partValues.literals().map((Function1 & Serializable & scala.Serializable)l -> {
                Cast qual$3 = new Cast((Expression)l, (DataType)StringType$.MODULE$, tz);
                InternalRow x$3 = qual$3.eval$default$1();
                return qual$3.eval(x$3);
            }, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> (String)Option$.MODULE$.apply(x$6).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.toString()).orNull(Predef$.MODULE$.$conforms()), Seq$.MODULE$.canBuildFrom());
            ((IterableLike)this.partitionColNames().zip(partValues.columnNames(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ConvertToDeltaCommandBase.$anonfun$createAddFile$7(resolver, pathStr, x0$2);
                return BoxedUnit.UNIT;
            });
            return ((TraversableOnce)this.partitionColNames().zip((GenIterable)values, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (this.partitionColNames().nonEmpty()) {
                throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, (Seq<String>)((Seq)Seq$.MODULE$.empty()), this.partitionColNames());
            }
            return (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        });
        if (this.deltaPath.isEmpty()) {
            Path relativePath = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, basePath, path);
            Predef$.MODULE$.assert(!relativePath.isAbsolute(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Fail to relativize path ").append(path).append(" against base path ").append(basePath).append(".").toString());
            string = relativePath.toUri().toString();
        } else {
            string = path.toUri().toString();
        }
        String pathStrForAddFile = string;
        return new AddFile(pathStrForAddFile, (scala.collection.immutable.Map<String, String>)partition, file.length(), file.modificationTime(), true, AddFile$.MODULE$.apply$default$6(), AddFile$.MODULE$.apply$default$7());
    }

    public StructType constructTableSchema(SparkSession spark, StructType dataSchema, Seq<StructField> partitionFields) {
        Map overlappedPartCols = Map$.MODULE$.empty();
        partitionFields.foreach((Function1 & Serializable & scala.Serializable)partitionField -> dataSchema.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ConvertToDeltaCommandBase.$anonfun$constructTableSchema$2(partitionField, spark, x$8))) ? overlappedPartCols.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConvertToDeltaCommandBase.getColName$1(partitionField, spark)), partitionField)) : BoxedUnit.UNIT);
        return StructType$.MODULE$.apply((Seq)((TraversableLike)dataSchema.map((Function1 & Serializable & scala.Serializable)f -> (StructField)overlappedPartCols.getOrElse((Object)ConvertToDeltaCommandBase.getColName$1(f, spark), (Function0 & Serializable & scala.Serializable)() -> f), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionFields.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)overlappedPartCols.contains((Object)ConvertToDeltaCommandBase.getColName$1(f, spark)))), Seq$.MODULE$.canBuildFrom()));
    }

    public scala.collection.immutable.Map<String, String> getContext() {
        return Predef$.MODULE$.Map().empty();
    }

    public long streamWrite(SparkSession spark, OptimisticTransaction txn, Iterator<AddFile> addFiles, DeltaOperations.Convert op, long numFiles) {
        long l;
        long firstVersion = 0L;
        try {
            DeltaLog deltaLog = txn.deltaLog();
            Metadata metadata = txn.metadata();
            scala.collection.immutable.Map<String, String> context = this.getContext();
            None$ metrics = BoxesRunTime.unboxToBoolean((Object)spark.conf().get(DeltaSQLConf$.MODULE$.DELTA_HISTORY_METRICS_ENABLED())) ? new Some((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numConvertedFiles"), (Object)((Object)BoxesRunTime.boxToLong((long)numFiles)).toString())}))) : None$.MODULE$;
            CommitInfo commitInfo = CommitInfo$.MODULE$.apply(txn.clock().getTimeMillis(), op.name(), op.jsonEncodedValues(), context, (Option<Object>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<scala.collection.immutable.Map<String, String>>)metrics);
            Seq extraActions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{commitInfo, new Protocol(Protocol$.MODULE$.apply$default$1(), Protocol$.MODULE$.apply$default$2()), metadata}));
            Iterator actions = extraActions.toIterator().$plus$plus((Function0 & Serializable & scala.Serializable)() -> addFiles);
            deltaLog.store().write(FileNames$.MODULE$.deltaFile(deltaLog.logPath(), firstVersion), (Iterator<String>)actions.map((Function1 & Serializable & scala.Serializable)x$9 -> ((Action)x$9).json()), deltaLog.store().write$default$3());
            Snapshot currentSnapshot = deltaLog.update(deltaLog.update$default$1());
            if (currentSnapshot.version() != firstVersion) {
                throw new IllegalStateException(new StringBuilder(53).append("The committed version is ").append(firstVersion).append(" but the current version is ").append(new StringBuilder(36).append(currentSnapshot.version()).append(". Please contact Databricks support.").toString()).toString());
            }
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Committed delta #").append(firstVersion).append(" to ").append(deltaLog.logPath()).toString());
            try {
                deltaLog.checkpoint();
            }
            catch (IllegalStateException e) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Failed to checkpoint table state.", e);
            }
            l = firstVersion;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FileAlreadyExistsException) {
                FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                DeltaLog x$1 = txn.deltaLog();
                String x$2 = "delta.convert.commitFailure";
                scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)Utils$.MODULE$.exceptionString((Throwable)fileAlreadyExistsException))}));
                scala.collection.immutable.Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                this.recordDeltaEvent(x$1, x$2, x$4, x$3);
                throw DeltaErrors$.MODULE$.commitAlreadyExistsException(firstVersion, txn.deltaLog().logPath());
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                DeltaLog x$5 = txn.deltaLog();
                String x$6 = "delta.convert.commitFailure";
                scala.collection.immutable.Map x$7 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)Utils$.MODULE$.exceptionString(e))}));
                scala.collection.immutable.Map<TagDefinition, String> x$8 = this.recordDeltaEvent$default$3();
                this.recordDeltaEvent(x$5, x$6, x$8, x$7);
                throw e;
            }
            throw throwable;
        }
        return l;
    }

    public Option<StructType> mergeSchemasInParallel(SparkSession sparkSession, Seq<FileStatus> filesToTouch) {
        None$ none$;
        boolean x$2;
        Function1 & Serializable & scala.Serializable x$1;
        boolean assumeBinaryIsString = sparkSession.sessionState().conf().isParquetBinaryAsString();
        boolean assumeInt96IsTimestamp = sparkSession.sessionState().conf().isParquetINT96AsTimestamp();
        SerializableConfiguration serializedConf = new SerializableConfiguration(sparkSession.sessionState().newHadoopConf());
        Seq partialFileStatusInfo = (Seq)filesToTouch.map((Function1 & Serializable & scala.Serializable)f -> new Tuple2((Object)f.getPath().toString(), (Object)BoxesRunTime.boxToLong((long)f.getLen())), Seq$.MODULE$.canBuildFrom());
        int numParallelism = Math.min(Math.max(partialFileStatusInfo.size(), 1), sparkSession.sparkContext().defaultParallelism());
        boolean ignoreCorruptFiles = sparkSession.sessionState().conf().ignoreCorruptFiles();
        RDD qual$1 = sparkSession.sparkContext().parallelize(partialFileStatusInfo, numParallelism, ClassTag$.MODULE$.apply(Tuple2.class));
        StructType[] partiallyMergedSchemas = (StructType[])qual$1.mapPartitions((Function1)(x$1 = (Function1 & Serializable & scala.Serializable)iterator -> {
            Iterator iterator2;
            Seq fakeFileStatuses = iterator.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String path = (String)tuple2._1();
                long length = tuple2._2$mcJ$sp();
                FileStatus fileStatus = new FileStatus(length, false, 0, 0L, 0L, 0L, null, null, null, new Path(path));
                return fileStatus;
            }).toSeq();
            Seq<Footer> footers = DeltaFileOperations$.MODULE$.readParquetFootersInParallel(serializedConf.value(), (Seq<FileStatus>)fakeFileStatuses, ignoreCorruptFiles);
            ParquetToSparkSchemaConverter converter = new ParquetToSparkSchemaConverter(assumeBinaryIsString, assumeInt96IsTimestamp);
            if (footers.isEmpty()) {
                iterator2 = package$.MODULE$.Iterator().empty();
            } else {
                ObjectRef mergedSchema = ObjectRef.create((Object)ParquetFileFormat$.MODULE$.readSchemaFromFooter((Footer)footers.head(), converter));
                ((IterableLike)footers.tail()).foreach((Function1 & Serializable & scala.Serializable)footer -> {
                    ConvertToDeltaCommandBase.$anonfun$mergeSchemasInParallel$4(converter, mergedSchema, footer);
                    return BoxedUnit.UNIT;
                });
                iterator2 = package$.MODULE$.Iterator().single((Object)((StructType)mergedSchema.elem));
            }
            return iterator2;
        }), x$2 = qual$1.mapPartitions$default$2(), ClassTag$.MODULE$.apply(StructType.class)).collect();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            ObjectRef finalSchema = ObjectRef.create((Object)((StructType)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).head()));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas)).tail())).foreach((Function1 & Serializable & scala.Serializable)schema -> {
                finalSchema.elem = SchemaUtils$.MODULE$.mergeSchemas((StructType)finalSchema.elem, schema);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)((StructType)finalSchema.elem));
        }
        return none$;
    }

    private boolean isHiveStyleParquetTable(CatalogTable catalogTable) {
        return catalogTable.provider().contains((Object)"hive") && catalogTable.storage().serde().contains((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe");
    }

    private final void ConvertProperties$lzycompute$1() {
        ConvertToDeltaCommandBase convertToDeltaCommandBase = this;
        synchronized (convertToDeltaCommandBase) {
            if (this.ConvertProperties$module == null) {
                this.ConvertProperties$module = new ConvertToDeltaCommandBase$ConvertProperties$(this);
            }
        }
    }

    private static final java.util.Iterator fileListResult$1(Dataset fileListResultDf$1) {
        return fileListResultDf$1.toLocalIterator();
    }

    public static final /* synthetic */ void $anonfun$performConvert$2(ConvertToDeltaCommandBase $this, LongRef numFiles$1, OptimisticTransaction txn$1, SparkSession spark$1, ObjectRef dataSchema$1, Seq batch) {
        numFiles$1.elem += (long)batch.size();
        StructType batchSchema = ((StructType)$this.recordDeltaOperation(txn$1.deltaLog(), "delta.convert.schemaInference", $this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> (StructType)$this.mergeSchemasInParallel(spark$1, (Seq<FileStatus>)((Seq)batch.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toFileStatus(), Seq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Failed to infer schema from the given list of files.");
        }))).asNullable();
        dataSchema$1.elem = SchemaUtils$.MODULE$.mergeSchemas((StructType)dataSchema$1.elem, batchSchema);
    }

    public static final /* synthetic */ void $anonfun$createAddFile$2(Option tz$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            InternalRow x$1;
            Cast qual$1;
            Literal literal = (Literal)tuple2._1();
            StructField field = (StructField)tuple2._2();
            if (literal.eval(literal.eval$default$1()) != null && (qual$1 = new Cast((Expression)literal, field.dataType(), tz$1)).eval(x$1 = qual$1.eval$default$1()) == null) {
                Cast qual$2 = new Cast((Expression)literal, (DataType)StringType$.MODULE$, tz$1);
                InternalRow x$2 = qual$2.eval$default$1();
                Object partitionValue = qual$2.eval(x$2);
                String partitionValueStr = (String)Option$.MODULE$.apply(partitionValue).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toString()).orNull(Predef$.MODULE$.$conforms());
                throw DeltaErrors$.MODULE$.castPartitionValueException(partitionValueStr, field.dataType());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$createAddFile$7(Function2 resolver$1, String pathStr$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String parsed;
            String expected = (String)tuple2._1();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)expected, (Object)(parsed = (String)tuple2._2())))) {
                throw DeltaErrors$.MODULE$.unexpectedPartitionColumnFromFileNameException(pathStr$1, parsed, expected);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final String getColName$1(StructField f, SparkSession spark$2) {
        return spark$2.sessionState().conf().caseSensitiveAnalysis() ? f.name() : f.name().toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ boolean $anonfun$constructTableSchema$2(StructField partitionField$1, SparkSession spark$2, StructField x$8) {
        String string = ConvertToDeltaCommandBase.getColName$1(x$8, spark$2);
        String string2 = ConvertToDeltaCommandBase.getColName$1(partitionField$1, spark$2);
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$mergeSchemasInParallel$4(ParquetToSparkSchemaConverter converter$1, ObjectRef mergedSchema$1, Footer footer) {
        StructType schema = ParquetFileFormat$.MODULE$.readSchemaFromFooter(footer, converter$1);
        try {
            mergedSchema$1.elem = SchemaUtils$.MODULE$.mergeSchemas((StructType)mergedSchema$1.elem, schema);
        }
        catch (AnalysisException cause) {
            throw new SparkException(new StringBuilder(33).append("Failed to merge schema of file ").append(footer.getFile()).append(":\n").append(schema.treeString()).toString(), (Throwable)cause);
        }
    }

    public ConvertToDeltaCommandBase(TableIdentifier tableIdentifier, Option<StructType> partitionSchema, Option<String> deltaPath) {
        this.tableIdentifier = tableIdentifier;
        this.partitionSchema = partitionSchema;
        this.deltaPath = deltaPath;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        this.timestampPartitionPattern = "yyyy-MM-dd HH:mm:ss[.S]";
    }

    public class ConvertProperties
    implements Product,
    scala.Serializable {
        private final Option<CatalogTable> catalogTable;
        private final Option<String> provider;
        private final String targetDir;
        private final scala.collection.immutable.Map<String, String> properties;
        public final /* synthetic */ ConvertToDeltaCommandBase $outer;

        public Option<CatalogTable> catalogTable() {
            return this.catalogTable;
        }

        public Option<String> provider() {
            return this.provider;
        }

        public String targetDir() {
            return this.targetDir;
        }

        public scala.collection.immutable.Map<String, String> properties() {
            return this.properties;
        }

        public ConvertProperties copy(Option<CatalogTable> catalogTable, Option<String> provider, String targetDir, scala.collection.immutable.Map<String, String> properties) {
            return new ConvertProperties(this.org$apache$spark$sql$delta$commands$ConvertToDeltaCommandBase$ConvertProperties$$$outer(), catalogTable, provider, targetDir, properties);
        }

        public Option<CatalogTable> copy$default$1() {
            return this.catalogTable();
        }

        public Option<String> copy$default$2() {
            return this.provider();
        }

        public String copy$default$3() {
            return this.targetDir();
        }

        public scala.collection.immutable.Map<String, String> copy$default$4() {
            return this.properties();
        }

        public String productPrefix() {
            return "ConvertProperties";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.catalogTable();
                    break;
                }
                case 1: {
                    object = this.provider();
                    break;
                }
                case 2: {
                    object = this.targetDir();
                    break;
                }
                case 3: {
                    object = this.properties();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConvertProperties;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConvertProperties)) return false;
            if (((ConvertProperties)object).org$apache$spark$sql$delta$commands$ConvertToDeltaCommandBase$ConvertProperties$$$outer() != this.org$apache$spark$sql$delta$commands$ConvertToDeltaCommandBase$ConvertProperties$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            ConvertProperties convertProperties = (ConvertProperties)x$1;
            Option<CatalogTable> option = this.catalogTable();
            Option<CatalogTable> option2 = convertProperties.catalogTable();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<String> option3 = this.provider();
            Option<String> option4 = convertProperties.provider();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            String string = this.targetDir();
            String string2 = convertProperties.targetDir();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            scala.collection.immutable.Map<String, String> map = this.properties();
            scala.collection.immutable.Map<String, String> map2 = convertProperties.properties();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!convertProperties.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ConvertToDeltaCommandBase org$apache$spark$sql$delta$commands$ConvertToDeltaCommandBase$ConvertProperties$$$outer() {
            return this.$outer;
        }

        public ConvertProperties(ConvertToDeltaCommandBase $outer, Option<CatalogTable> catalogTable, Option<String> provider, String targetDir, scala.collection.immutable.Map<String, String> properties) {
            this.catalogTable = catalogTable;
            this.provider = provider;
            this.targetDir = targetDir;
            this.properties = properties;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

