/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.storage;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.storage.HadoopFileSystemLogStore;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\u0007\u000e\u0001iA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)1\u0007\u0001C\u0001i!)\u0001\b\u0001C\ts!9Q\t\u0001b\u0001\n\u00031\u0005BB(\u0001A\u0003%q\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0004t\u0001E\u0005I\u0011\u0001;\t\r}\u0004A\u0011BA\u0001\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!a\u0005\u0001\t\u0003\n)B\u0001\u0007I\t\u001a\u001bFj\\4Ti>\u0014XM\u0003\u0002\u000f\u001f\u000591\u000f^8sC\u001e,'B\u0001\t\u0012\u0003\u0015!W\r\u001c;b\u0015\t\u00112#A\u0002tc2T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011d\b\t\u00039ui\u0011!D\u0005\u0003=5\u0011\u0001\u0004S1e_>\u0004h)\u001b7f'f\u001cH/Z7M_\u001e\u001cFo\u001c:f!\t\u00013%D\u0001\"\u0015\t\u00113#\u0001\u0005j]R,'O\\1m\u0013\t!\u0013EA\u0004M_\u001e<\u0017N\\4\u0002\u0013M\u0004\u0018M]6D_:4\u0007CA\u0014)\u001b\u0005\u0019\u0012BA\u0015\u0014\u0005%\u0019\u0006/\u0019:l\u0007>tg-A\teK\u001a\fW\u000f\u001c;IC\u0012|w\u000e]\"p]\u001a\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\t\r|gN\u001a\u0006\u0003aU\ta\u0001[1e_>\u0004\u0018B\u0001\u001a.\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"2!\u000e\u001c8!\ta\u0002\u0001C\u0003&\u0007\u0001\u0007a\u0005C\u0003+\u0007\u0001\u00071&\u0001\bhKR4\u0015\u000e\\3D_:$X\r\u001f;\u0015\u0005i\u0002\u0005CA\u001e?\u001b\u0005a$BA\u001f0\u0003\t17/\u0003\u0002@y\tYa)\u001b7f\u0007>tG/\u001a=u\u0011\u0015\tE\u00011\u0001C\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005m\u001a\u0015B\u0001#=\u0005\u0011\u0001\u0016\r\u001e5\u0002I9|\u0017IY:ue\u0006\u001cGOR5mKNK8\u000f^3n\u000bb\u001cW\r\u001d;j_:lUm]:bO\u0016,\u0012a\u0012\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000bA\u0001\\1oO*\tA*\u0001\u0003kCZ\f\u0017B\u0001(J\u0005\u0019\u0019FO]5oO\u0006)cn\\!cgR\u0014\u0018m\u0019;GS2,7+_:uK6,\u0005pY3qi&|g.T3tg\u0006<W\rI\u0001\u0006oJLG/\u001a\u000b\u0005%bKf\u000e\u0005\u0002T-6\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FK\u0001\u0003V]&$\b\"B!\b\u0001\u0004\u0011\u0005\"\u0002.\b\u0001\u0004Y\u0016aB1di&|gn\u001d\t\u00049\u0012<gBA/c\u001d\tq\u0016-D\u0001`\u0015\t\u0001\u0017$\u0001\u0004=e>|GOP\u0005\u0002+&\u00111\rV\u0001\ba\u0006\u001c7.Y4f\u0013\t)gM\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t\u0019G\u000b\u0005\u0002iY:\u0011\u0011N\u001b\t\u0003=RK!a\u001b+\u0002\rA\u0013X\rZ3g\u0013\tqUN\u0003\u0002l)\"9qn\u0002I\u0001\u0002\u0004\u0001\u0018!C8wKJ<(/\u001b;f!\t\u0019\u0016/\u0003\u0002s)\n9!i\\8mK\u0006t\u0017aD<sSR,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003UT#\u0001\u001d<,\u0003]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\u0013Ut7\r[3dW\u0016$'B\u0001?U\u0003)\tgN\\8uCRLwN\\\u0005\u0003}f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u000359(/\u001b;f\u0013:$XM\u001d8bYR9!+a\u0001\u0002\u0006\u0005\u001d\u0001\"B!\n\u0001\u0004\u0011\u0005\"\u0002.\n\u0001\u0004Y\u0006\"B8\n\u0001\u0004\u0001\u0018\u0001\u0005;ssJ+Wn\u001c<f\u0007J\u001cg)\u001b7f)\u0015\u0011\u0016QBA\t\u0011\u0019\tyA\u0003a\u0001u\u0005\u0011am\u0019\u0005\u0006\u0003*\u0001\rAQ\u0001\u0016SN\u0004\u0016M\u001d;jC2<&/\u001b;f-&\u001c\u0018N\u00197f)\r\u0001\u0018q\u0003\u0005\u0006\u0003.\u0001\rA\u0011")
public class HDFSLogStore
extends HadoopFileSystemLogStore
implements Logging {
    private final SparkConf sparkConf;
    private final String noAbstractFileSystemExceptionMessage;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public FileContext getFileContext(Path path) {
        return FileContext.getFileContext((URI)path.toUri(), (Configuration)this.getHadoopConfiguration());
    }

    public String noAbstractFileSystemExceptionMessage() {
        return this.noAbstractFileSystemExceptionMessage;
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        boolean isLocalFs = path.getFileSystem(this.getHadoopConfiguration()) instanceof RawLocalFileSystem;
        if (isLocalFs) {
            HDFSLogStore hDFSLogStore = this;
            synchronized (hDFSLogStore) {
                this.writeInternal(path, actions, overwrite);
            }
        } else {
            this.writeInternal(path, actions, overwrite);
        }
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private void writeInternal(Path path, Iterator<String> actions, boolean overwrite) {
        FileContext fileContext;
        try {
            fileContext = this.getFileContext(path);
        }
        catch (Throwable throwable) {
            IOException iOException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException && (iOException = (IOException)throwable2).getMessage().contains(this.noAbstractFileSystemExceptionMessage())) {
                Throwable newException = DeltaErrors$.MODULE$.incorrectLogStoreImplementationException(this.sparkConf, iOException);
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> newException.getMessage(), newException.getCause());
                throw newException;
            }
            throw throwable;
        }
        FileContext fc = fileContext;
        if (!overwrite && fc.util().exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        Path tempPath = this.createTempPath(path);
        boolean streamClosed = false;
        boolean renameDone = false;
        FSDataOutputStream stream = fc.create(tempPath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.checksumParam((Options.ChecksumOpt)Options.ChecksumOpt.createDisabled())});
        try {
            actions.map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                Options.Rename renameOpt = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
                fc.rename(tempPath, path, new Options.Rename[]{renameOpt});
                renameDone = true;
                this.tryRemoveCrcFile(fc, tempPath);
            }
            catch (FileAlreadyExistsException e) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!renameDone) {
                fc.delete(tempPath, false);
            }
        }
    }

    private void tryRemoveCrcFile(FileContext fc, Path path) {
        try {
            Path checksumFile = new Path(path.getParent(), new StringBuilder(5).append(".").append(path.getName()).append(".crc").toString());
            if (fc.util().exists(checksumFile)) {
                fc.delete(checksumFile, true);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    public HDFSLogStore(SparkConf sparkConf, Configuration defaultHadoopConf) {
        this.sparkConf = sparkConf;
        super(sparkConf, defaultHadoopConf);
        Logging.$init$((Logging)this);
        this.noAbstractFileSystemExceptionMessage = "No AbstractFileSystem";
    }
}

