/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Branch", generator="Immutables")
@Immutable
public final class ImmutableBranch
implements Branch {
    private final String name;
    @Nullable
    private final String hash;
    private final transient int hashCode;

    private ImmutableBranch(String name, @Nullable String hash) {
        this.name = name;
        this.hash = hash;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="hash")
    @Nullable
    public String getHash() {
        return this.hash;
    }

    public final ImmutableBranch withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableBranch.validate(new ImmutableBranch(newValue, this.hash));
    }

    public final ImmutableBranch withHash(@Nullable String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return ImmutableBranch.validate(new ImmutableBranch(this.name, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBranch && this.equalTo((ImmutableBranch)another);
    }

    private boolean equalTo(ImmutableBranch another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.name.equals(another.name) && Objects.equals(this.hash, another.hash);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.hash);
        return h;
    }

    public String toString() {
        return "Branch{name=" + this.name + ", hash=" + this.hash + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBranch fromJson(Json json) {
        Builder builder = ImmutableBranch.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        return builder.build();
    }

    private static ImmutableBranch validate(ImmutableBranch instance) {
        instance.checkName();
        instance.checkHash();
        return instance;
    }

    public static ImmutableBranch copyOf(Branch instance) {
        if (instance instanceof ImmutableBranch) {
            return (ImmutableBranch)instance;
        }
        return ImmutableBranch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Branch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private String hash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Reference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Branch instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof Reference) {
                Reference instance = (Reference)object;
                this.name(instance.getName());
                String hashValue = instance.getHash();
                if (hashValue != null) {
                    this.hash(hashValue);
                }
            }
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder hash(@Nullable String hash) {
            this.hash = hash;
            return this;
        }

        public ImmutableBranch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableBranch.validate(new ImmutableBranch(this.name, this.hash));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Branch, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Branch", generator="Immutables")
    static final class Json
    implements Branch {
        @Nullable
        String name;
        @Nullable
        String hash;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="hash")
        public void setHash(@Nullable String hash) {
            this.hash = hash;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }
    }
}

