/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.deltalake;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.DeltaFileType;
import org.apache.spark.sql.delta.DeltaFileType$CHECKPOINT$;
import org.apache.spark.sql.delta.DeltaFileType$CHECKSUM$;
import org.apache.spark.sql.delta.DeltaFileType$DELTA$;
import org.apache.spark.sql.delta.DeltaFileType$UNKNOWN$;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.projectnessie.client.NessieClient;
import org.projectnessie.deltalake.CatalogNameUtil$;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.DeltaLakeTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableOperations;
import org.projectnessie.model.Operation;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u00193\u0001eB\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I!\u0016\u0005\t3\u0002\u0011\t\u0011)A\u00055\")!\r\u0001C\u0001G\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007B\u0002;\u0001A\u0003%!\u000eC\u0004v\u0001\t\u0007I\u0011A5\t\rY\u0004\u0001\u0015!\u0003k\u0011\u001d9\bA1A\u0005\u0002%Da\u0001\u001f\u0001!\u0002\u0013Q\u0007bB=\u0001\u0001\u0004%\tA\u001f\u0005\n\u0003'\u0001\u0001\u0019!C\u0001\u0003+Aq!!\t\u0001A\u0003&1\u0010C\u0005\u0002$\u0001\u0011\r\u0011\"\u0003\u0002&!A\u0011\u0011\u0007\u0001!\u0002\u0013\t9\u0003C\u0004\u00024\u0001!I!!\u000e\t\u000f\u0005]\u0002\u0001\"\u0003\u00026!9\u0011\u0011\b\u0001\u0005\n\u0005m\u0002\"CA\"\u0001\t\u0007I\u0011BA#\u0011!\tI\u0006\u0001Q\u0001\n\u0005\u001d\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003?\u0002A\u0011BA1\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002v\u0001!\t%a\u001e\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011Q\u0016\u0001\u0005B\u0005=\u0006\"CAb\u0001E\u0005I\u0011AAc\u0011\u001d\tY\u000e\u0001C\u0005\u0003;D\u0011\"a<\u0001#\u0003%I!!=\t\u000f\u0005U\b\u0001\"\u0003\u0002x\"9!q\u0002\u0001\u0005\n\tE\u0001b\u0002B\u000f\u0001\u0011%!q\u0004\u0005\n\u0005_\u0001\u0011\u0013!C\u0005\u0003cD\u0011B!\r\u0001#\u0003%I!!=\t\u000f\tM\u0002\u0001\"\u0005\u00036!9!q\b\u0001\u0005\u0002\t\u0005\u0003b\u0002B \u0001\u0011\u0005!1\n\u0005\b\u0005\u001f\u0002A\u0011\u0001B)\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005?BqAa\u001b\u0001\t\u0003\u0011i\u0007C\u0004\u0003z\u0001!\tAa\u001f\t\u000f\t}\u0004\u0001\"\u0001\u0003\u0002\"9!q\u0011\u0001\u0005\n\t%\u0005b\u0002BJ\u0001\u0011%!Q\u0013\u0005\b\u0005?\u0003A\u0011\tBQ\u0011\u001d\u0011)\u000b\u0001C!\u0005OCqA!+\u0001\t\u0003\u0012Y\u000bC\u0004\u00030\u0002!\tE!-\u0003\u001d9+7o]5f\u0019><7\u000b^8sK*\u00111\u0007N\u0001\nI\u0016dG/\u00197bW\u0016T!!\u000e\u001c\u0002\u001bA\u0014xN[3di:,7o]5f\u0015\u00059\u0014aA8sO\u000e\u00011\u0003\u0002\u0001;\u0001:\u0003\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u0012a!\u00118z%\u00164\u0007CA!M\u001b\u0005\u0011%BA\"E\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0012$\u0002\u000b\u0011,G\u000e^1\u000b\u0005\u001dC\u0015aA:rY*\u0011\u0011JS\u0001\u0006gB\f'o\u001b\u0006\u0003\u0017Z\na!\u00199bG\",\u0017BA'C\u0005!aunZ*u_J,\u0007CA(S\u001b\u0005\u0001&BA)I\u0003!Ig\u000e^3s]\u0006d\u0017BA*Q\u0005\u001daunZ4j]\u001e\f\u0011b\u001d9be.\u001cuN\u001c4\u0011\u0005Y;V\"\u0001%\n\u0005aC%!C*qCJ\\7i\u001c8g\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u00037\u0002l\u0011\u0001\u0018\u0006\u0003;z\u000bAaY8oM*\u0011qLS\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0005d&!D\"p]\u001aLw-\u001e:bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004I\u001a<\u0007CA3\u0001\u001b\u0005\u0011\u0004\"\u0002+\u0004\u0001\u0004)\u0006\"B-\u0004\u0001\u0004Q\u0016\u0001\u00053fYR\fg)\u001b7f!\u0006$H/\u001a:o+\u0005Q\u0007CA6s\u001b\u0005a'BA7o\u0003\u0015\u0011XmZ3y\u0015\ty\u0007/\u0001\u0003vi&d'\"A9\u0002\t)\fg/Y\u0005\u0003g2\u0014q\u0001U1ui\u0016\u0014h.A\teK2$\u0018MR5mKB\u000bG\u000f^3s]\u0002\n1c\u00195fG.\u001cX/\u001c$jY\u0016\u0004\u0016\r\u001e;fe:\fAc\u00195fG.\u001cX/\u001c$jY\u0016\u0004\u0016\r\u001e;fe:\u0004\u0013!F2iK\u000e\\\u0007o\\5oi\u001aKG.\u001a)biR,'O\\\u0001\u0017G\",7m\u001b9pS:$h)\u001b7f!\u0006$H/\u001a:oA\u0005\u0001B.Y:u':\f\u0007o\u001d5piV+\u0018\u000eZ\u000b\u0002wB\u00191\b @\n\u0005ud$AB(qi&|g\u000eE\u0002\u0000\u0003\u001bqA!!\u0001\u0002\nA\u0019\u00111\u0001\u001f\u000e\u0005\u0005\u0015!bAA\u0004q\u00051AH]8pizJ1!a\u0003=\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA\t\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0002\u001f\u0002)1\f7\u000f^*oCB\u001c\bn\u001c;Vk&$w\fJ3r)\u0011\t9\"!\b\u0011\u0007m\nI\"C\u0002\u0002\u001cq\u0012A!\u00168ji\"A\u0011qD\u0006\u0002\u0002\u0003\u000710A\u0002yIE\n\u0011\u0003\\1tiNs\u0017\r]:i_R,V/\u001b3!\u0003\u0019\u0019G.[3oiV\u0011\u0011q\u0005\t\u0005\u0003S\ti#\u0004\u0002\u0002,)\u0019\u00111\u0005\u001b\n\t\u0005=\u00121\u0006\u0002\r\u001d\u0016\u001c8/[3DY&,g\u000e^\u0001\bG2LWM\u001c;!\u0003-\u0019\u0017\r^1m_\u001et\u0015-\\3\u0015\u0003y\fa\u0001\u001d:fM&D\u0018aC2bi\u0006dwnZ\"p]\u001a,\"!!\u0010\u0011\u000b}\fyD @\n\t\u0005\u0005\u0013\u0011\u0003\u0002\u0004\u001b\u0006\u0004\u0018\u0001\u0004:fM\u0016\u0014XM\\2f\u001b\u0006\u0004XCAA$!\u001d\tI%a\u0013\u007f\u0003\u001bj\u0011A\\\u0005\u0004\u0003\u0003r\u0007\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005MC'A\u0003n_\u0012,G.\u0003\u0003\u0002X\u0005E#!\u0003*fM\u0016\u0014XM\\2f\u00035\u0011XMZ3sK:\u001cW-T1qA\u0005i1m\u001c8gS\u001e,(/\u001a3SK\u001a$\"!!\u0014\u0002\u001fI,g-\u001a:f]\u000e,')\u001f(b[\u0016$B!!\u0014\u0002d!1\u0011QM\u000bA\u0002y\fqA]3g\u001d\u0006lW-A\bva\u0012\fG/\u001a*fM\u0016\u0014XM\\2f)\u0011\t9\"a\u001b\t\u000f\u00055d\u00031\u0001\u0002N\u0005\u0019!/\u001a4\u0002!I,gM]3tQJ+g-\u001a:f]\u000e,G\u0003BA\f\u0003gBa!!\u001a\u0018\u0001\u0004q\u0018\u0001\u00037jgR4%o\\7\u0015\t\u0005e\u0014q\u0013\t\u0007\u0003w\n))a#\u000f\t\u0005u\u0014\u0011\u0011\b\u0005\u0003\u0007\ty(C\u0001>\u0013\r\t\u0019\tP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9)!#\u0003\u0011%#XM]1u_JT1!a!=!\u0011\ti)a%\u000e\u0005\u0005=%bAAI=\u0006\u0011am]\u0005\u0005\u0003+\u000byI\u0001\u0006GS2,7\u000b^1ukNDq!!'\u0019\u0001\u0004\tY*\u0001\u0003qCRD\u0007\u0003BAG\u0003;KA!a(\u0002\u0010\n!\u0001+\u0019;i\u0003Q\u0001\u0018M]:f)\u0006\u0014G.Z%eK:$\u0018NZ5feR!\u0011QUAV!\u0019Y\u0014q\u0015@\u007f}&\u0019\u0011\u0011\u0016\u001f\u0003\rQ+\b\u000f\\34\u0011\u0019\tI*\u0007a\u0001}\u0006)qO]5uKRA\u0011qCAY\u0003g\u000bI\fC\u0004\u0002\u001aj\u0001\r!a'\t\u000f\u0005U&\u00041\u0001\u00028\u00069\u0011m\u0019;j_:\u001c\b#BA>\u0003\u000bs\b\"CA^5A\u0005\t\u0019AA_\u0003%yg/\u001a:xe&$X\rE\u0002<\u0003\u007fK1!!1=\u0005\u001d\u0011un\u001c7fC:\fqb\u001e:ji\u0016$C-\u001a4bk2$HeM\u000b\u0003\u0003\u000fTC!!0\u0002J.\u0012\u00111\u001a\t\u0005\u0003\u001b\f9.\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003%)hn\u00195fG.,GMC\u0002\u0002Vr\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI.a4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\tva\u0012\fG/\u001a#fYR\fG+\u00192mKRA\u0011q\\As\u0003O\fY\u000f\u0005\u0003\u0002P\u0005\u0005\u0018\u0002BAr\u0003#\u0012a\u0002R3mi\u0006d\u0015m[3UC\ndW\rC\u0004\u0002\u001ar\u0001\r!a'\t\r\u0005%H\u00041\u0001\u007f\u0003%!\u0018M]4fiJ+g\r\u0003\u0005\u0002nr\u0001\n\u00111\u0001\u007f\u00039a\u0017m\u001d;DQ\u0016\u001c7\u000e]8j]R\f!$\u001e9eCR,G)\u001a7uCR\u000b'\r\\3%I\u00164\u0017-\u001e7uIM*\"!a=+\u0007y\fI-A\tfqR\u0014\u0018m\u0019;DQ\u0016\u001c7\u000e]8j]R$b!!?\u0003\f\t5\u0001cB\u001e\u0002|\u0006}(QA\u0005\u0004\u0003{d$A\u0002+va2,'\u0007E\u0002<\u0005\u0003I1Aa\u0001=\u0005\u0011auN\\4\u0011\u000b\u0005m$q\u0001@\n\t\t%\u0011\u0011\u0012\u0002\u0004'\u0016\f\bBBAw=\u0001\u0007a\u0010C\u0004\u0002\u001az\u0001\r!a'\u0002'5|g/Z\"iK\u000e\\\u0007o\\5oi\u001aKG.Z:\u0015\r\t\u0015!1\u0003B\r\u0011\u001d\u0011)b\ba\u0001\u0005/\tQAZ5mKN\u0004b!a\u001f\u0003\b\u0005m\u0005b\u0002B\u000e?\u0001\u0007\u00111T\u0001\bI\u0016\u001cH\u000fR5s\u0003\u0019\u0019w.\\7jiRa\u0011Q\u0018B\u0011\u0005G\u0011)C!\u000b\u0003.!9\u0011\u0011\u0014\u0011A\u0002\u0005m\u0005BBA7A\u0001\u0007a\u0010\u0003\u0004\u0003(\u0001\u0002\rA`\u0001\u0005Q\u0006\u001c\b\u000e\u0003\u0005\u0003,\u0001\u0002\n\u00111\u0001\u007f\u0003\u001diWm]:bO\u0016D\u0001\"!<!!\u0003\u0005\rA`\u0001\u0011G>lW.\u001b;%I\u00164\u0017-\u001e7uIQ\n\u0001cY8n[&$H\u0005Z3gCVdG\u000fJ\u001b\u0002\u001b]\u0014\u0018\u000e^3J]R,'O\\1m))\t9Ba\u000e\u0003:\tm\"Q\b\u0005\b\u00033\u001b\u0003\u0019AAN\u0011\u001d\t)l\ta\u0001\u0003oCa!!\u001c$\u0001\u0004q\bB\u0002B\u0014G\u0001\u0007a0A\u0005qCRDGk\\&fsR!!1\tB%!\u0011\tyE!\u0012\n\t\t\u001d\u0013\u0011\u000b\u0002\f\u0007>tG/\u001a8ug.+\u0017\u0010C\u0004\u0002\u001a\u0012\u0002\r!a'\u0015\t\t\r#Q\n\u0005\u0007\u00033+\u0003\u0019\u0001@\u0002%9,Xn\u00115fG.\u0004x.\u001b8u!\u0006\u0014Ho\u001d\u000b\u0005\u0005'\u0012Y\u0006\u0005\u0003<y\nU\u0003cA\u001e\u0003X%\u0019!\u0011\f\u001f\u0003\u0007%sG\u000fC\u0004\u0002\u001a\u001a\u0002\r!a'\u0002\u0017\u001d,GOR5mKRK\b/\u001a\u000b\u0005\u0005C\u0012I\u0007\u0005\u0003\u0003d\t\u0015T\"\u0001#\n\u0007\t\u001dDIA\u0007EK2$\u0018MR5mKRK\b/\u001a\u0005\b\u00033;\u0003\u0019AAN\u0003-)\u0007\u0010\u001e:bGRlU\r^1\u0015\t\t=$Q\u000f\t\u0005\u0005G\u0012\t(C\u0002\u0003t\u0011\u00131\u0002T8h\r&dW-T3uC\"9!q\u000f\u0015A\u0002\u0005-\u0015A\u00034jY\u0016\u001cF/\u0019;vg\u0006qQ\r\u001f;sC\u000e$h+\u001a:tS>tG\u0003BA\u0000\u0005{Bq!!'*\u0001\u0004\tY*A\u0007mSN$h)\u001b7fg\u001a\u0013x.\u001c\u000b\u0005\u0005\u0007\u0013)\t\u0005\u0004\u0002|\u0005\u0015%q\u000e\u0005\b\u00033S\u0003\u0019AAN\u0003=)W\u000e\u001d;z\u0007\",7m\u001b9pS:$HC\u0002B8\u0005\u0017\u0013y\tC\u0004\u0003\u000e.\u0002\r!a@\u0002\u000fY,'o]5p]\"9!\u0011S\u0016A\u0002\t=\u0014a\u00037pO\u001aKG.Z'fi\u0006\f\u0001bZ3u)\u0006\u0014G.\u001a\u000b\u0007\u0005/\u0013IJa'\u0011\tmb\u0018q\u001c\u0005\b\u00033c\u0003\u0019AAN\u0011\u0019\u0011i\n\fa\u0001}\u00061!M]1oG\"\fAA]3bIR!!Q\u0001BR\u0011\u001d\tI*\fa\u0001\u00037\u000bq\"\u001b8wC2LG-\u0019;f\u0007\u0006\u001c\u0007.\u001a\u000b\u0003\u0003/\tQ#[:QCJ$\u0018.\u00197Xe&$XMV5tS\ndW\r\u0006\u0003\u0002>\n5\u0006bBAM_\u0001\u0007\u00111T\u0001\u0016e\u0016\u001cx\u000e\u001c<f\u0007\",7m\u001b9pS:$\b+\u0019;i)\u0011\tYJa-\t\u000f\u0005e\u0005\u00071\u0001\u0002\u001c\u0002")
public class NessieLogStore
implements LogStore,
Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final Pattern deltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;
    private Option<String> lastSnapshotUuid;
    private final NessieClient client;
    private final Map<String, Reference> referenceMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    @Override
    public final Seq<String> read(String path) {
        return LogStore.read$(this, path);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore.write$(this, path, actions);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore.listFrom$(this, path);
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return LogStore.resolvePathOnPhysicalStorage$(this, path);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Option<String> lastSnapshotUuid() {
        return this.lastSnapshotUuid;
    }

    public void lastSnapshotUuid_$eq(Option<String> x$1) {
        this.lastSnapshotUuid = x$1;
    }

    private NessieClient client() {
        return this.client;
    }

    private String catalogName() {
        return CatalogNameUtil$.MODULE$.catalogName();
    }

    private String prefix() {
        return new StringBuilder(19).append("spark.sql.catalog.").append(this.catalogName()).append(".").toString();
    }

    private scala.collection.immutable.Map<String, String> catalogConf() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkSession$.MODULE$.active().sparkContext().getConf().getAllWithPrefix(this.prefix()))).toMap(Predef$.MODULE$.$conforms());
    }

    private Map<String, Reference> referenceMap() {
        return this.referenceMap;
    }

    private Reference configuredRef() {
        String refName = SparkSession$.MODULE$.active().sparkContext().getConf().get(new StringBuilder(3).append(this.prefix()).append("ref").toString());
        return this.referenceByName(refName);
    }

    /*
     * WARNING - void declaration
     */
    private Reference referenceByName(String refName) {
        void var2_2;
        Object object;
        Reference ref = this.referenceMap().get(refName);
        if (ref == null) {
            ref = this.client().getTreeApi().getReferenceByName(refName);
            object = this.referenceMap().put(refName, ref);
        } else {
            object = BoxedUnit.UNIT;
        }
        return var2_2;
    }

    private void updateReference(Reference ref) {
        this.referenceMap().put(ref.getName(), ref);
    }

    private void refreshReference(String refName) {
        this.referenceMap().remove(refName);
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        throw new UnsupportedOperationException("listFrom from Nessie does not work.");
    }

    private Tuple3<String, String, String> parseTableIdentifier(String path) {
        if (path.contains("@") && path.contains("#")) {
            String[] tableRef = path.split("@");
            String[] refHash = tableRef[1].split("#");
            return new Tuple3((Object)tableRef[0], (Object)refHash[0], (Object)refHash[0]);
        }
        if (path.contains("@")) {
            String[] tableRef = path.split("@");
            return new Tuple3((Object)tableRef[0], (Object)tableRef[1], null);
        }
        return new Tuple3((Object)path, (Object)SparkSession$.MODULE$.active().sparkContext().getConf().get(new StringBuilder(3).append(this.prefix()).append("ref").toString()), (Object)SparkSession$.MODULE$.active().sparkContext().getConf().get(new StringBuilder(4).append(this.prefix()).append("hash").toString(), null));
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        if (path.getName().equals("_last_checkpoint")) {
            Path x$1 = path;
            String x$2 = this.configuredRef().getName();
            String x$3 = this.configuredRef().getHash();
            String x$4 = actions.mkString();
            String x$5 = this.commit$default$4();
            this.commit(x$1, x$2, x$3, x$5, x$4);
            return;
        }
        Path parent = path.getParent();
        String[] nameSplit = path.getName().split("\\.", 2);
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(nameSplit[0]);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = new StringBuilder(2).append(tableName2).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(nameSplit[1]).toString();
        Path nessiePath = new Path(parent, name);
        if (overwrite) {
            throw new IllegalStateException(new StringBuilder(32).append("Nessie won't overwrite for path ").append(path).toString());
        }
        this.writeInternal(nessiePath, actions, ref2, hash2);
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private DeltaLakeTable updateDeltaTable(Path path, String targetRef, String lastCheckpoint) {
        ImmutableDeltaLakeTable immutableDeltaLakeTable;
        Option<DeltaLakeTable> currentTable = this.getTable(path.getParent(), targetRef);
        ImmutableDeltaLakeTable table = (ImmutableDeltaLakeTable)currentTable.map((Function1 & Serializable & scala.Serializable)instance -> ImmutableDeltaLakeTable.copyOf(instance)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableDeltaLakeTable.builder().build());
        DeltaFileType deltaFileType = this.getFileType(path);
        if (((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType)) {
            String string = path.toString();
            immutableDeltaLakeTable = table.withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(table.getMetadataLocationHistory()).asScala()).toList().$colon$colon((Object)string)).asJava());
        } else {
            if (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType)) {
                throw new UnsupportedOperationException("Can't write checkpoints from LogStore");
            }
            if (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType)) {
                immutableDeltaLakeTable = table;
            } else if (((Object)DeltaFileType$UNKNOWN$.MODULE$).equals(deltaFileType)) {
                ImmutableDeltaLakeTable immutableDeltaLakeTable2;
                if (!path.getName().equals("_last_checkpoint")) {
                    immutableDeltaLakeTable2 = table;
                } else {
                    Tuple2<Object, Seq<String>> tuple2 = this.extractCheckpoint(lastCheckpoint, path.getParent());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long version = tuple2._1$mcJ$sp();
                    Seq parts = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)parts);
                    Tuple2 tuple23 = tuple22;
                    long version2 = tuple23._1$mcJ$sp();
                    Seq parts2 = (Seq)tuple23._2();
                    immutableDeltaLakeTable2 = table.withCheckpointLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(parts2).asJava()).withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.getCheckpointLocationHistory()).asScala()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$updateDeltaTable$3(this, version2, x)))).asJava()).withLastCheckpoint(lastCheckpoint);
                }
                immutableDeltaLakeTable = immutableDeltaLakeTable2;
            } else {
                immutableDeltaLakeTable = table;
            }
        }
        return immutableDeltaLakeTable;
    }

    private String updateDeltaTable$default$3() {
        return null;
    }

    private Tuple2<Object, Seq<String>> extractCheckpoint(String lastCheckpoint, Path path) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        CheckpointMetaData checkpoint = (CheckpointMetaData)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(lastCheckpoint), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(CheckpointMetaData.class));
        long version = checkpoint.version();
        Option<Object> parts = checkpoint.parts();
        Path tempPath = new Path(path, (String)this.lastSnapshotUuid().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("didn't write the correct checkpoint dir");
        }));
        Seq files = parts.isEmpty() ? (Seq)new .colon.colon((Object)FileNames$.MODULE$.checkpointFileSingular(tempPath, version), (List)Nil$.MODULE$) : FileNames$.MODULE$.checkpointFileWithParts(tempPath, version, BoxesRunTime.unboxToInt((Object)checkpoint.parts().get()));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)version), this.moveCheckpointFiles((Seq<Path>)files, path));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<String> moveCheckpointFiles(Seq<Path> files, Path destDir) {
        void var3_3;
        Seq movedFiles = (Seq)files.map((Function1 & Serializable & scala.Serializable)f -> {
            FileSystem fs = f.getFileSystem($this.hadoopConf);
            String[] parts = f.getName().split("\\.", 2);
            String destFile = new StringBuilder(2).append(parts[0]).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(parts[1]).toString();
            Path dest = new Path(destDir, destFile);
            fs.rename(f, dest);
            return dest.toString();
        }, Seq$.MODULE$.canBuildFrom());
        ((Path)files.head()).getFileSystem(this.hadoopConf).delete(((Path)files.head()).getParent(), true);
        return var3_3;
    }

    private boolean commit(Path path, String ref, String hash, String message, String lastCheckpoint) {
        int retries = hash == null ? 1 : 0;
        while (true) {
            String targetRef = ref == null ? this.configuredRef().getName() : ref;
            String targetHash = hash == null ? this.referenceByName(targetRef).getHash() : hash;
            DeltaLakeTable table = this.updateDeltaTable(path, targetRef, lastCheckpoint);
            Operation.Put put = Operation.Put.of(this.pathToKey(path.getParent()), table);
            ImmutableCommitMeta meta = CommitMeta.builder().message(message).putProperties("spark.app.id", this.sparkConf.get("spark.app.id")).putProperties("application.type", "delta").build();
            ImmutableOperations op = ImmutableOperations.builder().addOperations((Operation)put).commitMeta(meta).build();
            try {
                Branch updated = this.client().getTreeApi().commitMultipleOperations(targetRef, targetHash, op);
                this.updateReference(updated != null ? updated : this.client().getTreeApi().getReferenceByName(targetRef));
                return true;
            }
            catch (NessieConflictException ex) {
                this.refreshReference(targetRef);
                if (retries <= 0) {
                    throw ex;
                }
                --retries;
                continue;
            }
            break;
        }
    }

    private String commit$default$4() {
        return "delta commit";
    }

    private String commit$default$5() {
        return null;
    }

    public void writeInternal(Path path, Iterator<String> actions, String ref, String hash) {
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        if (fs.exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        boolean streamClosed = false;
        boolean commitDone = false;
        FSDataOutputStream stream = fs.create(path);
        try {
            actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                commitDone = this.commit(path, ref, hash, this.commit$default$4(), this.commit$default$5());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!commitDone) {
                fs.delete(path, false);
            }
        }
    }

    public ContentsKey pathToKey(Path path) {
        return this.pathToKey(path.toUri().getPath());
    }

    public ContentsKey pathToKey(String path) {
        List parts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).toList();
        return ContentsKey.of((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)parts).asJava());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] stringArray;
        String[] segments = path.getName().split("\\.");
        String[] stringArray2 = segments;
        Object object = stringArray2 != null && (stringArray = stringArray2).length == 6 ? new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[4])).toInt())) : None$.MODULE$;
        return object;
    }

    public DeltaFileType getFileType(Path path) {
        Path path2 = path;
        DeltaFileType deltaFileType = this.checkpointFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKPOINT$.MODULE$ : (this.deltaFilePattern().matcher(path.getName()).matches() ? DeltaFileType$DELTA$.MODULE$ : (this.checksumFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKSUM$.MODULE$ : DeltaFileType$UNKNOWN$.MODULE$));
        return deltaFileType;
    }

    public LogFileMeta extractMeta(FileStatus fileStatus) {
        return new LogFileMeta(fileStatus, this.extractVersion(fileStatus.getPath()), this.getFileType(fileStatus.getPath()), this.numCheckpointParts(fileStatus.getPath()));
    }

    public long extractVersion(Path path) {
        DeltaFileType deltaFileType = this.getFileType(path);
        long l = ((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".json").split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0].split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc").split("-")[0])).toLong() : -1L));
        return l;
    }

    public Iterator<LogFileMeta> listFilesFrom(Path path2) {
        FileSystem fs = path2.getFileSystem(this.hadoopConf);
        if (!fs.exists(path2.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path2.getParent()).toString());
        }
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(path2.toUri().getPath());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = null;
        name = hash2 != null ? hash2 : (ref2 != null ? ref2 : this.configuredRef().getName());
        Option<DeltaLakeTable> currentTable = this.getTable(new Path(tableName2).getParent(), name);
        Set currentMetadataPath = (Set)currentTable.map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getMetadataLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> new Path(x$9), Buffer$.MODULE$.canBuildFrom())).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(15).append("No such table: ").append(path2).toString());
        });
        Set currentPath = ((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory() != null ? (Set)currentMetadataPath.$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> new Path(x$10), Buffer$.MODULE$.canBuildFrom())) : currentMetadataPath;
        long requestedVersion = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> FileNames$.MODULE$.getFileVersion(path2)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path2.getName())).stripSuffix(".checkpoint"))).toLong()));
        FileStatus[] files = fs.listStatus(path2.getParent());
        LogFileMeta[] filteredFiles = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)fileStatus -> this.extractMeta((FileStatus)fileStatus), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)currentPath.contains((Object)x.fileStatus().getPath()))))).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$9(requestedVersion, x$11))))).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.version()), (Ordering)Ordering.Long$.MODULE$);
        None$ maxExpected = currentPath.nonEmpty() ? new Some(((TraversableOnce)currentPath.map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)this.extractVersion(path)), Set$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        None$ maxFound = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).nonEmpty() ? new Some(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)maxFound.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) == BoxesRunTime.unboxToLong((Object)maxExpected.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), () -> NessieLogStore.$anonfun$listFilesFrom$15((Option)maxFound, (Option)maxExpected));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.fileType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DeltaFileType.class))))).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$19(x$15))) == filteredFiles.length ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).$plus$plus((GenTraversableOnce)new .colon.colon((Object)this.emptyCheckpoint(requestedVersion, (LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).head()), (List)Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).iterator() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).iterator();
    }

    private LogFileMeta emptyCheckpoint(long version, LogFileMeta logFileMeta) {
        FileStatus fileStatus = new FileStatus(0L, false, 0, 0L, logFileMeta.fileStatus().getModificationTime(), FileNames$.MODULE$.deltaFile(logFileMeta.fileStatus().getPath().getParent(), version));
        return new LogFileMeta(fileStatus, version, DeltaFileType$DELTA$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    private Option<DeltaLakeTable> getTable(Path path, String branch) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.client().getContentsApi().getContents(this.pathToKey(path), branch, null)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$getTable$2(x))).map((Function1 & Serializable & scala.Serializable)x$16 -> (DeltaLakeTable)x$16).toOption();
    }

    @Override
    public Seq<String> read(Path path) {
        Seq seq;
        if (path.getName().equals("_last_checkpoint")) {
            Option<DeltaLakeTable> table = this.getTable(path.getParent(), this.configuredRef().getName());
            String data = (String)table.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getLastCheckpoint()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new FileNotFoundException();
            });
            if (data == null) {
                throw new FileNotFoundException();
            }
            seq = (Seq)new .colon.colon((Object)data, (List)Nil$.MODULE$);
        } else {
            FileSystem fs = path.getFileSystem(this.hadoopConf);
            try (FSDataInputStream stream = fs.open(path);){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.trim(), Buffer$.MODULE$.canBuildFrom());
            }
        }
        return seq;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    @Override
    public Path resolveCheckpointPath(Path path) {
        this.lastSnapshotUuid_$eq((Option<String>)new Some((Object)UUID.randomUUID().toString()));
        return path.getFileSystem(this.hadoopConf).makeQualified(new Path(path, (String)this.lastSnapshotUuid().get()));
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ Map liftedTree1$1(String requestedRef$1) {
        void v0;
        try {
            void var3_3;
            Reference ref = (Reference)Option$.MODULE$.apply((Object)requestedRef$1).map((Function1 & Serializable & scala.Serializable)x$1 -> this.client().getTreeApi().getReferenceByName((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.client().getTreeApi().getDefaultBranch());
            HashMap<String, Reference> map = new HashMap<String, Reference>();
            map.put(requestedRef$1, ref);
            v0 = var3_3;
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef$1 != null) {
                throw new IllegalArgumentException(new StringBuilder(104).append("Nessie ref ").append(requestedRef$1).append(" provided ").append("via ").append("nessie.ref").append(" does not exist. This ref must exist before creating a NessieCatalog.").toString(), ex);
            }
            throw new IllegalArgumentException(new StringBuilder(143).append("Nessie does not have an existing default branch. Either configure ").append("an alternative ref via ").append("nessie.ref").append(" or create the default branch on the server.").toString(), ex);
        }
        return v0;
    }

    public static final /* synthetic */ boolean $anonfun$updateDeltaTable$3(NessieLogStore $this, long version$1, String x) {
        return $this.extractVersion(new Path(x)) < version$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$9(long requestedVersion$1, LogFileMeta x$11) {
        return x$11.version() >= requestedVersion$1;
    }

    public static final /* synthetic */ String $anonfun$listFilesFrom$15(Option maxFound$1, Option maxExpected$1) {
        return new StringBuilder(27).append("maxFound(").append(maxFound$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)).append(") != maxExpected(").append(maxExpected$1.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$19(DeltaFileType x$15) {
        DeltaFileType deltaFileType = x$15;
        DeltaFileType$CHECKPOINT$ deltaFileType$CHECKPOINT$ = DeltaFileType$CHECKPOINT$.MODULE$;
        return !(deltaFileType != null ? !((Object)deltaFileType).equals(deltaFileType$CHECKPOINT$) : deltaFileType$CHECKPOINT$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTable$2(Contents x) {
        return x != null && x instanceof DeltaLakeTable;
    }

    public NessieLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        LogStore.$init$(this);
        Logging.$init$((Logging)this);
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.json")).r().pattern();
        this.checksumFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.crc")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
        this.lastSnapshotUuid = None$.MODULE$;
        Function1 & Serializable & scala.Serializable removePrefix = (Function1 & Serializable & scala.Serializable)x -> x.replace("nessie.", "");
        this.client = NessieClient.builder().fromConfig(c -> (String)this.catalogConf().getOrElse(removePrefix.apply(c), (Function0 & Serializable & scala.Serializable)() -> null)).build();
        String requestedRef = SparkSession$.MODULE$.active().sparkContext().getConf().get(new StringBuilder(3).append(this.prefix()).append("ref").toString());
        this.referenceMap = this.liftedTree1$1(requestedRef);
    }
}

