/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.immutables.value.Value;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ImmutableHiveTable;

@JsonSerialize(as=ImmutableHiveTable.class)
@JsonDeserialize(as=ImmutableHiveTable.class)
@JsonTypeName(value="HIVE_TABLE")
@Value.Immutable(prehash=true)
public abstract class HiveTable
extends Contents {
    @Size(min=1)
    public abstract @Size(min=1) byte[] getTableDefinition();

    @NotNull
    public abstract List<byte[]> getPartitions();

    public int hashCode() {
        int h = 1;
        h += 31 * h + Objects.hashCode(this.getId());
        h += 31 * h + Arrays.hashCode(this.getTableDefinition());
        for (byte[] p : this.getPartitions()) {
            h += 31 * h + Arrays.hashCode(p);
        }
        return h;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHiveTable && this.equalTo((ImmutableHiveTable)another);
    }

    private boolean equalTo(ImmutableHiveTable another) {
        if (this.hashCode() != another.hashCode()) {
            return false;
        }
        return Objects.equals(this.getId(), another.getId()) && Arrays.equals(this.getTableDefinition(), another.getTableDefinition()) && this.partitionsEqual(this.getPartitions(), another.getPartitions());
    }

    private boolean partitionsEqual(List<byte[]> partitions, List<byte[]> partitions1) {
        if (partitions.size() != partitions1.size()) {
            return false;
        }
        for (int i = 0; i < partitions.size(); ++i) {
            if (Arrays.equals(partitions.get(i), partitions1.get(i))) continue;
            return false;
        }
        return true;
    }
}

