/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import nessie.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import nessie.software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import nessie.software.amazon.awssdk.auth.signer.Aws4Signer;
import nessie.software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import nessie.software.amazon.awssdk.http.SdkHttpFullRequest;
import nessie.software.amazon.awssdk.http.SdkHttpMethod;
import nessie.software.amazon.awssdk.regions.Region;

public class AwsAuth
implements ClientRequestFilter {
    private final ObjectMapper objectMapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private final Aws4Signer signer;
    private final AwsCredentialsProvider awsCredentialsProvider;
    private final Region region = Region.US_WEST_2;

    public AwsAuth() {
        this.awsCredentialsProvider = DefaultCredentialsProvider.create();
        this.signer = Aws4Signer.create();
    }

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        SdkHttpFullRequest modifiedRequest = this.signer.sign(this.prepareRequest(clientRequestContext), Aws4SignerParams.builder().signingName("execute-api").awsCredentials(this.awsCredentialsProvider.resolveCredentials()).signingRegion(this.region).build());
        for (Map.Entry entry : modifiedRequest.toBuilder().headers().entrySet()) {
            if (clientRequestContext.getHeaders().containsKey(entry.getKey())) continue;
            clientRequestContext.getHeaders().put((Object)((String)entry.getKey()), Arrays.asList(((List)entry.getValue()).toArray()));
        }
    }

    private SdkHttpFullRequest prepareRequest(ClientRequestContext clientRequestContext) {
        try {
            URI uri = clientRequestContext.getUri();
            SdkHttpFullRequest.Builder builder = SdkHttpFullRequest.builder().uri(uri).method(SdkHttpMethod.fromValue((String)clientRequestContext.getMethod()));
            Arrays.stream(uri.getQuery().split("&")).map(s -> s.split("=")).forEach(s -> builder.putRawQueryParameter(s[0], s[1]));
            Object entity = clientRequestContext.getEntity();
            if (entity != null) {
                try {
                    byte[] bytes = this.objectMapper.writeValueAsBytes(entity);
                    builder.contentStreamProvider(() -> new ByteArrayInputStream(bytes));
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
            return builder.build();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

