/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.deltalake;

import com.dremio.nessie.client.NessieClient;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.DeltaLakeTable;
import com.dremio.nessie.model.ImmutableDeltaLakeTable;
import com.dremio.nessie.model.Reference;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.DeltaFileType;
import org.apache.spark.sql.delta.DeltaFileType$CHECKPOINT$;
import org.apache.spark.sql.delta.DeltaFileType$CHECKSUM$;
import org.apache.spark.sql.delta.DeltaFileType$DELTA$;
import org.apache.spark.sql.delta.DeltaFileType$UNKNOWN$;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.util.FileNames$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t-g\u0001\u0002\u001d:\u0001\tC\u0001b\u0018\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005K\")Q\u000e\u0001C\u0001]\"91\u000f\u0001b\u0001\n\u0003!\bBB@\u0001A\u0003%Q\u000f\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001u\u0011\u001d\t\u0019\u0001\u0001Q\u0001\nUD\u0001\"!\u0002\u0001\u0005\u0004%\t\u0001\u001e\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003v\u0011%\tI\u0001\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\u0007\u0011%\tY\u0002\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\u0007\u0011%\ty\u0002\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002\"\u0001\u0001\u000b\u0011BA\u0007\u0011%\t\u0019\u0003\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u0007\u0011%\t9\u0003\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u0007\u0011%\tY\u0003\u0001b\u0001\n\u0003\tY\u0001\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0007\u0011%\ty\u0003\u0001a\u0001\n\u0003\t\t\u0004C\u0005\u0002N\u0001\u0001\r\u0011\"\u0001\u0002P!A\u00111\f\u0001!B\u0013\t\u0019\u0004C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`!A\u00111\u000e\u0001!\u0002\u0013\t\t\u0007C\u0004\u0002n\u0001!I!a\u001c\t\u0013\u0005u\u0004\u00011A\u0005\n\u0005}\u0004\"CAA\u0001\u0001\u0007I\u0011BAB\u0011!\t9\t\u0001Q!\n\u0005E\u0004bBAE\u0001\u0011\u0005\u00131\u0012\u0005\b\u0003k\u0003A\u0011BA\\\u0011\u001d\t\t\r\u0001C!\u0003\u0007D\u0011\"a6\u0001#\u0003%\t!!7\t\u000f\u0005=\b\u0001\"\u0003\u0002r\"I!1\u0001\u0001\u0012\u0002\u0013%!Q\u0001\u0005\b\u0005\u0013\u0001A\u0011\u0002B\u0006\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005KAqA!\r\u0001\t\u0013\u0011\u0019\u0004C\u0005\u0003F\u0001\t\n\u0011\"\u0003\u0003\u0006!I!q\t\u0001\u0012\u0002\u0013%!Q\u0001\u0005\b\u0005\u0013\u0002A\u0011\u0003B&\u0011\u001d\u0011)\u0006\u0001C\u0001\u0005/BqA!\u0016\u0001\t\u0003\u0011\t\u0007C\u0004\u0003f\u0001!\tAa\u001a\t\u000f\tM\u0004\u0001\"\u0001\u0003v!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BH\u0001\u0011\u0005!\u0011\u0013\u0005\b\u0005+\u0003A\u0011\u0001BL\u0011\u001d\u0011i\n\u0001C\u0005\u0005?CqA!+\u0001\t\u0013\u0011Y\u000bC\u0004\u00036\u0002!\tEa.\t\u000f\tm\u0006\u0001\"\u0011\u0003>\"9!q\u0018\u0001\u0005B\t\u0005\u0007b\u0002Bc\u0001\u0011\u0005#q\u0019\u0002\u000f\u001d\u0016\u001c8/[3M_\u001e\u001cFo\u001c:f\u0015\tQ4(A\u0005eK2$\u0018\r\\1lK*\u0011A(P\u0001\u0007]\u0016\u001c8/[3\u000b\u0005yz\u0014A\u00023sK6LwNC\u0001A\u0003\r\u0019w.\\\u0002\u0001'\u0011\u00011)S-\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\r\u0005s\u0017PU3g!\tQu+D\u0001L\u0015\taU*A\u0004ti>\u0014\u0018mZ3\u000b\u00059{\u0015!\u00023fYR\f'B\u0001)R\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%N\u000bQa\u001d9be.T!\u0001V+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0016aA8sO&\u0011\u0001l\u0013\u0002\t\u0019><7\u000b^8sKB\u0011!,X\u0007\u00027*\u0011A,U\u0001\tS:$XM\u001d8bY&\u0011al\u0017\u0002\b\u0019><w-\u001b8h\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0005\u0002bE6\t\u0011+\u0003\u0002d#\nI1\u000b]1sW\u000e{gNZ\u0001\u000bQ\u0006$wn\u001c9D_:4\u0007C\u00014l\u001b\u00059'B\u00015j\u0003\u0011\u0019wN\u001c4\u000b\u0005)\u001c\u0016A\u00025bI>|\u0007/\u0003\u0002mO\ni1i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDcA8reB\u0011\u0001\u000fA\u0007\u0002s!)ql\u0001a\u0001A\")Am\u0001a\u0001K\u0006\u0001B-\u001a7uC\u001aKG.\u001a)biR,'O\\\u000b\u0002kB\u0011a/`\u0007\u0002o*\u0011\u00010_\u0001\u0006e\u0016<W\r\u001f\u0006\u0003un\fA!\u001e;jY*\tA0\u0001\u0003kCZ\f\u0017B\u0001@x\u0005\u001d\u0001\u0016\r\u001e;fe:\f\u0011\u0003Z3mi\u00064\u0015\u000e\\3QCR$XM\u001d8!\u0003M\u0019\u0007.Z2lgVlg)\u001b7f!\u0006$H/\u001a:o\u0003Q\u0019\u0007.Z2lgVlg)\u001b7f!\u0006$H/\u001a:oA\u0005)2\r[3dWB|\u0017N\u001c;GS2,\u0007+\u0019;uKJt\u0017AF2iK\u000e\\\u0007o\\5oi\u001aKG.\u001a)biR,'O\u001c\u0011\u0002\u001f\r{eJR0O\u000bN\u001b\u0016*R0V%2+\"!!\u0004\u0011\t\u0005=\u0011QC\u0007\u0003\u0003#Q1!a\u0005|\u0003\u0011a\u0017M\\4\n\t\u0005]\u0011\u0011\u0003\u0002\u0007'R\u0014\u0018N\\4\u0002!\r{eJR0O\u000bN\u001b\u0016*R0V%2\u0003\u0013\u0001F\"P\u001d\u001a{f*R*T\u0013\u0016{VkU#S\u001d\u0006kU)A\u000bD\u001f:3uLT#T'&+u,V*F%:\u000bU*\u0012\u0011\u0002)\r{eJR0O\u000bN\u001b\u0016*R0Q\u0003N\u001bvk\u0014*E\u0003U\u0019uJ\u0014$`\u001d\u0016\u001b6+S#`!\u0006\u001b6kV(S\t\u0002\nQcQ(O\r~sUiU*J\u000b~\u000bU\u000b\u0016%`)f\u0003V)\u0001\fD\u001f:3uLT#T'&+u,Q+U\u0011~#\u0016\fU#!\u0003aqUiU*J\u000b~\u000bU\u000b\u0016%`)f\u0003Vi\u0018#F\r\u0006+F\nV\u0001\u001a\u001d\u0016\u001b6+S#`\u0003V#\u0006j\u0018+Z!\u0016{F)\u0012$B+2#\u0006%A\bD\u001f:3uLT#T'&+uLU#G\u0003A\u0019uJ\u0014$`\u001d\u0016\u001b6+S#`%\u00163\u0005%\u0001\tmCN$8K\\1qg\"|G/V;jIV\u0011\u00111\u0007\t\u0006\t\u0006U\u0012\u0011H\u0005\u0004\u0003o)%AB(qi&|g\u000e\u0005\u0003\u0002<\u0005%c\u0002BA\u001f\u0003\u000b\u00022!a\u0010F\u001b\t\t\tEC\u0002\u0002D\u0005\u000ba\u0001\u0010:p_Rt\u0014bAA$\u000b\u00061\u0001K]3eK\u001aLA!a\u0006\u0002L)\u0019\u0011qI#\u0002)1\f7\u000f^*oCB\u001c\bn\u001c;Vk&$w\fJ3r)\u0011\t\t&a\u0016\u0011\u0007\u0011\u000b\u0019&C\u0002\u0002V\u0015\u0013A!\u00168ji\"I\u0011\u0011L\f\u0002\u0002\u0003\u0007\u00111G\u0001\u0004q\u0012\n\u0014!\u00057bgR\u001cf.\u00199tQ>$X+^5eA\u000511\r\\5f]R,\"!!\u0019\u0011\t\u0005\r\u0014qM\u0007\u0003\u0003KR1!!\u0018<\u0013\u0011\tI'!\u001a\u0003\u00199+7o]5f\u00072LWM\u001c;\u0002\u000f\rd\u0017.\u001a8uA\u0005Yq-\u001a;Pe\u000e\u0013X-\u0019;f)\t\t\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9hO\u0001\u0006[>$W\r\\\u0005\u0005\u0003w\n)HA\u0005SK\u001a,'/\u001a8dK\u0006I!/\u001a4fe\u0016t7-Z\u000b\u0003\u0003c\nQB]3gKJ,gnY3`I\u0015\fH\u0003BA)\u0003\u000bC\u0011\"!\u0017\u001e\u0003\u0003\u0005\r!!\u001d\u0002\u0015I,g-\u001a:f]\u000e,\u0007%\u0001\u0005mSN$hI]8n)\u0011\ti)a+\u0011\r\u0005=\u0015\u0011TAP\u001d\u0011\t\t*!&\u000f\t\u0005}\u00121S\u0005\u0002\r&\u0019\u0011qS#\u0002\u000fA\f7m[1hK&!\u00111TAO\u0005!IE/\u001a:bi>\u0014(bAAL\u000bB!\u0011\u0011UAT\u001b\t\t\u0019KC\u0002\u0002&&\f!AZ:\n\t\u0005%\u00161\u0015\u0002\u000b\r&dWm\u0015;biV\u001c\bbBAW?\u0001\u0007\u0011qV\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002\"\u0006E\u0016\u0002BAZ\u0003G\u0013A\u0001U1uQ\u0006!\u0002/\u0019:tKR\u000b'\r\\3JI\u0016tG/\u001b4jKJ$B!!/\u0002@BIA)a/\u0002:\u0005e\u0012\u0011H\u0005\u0004\u0003{+%A\u0002+va2,7\u0007C\u0004\u0002.\u0002\u0002\r!!\u000f\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0011\u0005E\u0013QYAd\u0003\u001bDq!!,\"\u0001\u0004\ty\u000bC\u0004\u0002J\u0006\u0002\r!a3\u0002\u000f\u0005\u001cG/[8ogB1\u0011qRAM\u0003sA\u0011\"a4\"!\u0003\u0005\r!!5\u0002\u0013=4XM]<sSR,\u0007c\u0001#\u0002T&\u0019\u0011Q[#\u0003\u000f\t{w\u000e\\3b]\u0006yqO]5uK\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\\*\"\u0011\u0011[AoW\t\ty\u000e\u0005\u0003\u0002b\u0006-XBAAr\u0015\u0011\t)/a:\u0002\u0013Ut7\r[3dW\u0016$'bAAu\u000b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00181\u001d\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E;qI\u0006$X\rR3mi\u0006$\u0016M\u00197f)!\t\u00190!?\u0002|\u0006}\b\u0003BA:\u0003kLA!a>\u0002v\tqA)\u001a7uC2\u000b7.\u001a+bE2,\u0007bBAWG\u0001\u0007\u0011q\u0016\u0005\b\u0003{\u001c\u0003\u0019AA\u001d\u0003%!\u0018M]4fiJ+g\rC\u0005\u0003\u0002\r\u0002\n\u00111\u0001\u0002:\u0005qA.Y:u\u0007\",7m\u001b9pS:$\u0018AG;qI\u0006$X\rR3mi\u0006$\u0016M\u00197fI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0004U\u0011\tI$!8\u0002#\u0015DHO]1di\u000eCWmY6q_&tG\u000f\u0006\u0004\u0003\u000e\t}!\u0011\u0005\t\b\t\n=!1\u0003B\r\u0013\r\u0011\t\"\u0012\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\u0011\u0013)\"C\u0002\u0003\u0018\u0015\u0013A\u0001T8oOB1\u0011q\u0012B\u000e\u0003sIAA!\b\u0002\u001e\n\u00191+Z9\t\u000f\t\u0005Q\u00051\u0001\u0002:!9\u0011QV\u0013A\u0002\u0005=\u0016aE7pm\u0016\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016\u001cHC\u0002B\r\u0005O\u0011i\u0003C\u0004\u0003*\u0019\u0002\rAa\u000b\u0002\u000b\u0019LG.Z:\u0011\r\u0005=%1DAX\u0011\u001d\u0011yC\na\u0001\u0003_\u000bq\u0001Z3ti\u0012K'/\u0001\u0004d_6l\u0017\u000e\u001e\u000b\r\u0003#\u0014)Da\u000e\u0003<\t}\"1\t\u0005\b\u0003[;\u0003\u0019AAX\u0011\u001d\u0011Id\na\u0001\u0003s\t1A]3g\u0011\u001d\u0011id\na\u0001\u0003s\tA\u0001[1tQ\"I!\u0011I\u0014\u0011\u0002\u0003\u0007\u0011\u0011H\u0001\b[\u0016\u001c8/Y4f\u0011%\u0011\ta\nI\u0001\u0002\u0004\tI$\u0001\td_6l\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u0005\u00012m\\7nSR$C-\u001a4bk2$H%N\u0001\u000eoJLG/Z%oi\u0016\u0014h.\u00197\u0015\u0015\u0005E#Q\nB(\u0005#\u0012\u0019\u0006C\u0004\u0002.*\u0002\r!a,\t\u000f\u0005%'\u00061\u0001\u0002L\"9!\u0011\b\u0016A\u0002\u0005e\u0002b\u0002B\u001fU\u0001\u0007\u0011\u0011H\u0001\na\u0006$\b\u000eV8LKf$BA!\u0017\u0003`A!\u00111\u000fB.\u0013\u0011\u0011i&!\u001e\u0003\u0017\r{g\u000e^3oiN\\U-\u001f\u0005\b\u0003[[\u0003\u0019AAX)\u0011\u0011IFa\u0019\t\u000f\u00055F\u00061\u0001\u0002:\u0005\u0011b.^7DQ\u0016\u001c7\u000e]8j]R\u0004\u0016M\u001d;t)\u0011\u0011IG!\u001d\u0011\u000b\u0011\u000b)Da\u001b\u0011\u0007\u0011\u0013i'C\u0002\u0003p\u0015\u00131!\u00138u\u0011\u001d\ti+\fa\u0001\u0003_\u000b1bZ3u\r&dW\rV=qKR!!q\u000fB@!\u0011\u0011IHa\u001f\u000e\u00035K1A! N\u00055!U\r\u001c;b\r&dW\rV=qK\"9\u0011Q\u0016\u0018A\u0002\u0005=\u0016aC3yiJ\f7\r^'fi\u0006$BA!\"\u0003\fB!!\u0011\u0010BD\u0013\r\u0011I)\u0014\u0002\f\u0019><g)\u001b7f\u001b\u0016$\u0018\rC\u0004\u0003\u000e>\u0002\r!a(\u0002\u0015\u0019LG.Z*uCR,8/\u0001\bfqR\u0014\u0018m\u0019;WKJ\u001c\u0018n\u001c8\u0015\t\tM!1\u0013\u0005\b\u0003[\u0003\u0004\u0019AAX\u00035a\u0017n\u001d;GS2,7O\u0012:p[R!!\u0011\u0014BN!\u0019\ty)!'\u0003\u0006\"9\u0011QV\u0019A\u0002\u0005=\u0016aD3naRL8\t[3dWB|\u0017N\u001c;\u0015\r\t\u0015%\u0011\u0015BS\u0011\u001d\u0011\u0019K\ra\u0001\u0005'\tqA^3sg&|g\u000eC\u0004\u0003(J\u0002\rA!\"\u0002\u00171|wMR5mK6+G/Y\u0001\tO\u0016$H+\u00192mKR1!Q\u0016BX\u0005c\u0003R\u0001RA\u001b\u0003gDq!!,4\u0001\u0004\ty\u000bC\u0004\u00034N\u0002\r!!\u000f\u0002\r\t\u0014\u0018M\\2i\u0003\u0011\u0011X-\u00193\u0015\t\te!\u0011\u0018\u0005\b\u0003[#\u0004\u0019AAX\u0003=IgN^1mS\u0012\fG/Z\"bG\",GCAA)\u0003UI7\u000fU1si&\fGn\u0016:ji\u00164\u0016n]5cY\u0016$B!!5\u0003D\"9\u0011Q\u0016\u001cA\u0002\u0005=\u0016!\u0006:fg>dg/Z\"iK\u000e\\\u0007o\\5oiB\u000bG\u000f\u001b\u000b\u0005\u0003_\u0013I\rC\u0004\u0002.^\u0002\r!a,")
public class NessieLogStore
implements LogStore,
Logging {
    private final SparkConf sparkConf;
    private final Configuration hadoopConf;
    private final Pattern deltaFilePattern;
    private final Pattern checksumFilePattern;
    private final Pattern checkpointFilePattern;
    private final String CONF_NESSIE_URL;
    private final String CONF_NESSIE_USERNAME;
    private final String CONF_NESSIE_PASSWORD;
    private final String CONF_NESSIE_AUTH_TYPE;
    private final String NESSIE_AUTH_TYPE_DEFAULT;
    private final String CONF_NESSIE_REF;
    private Option<String> lastSnapshotUuid;
    private final NessieClient client;
    private Reference reference;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public final Seq<String> read(String path) {
        return LogStore.read$(this, path);
    }

    @Override
    public final void write(String path, Iterator<String> actions) {
        LogStore.write$(this, path, actions);
    }

    @Override
    public final Iterator<FileStatus> listFrom(String path) {
        return LogStore.listFrom$(this, path);
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path) {
        return LogStore.resolvePathOnPhysicalStorage$(this, path);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checksumFilePattern() {
        return this.checksumFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public String CONF_NESSIE_URL() {
        return this.CONF_NESSIE_URL;
    }

    public String CONF_NESSIE_USERNAME() {
        return this.CONF_NESSIE_USERNAME;
    }

    public String CONF_NESSIE_PASSWORD() {
        return this.CONF_NESSIE_PASSWORD;
    }

    public String CONF_NESSIE_AUTH_TYPE() {
        return this.CONF_NESSIE_AUTH_TYPE;
    }

    public String NESSIE_AUTH_TYPE_DEFAULT() {
        return this.NESSIE_AUTH_TYPE_DEFAULT;
    }

    public String CONF_NESSIE_REF() {
        return this.CONF_NESSIE_REF;
    }

    public Option<String> lastSnapshotUuid() {
        return this.lastSnapshotUuid;
    }

    public void lastSnapshotUuid_$eq(Option<String> x$1) {
        this.lastSnapshotUuid = x$1;
    }

    private NessieClient client() {
        return this.client;
    }

    private Reference getOrCreate() {
        Reference reference;
        String requestedRef = this.hadoopConf.get(this.CONF_NESSIE_REF());
        try {
            reference = (Reference)Option$.MODULE$.apply((Object)requestedRef).map((Function1 & Serializable & scala.Serializable)x$1 -> this.client().getTreeApi().getReferenceByName((String)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.client().getTreeApi().getDefaultBranch());
        }
        catch (NessieNotFoundException ex) {
            if (requestedRef != null) {
                throw new IllegalArgumentException(new StringBuilder(94).append("Nessie ref ").append(requestedRef).append(" provided ").append("via ").append(this.CONF_NESSIE_REF()).append(" does not exist. This ref must exist before creating a NessieCatalog.").toString(), ex);
            }
            throw new IllegalArgumentException(new StringBuilder(133).append("Nessie does not have an existing default branch. Either configure ").append("an alternative ref via ").append(this.CONF_NESSIE_REF()).append(" or create the default branch on the server.").toString(), ex);
        }
        return reference;
    }

    private Reference reference() {
        return this.reference;
    }

    private void reference_$eq(Reference x$1) {
        this.reference = x$1;
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path) {
        throw new UnsupportedOperationException("listFrom from Nessie does not work.");
    }

    private Tuple3<String, String, String> parseTableIdentifier(String path) {
        if (path.contains("@") && path.contains("#")) {
            String[] tableRef = path.split("@");
            String[] refHash = tableRef[1].split("#");
            return new Tuple3((Object)tableRef[0], (Object)refHash[0], (Object)refHash[0]);
        }
        if (path.contains("@")) {
            String[] tableRef = path.split("@");
            return new Tuple3((Object)tableRef[0], (Object)tableRef[1], null);
        }
        return new Tuple3((Object)path, (Object)this.hadoopConf.get("nessie.ref"), (Object)this.hadoopConf.get("nessie.hash"));
    }

    @Override
    public void write(Path path, Iterator<String> actions, boolean overwrite) {
        if (path.getName().equals("_last_checkpoint")) {
            Path x$1 = path;
            String x$2 = this.reference().getName();
            String x$3 = this.reference().getHash();
            String x$4 = actions.mkString();
            String x$5 = this.commit$default$4();
            this.commit(x$1, x$2, x$3, x$5, x$4);
            return;
        }
        Path parent = path.getParent();
        String[] nameSplit = path.getName().split("\\.", 2);
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(nameSplit[0]);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = new StringBuilder(2).append(tableName2).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(nameSplit[1]).toString();
        Path nessiePath = new Path(parent, name);
        if (overwrite) {
            throw new IllegalStateException(new StringBuilder(32).append("Nessie won't overwrite for path ").append(path).toString());
        }
        this.writeInternal(nessiePath, actions, ref2, hash2);
    }

    @Override
    public boolean write$default$3() {
        return false;
    }

    private DeltaLakeTable updateDeltaTable(Path path, String targetRef, String lastCheckpoint) {
        ImmutableDeltaLakeTable immutableDeltaLakeTable;
        Option<DeltaLakeTable> currentTable = this.getTable(path.getParent(), targetRef);
        ImmutableDeltaLakeTable table = (ImmutableDeltaLakeTable)currentTable.map((Function1 & Serializable & scala.Serializable)instance -> ImmutableDeltaLakeTable.copyOf(instance)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ImmutableDeltaLakeTable.builder().build());
        DeltaFileType deltaFileType = this.getFileType(path);
        if (((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType)) {
            String string = path.toString();
            immutableDeltaLakeTable = table.withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(table.getMetadataLocationHistory()).asScala()).toList().$colon$colon((Object)string)).asJava());
        } else {
            if (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType)) {
                throw new UnsupportedOperationException("Can't write checkpoints from LogStore");
            }
            if (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType)) {
                immutableDeltaLakeTable = table;
            } else if (((Object)DeltaFileType$UNKNOWN$.MODULE$).equals(deltaFileType)) {
                ImmutableDeltaLakeTable immutableDeltaLakeTable2;
                if (!path.getName().equals("_last_checkpoint")) {
                    immutableDeltaLakeTable2 = table;
                } else {
                    Tuple2<Object, Seq<String>> tuple2 = this.extractCheckpoint(lastCheckpoint, path.getParent());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    long version = tuple2._1$mcJ$sp();
                    Seq parts = (Seq)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)version), (Object)parts);
                    Tuple2 tuple23 = tuple22;
                    long version2 = tuple23._1$mcJ$sp();
                    Seq parts2 = (Seq)tuple23._2();
                    immutableDeltaLakeTable2 = table.withCheckpointLocationHistory((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter(parts2).asJava()).withMetadataLocationHistory((Iterable)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(table.getCheckpointLocationHistory()).asScala()).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$updateDeltaTable$3(this, version2, x)))).asJava()).withLastCheckpoint(lastCheckpoint);
                }
                immutableDeltaLakeTable = immutableDeltaLakeTable2;
            } else {
                immutableDeltaLakeTable = table;
            }
        }
        return immutableDeltaLakeTable;
    }

    private String updateDeltaTable$default$3() {
        return null;
    }

    private Tuple2<Object, Seq<String>> extractCheckpoint(String lastCheckpoint, Path path) {
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        CheckpointMetaData checkpoint = (CheckpointMetaData)package$.MODULE$.jvalue2extractable(JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(lastCheckpoint), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())).extract((Formats)formats, ManifestFactory$.MODULE$.classType(CheckpointMetaData.class));
        long version = checkpoint.version();
        Option<Object> parts = checkpoint.parts();
        Path tempPath = new Path(path, (String)this.lastSnapshotUuid().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("didn't write the correct checkpoint dir");
        }));
        Seq files = parts.isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{FileNames$.MODULE$.checkpointFileSingular(tempPath, version)})) : FileNames$.MODULE$.checkpointFileWithParts(tempPath, version, BoxesRunTime.unboxToInt((Object)checkpoint.parts().get()));
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)version), this.moveCheckpointFiles((Seq<Path>)files, path));
    }

    /*
     * WARNING - void declaration
     */
    private Seq<String> moveCheckpointFiles(Seq<Path> files, Path destDir) {
        void var3_3;
        Seq movedFiles = (Seq)files.map((Function1 & Serializable & scala.Serializable)f -> {
            FileSystem fs = f.getFileSystem($this.hadoopConf);
            String[] parts = f.getName().split("\\.", 2);
            String destFile = new StringBuilder(2).append(parts[0]).append("-").append(UUID.randomUUID().toString().replace("-", "")).append(".").append(parts[1]).toString();
            Path dest = new Path(destDir, destFile);
            fs.rename(f, dest);
            return dest.toString();
        }, Seq$.MODULE$.canBuildFrom());
        ((Path)files.head()).getFileSystem(this.hadoopConf).delete(((Path)files.head()).getParent(), true);
        return var3_3;
    }

    private boolean commit(Path path, String ref, String hash, String message, String lastCheckpoint) {
        String targetRef = ref == null ? this.reference().getName() : ref;
        String targetHash = hash == null ? this.reference().getHash() : hash;
        String messageWithSparkId = new StringBuilder(16).append(message).append(" ; spark.app.id=").append(this.sparkConf.get("spark.app.id")).toString();
        DeltaLakeTable table = this.updateDeltaTable(path, targetRef, lastCheckpoint);
        this.client().getContentsApi().setContents(this.pathToKey(path.getParent()), targetRef, targetHash, messageWithSparkId, table);
        this.reference_$eq(this.client().getTreeApi().getReferenceByName(this.reference().getName()));
        return true;
    }

    private String commit$default$4() {
        return "delta commit";
    }

    private String commit$default$5() {
        return null;
    }

    public void writeInternal(Path path, Iterator<String> actions, String ref, String hash) {
        FileSystem fs = path.getFileSystem(this.hadoopConf);
        if (!fs.exists(path.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path.getParent()).toString());
        }
        if (fs.exists(path)) {
            throw new java.nio.file.FileAlreadyExistsException(path.toString());
        }
        boolean streamClosed = false;
        boolean commitDone = false;
        FSDataOutputStream stream = fs.create(path);
        try {
            actions.map((Function1 & Serializable & scala.Serializable)x$5 -> new StringBuilder(1).append((String)x$5).append("\n").toString()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getBytes(StandardCharsets.UTF_8)).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                stream.write(x$1);
                return BoxedUnit.UNIT;
            });
            stream.close();
            streamClosed = true;
            try {
                commitDone = this.commit(path, ref, hash, this.commit$default$4(), this.commit$default$5());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!commitDone) {
                fs.delete(path, false);
            }
        }
    }

    public ContentsKey pathToKey(Path path) {
        return this.pathToKey(path.toUri().getPath());
    }

    public ContentsKey pathToKey(String path) {
        List parts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])path.split("/"))).toList();
        return new ContentsKey((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)parts).asJava());
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] stringArray;
        String[] segments = path.getName().split("\\.");
        String[] stringArray2 = segments;
        Object object = stringArray2 != null && (stringArray = stringArray2).length == 6 ? new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[4])).toInt())) : None$.MODULE$;
        return object;
    }

    public DeltaFileType getFileType(Path path) {
        Path path2 = path;
        DeltaFileType deltaFileType = this.checkpointFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKPOINT$.MODULE$ : (this.deltaFilePattern().matcher(path.getName()).matches() ? DeltaFileType$DELTA$.MODULE$ : (this.checksumFilePattern().matcher(path.getName()).matches() ? DeltaFileType$CHECKSUM$.MODULE$ : DeltaFileType$UNKNOWN$.MODULE$));
        return deltaFileType;
    }

    public LogFileMeta extractMeta(FileStatus fileStatus) {
        return new LogFileMeta(fileStatus, this.extractVersion(fileStatus.getPath()), this.getFileType(fileStatus.getPath()), this.numCheckpointParts(fileStatus.getPath()));
    }

    public long extractVersion(Path path) {
        DeltaFileType deltaFileType = this.getFileType(path);
        long l = ((Object)DeltaFileType$DELTA$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".json").split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKPOINT$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0].split("-")[0])).toLong() : (((Object)DeltaFileType$CHECKSUM$.MODULE$).equals(deltaFileType) ? new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path.getName())).stripSuffix(".crc").split("-")[0])).toLong() : -1L));
        return l;
    }

    public Iterator<LogFileMeta> listFilesFrom(Path path2) {
        FileSystem fs = path2.getFileSystem(this.hadoopConf);
        if (!fs.exists(path2.getParent())) {
            throw new FileNotFoundException(new StringBuilder(27).append("No such file or directory: ").append(path2.getParent()).toString());
        }
        Tuple3<String, String, String> tuple3 = this.parseTableIdentifier(path2.toUri().getPath());
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String tableName = (String)tuple3._1();
        String ref = (String)tuple3._2();
        String hash = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)tableName, (Object)ref, (Object)hash);
        Tuple3 tuple33 = tuple32;
        String tableName2 = (String)tuple33._1();
        String ref2 = (String)tuple33._2();
        String hash2 = (String)tuple33._3();
        String name = null;
        name = hash2 != null ? hash2 : (ref2 != null ? ref2 : this.reference().getName());
        Option<DeltaLakeTable> currentTable = this.getTable(new Path(tableName2).getParent(), name);
        Set currentMetadataPath = (Set)currentTable.map((Function1 & Serializable & scala.Serializable)x$8 -> ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$8.getMetadataLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> new Path(x$9), Buffer$.MODULE$.canBuildFrom())).toSet()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new FileNotFoundException(new StringBuilder(15).append("No such table: ").append(path2).toString());
        });
        Set currentPath = ((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory() != null ? (Set)currentMetadataPath.$plus$plus((GenTraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((DeltaLakeTable)currentTable.get()).getCheckpointLocationHistory()).asScala()).map((Function1 & Serializable & scala.Serializable)x$10 -> new Path(x$10), Buffer$.MODULE$.canBuildFrom())) : currentMetadataPath;
        long requestedVersion = BoxesRunTime.unboxToLong((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> FileNames$.MODULE$.getFileVersion(path2)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path2.getName())).stripSuffix(".checkpoint"))).toLong()));
        FileStatus[] files = fs.listStatus(path2.getParent());
        LogFileMeta[] filteredFiles = (LogFileMeta[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)fileStatus -> this.extractMeta((FileStatus)fileStatus), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)currentPath.contains((Object)x.fileStatus().getPath()))))).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$9(requestedVersion, x$11))))).sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.version()), (Ordering)Ordering.Long$.MODULE$);
        None$ maxExpected = currentPath.nonEmpty() ? new Some(((TraversableOnce)currentPath.map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)this.extractVersion(path)), Set$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        None$ maxFound = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).nonEmpty() ? new Some(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.version()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).max((Ordering)Ordering.Long$.MODULE$)) : None$.MODULE$;
        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)maxFound.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) == BoxesRunTime.unboxToLong((Object)maxExpected.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.fileType(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DeltaFileType.class))))).count((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$listFilesFrom$16(x$15))) == filteredFiles.length ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogFileMeta[]{this.emptyCheckpoint(requestedVersion, (LogFileMeta)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).head())})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(LogFileMeta.class))))).iterator() : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredFiles)).iterator();
    }

    private LogFileMeta emptyCheckpoint(long version, LogFileMeta logFileMeta) {
        FileStatus fileStatus = new FileStatus(0L, false, 0, 0L, logFileMeta.fileStatus().getModificationTime(), FileNames$.MODULE$.deltaFile(logFileMeta.fileStatus().getPath().getParent(), version));
        return new LogFileMeta(fileStatus, version, DeltaFileType$DELTA$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    private Option<DeltaLakeTable> getTable(Path path, String branch) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.client().getContentsApi().getContents(this.pathToKey(path), branch)).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)NessieLogStore.$anonfun$getTable$2(x))).map((Function1 & Serializable & scala.Serializable)x$16 -> (DeltaLakeTable)x$16).toOption();
    }

    @Override
    public Seq<String> read(Path path) {
        Seq seq;
        if (path.getName().equals("_last_checkpoint")) {
            Option<DeltaLakeTable> table = this.getTable(path.getParent(), this.reference().getName());
            String data = (String)table.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.getLastCheckpoint()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new FileNotFoundException();
            });
            if (data == null) {
                throw new FileNotFoundException();
            }
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{data}));
        } else {
            FileSystem fs = path.getFileSystem(this.hadoopConf);
            try (FSDataInputStream stream = fs.open(path);){
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
                seq = (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(IOUtils.readLines((Reader)reader)).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.trim(), Buffer$.MODULE$.canBuildFrom());
            }
        }
        return seq;
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public boolean isPartialWriteVisible(Path path) {
        return true;
    }

    @Override
    public Path resolveCheckpointPath(Path path) {
        this.lastSnapshotUuid_$eq((Option<String>)new Some((Object)UUID.randomUUID().toString()));
        return path.getFileSystem(this.hadoopConf).makeQualified(new Path(path, (String)this.lastSnapshotUuid().get()));
    }

    public static final /* synthetic */ boolean $anonfun$updateDeltaTable$3(NessieLogStore $this, long version$1, String x) {
        return $this.extractVersion(new Path(x)) < version$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$9(long requestedVersion$1, LogFileMeta x$11) {
        return x$11.version() >= requestedVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$listFilesFrom$16(DeltaFileType x$15) {
        DeltaFileType deltaFileType = x$15;
        DeltaFileType$CHECKPOINT$ deltaFileType$CHECKPOINT$ = DeltaFileType$CHECKPOINT$.MODULE$;
        return !(deltaFileType != null ? !((Object)deltaFileType).equals(deltaFileType$CHECKPOINT$) : deltaFileType$CHECKPOINT$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTable$2(Contents x) {
        return x != null && x instanceof DeltaLakeTable;
    }

    public NessieLogStore(SparkConf sparkConf, Configuration hadoopConf) {
        this.sparkConf = sparkConf;
        this.hadoopConf = hadoopConf;
        LogStore.$init$(this);
        Logging.$init$((Logging)this);
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.json")).r().pattern();
        this.checksumFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.crc")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+-[0-9a-f]+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
        this.CONF_NESSIE_URL = "nessie.url";
        this.CONF_NESSIE_USERNAME = "nessie.username";
        this.CONF_NESSIE_PASSWORD = "nessie.password";
        this.CONF_NESSIE_AUTH_TYPE = "nessie.auth_type";
        this.NESSIE_AUTH_TYPE_DEFAULT = "BASIC";
        this.CONF_NESSIE_REF = "nessie.ref";
        this.lastSnapshotUuid = None$.MODULE$;
        NessieClient.AuthType authType = NessieClient.AuthType.valueOf(hadoopConf.get(this.CONF_NESSIE_AUTH_TYPE(), this.NESSIE_AUTH_TYPE_DEFAULT()));
        String username = hadoopConf.get(this.CONF_NESSIE_USERNAME());
        String password = hadoopConf.get(this.CONF_NESSIE_PASSWORD());
        String url = hadoopConf.get(this.CONF_NESSIE_URL());
        this.client = new NessieClient(authType, url, username, password);
        this.reference = this.getOrCreate();
    }
}

