/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.model;

import com.dremio.nessie.model.Branch;
import com.dremio.nessie.model.Merge;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Merge", generator="Immutables")
@Immutable
public final class ImmutableMerge
implements Merge {
    private final String fromHash;
    private final Branch to;
    private final transient int hashCode;

    private ImmutableMerge(String fromHash, Branch to) {
        this.fromHash = fromHash;
        this.to = to;
        this.hashCode = this.computeHashCode();
    }

    @Override
    @JsonProperty(value="fromHash")
    public String getFromHash() {
        return this.fromHash;
    }

    @Override
    @JsonProperty(value="to")
    public Branch getTo() {
        return this.to;
    }

    public final ImmutableMerge withFromHash(String value) {
        String newValue = Objects.requireNonNull(value, "fromHash");
        if (this.fromHash.equals(newValue)) {
            return this;
        }
        return new ImmutableMerge(newValue, this.to);
    }

    public final ImmutableMerge withTo(Branch value) {
        if (this.to == value) {
            return this;
        }
        Branch newValue = Objects.requireNonNull(value, "to");
        return new ImmutableMerge(this.fromHash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMerge && this.equalTo((ImmutableMerge)another);
    }

    private boolean equalTo(ImmutableMerge another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.fromHash.equals(another.fromHash) && this.to.equals(another.to);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.fromHash.hashCode();
        h += (h << 5) + this.to.hashCode();
        return h;
    }

    public String toString() {
        return "Merge{fromHash=" + this.fromHash + ", to=" + this.to + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMerge fromJson(Json json) {
        Builder builder = ImmutableMerge.builder();
        if (json.fromHash != null) {
            builder.fromHash(json.fromHash);
        }
        if (json.to != null) {
            builder.to(json.to);
        }
        return builder.build();
    }

    public static ImmutableMerge copyOf(Merge instance) {
        if (instance instanceof ImmutableMerge) {
            return (ImmutableMerge)instance;
        }
        return ImmutableMerge.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Merge", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM_HASH = 1L;
        private static final long INIT_BIT_TO = 2L;
        private long initBits = 3L;
        @Nullable
        private String fromHash;
        @Nullable
        private Branch to;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Merge instance) {
            Objects.requireNonNull(instance, "instance");
            this.fromHash(instance.getFromHash());
            this.to(instance.getTo());
            return this;
        }

        @JsonProperty(value="fromHash")
        @CanIgnoreReturnValue
        public final Builder fromHash(String fromHash) {
            this.fromHash = Objects.requireNonNull(fromHash, "fromHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="to")
        @CanIgnoreReturnValue
        public final Builder to(Branch to) {
            this.to = Objects.requireNonNull(to, "to");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableMerge build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMerge(this.fromHash, this.to);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fromHash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("to");
            }
            return "Cannot build Merge, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Merge", generator="Immutables")
    static final class Json
    implements Merge {
        @Nullable
        String fromHash;
        @Nullable
        Branch to;

        Json() {
        }

        @JsonProperty(value="fromHash")
        public void setFromHash(String fromHash) {
            this.fromHash = fromHash;
        }

        @JsonProperty(value="to")
        public void setTo(Branch to) {
            this.to = to;
        }

        @Override
        public String getFromHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Branch getTo() {
            throw new UnsupportedOperationException();
        }
    }
}

