/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.LogFileMeta;
import org.apache.spark.sql.delta.LogFileMeta$;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitMarker;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.storage.LogStore;
import org.apache.spark.sql.delta.storage.LogStore$;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u001de\u0001\u0002'N\u0001aC\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tU\u0002\u0011\t\u0011)A\u0005W\")a\u000e\u0001C\u0001_\")!\u000b\u0001C\u0005g\")\u0001\u0010\u0001C\u0005s\"9\u0011\u0011\u0001\u0001\u0005\u0002\u0005\r\u0001bBA\u0001\u0001\u0011\u0005\u00111\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011%\u00199\u0007AI\u0001\n\u0003\u0019I\u0007C\u0005\u0004n\u0001\t\n\u0011\"\u0001\u0004j!91q\u000e\u0001\u0005\u0002\rE\u0004\"CB<\u0001E\u0005I\u0011AB5\u0011\u001d\u0019I\b\u0001C\u0005\u0007wBqaa!\u0001\t\u0013\t)\u000b\u0003\u0005\u0004\u0006\u0002!\t!TAS\u000f\u001d\ti%\u0014E\u0001\u0003\u001f2a\u0001T'\t\u0002\u0005E\u0003B\u00028\u0012\t\u0003\t\u0019\u0006C\u0004\u0002VE!I!a\u0016\t\u0011\u0005\u0005\u0015\u0003\"\u0001N\u0003\u0007C!Ba\u0010\u0012#\u0003%\t!\u0014B!\u0011\u001d\u0011)%\u0005C\u0005\u0005\u000fBqA!\u0019\u0012\t\u0013\u0011\u0019\u0007C\u0004\u0003\bF!IA!#\u0007\r\u0005=\u0015\u0003QAI\u0011)\ty(\u0007BK\u0002\u0013\u0005\u0011Q\u0015\u0005\u000b\u0003OK\"\u0011#Q\u0001\n\u0005e\u0002BCAU3\tU\r\u0011\"\u0001\u0002&\"Q\u00111V\r\u0003\u0012\u0003\u0006I!!\u000f\t\r9LB\u0011AAW\u0011\u001d\t\u0019,\u0007C!\u0003kCq!!/\u001a\t\u0003\n)\u000bC\u0004\u0002<f!\t%!*\t\u0013\u0005u\u0016$!A\u0005\u0002\u0005}\u0006\"CAc3E\u0005I\u0011AAd\u0011%\ti.GI\u0001\n\u0003\t9\rC\u0005\u0002`f\t\t\u0011\"\u0011\u0002b\"I\u00111_\r\u0002\u0002\u0013\u0005\u0011Q\u001f\u0005\n\u0003oL\u0012\u0011!C\u0001\u0003sD\u0011B!\u0002\u001a\u0003\u0003%\tEa\u0002\t\u0013\tU\u0011$!A\u0005\u0002\t]\u0001\"\u0003B\u00113\u0005\u0005I\u0011\tB\u0012\u0011%\u0011)#GA\u0001\n\u0003\u00129\u0003C\u0005\u0003*e\t\t\u0011\"\u0011\u0003,\u001dI!1S\t\u0002\u0002#\u0005!Q\u0013\u0004\n\u0003\u001f\u000b\u0012\u0011!E\u0001\u0005/CaA\u001c\u0018\u0005\u0002\t\u0015\u0006\"\u0003B\u0013]\u0005\u0005IQ\tB\u0014\u0011%\u00119KLA\u0001\n\u0003\u0013I\u000bC\u0005\u00030:\n\t\u0011\"!\u00032\"I!q\u0018\u0018\u0002\u0002\u0013%!\u0011\u0019\u0004\u0007\u0005\u0013\f\u0002Aa3\t\u0015\t]GG!A!\u0002\u0013\u0011i\r\u0003\u0006\u0003ZR\u0012\t\u0011)A\u0005\u0003sA!Ba75\u0005\u0003\u0005\u000b\u0011BA\u001d\u0011)\u0011i\u000e\u000eB\u0001B\u0003%!q\u001c\u0005\u0007]R\"\tA!:\t\u0013\tEHG1A\u0005\n\tM\b\u0002CB\u0001i\u0001\u0006IA!>\t\u0013\r\rAG1A\u0005\n\r\u0015\u0001\u0002CB\u0007i\u0001\u0006Iaa\u0002\t\u0017\r=A\u00071AA\u0002\u0013%1\u0011\u0003\u0005\f\u0007'!\u0004\u0019!a\u0001\n\u0013\u0019)\u0002C\u0006\u0004 Q\u0002\r\u0011!Q!\n\tE\u0007\"CB\u0011i\u0001\u0007I\u0011BB\u0012\u0011%\u0019)\u0003\u000ea\u0001\n\u0013\u00199\u0003\u0003\u0005\u0004,Q\u0002\u000b\u0015\u0002B\r\u0011\u001d\u0019i\u0003\u000eC\u0005\u0007_Aqa!\r5\t\u0013\u0019\u0019\u0004C\u0004\u0004:Q\"Iaa\u000f\t\u000f\r}B\u0007\"\u0003\u00040!91\u0011\t\u001b\u0005\n\r=\u0002bBB\"i\u0011\u000531\u0005\u0005\b\u0007\u000b\"D\u0011IB$\u0011%\u0019I%EI\u0001\n\u0003\u0019YEA\nEK2$\u0018\rS5ti>\u0014\u00180T1oC\u001e,'O\u0003\u0002O\u001f\u0006)A-\u001a7uC*\u0011\u0001+U\u0001\u0004gFd'B\u0001*T\u0003\u0015\u0019\b/\u0019:l\u0015\t!V+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0006\u0019qN]4\u0004\u0001M\u0019\u0001!W0\u0011\u0005ikV\"A.\u000b\u0003q\u000bQa]2bY\u0006L!AX.\u0003\r\u0005s\u0017PU3g!\t\u00017-D\u0001b\u0015\t\u0011W*\u0001\u0005nKR,'/\u001b8h\u0013\t!\u0017M\u0001\u0007EK2$\u0018\rT8hO&tw-\u0001\u0005eK2$\u0018\rT8h!\t9\u0007.D\u0001N\u0013\tIWJ\u0001\u0005EK2$\u0018\rT8h\u00039i\u0017\r_&fsN\u0004VM\u001d'jgR\u0004\"A\u00177\n\u00055\\&aA%oi\u00061A(\u001b8jiz\"2\u0001]9s!\t9\u0007\u0001C\u0003f\u0007\u0001\u0007a\rC\u0004k\u0007A\u0005\t\u0019A6\u0016\u0003Q\u0004\"!\u001e<\u000e\u0003=K!a^(\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u00023\u001d,GoU3sS\u0006d\u0017N_1cY\u0016D\u0015\rZ8pa\u000e{gNZ\u000b\u0002uB\u00111P`\u0007\u0002y*\u0011Q0U\u0001\u0005kRLG.\u0003\u0002\u0000y\nI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003)9W\r\u001e%jgR|'/\u001f\u000b\u0005\u0003\u000b\tI\u0003\u0005\u0004\u0002\b\u0005]\u0011Q\u0004\b\u0005\u0003\u0013\t\u0019B\u0004\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\tyaV\u0001\u0007yI|w\u000e\u001e \n\u0003qK1!!\u0006\\\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0007\u0002\u001c\t\u00191+Z9\u000b\u0007\u0005U1\f\u0005\u0003\u0002 \u0005\u0015RBAA\u0011\u0015\r\t\u0019#T\u0001\bC\u000e$\u0018n\u001c8t\u0013\u0011\t9#!\t\u0003\u0015\r{W.\\5u\u0013:4w\u000eC\u0004\u0002,\u0019\u0001\r!!\f\u0002\u00111LW.\u001b;PaR\u0004BAWA\u0018W&\u0019\u0011\u0011G.\u0003\r=\u0003H/[8o)\u0019\t)!!\u000e\u0002@!9\u0011qG\u0004A\u0002\u0005e\u0012!B:uCJ$\bc\u0001.\u0002<%\u0019\u0011QH.\u0003\t1{gn\u001a\u0005\b\u0003\u0003:\u0001\u0019AA\"\u0003\r)g\u000e\u001a\t\u00065\u0006=\u0012\u0011H\u0001\u0016O\u0016$\u0018i\u0019;jm\u0016\u001cu.\\7ji\u0006#H+[7f))\tIea\u0014\u0004\\\r}31\r\t\u0004\u0003\u0017JbBA4\u0011\u0003M!U\r\u001c;b\u0011&\u001cHo\u001c:z\u001b\u0006t\u0017mZ3s!\t9\u0017cE\u0002\u00123~#\"!a\u0014\u0002\u001b\u001d,GoQ8n[&$\u0018J\u001c4p)!\ti\"!\u0017\u0002j\u0005u\u0004bBA.'\u0001\u0007\u0011QL\u0001\tY><7\u000b^8sKB!\u0011qLA3\u001b\t\t\tGC\u0002\u0002d5\u000bqa\u001d;pe\u0006<W-\u0003\u0003\u0002h\u0005\u0005$\u0001\u0003'pON#xN]3\t\u000f\u0005-4\u00031\u0001\u0002n\u0005A!-Y:f!\u0006$\b\u000e\u0005\u0003\u0002p\u0005eTBAA9\u0015\u0011\t\u0019(!\u001e\u0002\u0005\u0019\u001c(bAA<'\u00061\u0001.\u00193p_BLA!a\u001f\u0002r\t!\u0001+\u0019;i\u0011\u001d\tyh\u0005a\u0001\u0003s\tqA^3sg&|g.\u0001\u0006hKR\u001cu.\\7jiN$\"\"!\"\u00030\t]\"1\bB\u001f!\u0015Q\u0016qQAF\u0013\r\tIi\u0017\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0003\u001bKR\"A\t\u0003\r\r{W.\\5u'!I\u0012,a%\u0002\u001a\u0006}\u0005\u0003BA\u0010\u0003+KA!a&\u0002\"\ta1i\\7nSRl\u0015M]6feB\u0019!,a'\n\u0007\u0005u5LA\u0004Qe>$Wo\u0019;\u0011\u0007i\u000b\t+C\u0002\u0002$n\u0013AbU3sS\u0006d\u0017N_1cY\u0016,\"!!\u000f\u0002\u0011Y,'o]5p]\u0002\n\u0011\u0002^5nKN$\u0018-\u001c9\u0002\u0015QLW.Z:uC6\u0004\b\u0005\u0006\u0004\u0002\f\u0006=\u0016\u0011\u0017\u0005\b\u0003\u007fr\u0002\u0019AA\u001d\u0011\u001d\tIK\ba\u0001\u0003s\tQb^5uQRKW.Z:uC6\u0004H\u0003BAF\u0003oCq!!+ \u0001\u0004\tI$\u0001\u0007hKR$\u0016.\\3ti\u0006l\u0007/\u0001\u0006hKR4VM]:j_:\fAaY8qsR1\u00111RAa\u0003\u0007D\u0011\"a #!\u0003\u0005\r!!\u000f\t\u0013\u0005%&\u0005%AA\u0002\u0005e\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0013TC!!\u000f\u0002L.\u0012\u0011Q\u001a\t\u0005\u0003\u001f\fI.\u0004\u0002\u0002R*!\u00111[Ak\u0003%)hn\u00195fG.,GMC\u0002\u0002Xn\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tY.!5\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u000f\u0005\u0003\u0002f\u0006=XBAAt\u0015\u0011\tI/a;\u0002\t1\fgn\u001a\u0006\u0003\u0003[\fAA[1wC&!\u0011\u0011_At\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\t1.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m(\u0011\u0001\t\u00045\u0006u\u0018bAA\u00007\n\u0019\u0011I\\=\t\u0011\t\rq%!AA\u0002-\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0005!\u0019\u0011YA!\u0005\u0002|6\u0011!Q\u0002\u0006\u0004\u0005\u001fY\u0016AC2pY2,7\r^5p]&!!1\u0003B\u0007\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\te!q\u0004\t\u00045\nm\u0011b\u0001B\u000f7\n9!i\\8mK\u0006t\u0007\"\u0003B\u0002S\u0005\u0005\t\u0019AA~\u0003!A\u0017m\u001d5D_\u0012,G#A6\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a9\u0002\r\u0015\fX/\u00197t)\u0011\u0011IB!\f\t\u0013\t\rA&!AA\u0002\u0005m\bbBA.)\u0001\u0007!\u0011\u0007\t\u0004O\nM\u0012b\u0001B\u001b\u001b\n\tBj\\4GS2,W*\u001a;b!\u0006\u00148/\u001a:\t\u000f\teB\u00031\u0001\u0002n\u00059An\\4QCRD\u0007bBA\u001c)\u0001\u0007\u0011\u0011\b\u0005\n\u0003\u0003\"\u0002\u0013!a\u0001\u0003\u0007\nAcZ3u\u0007>lW.\u001b;tI\u0011,g-Y;mi\u0012\"TC\u0001B\"U\u0011\t\u0019%a3\u000255|gn\u001c;p]&TXmQ8n[&$H+[7fgR\fW\u000e]:\u0016\t\t%#\u0011\u000b\u000b\u0005\u0005\u0017\u0012i\u0006E\u0003[\u0003\u000f\u0013i\u0005\u0005\u0003\u0003P\tEC\u0002\u0001\u0003\b\u0005'2\"\u0019\u0001B+\u0005\u0005!\u0016\u0003\u0002B,\u0003'\u00032A\u0017B-\u0013\r\u0011Yf\u0017\u0002\b\u001d>$\b.\u001b8h\u0011\u001d\u0011yF\u0006a\u0001\u0005\u0017\nqaY8n[&$8/A\bqCJ\fG\u000e\\3m'\u0016\f'o\u001951)A\tYI!\u001a\u0003h\t-$1\u0010B@\u0005\u0003\u0013\u0019\tC\u0003S/\u0001\u0007A\u000f\u0003\u0004\u0003j]\u0001\rA_\u0001\u0005G>tg\rC\u0004\u0003:]\u0001\rA!\u001c\u0011\t\t=$q\u000f\b\u0005\u0005c\u0012\u0019\bE\u0002\u0002\fmK1A!\u001e\\\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011\u001fB=\u0015\r\u0011)h\u0017\u0005\b\u0005{:\u0002\u0019AA\u001d\u0003\u0011!\u0018.\\3\t\u000f\u0005]r\u00031\u0001\u0002:!9\u0011\u0011I\fA\u0002\u0005e\u0002b\u0002BC/\u0001\u0007\u0011\u0011H\u0001\u0005gR,\u0007/A\rmCN$8i\\7nSR\u0014UMZ8sKRKW.Z:uC6\u0004HC\u0002BF\u0005\u001b\u0013\t\nE\u0003[\u0003_\tY\tC\u0004\u0003`a\u0001\rAa$\u0011\r\u0005\u001d\u0011qCAF\u0011\u001d\u0011i\b\u0007a\u0001\u0003s\taaQ8n[&$\bcAAG]M)aF!'\u0002 BQ!1\u0014BQ\u0003s\tI$a#\u000e\u0005\tu%b\u0001BP7\u00069!/\u001e8uS6,\u0017\u0002\u0002BR\u0005;\u0013\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c83)\t\u0011)*A\u0003baBd\u0017\u0010\u0006\u0004\u0002\f\n-&Q\u0016\u0005\b\u0003\u007f\n\u0004\u0019AA\u001d\u0011\u001d\tI+\ra\u0001\u0003s\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u00034\nm\u0006#\u0002.\u00020\tU\u0006c\u0002.\u00038\u0006e\u0012\u0011H\u0005\u0004\u0005s[&A\u0002+va2,'\u0007C\u0005\u0003>J\n\t\u00111\u0001\u0002\f\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0007\u0004B!!:\u0003F&!!qYAt\u0005\u0019y%M[3di\na\")\u001e4gKJLgn\u001a'pO\u0012+G.\u001a;j_:LE/\u001a:bi>\u00148\u0003\u0002\u001bZ\u0005\u001b\u0004b!a\u0002\u0003P\nE\u0017\u0002\u0002B\n\u00037\u0001B!a\u001c\u0003T&!!Q[A9\u0005)1\u0015\u000e\\3Ti\u0006$Xo]\u0001\u000bk:$WM\u001d7zS:<\u0017\u0001D7bqRKW.Z:uC6\u0004\u0018AC7bqZ+'o]5p]\u0006ia/\u001a:tS>tw)\u001a;uKJ\u0004rA\u0017Bq\u0003[\nI$C\u0002\u0003dn\u0013\u0011BR;oGRLwN\\\u0019\u0015\u0015\t\u001d(\u0011\u001eBv\u0005[\u0014y\u000fE\u0002\u0002\u000eRBqAa6:\u0001\u0004\u0011i\rC\u0004\u0003Zf\u0002\r!!\u000f\t\u000f\tm\u0017\b1\u0001\u0002:!9!Q\\\u001dA\u0002\t}\u0017!\u00044jY\u0016\u001cHk\u001c#fY\u0016$X-\u0006\u0002\u0003vB1!q\u001fB\u007f\u0005#l!A!?\u000b\t\tm(QB\u0001\b[V$\u0018M\u00197f\u0013\u0011\u0011yP!?\u0003\u000bE+X-^3\u0002\u001d\u0019LG.Z:U_\u0012+G.\u001a;fA\u0005\u0001R.Y=cK\u0012+G.\u001a;f\r&dWm]\u000b\u0003\u0007\u000f\u0001bAa>\u0004\n\tE\u0017\u0002BB\u0006\u0005s\u00141\"\u0011:sCf\u0014UO\u001a4fe\u0006\tR.Y=cK\u0012+G.\u001a;f\r&dWm\u001d\u0011\u0002\u00111\f7\u000f\u001e$jY\u0016,\"A!5\u0002\u00191\f7\u000f\u001e$jY\u0016|F%Z9\u0015\t\r]1Q\u0004\t\u00045\u000ee\u0011bAB\u000e7\n!QK\\5u\u0011%\u0011\u0019aPA\u0001\u0002\u0004\u0011\t.A\u0005mCN$h)\u001b7fA\u0005i\u0001.Y:OKb$8)\u00197mK\u0012,\"A!\u0007\u0002#!\f7OT3yi\u000e\u000bG\u000e\\3e?\u0012*\u0017\u000f\u0006\u0003\u0004\u0018\r%\u0002\"\u0003B\u0002\u0005\u0006\u0005\t\u0019\u0001B\r\u00039A\u0017m\u001d(fqR\u001c\u0015\r\u001c7fI\u0002\nA!\u001b8jiR\u00111qC\u0001\u0011g\"|W\u000f\u001c3EK2,G/\u001a$jY\u0016$BA!\u0007\u00046!91qG#A\u0002\tE\u0017\u0001\u00024jY\u0016\f1C\\3fIN$\u0016.\\3BI*,8\u000f^7f]R$BA!\u0007\u0004>!91q\u0007$A\u0002\tE\u0017a\u00034mkND')\u001e4gKJ\f!#];fk\u00164\u0015\u000e\\3t\u0013:\u0014UO\u001a4fe\u00069\u0001.Y:OKb$\u0018\u0001\u00028fqR$\"A!5\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019iEK\u0002l\u0003\u0017Dq!!+\t\u0001\u0004\u0019\t\u0006\u0005\u0003\u0004T\r]SBAB+\u0015\r\u0001\u00161^\u0005\u0005\u00073\u001a)FA\u0005US6,7\u000f^1na\"91Q\f\u0005A\u0002\te\u0011aE2b]J+G/\u001e:o\u0019\u0006\u001cHoQ8n[&$\b\"CB1\u0011A\u0005\t\u0019\u0001B\r\u0003EiWo\u001d;CKJ+7M]3bi\u0006\u0014G.\u001a\u0005\n\u0007KB\u0001\u0013!a\u0001\u00053\tqcY1o%\u0016$XO\u001d8FCJd\u0017.Z:u\u0007>lW.\u001b;\u0002?\u001d,G/Q2uSZ,7i\\7nSR\fE\u000fV5nK\u0012\"WMZ1vYR$3'\u0006\u0002\u0004l)\"!\u0011DAf\u0003}9W\r^!di&4XmQ8n[&$\u0018\t\u001e+j[\u0016$C-\u001a4bk2$H\u0005N\u0001\u0013G\",7m\u001b,feNLwN\\#ySN$8\u000f\u0006\u0004\u0004\u0018\rM4Q\u000f\u0005\b\u0003\u007fZ\u0001\u0019AA\u001d\u0011%\u0019\tg\u0003I\u0001\u0002\u0004\u0011I\"\u0001\u000fdQ\u0016\u001c7NV3sg&|g.\u0012=jgR\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001dA\f'/\u00197mK2\u001cV-\u0019:dQRA\u0011\u0011JB?\u0007\u007f\u001a\t\tC\u0004\u0003~5\u0001\r!!\u000f\t\u000f\u0005]R\u00021\u0001\u0002:!9\u0011\u0011I\u0007A\u0002\u0005e\u0012\u0001F4fi\u0016\u000b'\u000f\\5fgR$U\r\u001c;b\r&dW-A\u000fhKR,\u0015M\u001d7jKN$(+\u001a9s_\u0012,8-\u001b2mK\u000e{W.\\5u\u0001")
public class DeltaHistoryManager
implements DeltaLogging {
    private final DeltaLog deltaLog;
    private final int maxKeysPerList;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$2() {
        return DeltaHistoryManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkSession spark() {
        return SparkSession$.MODULE$.active();
    }

    private SerializableConfiguration getSerializableHadoopConf() {
        return new SerializableConfiguration(this.spark().sessionState().newHadoopConf());
    }

    public Seq<CommitInfo> getHistory(Option<Object> limitOpt) {
        long listStart = BoxesRunTime.unboxToLong((Object)limitOpt.map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)limit -> scala.math.package$.MODULE$.max($this.deltaLog.update($this.deltaLog.update$default$1()).version() - (long)limit + 1L, 0L)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.getEarliestDeltaFile()));
        return this.getHistory(listStart, (Option<Object>)None$.MODULE$);
    }

    public Seq<CommitInfo> getHistory(long start, Option<Object> end) {
        public final class Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.delta.actions.CommitInfo").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1(DeltaHistoryManager $outer) {
            }
        }
        SparkSession _spark = this.spark();
        SerializableConfiguration conf = this.getSerializableHadoopConf();
        String logPath = this.deltaLog.logPath().toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(DeltaHistoryManager.class.getClassLoader());
        Dataset info = this.spark().range(start, BoxesRunTime.unboxToLong((Object)end.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> $this.deltaLog.update($this.deltaLog.update$default$1()).version())) + 1L).mapPartitions((Function1 & Serializable & scala.Serializable)versions -> {
            LogStore logStore = LogStore$.MODULE$.apply(SparkEnv$.MODULE$.get().conf(), conf.value());
            Path basePath = new Path(logPath);
            FileSystem fs = basePath.getFileSystem(conf.value());
            return versions.flatMap((Function1 & Serializable & scala.Serializable)commit -> {
                Iterable iterable;
                try {
                    CommitInfo ci = DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$getCommitInfo(logStore, basePath, Predef$.MODULE$.Long2long(commit));
                    FileStatus metadata = fs.getFileStatus(FileNames$.MODULE$.deltaFile(basePath, Predef$.MODULE$.Long2long(commit)));
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)ci.withTimestamp(metadata.getModificationTime())));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            });
        }, _spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_DeltaHistoryManager$$typecreator4$1(null))));
        return Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$monotonizeCommitTimestamps((CommitMarker[])info.collect()))).reverse());
    }

    public Commit getActiveCommitAtTime(Timestamp timestamp, boolean canReturnLastCommit, boolean mustBeRecreatable, boolean canReturnEarliestCommit) {
        Commit commit;
        long time = timestamp.getTime();
        long earliest = mustBeRecreatable ? this.getEarliestReproducibleCommit() : this.getEarliestDeltaFile();
        long latestVersion = this.deltaLog.update(this.deltaLog.update$default$1()).version();
        if (latestVersion - earliest > (long)(2 * this.maxKeysPerList)) {
            commit = this.parallelSearch(time, earliest, latestVersion + 1L);
        } else {
            Commit[] commits = DeltaHistoryManager$.MODULE$.getCommits(this.deltaLog.logFileHandler(), this.deltaLog.logPath(), earliest, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(latestVersion + 1L))));
            commit = (Commit)DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$lastCommitBeforeTimestamp((Seq<Commit>)Predef$.MODULE$.wrapRefArray((Object[])commits), time).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Commit)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commits)).head());
        }
        Commit commit2 = commit;
        Timestamp commitTs = new Timestamp(commit2.timestamp());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getTimeZone(SQLConf$.MODULE$.get().sessionLocalTimeZone()));
        String tsString = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, DateTimeUtils$.MODULE$.fromJavaTimestamp(commitTs));
        if (commit2.timestamp() > time && !canReturnEarliestCommit) {
            throw DeltaErrors$.MODULE$.timestampEarlierThanCommitRetention(timestamp, commitTs, tsString);
        }
        if (commit2.version() == latestVersion && !canReturnLastCommit && commit2.timestamp() < time) {
            throw DeltaErrors$.MODULE$.temporallyUnstableInput(timestamp, commitTs, tsString, commit2.version());
        }
        return commit2;
    }

    public boolean getActiveCommitAtTime$default$3() {
        return true;
    }

    public boolean getActiveCommitAtTime$default$4() {
        return false;
    }

    public void checkVersionExists(long version, boolean mustBeRecreatable) {
        long earliest = mustBeRecreatable ? this.getEarliestReproducibleCommit() : this.getEarliestDeltaFile();
        long latest = this.deltaLog.update(this.deltaLog.update$default$1()).version();
        if (version < earliest || version > latest) {
            throw DeltaErrors$.MODULE$.versionNotExistException(version, earliest, latest);
        }
    }

    public boolean checkVersionExists$default$2() {
        return true;
    }

    private Commit parallelSearch(long time, long start, long end) {
        return DeltaHistoryManager$.MODULE$.org$apache$spark$sql$delta$DeltaHistoryManager$$parallelSearch0(this.spark(), this.getSerializableHadoopConf(), this.deltaLog.logPath().toString(), time, start, end, this.maxKeysPerList);
    }

    private long getEarliestDeltaFile() {
        Option earliestVersionOpt = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])this.deltaLog.logFileHandler().listFilesFrom(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), 0L)).filter((Function1 & Serializable & scala.Serializable)logFileMeta -> BoxesRunTime.boxToBoolean((boolean)LogFileMeta$.MODULE$.isDeltaFile(logFileMeta))).take(1).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.version())).toArray(ClassTag$.MODULE$.Long()))).headOption();
        if (earliestVersionOpt.isEmpty()) {
            throw DeltaErrors$.MODULE$.noHistoryFound(this.deltaLog.logPath());
        }
        return BoxesRunTime.unboxToLong((Object)earliestVersionOpt.get());
    }

    public long getEarliestReproducibleCommit() {
        Iterator files = this.deltaLog.logFileHandler().listFilesFrom(FileNames$.MODULE$.deltaFile(this.deltaLog.logPath(), 0L)).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DeltaHistoryManager.$anonfun$getEarliestReproducibleCommit$1(f)));
        HashMap checkpointMap = new HashMap();
        LongRef smallestDeltaVersion = LongRef.create((long)Long.MAX_VALUE);
        None$ lastCompleteCheckpoint = None$.MODULE$;
        while (files.hasNext()) {
            BoxedUnit boxedUnit;
            LogFileMeta nextFilePath = (LogFileMeta)files.next();
            if (LogFileMeta$.MODULE$.isDeltaFile(nextFilePath)) {
                long version = nextFilePath.version();
                if (version == 0L) {
                    return version;
                }
                smallestDeltaVersion.elem = scala.math.package$.MODULE$.min(version, smallestDeltaVersion.elem);
                if (lastCompleteCheckpoint.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 >= smallestDeltaVersion$1.elem)) {
                    return BoxesRunTime.unboxToLong((Object)lastCompleteCheckpoint.get());
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (LogFileMeta$.MODULE$.isCheckpointFile(nextFilePath)) {
                int preCount;
                long checkpointVersion = nextFilePath.version();
                Option<Object> parts = nextFilePath.numParts();
                if (parts.isEmpty()) {
                    lastCompleteCheckpoint = new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                int numParts = BoxesRunTime.unboxToInt((Object)parts.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1));
                if (numParts == (preCount = BoxesRunTime.unboxToInt((Object)checkpointMap.getOrElse((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0))) + 1) {
                    lastCompleteCheckpoint = new Some((Object)BoxesRunTime.boxToLong((long)checkpointVersion));
                }
                boxedUnit = checkpointMap.put((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)checkpointVersion)), (Object)BoxesRunTime.boxToInteger((int)numParts)), (Object)BoxesRunTime.boxToInteger((int)(preCount + 1)));
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        if (lastCompleteCheckpoint.exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 >= smallestDeltaVersion$1.elem)) {
            return BoxesRunTime.unboxToLong((Object)lastCompleteCheckpoint.get());
        }
        if (smallestDeltaVersion.elem < Long.MAX_VALUE) {
            throw DeltaErrors$.MODULE$.noReproducibleHistoryFound(this.deltaLog.logPath());
        }
        throw DeltaErrors$.MODULE$.noHistoryFound(this.deltaLog.logPath());
    }

    public static final /* synthetic */ boolean $anonfun$getEarliestReproducibleCommit$1(LogFileMeta f) {
        return LogFileMeta$.MODULE$.isDeltaFile(f) || LogFileMeta$.MODULE$.isCheckpointFile(f);
    }

    public DeltaHistoryManager(DeltaLog deltaLog, int maxKeysPerList) {
        this.deltaLog = deltaLog;
        this.maxKeysPerList = maxKeysPerList;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
    }

    public static class BufferingLogDeletionIterator
    implements Iterator<FileStatus> {
        private final Iterator<FileStatus> underlying;
        private final long maxTimestamp;
        private final long maxVersion;
        private final Function1<Path, Object> versionGetter;
        private final Queue<FileStatus> filesToDelete;
        private final ArrayBuffer<FileStatus> maybeDeleteFiles;
        private FileStatus lastFile;
        private boolean hasNextCalled;

        public Iterator<FileStatus> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.isTraversableAgain$((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public Iterator<FileStatus> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<FileStatus> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<FileStatus> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<FileStatus, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.$plus$plus$((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<FileStatus, GenTraversableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public Iterator<FileStatus> filter(Function1<FileStatus, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<FileStatus, B, Object> p) {
            return Iterator.corresponds$((Iterator)this, that, p);
        }

        public Iterator<FileStatus> withFilter(Function1<FileStatus, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public Iterator<FileStatus> filterNot(Function1<FileStatus, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<FileStatus, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, FileStatus, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<FileStatus, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public Iterator<FileStatus> takeWhile(Function1<FileStatus, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> partition(Function1<FileStatus, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> span(Function1<FileStatus, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<FileStatus> dropWhile(Function1<FileStatus, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<FileStatus, B>> zip(Iterator<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<FileStatus, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<FileStatus, U> f) {
            Iterator.foreach$((Iterator)this, f);
        }

        public boolean forall(Function1<FileStatus, Object> p) {
            return Iterator.forall$((Iterator)this, p);
        }

        public boolean exists(Function1<FileStatus, Object> p) {
            return Iterator.exists$((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public Option<FileStatus> find(Function1<FileStatus, Object> p) {
            return Iterator.find$((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p) {
            return Iterator.indexWhere$((Iterator)this, p);
        }

        public int indexWhere(Function1<FileStatus, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public BufferedIterator<FileStatus> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public int length() {
            return Iterator.length$((Iterator)this);
        }

        public Tuple2<Iterator<FileStatus>, Iterator<FileStatus>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Traversable<FileStatus> toTraversable() {
            return Iterator.toTraversable$((Iterator)this);
        }

        public Iterator<FileStatus> toIterator() {
            return Iterator.toIterator$((Iterator)this);
        }

        public Stream<FileStatus> toStream() {
            return Iterator.toStream$((Iterator)this);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public List<FileStatus> reversed() {
            return TraversableOnce.reversed$((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.size$((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.nonEmpty$((TraversableOnce)this);
        }

        public int count(Function1<FileStatus, Object> p) {
            return TraversableOnce.count$((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<FileStatus, B> pf) {
            return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, FileStatus, B> op) {
            return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<FileStatus, B, B> op) {
            return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, FileStatus, B> op) {
            return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<FileStatus, B, B> op) {
            return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.reduceOption$((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, FileStatus, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.sum$((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.product$((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
        }

        public List<FileStatus> toList() {
            return TraversableOnce.toList$((TraversableOnce)this);
        }

        public Iterable<FileStatus> toIterable() {
            return TraversableOnce.toIterable$((TraversableOnce)this);
        }

        public Seq<FileStatus> toSeq() {
            return TraversableOnce.toSeq$((TraversableOnce)this);
        }

        public IndexedSeq<FileStatus> toIndexedSeq() {
            return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.toBuffer$((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.toSet$((TraversableOnce)this);
        }

        public Vector<FileStatus> toVector() {
            return TraversableOnce.toVector$((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, FileStatus, Col> cbf) {
            return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef.$less$colon$less<FileStatus, Tuple2<T, U>> ev) {
            return TraversableOnce.toMap$((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.mkString$((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
        }

        public int sizeHintIfCheap() {
            return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
        }

        private Queue<FileStatus> filesToDelete() {
            return this.filesToDelete;
        }

        private ArrayBuffer<FileStatus> maybeDeleteFiles() {
            return this.maybeDeleteFiles;
        }

        private FileStatus lastFile() {
            return this.lastFile;
        }

        private void lastFile_$eq(FileStatus x$1) {
            this.lastFile = x$1;
        }

        private boolean hasNextCalled() {
            return this.hasNextCalled;
        }

        private void hasNextCalled_$eq(boolean x$1) {
            this.hasNextCalled = x$1;
        }

        private void init() {
            block0: {
                if (!this.underlying.hasNext()) break block0;
                this.lastFile_$eq((FileStatus)this.underlying.next());
                this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{this.lastFile()}));
            }
        }

        private boolean shouldDeleteFile(FileStatus file) {
            return file.getModificationTime() <= this.maxTimestamp && BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) <= this.maxVersion;
        }

        private boolean needsTimeAdjustment(FileStatus file) {
            return BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)this.lastFile().getPath())) < BoxesRunTime.unboxToLong((Object)this.versionGetter.apply((Object)file.getPath())) && this.lastFile().getModificationTime() >= file.getModificationTime();
        }

        private void flushBuffer() {
            if (this.maybeDeleteFiles().lastOption().exists((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.shouldDeleteFile(file)))) {
                this.filesToDelete().enqueue(this.maybeDeleteFiles());
            }
            this.maybeDeleteFiles().clear();
        }

        private void queueFilesInBuffer() {
            boolean continueBuffering = true;
            while (continueBuffering) {
                if (!this.underlying.hasNext()) {
                    this.flushBuffer();
                    return;
                }
                FileStatus currentFile = (FileStatus)this.underlying.next();
                Predef$.MODULE$.require(currentFile != null, (Function0 & Serializable & scala.Serializable)() -> "FileStatus iterator returned null");
                if (this.needsTimeAdjustment(currentFile)) {
                    currentFile = new FileStatus(currentFile.getLen(), currentFile.isDirectory(), (int)currentFile.getReplication(), currentFile.getBlockSize(), this.lastFile().getModificationTime() + 1L, currentFile.getPath());
                    this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                } else {
                    this.flushBuffer();
                    this.maybeDeleteFiles().append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FileStatus[]{currentFile}));
                    continueBuffering = false;
                }
                this.lastFile_$eq(currentFile);
            }
        }

        public boolean hasNext() {
            block0: {
                this.hasNextCalled_$eq(true);
                if (!this.filesToDelete().isEmpty()) break block0;
                this.queueFilesInBuffer();
            }
            return this.filesToDelete().nonEmpty();
        }

        public FileStatus next() {
            if (!this.hasNextCalled()) {
                throw new NoSuchElementException();
            }
            this.hasNextCalled_$eq(false);
            return (FileStatus)this.filesToDelete().dequeue();
        }

        public BufferingLogDeletionIterator(Iterator<FileStatus> underlying, long maxTimestamp, long maxVersion, Function1<Path, Object> versionGetter) {
            this.underlying = underlying;
            this.maxTimestamp = maxTimestamp;
            this.maxVersion = maxVersion;
            this.versionGetter = versionGetter;
            GenTraversableOnce.$init$((GenTraversableOnce)this);
            TraversableOnce.$init$((TraversableOnce)this);
            Iterator.$init$((Iterator)this);
            this.filesToDelete = new Queue();
            this.maybeDeleteFiles = new ArrayBuffer();
            this.hasNextCalled = false;
            this.init();
        }
    }

    public static class Commit
    implements CommitMarker,
    Product,
    scala.Serializable {
        private final long version;
        private final long timestamp;

        public long version() {
            return this.version;
        }

        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public Commit withTimestamp(long timestamp) {
            long x$1 = timestamp;
            long x$2 = this.copy$default$1();
            return this.copy(x$2, x$1);
        }

        @Override
        public long getTimestamp() {
            return this.timestamp();
        }

        @Override
        public long getVersion() {
            return this.version();
        }

        public Commit copy(long version, long timestamp) {
            return new Commit(version, timestamp);
        }

        public long copy$default$1() {
            return this.version();
        }

        public long copy$default$2() {
            return this.timestamp();
        }

        public String productPrefix() {
            return "Commit";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Long l;
            int n = x$1;
            switch (n) {
                case 0: {
                    l = BoxesRunTime.boxToLong((long)this.version());
                    break;
                }
                case 1: {
                    l = BoxesRunTime.boxToLong((long)this.timestamp());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return l;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Commit;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.version()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.timestamp()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Commit)) return false;
            boolean bl = true;
            if (!bl) return false;
            Commit commit = (Commit)x$1;
            if (this.version() != commit.version()) return false;
            if (this.timestamp() != commit.timestamp()) return false;
            if (!commit.canEqual(this)) return false;
            return true;
        }

        public Commit(long version, long timestamp) {
            this.version = version;
            this.timestamp = timestamp;
            Product.$init$((Product)this);
        }
    }
}

